/*
  ModemHelper.h - high level functionality for GSM modem
  Copyright (c) 2011 Dmitry Pakhomenko.  All right reserved.

  http://atmega.magictale.com

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef ModemHelper_h
#define ModemHelper_h

#include <inttypes.h>
#include "Board.h"

inline void setStrHTTPParam(char** buf, const prog_char name[], char* value);
inline void fillHTTPHeader(char** buf, uint32_t contentLen);
inline void fillFinalBoundaryHTTP(char** buf);
inline void fillBinHTTPParam(char** buf, char* fileName, uint32_t* len);
inline uint8_t sendHTTPRequest(char* buf, uint16_t bufLen, StrEventType* evnt);
uint8_t transmitEventTCP(uint8_t finalPowerOff, StrEventType* evnt);
uint8_t getModemInfo();
//uint8_t transmitEventHTTP();

inline void getHostPort(char** buf, uint8_t len);
inline void getUri(char** buf, uint8_t len);


#endif
