/*
  MicroSD.h - SDCard+FAT wrapper around Roland Riegel library for DefendLineII
  Copyright (c) 2010 Dmitry Pakhomenko.  All right reserved.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef MicroSD_h
#define MicroSD_h

#include <inttypes.h>
#include <string.h>
#include <avr/pgmspace.h>

#include "hardwareserial.h"
#include "byteordering.h"
#include "sd_raw_config.h"
#include "sd_raw.h"
#include "sd-reader_config.h"
#include "partition_config.h"
#include "partition.h"
#include "fat_config.h"
#include "fat.h"
#include "hardwareserial.h"

class MicroSD
{
  private:
   	HardwareSerial* ser;
	struct partition_struct* partition;

	uint8_t findFileInDir(struct fat_fs_struct* fs, struct fat_dir_struct* dd, 
		const char* name, struct fat_dir_entry_struct* dir_entry);

  public:
	MicroSD(HardwareSerial* serial);

	struct fat_dir_struct* dd;
	struct fat_fs_struct* fs;

	struct fat_file_struct* openFileInDir(struct fat_fs_struct* fs, 
		struct fat_dir_struct* dd, const char* name);


	uint8_t initCard();
	uint8_t initFilesystem(void);
	void ls(void);
	uint8_t diskInfo(void);
	uint8_t cd(char* dir);
	uint8_t rm(char* fileName);
	uint8_t mkdir(char* dirName);
	uint8_t sync(void);
	uint8_t touch(char* fileName);
	uint8_t cat(char* fileName);
	uint8_t closeFilesystem(void);
    uint8_t fileLen(char* fileName, uint32_t* fileSize);

	struct fat_file_struct* fileOpen(char* fileName);
	void fileClose(struct fat_file_struct* fd);
	uint8_t fileWrite(struct fat_file_struct* fd, uint8_t* buffer, uint16_t len);
};
extern MicroSD flashCard;

#endif

