/*
  IRHelper.cpp - high level functionality for Infra Red library
  Copyright (c) 2011 Dmitry Pakhomenko.  All right reserved.

  http://atmega.magictale.com

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "IRHelper.h"
#include "SoundHelper.h"

IRrecv irrecv(IR_RECV_PIN);
decode_results IR_results;

void IRDecode(decode_results *results) 
{
  int count = results->rawlen;
  if (results->decode_type == UNKNOWN) {
    Serial.print_p(FAILED_TO);
    Serial.print_p(DECODE);
    Serial.println_p(MESSAGE);
  } 
  else 
  {
#ifdef SND
    play(1000, 100);
#endif

    if (results->decode_type == NEC) {
      Serial.print_p(DECODED_WORD);
      Serial.print_p(RC_NEC);
      Serial.print_p(COLUMN);
      Serial.print_p(SPACE_CHAR);
    } 
    else if (results->decode_type == SONY) {
      Serial.print_p(DECODED_WORD);
      Serial.print_p(RC_SONY);
      Serial.print_p(COLUMN);
      Serial.print_p(SPACE_CHAR);
    } 
    else if (results->decode_type == RC5) {
      Serial.print_p(DECODED_WORD);
      Serial.print_p(RC_RC5);
      Serial.print_p(COLUMN);
      Serial.print_p(SPACE_CHAR);
    } 
    else if (results->decode_type == RC6) {
      Serial.print_p(DECODED_WORD);
      Serial.print_p(RC_RC6);
      Serial.print_p(COLUMN);
      Serial.print_p(SPACE_CHAR);
    }
    Serial.print(results->value, HEX);
    Serial.print_p(PSTR(" ("));
    Serial.print(results->bits, DEC);
    Serial.print_p(SPACE_CHAR);
    Serial.print_p(BITS);
    Serial.println_p(PSTR(")"));

    if (results->value == DEACT_CODE)
    {
#ifdef LCD
	lcdBacklight = MAX_BRIGHTNESS;
	lcdOnTime = 10;
        analogWrite(LCD_BACKLIGHT_PIN, lcdBacklight);
#endif
        if (sysState == sysReady)
        {
            sysState = sysGuarding;
            Serial.print_p(SET);
            Serial.print_p(TO);
            Serial.print_p(GUARDING);
            Serial.println_p(STATE);
#ifdef SND
            playRtttl(missionImpossible);
#endif

            lastSensorStates = currSensorStates;
        }else if(sysState == sysGuarding)
        {
            sysState = sysReady;
            Serial.print_p(SET);
            Serial.print_p(TO);
            Serial.print_p(INACTIVE);
            Serial.println_p(STATE);
#ifdef SND
            playStartSequence();
#endif
        }
    }
  }
  irrecv.resume(); // Receive the next value
}

void IRHandle()
{
    if (irrecv.decode(&IR_results)) {
        IRDecode(&IR_results);
    }
}

void IRInit(uint8_t blink)
{
	irrecv.blink13(blink);
	irrecv.enableIRIn(); // Start the receiver
}

