/*
  FormatDataHelper.cpp - high level functionality for string data
  manipulation
  Copyright (c) 2011 Dmitry Pakhomenko.  All right reserved.

  http://atmega.magictale.com

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "FormatDataHelper.h"

uint8_t fillTemperature(char** buf)
{
	uint16_t t;
        uint8_t len;
	//Temperature
	if (Thermometer.init(DS1631_I2C_ADDR) == 0)
	{
		Thermometer.startConvert(DS1631_I2C_ADDR);
		_delay_ms(TEMP_SENSOR_READING_DELAY);
		t = Thermometer.readTemp(DS1631_I2C_ADDR);
		*buf += sprintf_P(*buf, SPEC_INT_FORMAT, t >> 8);
		*buf += sprintf_P(*buf, FULL_STOP);
		len = sprintf_P(*buf, TWO_POS_INT_FORMAT, (10000 * ((uint32_t)(t & 0x00FF))) / 256);
		if (len > 2) len = 2;
		*buf += len;
	}else
		*buf += sprintf_P(*buf, NA);

	return true;
}

uint8_t fillVoltage(char** buf, uint16_t voltage)
{
    uint16_t voltBy10 = voltage / 10;
    *buf += sprintf_P(*buf, DECIMAL_FORMAT, voltBy10);
	*buf += sprintf_P(*buf, FULL_STOP);
    *buf += sprintf_P(*buf, DECIMAL_FORMAT, (voltage - voltBy10 * 10));
	*buf += sprintf_P(*buf, VOLTS);
}

uint8_t fillSoftVer(char** buf)
{
    *buf += sprintf_P(*buf, FIRMWARE_REV);
    *buf += sprintf_P(*buf, SPACE_CHAR);
    *buf += sprintf_P(*buf, FIRMWARE_DATE);
}

uint8_t fillStatus(char** buf)
{
    int adcVal;

    adcVal = analogRead(PMON_PIN);
    *buf += sprintf_P(*buf, MAIN_PWR_FLD);
    fillVoltage(buf, get_voltage(adcVal));

    adcVal = analogRead(BMON_PIN);
    *buf += sprintf_P(*buf, BAT_PWR_FLD);
    fillVoltage(buf, get_voltage(adcVal));

    *buf += sprintf_P(*buf, COMMA);
    *buf += sprintf_P(*buf, SENSORS);
	*buf += sprintf_P(*buf, TWO_POS_HEX_FORMAT, currSensorStates);

    *buf += sprintf_P(*buf, COMMA);

    if (sysState == sysGuarding)
        *buf += sprintf_P(*buf, GUARDING);
    else
        *buf += sprintf_P(*buf, INACTIVE);
}

/*
uint8_t fillDateTime(char** buf)
{
	*buf += sprintf_P(*buf, PSTR("XX-date="));

	RtcTimeType rtc;
	if (RTClock.init(PCF8563_I2C_ADDR) == 0)
	{
		*buf += sprintf_P(*buf, DATE_FLD);

		RTClock.getTime(PCF8563_I2C_ADDR, &rtc);

		*buf += sprintf_P(*buf, TWO_POS_HEX_FORMAT, rtc.hours);
		*buf += sprintf_P(*buf, COLUMN);

		*buf += sprintf_P(*buf, TWO_POS_HEX_FORMAT, rtc.minutes);
		*buf += sprintf_P(*buf, COLUMN);

		*buf += sprintf_P(*buf, TWO_POS_HEX_FORMAT, rtc.seconds);
		*buf += sprintf_P(*buf, SPACE);

		*buf += sprintf_P(*buf, TWO_POS_HEX_FORMAT, rtc.day);
		*buf += sprintf_P(*buf, SLASH);

		*buf += sprintf_P(*buf, TWO_POS_HEX_FORMAT, rtc.month);
		*buf += sprintf_P(*buf, SLASH);

		*buf += sprintf_P(*buf, FOUR_POS_HEX_FORMAT, rtc.year);
	}
	else
		*buf += sprintf_P(*buf, NA);

	*buf += sprintf(*buf, AMP);

	return true;
}

inline uint8_t fillSubject(char** buf)
{
	*buf += sprintf_P(*buf, PSTR("XX-subject="));
	*buf += sprintf_P(*buf, PSTR("Test_subject"));
	*buf += sprintf(*buf, AMP);
	return true;
}

inline uint8_t fillBody(char** buf)
{
	*buf += sprintf_P(*buf, PSTR("XX-body="));
	*buf += sprintf_P(*buf, PSTR("Test_body"));
	*buf += sprintf(*buf, AMP);
	return true;
}

inline uint8_t fillDeviceID(char** buf)
{
	*buf += sprintf_P(*buf, PSTR("XX-deviceid="));
	*buf += sprintf_P(*buf, PSTR("DLII"));
	*buf += sprintf(*buf, AMP);
	return true;
}

inline uint8_t fillSoftVersion(char** buf)
{
	*buf += sprintf_P(*buf, PSTR("XX-softversion="));
	*buf += sprintf_P(*buf, PSTR("V_1.0.0.1"));
	*buf += sprintf(*buf, AMP);
	return true;
}*/

uint8_t createEventFile(char* fileName)
{
	//if (flashCard.initCard() == 0) return false;
	//if (flashCard.touch(fileName) == 0) return false;

	RtcTimeType rtc;
	uint16_t t;
	uint16_t res;
	char* buf = (char*)aux_buffer;
	buf[0] = '\0';

	//Device name
	buf += sprintf_P(buf, DEVICE_NAME_FLD);
	eeprom_busy_wait();
	eeprom_read_block(buf, eepromParams.device_name, SENSOR_DESCR_LEN);

	buf+=strlen(buf);
	appendCRLF(&buf);

	//Firmware version
	buf += sprintf_P(buf, FIRMWARE_FLD);
	buf += sprintf_P(buf, FIRMWARE_REV);

	appendCRLF(&buf);

	//DateTime
	if (RTClock.init(PCF8563_I2C_ADDR) == 0)
	{
		buf += sprintf_P(buf, DATE_FLD);

		RTClock.getTime(PCF8563_I2C_ADDR, &rtc);

		buf += sprintf_P(buf, TWO_POS_HEX_FORMAT, rtc.hours);
		buf += sprintf_P(buf, COLUMN);

		buf += sprintf_P(buf, TWO_POS_HEX_FORMAT, rtc.minutes);
		buf += sprintf_P(buf, COLUMN);

		buf += sprintf_P(buf, TWO_POS_HEX_FORMAT, rtc.seconds);
		buf += sprintf_P(buf, SPACE_CHAR);

		buf += sprintf_P(buf, TWO_POS_HEX_FORMAT, rtc.day);
		buf += sprintf_P(buf, SLASH);

		buf += sprintf_P(buf, TWO_POS_HEX_FORMAT, rtc.month);
		buf += sprintf_P(buf, SLASH);

		buf += sprintf_P(buf, FOUR_POS_HEX_FORMAT, rtc.year);

		appendCRLF(&buf);
	}

	//Temperature
	if (Thermometer.init(DS1631_I2C_ADDR) == 0)
	{
		Thermometer.startConvert(DS1631_I2C_ADDR);
		_delay_ms(TEMP_SENSOR_READING_DELAY);
		t = Thermometer.readTemp(DS1631_I2C_ADDR);
		buf += sprintf_P(buf, TEMP_FLD);
		buf += sprintf_P(buf, SPEC_INT_FORMAT, t >> 8);
		buf += sprintf_P(buf, FULL_STOP);
		buf += sprintf_P(buf, TWO_POS_INT_FORMAT, (10000 * ((uint32_t)(t & 0x00FF))) / 256);
		buf += sprintf_P(buf, DEGREES_C_UNITS);

		appendCRLF(&buf);
	}

	//Guarding status (active/inactive)

	//Triggered event type and description (manual, remote request, sensor input, thermostat, alarm, timer)

	//System status (ok/failed module name)
	uint8_t stat_good = true;
	buf += sprintf_P(buf, SYSTEM_STATUS_FLD);
	if (Thermometer.init(DS1631_I2C_ADDR) != 0)
	{
		buf += sprintf_P(buf, TEMP_SENSOR_NAME);
		buf += sprintf_P(buf, NOT);
		buf += sprintf_P(buf, DETECTED);
		stat_good = false;
	}
	if (RTClock.init(PCF8563_I2C_ADDR) != 0)
	{
		buf += sprintf_P(buf, RTC_CHIP_NAME);
		buf += sprintf_P(buf, NOT);
		buf += sprintf_P(buf, DETECTED);
		stat_good = false;
	}
	if (!Camera.sync(&res))
	{
		buf += sprintf_P(buf, SERIAL_CAMERA);
		buf += sprintf_P(buf, DASH_SPACES);
		buf += sprintf_P(buf, NOT);
		buf += sprintf_P(buf, DETECTED);
		
		stat_good = false;
	}
	if (stat_good) buf += sprintf_P(buf, OK);


	//Active power source (main/backup)

	//Geolocation (if available)

	//MicroSD card free space percentage

	Serial.println((char*)aux_buffer);

	return false;
}
