/*
  DS1621.h - Digital Thermometer and Thermostat library for DefendLineII
  Copyright (c) 2010 Dmitry Pakhomenko.  All right reserved.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef DS1621_h
#define DS1621_h

#include <inttypes.h>

#include "Wire.h"

#define DS1631_I2C_ADDR			0x48	//Base I2C address of DS1621 devices

#define DS1621_CMD_STARTCONV	0xEE	//DS1621 Start conversion command byte
#define DS1621_CMD_STOPCONV		0x22	//DS1621 Stop conversion command byte
#define DS1621_CMD_READTEMP		0xAA	//DS1621 Read Temperature command byte

#define DS1621_CMD_READCNTR		0xA8	//DS1621 Read value of Count_Remain
#define DS1621_CMD_READSLOPE	0xA9	//DS1621 Read value of the Count_Per_C


#define DS1621_CMD_ACCESSTH		0xA1	//DS1621 TH read/write command byte
#define DS1621_CMD_ACCESSTL		0xA2	//DS1621 TL read/write command byte
#define DS1621_CMD_ACCESSCONFIG	0xAC	//DS1621 Config read/write command byte

#define DS1621_CONFIG_1SHOT		0x01	//One Shot mode
#define DS1621_CONFIG_POL		0x02	//Output polarity
#define DS1621_CONFIG_NVB		0x10	//Nonvolatile memory busy flag
#define DS1621_CONFIG_TLF		0x20	//Temperature low flag
#define DS1621_CONFIG_THF		0x40	//Tenperature high flag
#define DS1621_CONFIG_DONE		0x80	//Conversion done flag

class DS1621
{
  private:
  	uint16_t readTempReg(uint8_t i2cAddr, uint8_t cmd);
	uint8_t readByte(uint8_t i2cAddr, uint8_t cmd);
  public:
    DS1621();

	//Initialize the DS1621 chip
	uint8_t init(uint8_t i2cAddr);

	//Set the configuration byte of the DS1621
	uint8_t setConfig(uint8_t i2cAddr, uint8_t config);

	//Get the configuration byte of the DS1621
	uint8_t getConfig(uint8_t i2cAddr);

	//Start a temperature conversion
	void startConvert(uint8_t i2cAddr);

	//Stop a temperature conversion (or stop continuous conversion mode)
	void stopConvert(uint8_t i2cAddr);

	//Read the result of a temperature conversion
	uint16_t readTemp(uint8_t i2cAddr);

	//Set the Temp-High threshold
	void setTH(uint8_t i2cAddr, uint16_t value);

	//Set the Temp-Low threshold
	void setTL(uint8_t i2cAddr, uint16_t value);

	//Get the Temp-High threshold
	uint16_t getTH(uint8_t i2cAddr);

	//Get the Temp-Low threshold
	uint16_t getTL(uint8_t i2cAddr);

	uint8_t getCountRemain(uint8_t i2cAddr);

	uint8_t getCountPerC(uint8_t i2cAddr);
};

extern DS1621 Thermometer;

#endif

