/*
  ConsoleHelper.cpp - high level console functionality
  Copyright (c) 2011 Dmitry Pakhomenko.  All right reserved.

  http://atmega.magictale.com

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "ConsoleHelper.h"

#include "wiring.h"
#include "Utils.h"

void waitForInput()
{
    if (termCmd)
    {
        for (uint8_t i = 0; i < 1; i++)
        {
        ring_buffer* buf = Serial.getBuffer();
        char* command = (char*)&buf->buffer[buf->tail];

        if ((strncmp_P(command, PSTR("exit"), 4) == 0) && ((mdmMode) || (gpsMode)))
        {
            mdmMode = false;
            gpsMode = false;                            
            cameraMode = false;
            GsmModem.powerOff();
            Serial.println_p(SUCCESS);
        }else if (mdmMode)
        {
            //Don't send last 0x0 character
            while (Serial.available() > 1)
            {
                Serial3.write(Serial.read());
            }
            Serial3.println();
        }else if (gpsMode)
        {
            //Don't send last 0x0 character
            while (Serial.available() > 1)
            {
                Serial2.write(Serial.read());
            }
            Serial2.println();
        }else if (cameraMode)
        {
            //Don't send anything
        }
        else if (strncmp_P(command, PSTR("help"), 4) == 0)
        {
            printHelp();
        }else if (strncmp_P(command, PSTR("test"), 4) == 0)
        {
            printHardwareCheck();
        }else if (strncmp_P(command, PSTR("bootldr"), 7) == 0)
        {
            Serial.println_p(PSTR("Bootloader will be starting in 5 seconds..."));
            _delay_ms(5000);
            boot_loader_start();
        }else if (strncmp_P(command, PSTR("ls"), 2) == 0)
        {
            flashCard.ls();
        }else if (strncmp_P(command, PSTR("mkdir "), 6) == 0)
        {
            command += 6;
            if(command[0] == '\0')
                continue;
            flashCard.mkdir(command);
            Serial.println_p(SUCCESS);
        }else if (strncmp_P(command, PSTR("cd "), 3) == 0)
        {
            command += 3;
            if(command[0] == '\0')
                continue;
            flashCard.cd(command);
            Serial.println_p(SUCCESS);
        }else if (strncmp_P(command, PSTR("len "), 4) == 0)
        {
            command += 4;
            if(command[0] == '\0')
                continue;
            uint32_t fileLen;
            flashCard.fileLen(command, &fileLen);
            Serial.println(fileLen, DEC);
            Serial.println_p(SUCCESS);
        }else if (strncmp_P(command, PSTR("rm "), 3) == 0)
        {
            command += 3;
            if(command[0] == '\0')
                continue;
            flashCard.rm(command);
            Serial.println_p(SUCCESS);
        }else if (strncmp_P(command, PSTR("df"), 2) == 0)
        {
            flashCard.diskInfo();
        }else if (strncmp_P(command, PSTR("cat "), 4) == 0)
        {
            command += 4;
            if(command[0] == '\0')
                continue;
            flashCard.cat(command);
        }else if (strncmp_P(command, PSTR("touch "), 6) == 0)
        {
            command += 6;
            if(command[0] == '\0')
                continue;
            flashCard.touch(command);
            Serial.println_p(SUCCESS);
        }else if (strcmp_P(command, PSTR("sync")) == 0)
        {
            if (flashCard.sync())
            Serial.println_p(SUCCESS);
        }else if (strncmp_P(command, PSTR("takephoto "), 10) == 0)
        {
            command += 10;
            if(command[0] == '\0')
                continue;
            uint16_t resCode;
            if (!takePicture(command, resCode))
            {
                Serial.println_p(PSTR("error taking picture"));
            }else 
            {
                Serial.println_p(SUCCESS);
            }
        }else if (strncmp_P(command, PSTR("sendphoto "), 10) == 0)
        {
            command += 10;
            if(command[0] == '\0')
                continue;
            uint16_t resCode;
            if (!sendPicture(command, NULL, NULL, NULL))
                Serial.println_p(PSTR("error sending picture"));
            else Serial.println_p(SUCCESS);
        }else if(strncmp_P(command, PSTR("write "), 6) == 0)
        {
            command += 6;
            if(command[0] == '\0')
                continue;
            Serial.println_p(PSTR("opening file..."));
            struct fat_file_struct* fd = flashCard.fileOpen(command);
            if(!fd)
            {
                Serial.print_p(PSTR("error opening "));
                Serial.println(command);
                continue;
            }

            /*for (uint8_t cntr = 0; cntr < 20; cntr++)
            {                                   
                if(fat_write_file(fd, (uint8_t*)aux_buffer, AUX_BUF_LEN) != AUX_BUF_LEN)
                {
                    Serial.println_p(PSTR("error writing to file"));
                    break;
                        //continue;
                }
            }*/

            Serial.println_p(PSTR("please type file content, double <Enter> to finish file appending"));
            Serial.flush();
            termCmd = false;

            while (1)
            {
                if (Serial.available() == 0)
                {
                    _delay_ms(100);
                    continue;
                }
                        
                if (termCmd)
                {
                    command = (char*)&buf->buffer[buf->tail];
                    if (command[0] == '\0') break;

                    /* Inserting line feed character */
                    buf->buffer[buf->head-1] = 0xD;
                    buf->buffer[buf->head] = 0;

                    if(fat_write_file(fd, (uint8_t*)command, strlen(command)) != strlen(command))
                    {
                        Serial.println_p(PSTR("error writing to file"));
                        break;
                    }

                    Serial.flush();
                    termCmd = false;
                }
            }

            fat_close_file(fd);
            Serial.println_p(SUCCESS);
        }else if(strncmp_P(command, PSTR("set time "), 9) == 0)
        {
            command += 9;
            if(command[0] == '\0')
                continue;
            uint8_t res = false;
            RtcTimeType rtc;
            rtc.hours = strtobcd(&command);
            if(command[0] == ':')
            {
                command += 1;
                rtc.minutes = strtobcd(&command);
                if(command[0] == ':')
                {
                    command += 1;
                    rtc.seconds = strtobcd(&command);
                    if(command[0] == ' ')
                    {
                        command += 1;
                        rtc.day = strtobcd(&command);
                        if(command[0] == '/')
                        {
                            command += 1;
                            rtc.month = strtobcd(&command);
                            if(command[0] == '/')
                            {
                                command += 1;
                                rtc.year = strtobcd(&command);
                                if (!(rtc.hours > 0x23 || rtc.minutes > 0x59 || rtc.seconds > 0x59
                                    || rtc.day > 0x31 || rtc.month > 0x12))
                                {
                                    RTClock.setTime(PCF8563_I2C_ADDR, &rtc);
                                    Serial.println_p(SUCCESS);
                                    res = true;
                                }
                            }
                        }
                    }
                }
                if (!res) 
                    Serial.println_p(PSTR("Incorrect datetime format, must be [HH:mm:ss MM/DD/YYYY]"));
            }
        }else if(strncmp_P(command, PSTR("get sensor descr "), 17) == 0)
        {
            command += 17;
            if(command[0] == '\0')
                continue;
            if(command[0] >= '0' && command[0] <= '3')
            {
                uint8_t sensorNum = command[0] - 0x30;
                uint8_t* senDescAddr = eepromParams.sensor0_descr;
                //for (uint8_t i = 0; i < sensorNum; i++)
                //{
                //      senDescAddr += SENSOR_DESCR_LEN;
                //}
                senDescAddr += sensorNum * SENSOR_DESCR_LEN;
                eeprom_busy_wait();
                eeprom_read_block(aux_buffer, (void*)senDescAddr, SENSOR_DESCR_LEN);
                Serial.print_p(CURRENT_VALUE);
                Serial.println((const char*)aux_buffer);
                Serial.println_p(SUCCESS);
            }
        }else if(strncmp_P(command, PSTR("set sensor descr "), 17) == 0)
        {
            command += 17;
            if(command[0] == '\0')
                continue;
            if(command[0] >= '0' && command[0] <= '3')
            {
                uint8_t sensorNum = command[0] - 0x30;
                uint8_t* senDescAddr = eepromParams.sensor0_descr;
                //for (uint8_t i = 0; i < sensorNum; i++)
                //{
                //      senDescAddr += SENSOR_DESCR_LEN;
                //}
                senDescAddr += sensorNum * SENSOR_DESCR_LEN;
                if(command[1] != ' ')
                    continue;
                command += 2;
                eeprom_busy_wait();
                eeprom_write_block(command, (void*)senDescAddr, SENSOR_DESCR_LEN);
                Serial.print_p(NEW_VALUE);
                Serial.println((const char*)command);
                Serial.println_p(SUCCESS);
            }
        }else if(strncmp_P(command, PSTR("set device name "), 16) == 0)
        {
            command += 16;
            if(command[0] == '\0')
                continue;
            eeprom_busy_wait();
            eeprom_write_block(command, (void*)eepromParams.device_name, SENSOR_DESCR_LEN);
            Serial.print_p(NEW_VALUE);
            Serial.println((const char*)command);
            Serial.println_p(SUCCESS);
        }else if(strncmp_P(command, PSTR("get device name"), 15) == 0)
        {
            printDeviceName();
            Serial.println_p(SUCCESS);
        }else if(strncmp_P(command, PSTR("set apn "), 8) == 0)
        {
            command += 8;
            if(command[0] == '\0')
                continue;
            eeprom_busy_wait();
            eeprom_write_block(command, (void*)eepromParams.gsm_apn_name, SENSOR_DESCR_LEN);
            Serial.print_p(NEW_VALUE);
            Serial.println((const char*)command);
            Serial.println_p(SUCCESS);
        }else if(strncmp_P(command, PSTR("get apn"), 7) == 0)
        {
            printGsmApn();
            Serial.println_p(SUCCESS);
        }else if(strncmp_P(command, PSTR("set gprs login "), 15) == 0)
        {
            command += 15;
            if(command[0] == '\0')
                continue;
            eeprom_busy_wait();
            eeprom_write_block(command, (void*)eepromParams.gsm_apn_login, SENSOR_DESCR_LEN);
            Serial.print_p(NEW_VALUE);
            Serial.println((const char*)command);
            Serial.println_p(SUCCESS);
        }else if(strncmp_P(command, PSTR("get gprs login"), 14) == 0)
        {
            printGPRSLogin();
            Serial.println_p(SUCCESS);
        }else if(strncmp_P(command, PSTR("set gprs pwd "), 13) == 0)
        {
            command += 13;
            if(command[0] == '\0')
                continue;
            eeprom_busy_wait();
            eeprom_write_block(command, (void*)eepromParams.gsm_apn_pwd, SENSOR_DESCR_LEN);
            Serial.print_p(NEW_VALUE);
            Serial.println((const char*)command);
            Serial.println_p(SUCCESS);
        }else if(strncmp_P(command, PSTR("get gprs pwd"), 12) == 0)
        {
            printGPRSPwd();
            Serial.println_p(SUCCESS);
        }else if(strncmp_P(command, PSTR("set url "), 8) == 0)
        {
            command += 8;
            if(command[0] == '\0')
                continue;
            eeprom_busy_wait();
            eeprom_write_block(command, (void*)eepromParams.server_HTTP_URL, SERVER_HTTP_URL_LEN);
            Serial.print_p(NEW_VALUE);
            Serial.println((const char*)command);
            Serial.println_p(SUCCESS);
        }else if(strncmp_P(command, PSTR("get url"), 7) == 0)
        {
            printServerHTTP_URL();
            Serial.println_p(SUCCESS);
        }else if(strncmp_P(command, PSTR("set output "), 11) == 0)
        {
            command += 11;
            if(command[0] != '\0')
            {
                uint8_t output_num = strtobcd(&command);
                if(command[0] == ' ')
                {
                    command += 1;
                    uint8_t output_value = strtobcd(&command);
                    if (output_value == 0 || output_value == 1)
                    {
                        if (output_num == 0 || output_num == 1)
                        {
                            set_relay(output_num, output_value);
                            Serial.println_p(SUCCESS);
                            //break;
                        }
                    }
                }
            }
            //Serial.println_p(PSTR("Incorrect format, must be [output_num=0..1] [output_value=0..1]"));
        }else if (strncmp_P(command, PSTR("snapshot "), 9) == 0)
        {
            command += 9;
            if(command[0] == '\0')
                continue;
            createEventFile(command);
        }else if (strncmp_P(command, PSTR("modem"), 5) == 0)
        {       
            mdmMode = true;
            GsmModem.init();
            if (GsmModem.waitForNetworkRegistration())
            {
                GsmModem.enableRTC();
            }
            Serial.println_p(SUCCESS);
        }else if (strncmp_P(command, PSTR("gps"), 3) == 0)
        {       
            gpsMode = true;
            Serial.println_p(SUCCESS);
        }else if (strncmp_P(command, PSTR("camera"), 6) == 0)
        {       
            cameraMode = true;
            Serial.println_p(SUCCESS);
        }else if(strncmp_P(command, PSTR("get sensor mask"), 15) == 0)
        {
            printSensorMask();
            Serial.println_p(SUCCESS);
        }else if(strncmp_P(command, PSTR("set sensor mask "), 16) == 0)
        {
            command += 16;
            if(command[0] == '\0')
                continue;
            uint8_t sensorMask = bcdtobin(strtobcd(&command));
            eeprom_busy_wait();
            eeprom_write_byte(&eepromParams.sensor_mask, sensorMask);
            Serial.print_p(NEW_VALUE);
            Serial.println(sensorMask, DEC);
            Serial.println_p(SUCCESS);
        }else if(strncmp_P(command, PSTR("get report hour"), 15) == 0)
        {
            printReportHour();
            Serial.println_p(SUCCESS);
        }else if(strncmp_P(command, PSTR("set report hour "), 16) == 0)
        {
            command += 16;
            if(command[0] == '\0')
                continue;
            uint8_t reportHour = strtobcd(&command);
            if (reportHour > 23)
            {
                Serial.println_p(FAILURE);
                continue;
            }
            eeprom_busy_wait();
            eeprom_write_byte(&eepromParams.report_hour, reportHour);
            Serial.print_p(NEW_VALUE);
            Serial.println(reportHour, DEC);
            Serial.println_p(SUCCESS);
        }else if(strncmp_P(command, PSTR("get tzone shift"), 15) == 0)
        {
            printTZShift();
            Serial.println_p(SUCCESS);
        }else if(strncmp_P(command, PSTR("set tzone shift "), 16) == 0)
        {
            command += 16;
            if(command[0] == '\0')
                continue;
            uint8_t tz = bcdtobin(strtobcd(&command));
            if ( tz > 14)
            {
                Serial.println_p(FAILURE);
                continue;
            }
            eeprom_busy_wait();
            eeprom_write_byte(&eepromParams.time_zone_shift, tz);
            Serial.print_p(NEW_VALUE);
            Serial.println(tz, DEC);
            Serial.println_p(SUCCESS);
        }else if(strncmp_P(command, PSTR("bcdtest "), 8) == 0)
        {
            command += 8;
            if(command[0] == '\0')
                continue;
            uint8_t arg1 = strtobcd(&command);

            Serial.println(arg1, HEX);
            Serial.println(bcdtobin(arg1), HEX);
            Serial.println(bintobcd(bcdtobin(arg1)), HEX);


            Serial.println_p(SUCCESS);
        }else
        {
            Serial.println_p(PSTR("incorrect command"));
        }

        }

        printMenu();
        Serial.flush();
        termCmd = false;
    }if (ctrlC)
    {
        Serial.println();
        Serial.println_p(PSTR("<ctrl+C>"));
        printMenu();
        Serial.flush();
        ctrlC = false;
    }
}

void printMenu()
{
        Serial.println();
        if (!mdmMode && !gpsMode)
                Serial.print_p(PSTR("->"));
}

void printReportHour()
{
        eeprom_busy_wait();
        uint8_t bt = eeprom_read_byte(&eepromParams.report_hour);
        Serial.print_p(REPORT_HOUR_FLD);
        Serial.println(bt, DEC);
}

void printTZShift()
{
        eeprom_busy_wait();
        uint8_t bt = eeprom_read_byte(&eepromParams.time_zone_shift);
        Serial.print_p(TZONE_SHIFT_FLD);
        Serial.println(bt, DEC);
}

void printSensorMask()
{
        eeprom_busy_wait();
        uint8_t bt = eeprom_read_byte(&eepromParams.sensor_mask);
        Serial.print_p(SENSOR_MASK_FLD);
        Serial.println(bt, DEC);
}

void printDeviceName()
{
        eeprom_busy_wait();
        eeprom_read_block(aux_buffer, eepromParams.device_name, SENSOR_DESCR_LEN);
        Serial.print_p(DEVICE_NAME_FLD);
        Serial.println((const char*)aux_buffer);
}

void printGsmApn()
{
        eeprom_busy_wait();
        eeprom_read_block(aux_buffer, eepromParams.gsm_apn_name, SENSOR_DESCR_LEN);
        Serial.print_p(GSM_APN_FLD);
        Serial.println((const char*)aux_buffer);
}

void printGPRSLogin()
{
        eeprom_busy_wait();
        eeprom_read_block(aux_buffer, eepromParams.gsm_apn_login, SENSOR_DESCR_LEN);
        Serial.print_p(GSM_LOGIN_FLD);
        Serial.println((const char*)aux_buffer);
}

void printGPRSPwd()
{
        eeprom_busy_wait();
        eeprom_read_block(aux_buffer, eepromParams.gsm_apn_pwd, SENSOR_DESCR_LEN);
        Serial.print_p(GSM_PWD_FLD);
        Serial.println((const char*)aux_buffer);
}

void printServerHTTP_URL()
{
        eeprom_busy_wait();
        eeprom_read_block(aux_buffer, eepromParams.server_HTTP_URL, SERVER_HTTP_URL_LEN);
        Serial.print_p(SERVER_HTTP_URL_FLD);
        Serial.println((const char*)aux_buffer);
}

void printHelp()
{
        Serial.print_p(CRLF);
        Serial.print_p(EQ_EQ_EQ_L);
        Serial.print_p(PRODUCT_NAME);
        Serial.print_p(SPACE_CHAR);
        Serial.print_p(FIRMWARE_REV);
        Serial.print_p(SPACE_CHAR);
        Serial.print_p(FIRMWARE_DATE);
        Serial.println_p(EQ_EQ_EQ_R);

        Serial.print_p(EQ_EQ_EQ_L);
        Serial.print_p(PSTR("visit http://atmega.magictale.com"));
        Serial.println_p(EQ_EQ_EQ_R);

        printDeviceName();
        printGsmApn();
        printServerHTTP_URL();
        Serial.print_p(PSTR("\r\nAvail.commands: test, bootldr, ls, mkdir, cd, "));
        Serial.print_p(PSTR("rm, df, cat, touch, sync, takephoto, write, set time, "));
        Serial.print_p(PSTR("get sensor descr, set sensor descr, get device name, set device name, "));
        Serial.print_p(PSTR("set output, set apn, get apn, set url, get url, modem, gps, "));
        Serial.print_p(PSTR("sendphoto, snapshot, exit, get sensor mask, set sensor mask, "));
        Serial.println_p(PSTR("get report hour, set report hour, get tzone shift, set tzone shift"));
}

void printHardwareCheck()
{       
        RtcTimeType rtc;
        uint16_t t;
        char buffer[15];

#if defined(__AVR_ATmega1280__)
        Serial.println_p(PSTR("AVR ATMEGA1280 CPU"));
#elif defined(__AVR_ATmega2560__)
        Serial.println_p(PSTR("AVR ATMEGA2560 CPU"));
#endif

        Serial.print_p(TEMP_SENSOR_NAME);
        if (Thermometer.init(DS1631_I2C_ADDR) == 0)
        {
                Serial.print_p(DETECTED);
                Serial.print_p(PSTR(", "));

                Thermometer.startConvert(DS1631_I2C_ADDR);
                _delay_ms(TEMP_SENSOR_READING_DELAY);
                t = Thermometer.readTemp(DS1631_I2C_ADDR);
                Serial.print_p(CURRENT);
        Serial.print_p(TEMPERATURE);
                Serial.print(t>>8);
                Serial.print_p(FULL_STOP);
                Serial.print((10000*((uint32_t)(t&0x00FF)))/256);
                Serial.println_p(DEGREES_C_UNITS);
        }
        else {
                Serial.print_p(NOT);
                Serial.println_p(DETECTED);
        }
        Serial.print_p(RTC_CHIP_NAME);
        if (RTClock.init(PCF8563_I2C_ADDR) == 0)
        {

                Serial.print_p(DETECTED);
                Serial.print_p(PSTR(", "));
                Serial.print_p(CURRENT);
        Serial.print_p(TIME);

                RTClock.getTime(PCF8563_I2C_ADDR, &rtc);

                sprintf_P(buffer, TWO_POS_HEX_FORMAT, rtc.hours);
                Serial.print(buffer);
                Serial.print_p(COLUMN);
                sprintf_P(buffer, TWO_POS_HEX_FORMAT, rtc.minutes);
                Serial.print(buffer);
                Serial.print_p(COLUMN);
                sprintf_P(buffer, TWO_POS_HEX_FORMAT, rtc.seconds);
                Serial.print(buffer);

                Serial.print_p(SPACE_CHAR);

                sprintf_P(buffer, TWO_POS_HEX_FORMAT, rtc.day);
                Serial.print(buffer);
                Serial.print_p(SLASH);
                sprintf_P(buffer, TWO_POS_HEX_FORMAT, rtc.month);
                Serial.print(buffer);
                Serial.print_p(SLASH);
                sprintf_P(buffer, FOUR_POS_HEX_FORMAT, rtc.year);
                Serial.println(buffer);
        }
        else{
                Serial.print_p(NOT);
                Serial.println_p(DETECTED);
        }
        Serial.print_p(MICRO_SD_NAME);
        if(sd_raw_init())
                Serial.println_p(DETECTED);
        else{
                Serial.print_p(NOT);
                Serial.println_p(DETECTED);
        }

        uint16_t res;
        Serial.print_p(SERIAL_CAMERA);
        Serial.print_p(DASH_SPACES);
        if (Camera.sync(&res))
        {
                Serial.println_p(DETECTED);
        
        Serial.print_p(SERIAL_CAMERA);
        Serial.print_p(INITIAL);
        Serial.print_p(DASH_SPACES);

                if (Camera.initial(CCT_JPEG, CPR_160X120, CJR_640X480, &res))
                        Serial.println_p(SUCCESS);
                else Serial.println_p(FAILURE);

        Serial.print_p(SERIAL_CAMERA);
        Serial.print_p(SET_PACKAGE_SIZE);
                Serial.print_p(DASH_SPACES);
                if (Camera.setPackageSize(0x40, &res))
                        Serial.println_p(SUCCESS);
                else Serial.println_p(FAILURE);

        Serial.print_p(SERIAL_CAMERA);
        Serial.print_p(SNAPSHOT);
                Serial.print_p(DASH_SPACES);
                if (Camera.snapshot(CST_COMPRESSED, 0, &res))
                        Serial.println_p(SUCCESS);
                else Serial.println_p(FAILURE);
        }
        else 
        {
                Serial.print_p(NOT);
                Serial.println_p(DETECTED);
        }

    /*if (getModemInfo())
    {
        if (!GsmModem.powerOff()) GsmModem.forcedPowerOff();
    }*/


    int adcVal = analogRead(PMON_PIN);
    char* bufPntr = (char*)&buffer;
    Serial.print_p(MAIN_POWER);
    fillVoltage(&bufPntr, get_voltage(adcVal));
    Serial.println(buffer);

    adcVal = analogRead(BMON_PIN);
    bufPntr = (char*)&buffer;
    Serial.print_p(BATTERY_LEVEL);
    fillVoltage(&bufPntr, get_voltage(adcVal));
    Serial.println(buffer);


    //sendHTTPRequest((char*)aux_buffer);

    //Test SMS
    /*if (!GsmModem.setSMSMsgFormat(true)) 
        Serial.print_p(PSTR("Failed to set SMS format"));
    else if (!GsmModem.setGSMCharSet()) 
        Serial.print_p(PSTR("Failed to set SMS charset"));
    else{
        sprintf(buffer, "%s", "+61400047702");
        sprintf((char*)aux_buffer, "%s", "Test message from DefendLineII");

        mdmMode = true;
        if (!GsmModem.sendSMS((char*)buffer, (char*)aux_buffer))
        Serial.print_p(PSTR("Failed to send SMS"));

        //mdmMode = false;
    }*/
}


