/*
  CameraHelper.cpp - high level camera functionality
  Copyright (c) 2011 Dmitry Pakhomenko.  All right reserved.

  http://atmega.magictale.com

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <util/delay.h>

#include "CameraHelper.h"

inline volatile void onPicturePacketReceived(uint8_t* buf, uint16_t len, struct fat_file_struct* fd)
{
    Serial.print_p(WRITING);
    Serial.print(len, DEC);
    Serial.println_p(BYTES);

    LED_ORANGE_1;
    flashCard.fileWrite(fd, buf, len);
    LED_ORANGE_0;
}

uint8_t takePicture(char* fileName, uint16_t resCode)
{
    uint8_t attempts;

    for (attempts = 0; attempts < CAM_REPEATS; attempts++)
    {
        Serial.print_p(TAKING_PICTURE);
        Serial.print_p(AND_SAVING_AS);
        Serial.print(fileName);
        Serial.print_p(T_FULL_STOP);

        if (flashCard.initCard() == 0) continue;
        if (flashCard.touch(fileName) == 0) 
        {
            if (flashCard.rm(fileName) == 0) continue;
            else if (flashCard.touch(fileName) == 0) continue;
        }

        Serial.println_p(SYNC_WITH_CAMERA);
        if (!Camera.sync(&resCode)) continue;

        _delay_ms(500);
        _delay_ms(500);
        _delay_ms(500);
        _delay_ms(500);

        Serial.print_p(SERIAL_CAMERA);
        Serial.println_p(INITIAL);

        if (!Camera.initial(CCT_JPEG, CPR_160X120, CJR_640X480, &resCode)) continue;

        Serial.print_p(SERIAL_CAMERA);
        Serial.println_p(SET_PACKAGE_SIZE);

        if (!Camera.setPackageSize(0x80, &resCode)) continue;
        Serial.print_p(SERIAL_CAMERA);
        Serial.println_p(SNAPSHOT);

        if (!Camera.snapshot(CST_COMPRESSED, 0, &resCode)) continue;

        Serial.println_p(CAMERA_SYNCHRONIZED);

        struct fat_file_struct* fd = flashCard.fileOpen(fileName);
        if (fd)
        {
                uint8_t res = Camera.getPicture(CPT_SHAPSHOT, &resCode, 
                (uint8_t*)aux_buffer, AUX_BUF_LEN, onPicturePacketReceived, fd);

                flashCard.fileClose(fd);

                if (!res){
                        flashCard.rm(fileName);
                        Serial.print_p(FAILED_TO);
                        Serial.println_p(GET_PICTURE_FILE_DELETED);

                        continue;
                }
                return true;
        }else{
                Serial.print_p(FAILED_TO);
                Serial.println_p(GET_FILE_HANDLER);
        }

        continue;
    }
    LED_ORANGE_0;
    return false;
}
