#ifndef Board_h
#define Board_h

#include <avr/eeprom.h>
#include "PCF8563.h"

//  MMC
#define MMC0  PORTB &= ~(1 << 6)
#define MMC1  PORTB |= (1 << 6)

#define sbi(port,bitnum)                port |= _BV(bitnum)
#define cbi(port,bitnum)                port &= ~(_BV(bitnum))

#ifndef outb
        #define outb(addr, data)        addr = (data)
#endif
#ifndef inb
        #define inb(addr)                       (addr)
#endif
#ifndef outw
        #define outw(addr, data)        addr = (data)
#endif
#ifndef inw
        #define inw(addr)                       (addr)
#endif

#define LED_PORT        PORTC
#define LED_DDR         DDRC
#define LED_ORANGE      0
#define LED_BLUE        1

#define BUTTON1         5
#define BUTTON2         6
#define BTN1_MSK        0x20
#define BTN2_MSK        0x40

#define CTS0_PORT       PORTG
#define CTS0_DDR        DDRG
#define CTS0            3


#define LED_ORANGE_0 cbi(LED_PORT,LED_ORANGE)
#define LED_ORANGE_1 sbi(LED_PORT,LED_ORANGE)

#define LED_BLUE_0 cbi(LED_PORT,LED_BLUE)
#define LED_BLUE_1 sbi(LED_PORT,LED_BLUE)

#define RELAY_PORT      PORTC
#define RELAY_DDR       DDRC
#define RELAY_0         6
#define RELAY_1         7

#define RELAY_0_0       cbi(RELAY_PORT,RELAY_0)
#define RELAY_0_1       sbi(RELAY_PORT,RELAY_0)

#define RELAY_1_0       cbi(RELAY_PORT,RELAY_1)
#define RELAY_1_1       sbi(RELAY_PORT,RELAY_1)


#define MODEM_PORT      PORTC
#define MODEM_DDR       DDRC

#define PWRK            2
#define STAT            3
#define MDM_RTS         4
#define MDM_CTS         5

#define STAT_MSK        0x8
#define MDM_CTS_MSK     0x20

#define PWRK_0          cbi(MODEM_PORT,PWRK)
#define PWRK_1          sbi(MODEM_PORT,PWRK)

#define MDM_RTS_0       cbi(MODEM_PORT,MDM_RTS)
#define MDM_RTS_1       sbi(MODEM_PORT,MDM_RTS)


#define SENSOR0         0
#define SENSOR1         1
#define SENSOR2         2
#define SENSOR3         3
#define TMPR            4

#define SENSOR_IN       PINK
#define SENSOR_PORT     PORTK
#define SENSOR_DDR      DDRK

#define DEF_SENSORS_MSK 0x1F

#define DEF_REPORT_HOUR 19
#define DEF_TIMEZONE 0x0A00
//Power modem off when it is not used
#define DEF_MODEM_POWER_OFF true
//Interval in munites between modem wake up intervals
//for routine checks of incoming SMS commands
#define DEF_MODEM_POWER_INTERVAL 15

#define LCD_BACKLIGHT_PIN       13
#define MAX_BRIGHTNESS  255
//#define LCD_BACKLIGHT 7
//#define LCD_BACKLIGHT_0 cbi(PORTB,LCD_BACKLIGHT)
//#define LCD_BACKLIGHT_1 sbi(PORTB,LCD_BACKLIGHT)

#define SND_PIN         11

#define PMON_PIN        0
#define BMON_PIN        1

#define R12 100
#define R11 22
#define R12BYR11 R12 / R11
#define REF_VOLTAGE 256
#define ADC_MAX_VALUE 0x3FF

#define AUX_BUF_LEN 1024

#define SENSOR_DESCR_LEN 16
#define SERVER_HTTP_URL_LEN 60
#define STATUS_LEN 60

//Should be stored in EEPROM providing means to be redefined by end user
#define DEACT_CODE 0x2FC48B7
#define IR_RECV_PIN     38
//#define IR_RECV_PIN     5


#define TIMER_CLK_STOP                  0x00    ///< Timer Stopped
#define TIMER_CLK_DIV1                  0x01    ///< Timer clocked at F_CPU
#define TIMER_CLK_DIV8                  0x02    ///< Timer clocked at F_CPU/8
#define TIMER_CLK_DIV64                 0x03    ///< Timer clocked at F_CPU/64
#define TIMER_CLK_DIV256                0x04    ///< Timer clocked at F_CPU/256
#define TIMER_CLK_DIV1024               0x05    ///< Timer clocked at F_CPU/1024
#define TIMER_CLK_T_FALL                0x06    ///< Timer clocked at T falling edge
#define TIMER_CLK_T_RISE                0x07    ///< Timer clocked at T rising edge
#define TIMER_PRESCALE_MASK             0x07    ///< Timer Prescaler Bit-Mask


#define SYS_TIMER_FREQ  10
#define SYS_TIMER_CNTR  65535 - (F_CPU/64/SYS_TIMER_FREQ)
#define TEMP_SENSOR_READING_DELAY 750
#define MIN_YEAR 2000


//#define DEBUG
#define LCD
#define SND

#define CAM_REPEATS 3
#define MDM_REPEATS 1

typedef struct struct_EepromParams
{       
    uint8_t sensor0_descr[SENSOR_DESCR_LEN];
    uint8_t sensor1_descr[SENSOR_DESCR_LEN];
    uint8_t sensor2_descr[SENSOR_DESCR_LEN];
    uint8_t sensor3_descr[SENSOR_DESCR_LEN];
    uint8_t device_name[SENSOR_DESCR_LEN];
    uint8_t gsm_apn_name[SENSOR_DESCR_LEN];
    uint8_t server_HTTP_URL[SERVER_HTTP_URL_LEN];
    uint8_t sensor_mask;
    uint8_t report_hour;
    uint8_t time_zone_shift;
    uint8_t gprs_power_off;
    uint8_t gprs_power_interval;
    uint8_t gsm_apn_login[SENSOR_DESCR_LEN];
    uint8_t gsm_apn_pwd[SENSOR_DESCR_LEN];

} EepromParamsType;

typedef struct struct_StrEvent
{
    char* fileName;
    char* exTemp;
    char* subject;
    char* body;
    char* deviceID;
    char* softVer;
    char* detectorID;

} StrEventType;

enum enum_SysState
{
    sysRelayTest,
    sysDispDeviceName,
    sysDispDeviceNameWait,
    sysRTCTest,
    sysRTCTestWait,
    sysTempSensorTest,
    sysTempSensorTestWait,
    sysMicroSDTest,
    sysMicroSDTestWait,
    sysCameraTest,
    sysCameraTestWait,
    sysModemInitTest,
    sysModemInitTestWait,
    sysModemNameTest,
    sysModemNameTestWait,
    sysModemIMEITest,
    sysModemIMEITestWait,
    sysModemNwkReg,
    sysModemNwkRegWait,
    sysModemPowerOff,

//    sysGpsTest,

    sysReady,
    sysGuarding,
    sysFailure
};

enum enum_Event
{   evt_Alarm,
    evt_SMSCmd,
    evt_DailyReport,

    evt_IRRemoteCmd,
    evt_Power,
    evt_ConsoleCmd,
    evt_RTC,
    evt_TempThreshold,
    evt_GPS
};

typedef struct struct_SysEvent
{
    uint8_t evt;
    RtcTimeType timeStamp;
    uint8_t data;
} SysEventType;

extern EepromParamsType eepromParams;

extern volatile uint8_t termCmd;
extern volatile uint8_t ctrlC;
extern volatile uint8_t* aux_buffer[AUX_BUF_LEN];
extern volatile uint8_t mdmMode;
extern volatile uint8_t kbdInt;
extern volatile uint8_t sysState;
extern void (*boot_loader_start)(void);
extern volatile uint8_t gpsMode;
extern volatile uint8_t cameraMode;
extern volatile uint8_t lastSensorStates;
extern volatile uint8_t currSensorStates;
extern volatile uint8_t lcdBacklight;
extern volatile uint8_t lcdOnTime;

extern char *missionImpossible;

uint8_t createEventFile(char* fileName);
uint8_t takePicture(char* fileName, uint16_t resCode);
uint8_t sendPicture(char* fileName, char* subject, char* body, char* detectorID);
bool isTimeSync();

#endif

