import asyncore, socket
import time
import RPi.GPIO as GPIO


GPIO.setmode(GPIO.BCM)
# GPIO PINS (BCM) https://makezine.com/projects/tutorial-raspberry-pi-gpio-pins-and-python/
# https://learn.sparkfun.com/tutorials/raspberry-gpio/python-rpigpio-api
PIN_D_BUTTON 	= 18
PIN_D_WHITELED 	= 24
PIN_D_BLUELED 	= 23
PIN_D_ACTIVE 	= 25


DISCONNECT                = 1#  // OUTGOING : Ask the AVS client to disconnect from us
WAKE_WORD_DETECTED        = 2#  // OUTGOING : sent to AVS client when a wake word is detected
PAUSE_WAKE_WORD_ENGINE    = 3#  // INCOMING : request to pause the engine and yield the Mic
RESUME_WAKE_WORD_ENGINE   = 4#  // INCOMING : request to resume the engine
CONFIRM                   = 5#  // OUTGOING : sent to AVS client to confirm the engine has stopped
UNKNOWN                   = 6


GPIO.setup(PIN_D_BUTTON, GPIO.IN, pull_up_down = GPIO.PUD_DOWN)
GPIO.setup(PIN_D_BLUELED,GPIO.OUT)
GPIO.setup(PIN_D_WHITELED,GPIO.OUT)
GPIO.setup(PIN_D_ACTIVE,GPIO.OUT)


HOST='localhost'
PORT=5123
isPaused=False
timerOn=False
touched=False
start=0

def check_button_press():
    global touched
    b=GPIO.input(PIN_D_BUTTON)	
    if ((b==1) and (not touched) and (not isPaused)):
	print("Touched")
        touched=True
        return True
    else:
        return False
		

def processCommand(state):
    global isPaused
    global start
    global timerOn
    global touched 
    touched=False
    if (state==PAUSE_WAKE_WORD_ENGINE):
        print("PAUSED")
        GPIO.output(PIN_D_BLUELED, GPIO.HIGH)
        GPIO.output(PIN_D_WHITELED, GPIO.LOW)
        GPIO.output(PIN_D_ACTIVE, GPIO.HIGH)
        isPaused = True;
    if (state==RESUME_WAKE_WORD_ENGINE):
        print("UNPAUSED")
        GPIO.output(PIN_D_BLUELED, GPIO.LOW)
	if (isPaused==False):
	    GPIO.output(PIN_D_WHITELED, GPIO.LOW)
	    GPIO.output(PIN_D_ACTIVE, GPIO.LOW)
	    timerOn = False
	else:
            GPIO.output(PIN_D_WHITELED, GPIO.HIGH)
            GPIO.output(PIN_D_ACTIVE, GPIO.HIGH)
            timerOn = True;
            start = int(round(time.time() * 1000))
	isPaused = False
	
class WakeWordAgent(asyncore.dispatcher):
    command=0

    def initiate_connection(self):
        self.create_socket(socket.AF_INET, socket.SOCK_STREAM)
        self.connect( (HOST, PORT) )
        
    def __init__(self):
        asyncore.dispatcher.__init__(self)
        self.initiate_connection()

    def handle_connect(self):
        print("Connected")

    def handle_close(self):
        self.close()
        print("Closed")

    def handle_read(self):
	global isPaused
        data=self.recv(4)
        bytes_received=bytearray(data)
	ch=bytes_received[len(bytes_received)-1]
        if (ch<>0):
            processCommand(ch)   

    def writable(self):
        return (self.command > 0)

    def handle_write(self):
        bytes_send = bytearray()
        bytes_send.append(0)
        bytes_send.append(0)
        bytes_send.append(0)
        bytes_send.append(self.command)
        sent = self.send(bytes_send)
        self.command=0


client = WakeWordAgent()
while True:
    while asyncore.socket_map:
        if (check_button_press()):
            client.command=WAKE_WORD_DETECTED
		
        if (timerOn==True):
	    stop = int(round(time.time() * 1000))
	    print("Waiting")
	    if (stop - start) > 5000:
	    	processCommand(RESUME_WAKE_WORD_ENGINE)
				
        asyncore.loop(timeout=1, count=1)
		
    print("No connection")
    time.sleep(2)
    print("Retrying")
    client.initiate_connection()




