#define RedLED 3
#define GreenLED 6
#define BlueLED 5

boolean powerOn = false;

int r = 0;
int g = 0;
int b = 0;

boolean blinking = false; //Whether or not we should be blinking the light
boolean blinkState = false; //When we are blinking, is the light supposed to be on (true) or off (false)
unsigned long blinkInterval = 1000; //How long we want between blinks.
long lastBlink = 0;

char inData;

void setup()
{
  pinMode(RedLED, OUTPUT);
  pinMode(GreenLED, OUTPUT);
  pinMode(BlueLED, OUTPUT);
  analogWrite(RedLED, 255); //Start out with the light off
  analogWrite(GreenLED, 255);
  analogWrite(BlueLED, 255);
  
  Serial.begin(9600);
}

void loop()
{
  if (Serial.available() > 0) //If there is data coming from the pc
  {
     inData = Serial.read() - '10';
     
     if (inData == 0) // 0 means turn light off
     {
         togglePower(false); 
     }
     else if (inData == 1) // 1 means turn light on
     {
        togglePower(true); 
     }
     else if (inData == 3) // 3 means change colors
     {
       r = 255 - getIncomingData();
       g = 255 - getIncomingData();
       b = 255 - getIncomingData();
       
       //Serial.println(r); //For testing purposes
       //Serial.println(g);
       //Serial.println(b); 
       
       if (powerOn)
       {
         updateColors();
       }
     }
     else if (inData == 4) // 4 means turn off blink mode
     {
       blinking = false;
       updateColors();
       //Serial.println("Blink mode off"); //For testing purposes
     }
     else if (inData == 5) // 5 means turn on blink mode
     {
       blinkInterval = getIncomingData();
       blinking = true;
       //Serial.println("Blink mode on "); //For testing purposes
       //Serial.println(blinkInterval); //For testing purposes
     }

  }
  
  //This section controls the blinking
  if (blinking && powerOn)
  {
    if (millis() - lastBlink >= blinkInterval)
    {
      lastBlink = millis();
      if (blinkState)
      {
        updateColors();
      }
      else if (!blinkState)
      {
        turnLEDoff();
      }
      
      blinkState = !blinkState;
    }
  }
}

void togglePower(boolean on)
{
  if (!on)
  {
    powerOn = false;
    
    turnLEDoff();
    
    //Serial.println("Power is off"); //For testing purposes
  }
  else if (on)
  {
    powerOn = true;
    updateColors(); //This turns on the rgb LED
    //Serial.println("Power is on"); //For testing purposes
  }
}

void turnLEDoff()
{
    //For thie RGB led, 255 is what we think of as 0.
    digitalWrite(RedLED, 255);
    digitalWrite(GreenLED, 255);
    digitalWrite(BlueLED, 255);
}

// Credit for this section goes to ROBOTMAN at Trossen Robotics Community forums.
int getIncomingData()
{
  inData = 0;
  int newNumber = 0;
  
  while (inData != '/')
  {
    inData = Serial.read();
    if (inData > 0 && inData != '/')
    {
       newNumber = newNumber * 10 + inData - '0';
    }
  }
  
  return newNumber;
}

void updateColors()
{
 analogWrite(RedLED, r);
 analogWrite(GreenLED, g);
 analogWrite(BlueLED, b);
}
