//multi mode version
//modes are rotating circularly 
//
//mode 0 - slow fading
//mode 1 - slow switching
//mode 2 - fast fading
//mode 3 - fast switching



#include "C:\projects\pic\pic12f683\pwm_led.h"

//void rand_duty(&int,&int);
void rand_duty(int &r, int &rN);
void load_duty_values(void);
void load_duty_values_j(void);
void read_EEPROM_duty(void);


//boolean dirR=0;
//boolean dirG=0;
//boolean dirB=0;

boolean i = 0;

//int time_dir = 0;
int led_period = 0;
long state_time = 0;

int ledR_duty=41;
int ledG_duty=182;
int ledB_duty=61;
int ledR_dutyNew=32;
int ledG_dutyNew=64;
int ledB_dutyNew=128;

int state = 0;
long mode_time = 0;	//time period of current mode

BYTE address_mode=0;
BYTE value_mode=0;
BYTE address_duty=1;
//BYTE value_duty=0;

int temp = 0;

#define FAST_RATE 4
#define SLOW_RATE 16

#define MAX_LED_PERIOD 255

#define ledB_pin PIN_A0 
#define ledR_pin PIN_A1 
#define ledG_pin PIN_A2 

#define STATE_T_FAST 100 //state_time * timer1_period (30mS)
#define STATE_T_SLOW 300

//define duration of mode
#define SWITCH_MODE 5000 //time * timer1_period (30mS)

#define MAX_STAP 36


//timer0 period - 32 uS (PWM period is 8.192 mS or 122Hz)
//
#int_RTCC
void RTCC_isr()
{

//	if(i==0) {i=1; output_high (PIN_A5);}
//	else {i=0; output_low (PIN_A5);}


	led_period++;
	
	if(led_period==MAX_LED_PERIOD) 
	{
		led_period = 0;
	}

	if(led_period<=ledB_duty)
		output_high (ledB_pin);
	else
		output_low (ledB_pin);


	if(led_period<=ledR_duty)
		output_high (ledR_pin);
	else
		output_low (ledR_pin);

	if(led_period<=ledG_duty)
		output_high (ledG_pin);
	else
		output_low (ledG_pin);

	set_timer0(192); 
}

//period of duty changing
//and mesuring of long time periods
#int_TIMER2
void TIMER2_isr()
{
	state_time++;
	mode_time++;

	if(ledB_duty != ledB_dutyNew) {
		if(ledB_duty<ledB_dutyNew) ledB_duty++;
		else ledB_duty--;
	}

	if(ledR_duty != ledR_dutyNew) {
		if(ledR_duty<ledR_dutyNew) ledR_duty++;
		else ledR_duty--;
	}

	if(ledG_duty != ledG_dutyNew) {
		if(ledG_duty<ledG_dutyNew) ledG_duty++;
		else ledG_duty--;
	}
}



void main()
{
	setup_oscillator(OSC_8MHZ);	
   	setup_adc_ports(NO_ANALOGS|VSS_VDD);
   	setup_adc(ADC_OFF);
  	setup_timer_0(RTCC_INTERNAL|RTCC_DIV_1);
   	setup_timer_1(T1_DISABLED);
    setup_timer_2(T2_DIV_BY_16,255,SLOW_RATE);	//0.5 uS * 16 * 256 * 16 = 0.032768 S
   	setup_comparator(NC_NC_NC_NC);
   	setup_vref(FALSE);
 	
	enable_interrupts(INT_RTCC);
//	enable_interrupts(INT_TIMER1);
  	enable_interrupts(INT_TIMER2);
   	enable_interrupts(GLOBAL);
 

	value_mode = read_EEPROM(address_mode); 


	switch(value_mode) {
		case 0:
			write_EEPROM(address_mode,1);
			read_EEPROM_duty();			
		break;
		case 1:
			write_EEPROM(address_mode,2);			
			read_EEPROM_duty();			
		break;
		case 2:
			write_EEPROM(address_mode,3);			
			setup_timer_2(T2_DIV_BY_16,255,FAST_RATE);
			read_EEPROM_duty();			
		break;
		case 3:
			write_EEPROM(address_mode,0);			
			setup_timer_2(T2_DIV_BY_16,255,FAST_RATE);
			read_EEPROM_duty();			
		break;
		default:
			write_EEPROM(address_mode,0);	
			rand_duty(ledR_duty,ledR_dutyNew);
			rand_duty(ledG_duty,ledG_dutyNew);
			rand_duty(ledB_duty,ledB_dutyNew);
			write_EEPROM(address_duty,ledR_dutyNew);			
			write_EEPROM(address_duty+1,ledG_dutyNew);			
			write_EEPROM(address_duty+2,ledB_dutyNew);			
	}



   while (TRUE) {

		switch(value_mode) {
			case 0:
				load_duty_values();
			break;
			case 1:
				if(state_time >= STATE_T_SLOW) {
					state_time = 0;
					load_duty_values_j();
				}
			break;
			case 2:
					load_duty_values();
			break;
			case 3:
				if(state_time >= STATE_T_FAST) {
					state_time = 0;
					load_duty_values_j();
				}
			break;
		}	


		if(mode_time >= SWITCH_MODE) {
			mode_time = 0;
			switch(value_mode) {
				case 0:
					value_mode = 1;
					state_time = 0;
				break;
				case 1:
					value_mode = 2;
					setup_timer_2(T2_DIV_BY_16,255,FAST_RATE);
				break;
				case 2:
					value_mode = 3;
					state_time = 0;
				break;
				case 3:
					value_mode = 0;
					setup_timer_2(T2_DIV_BY_16,255,SLOW_RATE);
				break;

			}
		}
	}
}

void load_duty_values(void) {
	if(ledB_duty == ledB_dutyNew) {
		rand_duty(ledB_duty,ledB_dutyNew);
	}
	if(ledG_duty == ledG_dutyNew) {
		rand_duty(ledG_duty,ledG_dutyNew);
	}
	if(ledR_duty == ledR_dutyNew) {
		rand_duty(ledR_duty,ledR_dutyNew);
	}
}


void load_duty_values_j(void) {
	if(ledB_duty == ledB_dutyNew) {
		rand_duty(ledB_duty,ledB_dutyNew);
		ledB_duty = ledB_dutyNew;
	}
	if(ledG_duty == ledG_dutyNew) {
		rand_duty(ledG_duty,ledG_dutyNew);
		ledG_duty = ledG_dutyNew;
	}
	if(ledR_duty == ledR_dutyNew) {
		rand_duty(ledR_duty,ledR_dutyNew);
		ledR_duty = ledR_dutyNew;
	}
}


void rand_duty(int &r, int &rN){
	rN = r;
	shift_right(&rN,1,(bit_test(r,2)^bit_test(r,0)));
}

void read_EEPROM_duty(void) {
	ledR_dutyNew = read_EEPROM(address_duty); 
	ledG_dutyNew = read_EEPROM(address_duty+1); 
	ledB_dutyNew = read_EEPROM(address_duty+2); 
}
