/*

RFM69_transmitter3
D.R.Patterson, 7/10/2018

With Pressure and temperature data from a MPL3115A2 sensor
Data is sent and received
"Ak" is sent to synchronise the receiver
When "Ak" is received, sensor data is sent

A unit specific pressure correction is applied to the MPL3115A2
The sea level pressure is calculated using the base altitude.
This is applied to the MPL3115A2 sensor.

Temperature is calibrated.
This is problematic.
The sensor appears to self heat for up to 17 miniutes,
requiring an increasing temperature correction, then
a fixed temperaure correction.
  Raw temperure values (zero correction) were plotted against time.
  A polynomial fit was found for values returned after 1 minute.
  For the 1st minute a simple linear correction appeared satisfactory.

The maximum altitude, altitude (above base) and temperature are sent to the reciver

   IMPORTANT: Make sure the NODEID and GATEWAYID as set connectly for each node
              For 2 way communication between 2 radios for instance
			  Radio1: NODEID 1  GATEWAYID 2
			  Radio2: NODEID 2  GATEWAYID 1
   Library by Felix Rusu - felix@lowpowerlab.com
   Get the RFM69 and SPIFlash library at: https://github.com/LowPowerLab/

For RC altitude limit is 400ft is 121.92m
(1000 ft if BMFA and < 3.5Kg)

use newbase = xx.x from serial port to change the base address
1 Decimal place!

*/

#include <RFM69.h>    //get it here: https://www.github.com/lowpowerlab/rfm69
#include <SPI.h>  // Include SPI if you're using SPI

#define NODEID        1    //unique for each node on same network
#define NETWORKID     100  //the same on all nodes that talk to each other
#define GATEWAYID     2    //The receiving node id
//Match frequency to the hardware version of the radio
#define FREQUENCY     RF69_433MHZ
// Aerial length 173mm ( wavelength/4 = c / (4*Frequency) )
// hobbytronics 16.5cm (8mm less)?

// ________ Review and amend this section ___________________________________________

// use your own 16 character encryption key!
#define ENCRYPTKEY    "DRPattEncryptkey" //exactly the same 16 characters/bytes on all nodes!
#define SERIAL_BAUD   74880
#define DATA_SIZE     20

// set default base altitude
// kitchen table 51.3 m
// cadmac 46-47 m
const float ALTBASIS = 51.3; // base altitude in m

// pressure correction
// Pa 4Pa per bit -512 to +508
const int pcorrection = -64;

// temperature coefficients
// unboxed
float mUB = 0.5;
float ccUB = 0.65;
float aUB = 0.0025;
float bUB = -0.0909;
float cUB = 1.1282;
float dUB = -0.0882;
// boxed
float mB = 0.6; //0.5;
float ccB = 0.4;
float aB = 0.002365;  //0.0027;
float bB = -0.10335;  //-0.1159;
float cB = 1.633007;  //1.7325;
float dB = -0.60147;  //-0.6926;

const boolean isBoxed = true;
const boolean Tcalibrate = false;

// Offset by base height rather than calibrated base height
// true use base as offset
// false use calibrated base as offset
const boolean useBase = false;

// __________________________________________________________________________________

float tempcorrection = 0;
// temperature correction is affected by enclosure!
// -8 to +7.9375 C,
// 0.0625 per bit

long TRANSMITPERIOD = 500; //transmit a packet to gateway so often (in ms)
char payload[DATA_SIZE];        // outgoing data buffer
char pdata[DATA_SIZE];
byte sendsize = 0;
boolean requestACK = false;
unsigned long lastPeriod = 0;
unsigned long tstart;
RFM69 radio;
String S;
float mintemp, maxtemp;
float maxaltitude = -99999;
float minaltitude = 99999;
const int STATUS = 0x00; // status register
float basealt;

float newbasealt;
float basetemp, seapress;

boolean useSerial = true;
const byte sPin = 5;

float fixTemp( float mytemp){ // Thermometer appears to self heat
  if (Tcalibrate) return mytemp;

// apply time elapsed correction
float tt = float(millis()) / 60000.0; // elapsed time in miutes
  if(isBoxed){
    if (tt > 17) tt = 17;
  
    if (tt < 1){
    mytemp = mytemp  -(mB *tt + ccB);
    }else{
    mytemp = mytemp - (aB * tt * tt * tt + bB * tt * tt + cB * tt + dB );
    }
  }else{ // un -boxed
    if(tt > 15) tt = 15;

    if (tt < 1) {
    mytemp = mytemp - (mUB * tt + ccUB);
    }else{ 
    mytemp = mytemp - (aUB *tt * tt * tt + bUB * tt * tt + cUB * tt + dUB);
    }
  }
return mytemp;
}

void setup() {
pinMode(sPin, INPUT_PULLUP);
pinMode(sPin + 1, OUTPUT);
  if(digitalRead(sPin) == LOW) useSerial = false;
  
  if (useSerial) Serial.begin(SERIAL_BAUD);
delay(100);
  if (useSerial) Serial.println(F("Initialising Transmitter"));
pinMode(2,INPUT);
radio.initialize(FREQUENCY,NODEID,NETWORKID);
radio.encrypt(ENCRYPTKEY);
delay(100);
  if (useSerial) Serial.println(F("Initialising Sensor"));
radio.sendWithRetry(GATEWAYID, "Sensor Init", 12, 1);
 
  if(!initSensor()){  // sensor not responding
  radio.sendWithRetry(GATEWAYID, "Bad Sensor", 11, 1);
    while(true){}
  }
  
// Sensor ok  
oneshotP();
  for (byte i = 0; i < 2; i++) { // discard some values
  while ((IIC_Read(STATUS) & 2) == 0);
  Baro_Read(); // reject
  oneshotP();
  }
sendAk();
  if (!Tcalibrate) {
  boolean waiting = true;
    while (waiting == true){
      if(useSerial) {
        if (Serial.available() > 0) {
        String S = "";
          while (Serial.available() > 0){
          byte c = Serial.read();
            if ((c != 13) && (c != 10) ){
            payload[sendsize] = (char)c;
            S = S + (char)c;
            }
          }

          if (S.startsWith("newbase")) {
          byte p = S.indexOf("=") + 1;
          S = S.substring(p);
          S.trim();
          float val = S.toFloat();
          unsigned long newval = val * 10;       
          writeeeprom(2, newval);
          Serial.println(F("________________________\n"));

            if(!initSensor()){  // sensor not responding
            radio.sendWithRetry(GATEWAYID, "Bad Sensor", 11, 1);

              while(true){}
            }
          // sensor ok
          oneshotP();
            for (byte i = 0; i < 2; i++) { // discard some values
              while ((IIC_Read(STATUS) & 2) == 0);
            Baro_Read(); // reject
            oneshotP();
            }
          sendAk();      
          }
        }
      }
 
      if (radio.receiveDone()) {
      S = "";  
        for (byte i = 0; i < radio.DATALEN; i++) {
        byte c = radio.DATA[i];
          if ((c != 10) && (c != 13)) S = S + (char)radio.DATA[i];
        }

        if (radio.ACKRequested()) radio.sendACK();
    
        if (S == "Ak") {
        waiting = false;
        } else {
          if (useSerial) {
          Serial.print(F("Received "));
          Serial.println(S);    
          }
        }
      }

      if((IIC_Read(STATUS) & 2) == 2){
      float currpress = Baro_Read(); 
      oneshotP();
        if(!useBase) {
        float myaltitude = altitude(currpress, seapress);
          if (abs(myaltitude - newbasealt) > 0.30) newbasealt = myaltitude;
        }
      }

      if ((millis() - tstart) > 5000) sendAk();
    }

    if (useSerial){
    Serial.println(F("Ak Received"));
    Serial.print(F("Ground Level ")); Serial.print(newbasealt); Serial.println(F(" m")); 
    Serial.flush();
    }
  }    

int T = float(millis()) / 1000 + 0.5;
String temp = String(T);
temp.trim();
temp = "T:" + temp;
unsigned int L = temp.length();
temp.toCharArray(pdata, L + 1); 
radio.sendWithRetry(GATEWAYID, pdata, L, 1);
}

void sendAk(){
payload[0] = 'A';
payload[1] = 'k';
  if (useSerial) Serial.println(F("\nSending Ak"));
radio.sendWithRetry(GATEWAYID, payload, 2, 1);
  if (useSerial) Serial.println(F("Waiting for Ak"));
tstart = millis();
}

void loop() {

  //process any serial input
  if (useSerial) {
    if (Serial.available() > 0) {
    S = "K<";
      while (Serial.available() > 0){
      byte c = Serial.read();
        if ((c != 13) && (c != 10) && (sendsize < DATA_SIZE)){
        payload[sendsize] = (char)c;
        S = S + payload[sendsize];
        sendsize++;
        }
      }
    Serial.println(S);
    }
  }

  //check for any received radio packets
  if (radio.receiveDone()) {
  S = "R<";  
    for (byte i = 0; i < radio.DATALEN; i++) {
    S = S + (char)radio.DATA[i];
    }
    
    if (useSerial) Serial.println(S);
    if (radio.ACKRequested()) radio.sendACK();
  }

  // data transmission
  if ((IIC_Read(STATUS) & 2) == 2) { // wait for new data ready
  float currpress = Baro_Read();
  float myaltitude = altitude(currpress, seapress) - newbasealt; // get altitude above base
  
  float mytemperature = fixTemp(Temp_Read() ); // temp in centigrade
  // reset for new altitude sample
  oneshotP(); // get ready for next one (376-377 mS later..)


    if (mytemperature > maxtemp) maxtemp = mytemperature;
    if (mytemperature < mintemp) mintemp = mytemperature;
    if (myaltitude > maxaltitude) maxaltitude = myaltitude;
    if (myaltitude < minaltitude) minaltitude = myaltitude;
  String a = String(myaltitude, 1); a.trim();
  String m = String(maxaltitude, 1); m.trim();
  String t = String(mytemperature, 1); t.trim();
  String out = "P:"+ a + "," + m + "," + t + " C";
  unsigned int L = out.length();
  out.toCharArray(pdata, L + 1); 
  radio.sendWithRetry(GATEWAYID, pdata, L, 1);
    if (useSerial){
    Serial.print("D>" + out);
    Serial.print(F(" (Presure ")); Serial.print(currpress); Serial.print(F(" Pa ) "));
      if (Tcalibrate){
      unsigned long tt = millis();
      int mins = tt / 60000;
      int secs = ( (tt / 1000) % 60);  
      Serial.print(mins);Serial.print(":");Serial.println(secs);
      }else Serial.println();
    }
  
    while( (IIC_Read(STATUS) & 2) == 2) { // wait for status bit to clear
                                          // probably not needed
    delay(1);
    }
  }
  
  // deal with serial input
  if (useSerial) {
  unsigned long currPeriod = millis() / TRANSMITPERIOD;
    if ((currPeriod != lastPeriod) && (sendsize > 0) ) {
    lastPeriod = currPeriod;
    radio.sendWithRetry(GATEWAYID, payload, sendsize, 1);
    S = "S>";
      for (byte i = 0; i < sendsize; i++) {
      S = S + payload[i];
      }
    Serial.println(S);
    }
  sendsize = 0;
  }
}
