/*
   Example RFM69 sender/receiver sketch
   Hobbytronics.co.uk 
   This is a sketch based on the examples from the library, but with all the unnecessary code removed
   Use this sketch as to send/receive data from a serial connection

   IMPORTANT: Make sure the NODEID and GATEWAYID as set connectly for each node
              For 2 way communication between 2 radios for instance
			  Radio1: NODEID 1  GATEWAYID 2
			  Radio2: NODEID 2  GATEWAYID 1
   Library by Felix Rusu - felix@lowpowerlab.com
   Get the RFM69 and SPIFlash library at: https://github.com/LowPowerLab/
*/
#include <RFM69.h>    //get it here: https://www.github.com/lowpowerlab/rfm69
#include <SPIFlash.h>

#define NODEID        2    //unique for each node on same network
#define NETWORKID     100  //the same on all nodes that talk to each other
#define GATEWAYID     1    //The receiving node id
//Match frequency to the hardware version of the radio (uncomment one):
#define FREQUENCY     RF69_433MHZ
//#define FREQUENCY   RF69_868MHZ
//#define FREQUENCY   RF69_915MHZ
#define ENCRYPTKEY    "DrP" //exactly the same 16 characters/bytes on all nodes!
//#define IS_RFM69HW    //uncomment only for RFM69HW! Leave out if you have RFM69W!

#define LED           9 // LED on D9 - Not necessary

#define SERIAL_BAUD   115200
#define DATA_SIZE     50

int TRANSMITPERIOD = 10; //transmit a packet to gateway so often (in ms)
char payload[DATA_SIZE];        // outgoing data buffer
byte sendsize=0;
boolean requestACK = false;

RFM69 radio;

void setup() {
  Serial.begin(SERIAL_BAUD);
  pinMode(2,INPUT);
  radio.initialize(FREQUENCY,NODEID,NETWORKID);
  #ifdef IS_RFM69HW
    radio.setHighPower(); //uncomment only for RFM69HW!
  #endif
  radio.encrypt(ENCRYPTKEY);
}

long lastPeriod = 0;
void loop() {
  //process any serial input
  if (Serial.available() > 0)
  {
    payload[sendsize] = Serial.read();
    sendsize++;
  }

  //check for any received packets
  if (radio.receiveDone())
  {
    for (byte i = 0; i < radio.DATALEN; i++)
      Serial.print((char)radio.DATA[i]);

    if (radio.ACKRequested())
    {
      radio.sendACK();
    }
  }

  int currPeriod = millis()/TRANSMITPERIOD;
  if ((currPeriod != lastPeriod) || (sendsize>(DATA_SIZE-2)))
  {
    lastPeriod=currPeriod;
    
    if(sendsize>0)
    {
      radio.sendWithRetry(GATEWAYID, payload, sendsize);
      sendsize = 0;
    }
  }
}
