/******************************************************************************
  SSD1306_Cube.ino

  This is a modified version of the Sparkfun example code for their MicroOLED Arduino Library
  It has been modified to work on the Hobbytronics OLED 128x64 module

  The same terms of use apply - see below

  *******************************************************************************
 * MicroOLED_Cube.ino
 * Rotating a 3-D Cube on the MicroOLED Breakout
 * Jim Lindblom @ SparkFun Electronics
 * Original Creation Date: October 27, 2014
 * 
 * This sketch uses the MicroOLED library to draw a 3-D projected
 * cube, and rotate it along all three axes.
 * 
 * Development environment specifics:
 *  Arduino 1.0.5
 *  Arduino Pro 3.3V
 *  Micro OLED Breakout v1.0
 * 
 * This code is beerware; if you see me (or any other SparkFun employee) at the
 * local, and you've found our code helpful, please buy us a round!
 * 
 * Distributed as-is; no warranty is given.
 ******************************************************************************/
#include <Wire.h>  // Include Wire if you're using I2C
#include <SPI.h>  // Include SPI if you're using SPI
#include <HT_SSD1306.h>  // Include the HT_SSD1306 library

//////////////////////////
// SSD1306 Definition //
//////////////////////////
#define PIN_RESET 9  // Connect RST to pin 9
#define PIN_DC    8  // Connect DC to pin 8
#define PIN_CS    10 // Connect CS to pin 10
#define DC_JUMPER 1  // For I2C Communication - this pin pulled high by default

//////////////////////////////////
// SSD1306 Object Declaration //
//////////////////////////////////
SSD1306 oled(PIN_RESET, PIN_DC, PIN_CS); // SPI declaration
//SSD1306 oled(PIN_RESET, DC_JUMPER);    // I2C declaration

int SCREEN_WIDTH = oled.getLCDWidth();
int SCREEN_HEIGHT = oled.getLCDHeight();

float d = 3;
float px[] = { 
  -d,  d,  d, -d, -d,  d,  d, -d };
float py[] = { 
  -d, -d,  d,  d, -d, -d,  d,  d };
float pz[] = { 
  -d, -d, -d, -d,  d,  d,  d,  d };

float p2x[] = {
  0,0,0,0,0,0,0,0};
float p2y[] = {
  0,0,0,0,0,0,0,0};

float r[] = {
  0,0,0};

#define SHAPE_SIZE 800
// Define how fast the cube rotates. Smaller numbers are faster.
// This is the number of ms between draws.
#define ROTATION_SPEED 0

void setup()
{
  oled.begin();
  oled.clear(ALL);
  oled.logo();
  oled.display();  
  delay(2000);
}

void loop()
{
  drawCube();
  delay(ROTATION_SPEED);
}

void drawCube()
{
  r[0]=r[0]+PI/180.0; // Add a degree
  r[1]=r[1]+PI/180.0; // Add a degree
  r[2]=r[2]+PI/180.0; // Add a degree
  if (r[0] >= 360.0*PI/180.0) r[0] = 0;
  if (r[1] >= 360.0*PI/180.0) r[1] = 0;
  if (r[2] >= 360.0*PI/180.0) r[2] = 0;

  for (int i=0;i<8;i++)
  {
    float px2 = px[i];
    float py2 = cos(r[0])*py[i] - sin(r[0])*pz[i];
    float pz2 = sin(r[0])*py[i] + cos(r[0])*pz[i];

    float px3 = cos(r[1])*px2 + sin(r[1])*pz2;
    float py3 = py2;
    float pz3 = -sin(r[1])*px2 + cos(r[1])*pz2;

    float ax = cos(r[2])*px3 - sin(r[2])*py3;
    float ay = sin(r[2])*px3 + cos(r[2])*py3;
    float az = pz3-150;

    p2x[i] = SCREEN_WIDTH/2+ax*SHAPE_SIZE/az;
    p2y[i] = SCREEN_HEIGHT/2+ay*SHAPE_SIZE/az;
  }

  oled.clear(PAGE);
  for (int i=0;i<3;i++) 
  {
    oled.line(p2x[i],p2y[i],p2x[i+1],p2y[i+1]);
    oled.line(p2x[i+4],p2y[i+4],p2x[i+5],p2y[i+5]);
    oled.line(p2x[i],p2y[i],p2x[i+4],p2y[i+4]);
  }    
  oled.line(p2x[3],p2y[3],p2x[0],p2y[0]);
  oled.line(p2x[7],p2y[7],p2x[4],p2y[4]);
  oled.line(p2x[3],p2y[3],p2x[7],p2y[7]);
  oled.display();
}

