/*

RFM69_Receiver
D.R.Patterson 7/10/2018

   RFM69 Receive / Send
   Shows elapsed time since transmitter was powered up
   Elapsed time includes an estimated 13 seconds before 1st
   Ak is sent by transmitter after powering up
   If the elapsed startup time is received this
   is used instead of the default 13s 

    Shows pressure and temperature data from transmitter
    Red Led(1) to show 3.3V Regulator is working
    Green Led indicates data has been received
    Red Led(2) indicates when altitude is > 400ft (121.92m)
    
   IMPORTANT: Make sure the NODEID and GATEWAYID as set connectly for each node
              For 2 way communication between 2 radios for instance
			  Radio1: NODEID 1  GATEWAYID 2
			  Radio2: NODEID 2  GATEWAYID 1
   Library by Felix Rusu - felix@lowpowerlab.com
   Get the RFM69 and SPIFlash library at: https://github.com/LowPowerLab/
*/

#include <RFM69.h>    //get it here: https://www.github.com/lowpowerlab/rfm69
#include <SPIFlash.h>
#include <HT_SSD1306.h>  // Include the HT_SSD1306 library
//////////////////////////
// SSD1306 Definition //
//////////////////////////
#define PIN_RESET 5  // Connect RST to pin 9 (SPI & I2C)
#define PIN_DC    4  // Connect DC to pin 8 (SPI only)
#define PIN_CS    3 // Connect CS to pin 10 (SPI only)

//////////////////////////////////
// SSD1306 Object Declaration //
//////////////////////////////////
SSD1306 oled(PIN_RESET, PIN_DC, PIN_CS);  // SPI Example

const int middleY = oled.getLCDHeight() / 2;
const int middleX = oled.getLCDWidth() / 2;

#define NODEID        2    //unique for each node on same network
#define NETWORKID     100  //the same on all nodes that talk to each other
#define GATEWAYID     1    //The receiving node id
//Match frequency to the hardware version of the radio (uncomment one):
#define FREQUENCY     RF69_433MHZ
// Aerial length 173mm
// hobbytronics 16.5cm (8mm less)? 

#define ENCRYPTKEY    "DRPattEncryptkey" //exactly the same 16 characters/bytes on all nodes!
#define SERIAL_BAUD   74880
#define DATA_SIZE     20

byte sendsize = 0;
unsigned long lastPeriod = 0;
String S;
unsigned long tstart, tbegin;
unsigned long newtime;

boolean useSerial = true;
const boolean requestACK = false;
const unsigned long TRANSMITPERIOD = 500; //transmit a packet to gateway so often (in ms)
const byte led = 9;
byte Toffset = 13; // takes 13 seconds before ak sent by transmitter
RFM69 radio;
boolean ok;

void setup() {
byte i;
pinMode(A1, INPUT_PULLUP);
pinMode(led-1,OUTPUT);
pinMode(led,OUTPUT);
pinMode(2,INPUT);
pinMode(7,OUTPUT);

  if(digitalRead(A1) == LOW){
  useSerial = false;
  digitalWrite(led, HIGH); delay(200);
  digitalWrite(led, LOW); delay(200);
  digitalWrite(led, HIGH); delay(200);
  digitalWrite(led, LOW); delay(200);
  }

digitalWrite(led, HIGH);

  if (useSerial) {
  Serial.begin(SERIAL_BAUD);
  delay(200);
  Serial.println(F("Initialising"));
  }
radio.initialize(FREQUENCY,NODEID,NETWORKID);
radio.encrypt(ENCRYPTKEY);
 
oled.begin();     // Initialize the OLED
oled.clear(PAGE); // Clear the display's internal memory
oled.clear(ALL);  // Clear the library's display buffer

float V = vok(true);
printTitle(String(V, 2)+" V" , 1, true);
oled.display();
delay(2000);

oled.logo();  
oled.display();   // Display what's in the buffer (splashscreen)
delay(5000);
oled.clear(ALL);
digitalWrite(led, LOW);

  if (useSerial) Serial.println(F("Waiting for Ak"));
printTitle(F("Awaiting Ak"), 1, true);
digitalWrite(PIN_CS, LOW); // disable the screen
ok = true;
  while (ok == true){
  digitalWrite(led, LOW);
    if (radio.receiveDone()) {
    digitalWrite(led, HIGH);  
    S = "";  
      for (i = 0; i < radio.DATALEN; i++) {
      byte c = radio.DATA[i];
        if ((c != 10) && (c != 13)) S = S + (char)radio.DATA[i]; 
      }
      
      if (radio.ACKRequested()) radio.sendACK();
      
      if (S.startsWith("Ak")) {
      ok = false;
        if (useSerial) Serial.println(F("Received Ak\nSending Ak"));
      ak();
      } else {
        if (useSerial) {
        Serial.print(F("Received "));
        Serial.println(S);
        }
      }
      
    digitalWrite(PIN_CS, HIGH);
    printTitle("R<" + S, 1, true);
    digitalWrite(PIN_CS, LOW);    
    
    }
  }
  
// has the starting up time been sent?
newtime = millis();
  while ((millis() - newtime) <300){
    if (radio.receiveDone()) {
    S = "";  
      for (i = 0; i < radio.DATALEN; i++) {
      S = S + (char)radio.DATA[i];
      }
      
      if (radio.ACKRequested()) radio.sendACK(); 
      
      if (S.startsWith("T:")) {
      S = S.substring(2);
      int t = S.toInt();
        if ((t < 256) && (t>0)) Toffset = t; 
      }
      
    break;
    }
  }
oled.clear(ALL);
digitalWrite(PIN_CS, HIGH);
tstart = millis();
tbegin = tstart;
  if (useSerial) Serial.println(F("Waiting for Data"));
printTitle(F("Awaiting data"), 1, false);
}

void loop() {
byte i;
char payload[DATA_SIZE];

digitalWrite(led, LOW);  
  //process any serial input
  if (useSerial) {
    if (Serial.available() > 0) {
    S = "K<";
      while (Serial.available() > 0){
      byte c = Serial.read();
        if ((c != 13) && (c != 10) && (sendsize < DATA_SIZE)){
        payload[sendsize] = (char)c;
        S = S + payload[sendsize];
        sendsize++;
        }
      }
    Serial.println(S);
    }
  }
  
  //check for any received radio packets
  if (radio.receiveDone()) {
  digitalWrite(led, HIGH);
  S = "";  
    for (i = 0; i < radio.DATALEN; i++) {
    S = S + (char)radio.DATA[i];
    }
    
    if (radio.ACKRequested()) radio.sendACK();
    
    if (S == "Ak"){ 
    ak(); // ak back
    }
    
    if (S.startsWith("P:")) {
    printData(S, 1);   
    } else {
    S = "R<" + S;  
    printTitle(S, 1, false);
      if (useSerial) Serial.println(S);
    }
  }

// Serial data transmission
unsigned long currPeriod = millis() / TRANSMITPERIOD;
  if ((currPeriod != lastPeriod) || (sendsize > (DATA_SIZE-2))) {
  lastPeriod = currPeriod;
    
    if (sendsize > 0) {
    radio.sendWithRetry(GATEWAYID, payload, sendsize, 1);  
      if (useSerial) {
      S = "S>";
        for (i = 0; i < sendsize; i++) {
        S = S + payload[i];
        }
      Serial.println(S);
      }
    sendsize = 0;
    }
  }else{
    if ((millis() - newtime) > 999) { // only update time every second
    showtime(false);
    oled.display();
    }
  }
  
  if((millis() - tbegin) >  119999){ // check battery every 2 minutes
  tbegin = millis();
  vok(false);
  }
}

void ak(){
digitalWrite(led, LOW);
delay(200);
//payload[0] = 'A';
//payload[1] = 'k';
radio.sendWithRetry(GATEWAYID, "Ak", 3, 1);
  if (useSerial) Serial.println(F("Ak Sent"));
}

/*
void sync(){
  if (useSerial) Serial.println(F("Sending Sync"));
printTitle(F("Sending Sync"), 1, true); 
radio.sendWithRetry(GATEWAYID, "Sync", 5, 1);
}
*/

void showtime(boolean clockstop){
int minutes;
int seconds;
unsigned long TNow;
  if (clockstop) {
  TNow = 0;
  } else {
  newtime = millis();
  TNow = (newtime - tstart)/ 1000 + Toffset;
  }
minutes = TNow / 60;
seconds = TNow % 60;
oled.setFontType(2);
oled.setCursor(40, 0);
  if (minutes<10) oled.print(0);
oled.print(minutes); oled.print(" ");
  if (seconds < 10) oled.print(0);
oled.print(seconds);
}

void printTitle(String title, int font, boolean clockstop){
oled.clear(PAGE);
showtime(clockstop);
oled.setFontType(font);
// Try to set the cursor in the middle of the screen
int L = oled.getFontWidth() * title.length();
int xpos = 0;
  if (L < oled.getLCDWidth()){
  xpos = middleX - L / 2;
  }
oled.setCursor(xpos, middleY - (oled.getFontHeight() / 2));
// Print the title:
oled.print(title);
oled.display();
}

void printData(String S, int font){
S.trim(); 
  if (useSerial){
  Serial.println();
  Serial.println(S);
  }

oled.clear(PAGE);
showtime(false);
oled.setFontType(font);

// Set the text in the middle of the screen
// Display Altitude
byte p = S.indexOf(",");
String T = S.substring(2 , p);
  // signal 400ft limit
  if(T.toFloat() > 121.9) digitalWrite(7, HIGH); else digitalWrite(7, LOW);
showme( T + " m", 3, 2);

// Display Max Altitude
byte np = S.indexOf(",", p + 1);
showme(S.substring(p + 1 , np) + " m", 2, 1);

// Display Temperatue
p = S.indexOf("C") + 1;
showme(S.substring(np + 1 , p), 1, 1 );
oled.display();
}

void showme(String myval, byte y, byte offset) {
int L;
L = oled.getFontWidth() * myval.length();
oled.setCursor(middleX - L / 2, oled.getLCDHeight() - y * oled.getFontHeight() + offset);
oled.print(myval);
  if (useSerial) Serial.println(myval);  
}

float vok(boolean show){
float V = analogRead(A0) * 0.0096997; // (7.98/3.97)* 4.94/1024 
  if(show){
    if (useSerial){
    Serial.print(F("Battery ")); Serial.print(V, 3); Serial.println(F(" V"));
    }
  }
  
  if ((V >4.4) && (V < 7.77)){ // 7.77 for 2 cells
  digitalWrite(led, LOW);
  digitalWrite(PIN_CS, HIGH);
  oled.setFontType(1);
  showme(F("LOW BATTERY!"), 3, 2);
  oled.display();
  digitalWrite(PIN_CS, LOW);
  radio.sleep();
    while(true){}
  } // <4.4 if on usb
return V;
}
