// Lego R/C Car with XBee
// Sam Thongrong
// sam_thongrong@hotmail.com
// For Instructable.com
// Oct 1, 2012
// Nov 16, 2012

//#include <Servo.h> 
         
#define TURN_PIN    10  // use D10 for servo     
       
#define DRIVE_ENABLE_PIN  9 //3  // use PWM for this pin   
#define BACKWARD_PIN      8 //4          
#define FORWARD_PIN       7 //2  

// Input Commands
#define BEGIN_COMMAND  0x7F  // decimal = 127, binary = 0111 1111
#define FORWARD        0x1   // decimal =   1, binary = 0000 0001
#define BACKWARD       0x2   // decimal =   2, binary = 0000 0010
#define LEFT           0x4   // decimal =   4, binary = 0000 0100
#define RIGHT          0x8   // decimal =   2, binary = 0000 1000

int command[2];

//Servo turnServo;  // create servo object to control a servo 
int   servoPos = 90;
int servomSec = 1500;
int speed = 250; // 0 - 255

void setup() {
  Serial.begin(9600);
  
  pinMode(DRIVE_ENABLE_PIN, OUTPUT);
  pinMode(BACKWARD_PIN, OUTPUT);
  pinMode(FORWARD_PIN, OUTPUT);
  
  pinMode(TURN_PIN, OUTPUT);
}

void loop() {
  // listen for wireless commands
  if (Serial.available() > 0) {
    if (readCommand() > 0) {
      executeCommand();
      delay(100);
    }
  }
}

int readCommand() {
  int b = Serial.read();
  if (b == BEGIN_COMMAND) {
    command[0] = readByte();
    command[1] = readByte();
    return 1;
  } else {
    return 0;
  }
}

// blocking read
int readByte() {
  while (true) {
    if (Serial.available() > 0) {
      return Serial.read();
    }
  }
}

void executeCommand() {
  int c     = command[0];
  int speed = command[1];

  digitalWrite(DRIVE_ENABLE_PIN, LOW);
  if (c & FORWARD) {
    digitalWrite(BACKWARD_PIN, LOW);
    digitalWrite(FORWARD_PIN, HIGH);
  }
  if (c & BACKWARD) {
    digitalWrite(FORWARD_PIN, LOW);
    digitalWrite(BACKWARD_PIN, HIGH);
  }
  if (c & (FORWARD | BACKWARD)) {
    //digitalWrite(DRIVE_ENABLE_PIN, HIGH);
    analogWrite(DRIVE_ENABLE_PIN, speed);
  }
   
  //digitalWrite(TURN_ENABLE_PIN, LOW);
  if (c & LEFT) {
    // turn left
    for (int i=0; i<100; i++){
      digitalWrite(TURN_PIN, HIGH);
      // Positive delay
      delayMicroseconds(500); 
    
      digitalWrite(TURN_PIN, LOW);
      // Negative delay
      delay(20); 
    }
  }
  if (c & RIGHT) {
    // turn right
    for (int i=0; i<100; i++){
      digitalWrite(TURN_PIN, HIGH);
      // Positive delay
      delayMicroseconds(2200); 
    
      digitalWrite(TURN_PIN, LOW);
      // Negative delay
      delay(20); 
    }
  }
  if (c != (LEFT | RIGHT)) {
    // go straight!
   //digitalWrite(TURN_ENABLE_PIN, HIGH);
     // go stright
    for (int i=0; i<100; i++){
      digitalWrite(TURN_PIN, HIGH);
      // Positive Delay
      delayMicroseconds(1300); 
    
      digitalWrite(TURN_PIN, LOW);
      // Negative delay
      delay(20); 
    } 
  }
}


