#include <Bounce.h>
#include <Servo.h>
 
#define PIN_DISTANCE_SENSOR A0
#define PIN_SERVO_INPUT     A1
#define PIN_ARMED_LASER     2
#define PIN_PUMP_CONTROL    3
#define PIN_ARM_SWITCH      4
#define PIN_SERVO_PWM       5
#define PIN_PIR_SENSOR      6

#define ARMED     1
#define NOT_ARMED 0
#define SHOT_TIME 400

Bounce armButton = Bounce(PIN_ARM_SWITCH, 10);
Servo shoulderServo;

boolean armButtonPressed = false;
boolean systemStatus = NOT_ARMED;
boolean lastSystemStatus = ARMED;
boolean pirDetected = false;
boolean targetWithinRange = false;
boolean pumpActive = false;

const int shotsToFire = 3;
const int distanceThresholdInches = 24;
const int distanceThreshold = 280; 
const int servoRetractedPos = 50;
const int servoArmedPos = 150;
const int servoInterpolationDelay = 10; // smoother action

int servoAnalogPos = 0;
int rawDistanceValue = 0;
//int distanceInInches = 0;


void setup() {

  pinMode(PIN_PUMP_CONTROL, OUTPUT);
  pinMode(PIN_ARMED_LASER, OUTPUT);
  pinMode(PIN_PIR_SENSOR, INPUT_PULLUP);
  pinMode(PIN_ARM_SWITCH, INPUT_PULLUP);
  //getServoPosition
  shoulderServo.attach(PIN_SERVO_PWM);
  //shoulderServo.write(90);//for servo pos, until servo retracted
  //delay(500); // allow the servo to reach it's middle position before system on
  Serial.begin(9600);

}

void loop() {
  
  getInput();
  if (armButtonPressed) systemStatus = !systemStatus; // press once to arm the system, press again to disarm
  if (systemStatus != lastSystemStatus){ // on state change, do some things
    if (systemStatus == ARMED){
      setSystemReady(); // move the servo up
    } else if (systemStatus == NOT_ARMED){
      setSystemRetracted(); // move back
    }
    lastSystemStatus = systemStatus;
  }
  armButtonPressed = false;
  if (systemStatus == ARMED && targetWithinRange && pirDetected){
    for (int ii = 0; ii < shotsToFire; ii++){//fire the water gun;
      digitalWrite(PIN_PUMP_CONTROL, HIGH);
      delay(SHOT_TIME);
      digitalWrite(PIN_PUMP_CONTROL, LOW);
      delay(SHOT_TIME);
    }
  }
  
}

void getInput(){

  if(armButton.update()){ // any button change?
    if (armButton.fallingEdge()){ //button.fallingEdge(); = press || button.risingEdge(); = release 
      armButtonPressed = true; // used as a flag
    }
  }
  
  rawDistanceValue = analogRead(PIN_DISTANCE_SENSOR);
  servoAnalogPos = analogRead(PIN_SERVO_INPUT);
  //distanceInInches = map(rawDistanceValue, 1023, 0, 0, some value);
  //targetWithinRange = distanceInInches < distanceThreshold ? 1 : 0;
  targetWithinRange = rawDistanceValue > distanceThreshold ? 1 : 0;
  pirDetected = !digitalRead(PIN_PIR_SENSOR);
  
}

void setSystemReady(){
 // if (blah) check to see if the servo is already in position), move from either the set postion else{ or the undefined position
  for(int ii = servoRetractedPos; ii <= servoArmedPos; ii += 1){                                  
    shoulderServo.write(ii);               
    delay(servoInterpolationDelay);                       
  } 
  digitalWrite(PIN_ARMED_LASER, true);
}

void setSystemRetracted(){
  digitalWrite(PIN_ARMED_LASER, false);
  for(int ii = servoArmedPos; ii >= servoRetractedPos; ii -= 1){                                  
    shoulderServo.write(ii);               
    delay(servoInterpolationDelay);                       
  } 
}

