/* ========================================
 *
 * Copyright Andyk75, 2016
 * All Rights Reserved
 * UNPUBLISHED, LICENSED SOFTWARE.
 *
 * ========================================
*/
#ifndef __WATCHDOGTIMER_H__
#define __WATCHDOGTIMER_H__
    
/* ========================================
 *  Includes
 * ======================================== */
#include <project.h>
    
    
    
/* ========================================
 * Global defines, Typedefs, Structures
 * ======================================== */

/* WDT related constants */

#define WDT_BLE_INTERRUPT               (CY_SYS_WDT_COUNTER0)    
#define WDT_BLE_INTERRUPT_MASK          (CY_SYS_WDT_COUNTER0_MASK)
#define WDT_BLE_INTERRUPT_SOURCE        (CY_SYS_WDT_COUNTER0_INT)
#define WDT_COUNTER_ENABLE              (1u)
// this is the timeout for this timer: 200 equals 6ms    = 200 / 32767 
// #define WDT_BLE_INTERRUPT_COUNT_PERIOD  (200ul)
    
#define WDT_COUNTER                 (CY_SYS_WDT_COUNTER1)
#define WDT_COUNTER_MASK            (CY_SYS_WDT_COUNTER1_MASK)
#define WDT_INTERRUPT_SOURCE        (CY_SYS_WDT_COUNTER1_INT)
#define WDT_COUNTER_ENABLE          (1u)
// This is the duration for this timer: 32767 equals 1s.    
#define WDT_COUNT_PERIOD            (32767ul)       
    
/* ========================================
 * Public Functions 
 * ======================================== */

void WDT_Start( uint32 BLE_WatchDog_Timeout , void *TimerISRCallback );

    

/* 
Usage: 
clear all settings in the slow-clock-tab of Design wide ressources.

create TimerISRCallback function:
    CY_ISR_PROTO(Timer_Interrupt);

implement this function like shown below. 
Call Setup from main with the ISR-callback function.

    WDT_Start(WatchdogTimeout, &Timer_Interrupt );

Adjust the Timer-Periods, in defines above or as the first function-parameter.

*/
    
    
    
// Template to copy into main:    
/*******************************************************************************
* Function Name: Timer_Interrupt
********************************************************************************
*
* Summary:
*  Handles the Interrupt Service Routine for the WDT timer.
*
* Parameters:
*   None
*
* Return:
*   None
*
*******************************************************************************/
/* 
CY_ISR(Timer_Interrupt)
{
    uint32 Interrupt_Source = CySysWdtGetInterruptSource();
    
    switch(Interrupt_Source) {        
        case WDT_BLE_INTERRUPT_SOURCE :
            // Just wake up to handle BLE
            // BLUE_Write(~BLUE_Read()); 
            TriggerDisplayFromIRQ = true;
            break;
                
        case WDT_INTERRUPT_SOURCE:
                // This is a 1s Interrupt source! 
                Debounceflag = false;
                // Just wake up for handling BLE
            break;
        
        default: 
            break;
    }
    
    // Clear interrupt request 
    CySysWdtClearInterrupt(Interrupt_Source);
    
}
*/
    
    
    
#endif // __WATCHDOGTIMER_H__
/* [] END OF FILE */
