/* ========================================
 *
 * Copyright Andyk75, 2016
 * All Rights Reserved
 * UNPUBLISHED, LICENSED SOFTWARE.
 *
 * ========================================
*/

/* ========================================
 *  Includes
 * ======================================== */
#include <watchdogtimer.h>

/* ========================================
 * Local Function Prototypes
 * ======================================== */



/* ========================================
 *  global variables
 * ======================================== */



/* ========================================
 * Public Functions 
 * ======================================== */
/*******************************************************************************
* Function Name: WDT_Start
********************************************************************************
*
* Summary:
*  Configures and starts Watchdog timer to trigger an interrupt every second.
*
* Parameters:
*   None
*
* Return:
*   None
*
*******************************************************************************/
void WDT_Start( uint32 BLE_WatchDog_Timeout , void *TimerISRCallback )
{
    /* Unlock the WDT registers for modification */
    CySysWdtUnlock();
    /* Setup ISR callback */
    WDT_Interrupt_StartEx(TimerISRCallback);
    
    /* Write the mode to generate interrupt on match */
    CySysWdtWriteMode(WDT_BLE_INTERRUPT, CY_SYS_WDT_MODE_INT);
    /* Configure the WDT counter clear on a match setting */
    CySysWdtWriteClearOnMatch(WDT_BLE_INTERRUPT, WDT_COUNTER_ENABLE);
    /* Configure the WDT counter match comparison value */
    CySysWdtWriteMatch(WDT_BLE_INTERRUPT, BLE_WatchDog_Timeout);
    /* Reset WDT counter */
    CySysWdtResetCounters(WDT_BLE_INTERRUPT);
    /* Enable the specified WDT counter */
    CySysWdtEnable(WDT_BLE_INTERRUPT_MASK);
    /* Lock out configuration changes to the Watchdog timer registers */
    
    /* Write the mode to generate interrupt on match */
    CySysWdtWriteMode(WDT_COUNTER, CY_SYS_WDT_MODE_INT);
    /* Configure the WDT counter clear on a match setting */
    CySysWdtWriteClearOnMatch(WDT_COUNTER, WDT_COUNTER_ENABLE);
    /* Configure the WDT counter match comparison value */
    CySysWdtWriteMatch(WDT_COUNTER, WDT_COUNT_PERIOD);
    /* Reset WDT counter */
    CySysWdtResetCounters(WDT_COUNTER);
    /* Enable the specified WDT counter */
    CySysWdtEnable(WDT_COUNTER_MASK);
    /* Lock out configuration changes to the Watchdog timer registers */
    
    CySysWdtLock();
}


/* ========================================
 *  Local Functions
 * ======================================== */


/* [] END OF FILE */
