/* ========================================
 *
 * Copyright Andyk75, 2016
 * All Rights Reserved
 * UNPUBLISHED, LICENSED SOFTWARE.
 *
 * ========================================
*/

/* ========================================
 *  Includes
 * ======================================== */
#include <poveffect.h>
#include <project.h>
#include <stdio.h>
#include <stdlib.h>
#include <utils.h>


/* ========================================
 * Local Function Prototypes
 * ======================================== */
#define MIN(a,b) (((a)<(b))?(a):(b))
#define MAX(a,b) (((a)>(b))?(a):(b))
#define	DEFAULT_TIMEOUT	( 50 )
#define MAXBRIGHTNESS_NIGHTMODE        30

inline uint8 calculate_sparkle( register uint8 i );
led_color GetNewSunDownColorFromList();
led_color GetNewSunDownColor();
void FadeStrip(  uint16 start, int16 length ,int percentage );
void StripLights_PixelHSV(int32 x,int32 y,hsv_color hsv );
void KITT(uint32 color);
uint32 ReduceColor(uint32 color, uint8 reduce) ;


/* ========================================
 *  global variables
 * ======================================== */

extern uint32  StripLights_ledArray[StripLights_ROWS][StripLights_COLUMNS];

uint8 kittcounter = 0, kittupdownselector = 0, hsvcounter = 0, hsvincrement = 0, valuecounter = 0;
uint8 LED = 16, HUE = 80, VALUE = 100, SATURATION = 255;
uint8_t flip = 0;

uint8 uc_Sundowncounter, uc_Sunrisecounter = 0;
uint8 reddone = 0, greendone = 0, bluedone = 0;
volatile uint8 StripBrightness = 0;
volatile uint16 myTime = 10;

led_color Sundowncolor, Sundowntempcolor;
uint16 FadeOutCounter = 0;
uint16 FadeOutCounterMax = StripLights_COLUMNS * 4; 

/* ========================================
 * Public Functions 
 * ======================================== */

void Display_new_Color(uint8 red, uint8 green, uint8 blue)
{
    led_color newcol; 
    newcol.c.r = red;
    newcol.c.g = green;
    newcol.c.b = blue;
    StripLights_MemClear(newcol.rgb);
}
void ColorKitt()
{
    hsv_color col;
    col.h.h = hsvcounter++;
    col.h.s = 0xFF;
    col.h.v = 100;
    
    KITT(hsv_to_rgb(col).rgb);    
}
void ColorSwirl()
{
    hsv_color col;
    col.h.h = hsvcounter++;
    col.h.s = 0xFF;
    col.h.v = 100;
    
    StripLights_MemClear(hsv_to_rgb(col).rgb);
}
void ValueSwirl()
{
    hsv_color col;
    
    if(kittcounter==0) 
    { 
        kittupdownselector = 0;
        hsvcounter = hsvcounter +43;
    }
    
    if(kittupdownselector == 0) { 
        kittcounter++;        
    } else {
        kittcounter--;
    }    
    
    if(kittcounter==100) kittupdownselector = 1;
    
    col.h.h = hsvcounter;
    col.h.s = 0xFF;
    col.h.v = kittcounter;
    
    StripLights_MemClear(hsv_to_rgb(col).rgb);
}
void RedKitt()
{
    KITT(StripLights_RED);
}


void CandyCane ( uint16_t count , uint32 c1, uint32 c2 )
{
    int x;
    count = 0;
	
    {   
        // all strip, for every other led
        for(x = StripLights_MIN_X; x <= StripLights_MAX_X; x+=2)
        {
			// if flipped. draw c1,c2 otherwise c2,c1
            if( flip ) {
                StripLights_Pixel(x, 0, c1);
                StripLights_Pixel(x+1, 0, c2);
            } else {
                StripLights_Pixel(x+1, 0, c1);
                StripLights_Pixel(x, 0, c2);
            }
        }

        flip = 1 - flip;
    }   
}

void Twinkle( uint16_t count ) 
{
        int i,x;
        led_color col;
        uint32 startColor;
        startColor = StripLights_WHITE;
            
        
        for(x = 0; x <= count; x++)
        {            

			col.c.r = rand();
			col.c.g = rand();
			col.c.b = rand();

			startColor = col.rgb;
                       
			StripLights_Pixel(rand()%StripLights_MAX_X, 0, startColor);
			
            for(i = StripLights_MIN_X; i <= StripLights_MAX_X; i++)
            {            
                col.rgb = StripLights_GetPixel(i, 0);
                
                if ( col.c.r > 0 ) col.c.r -= col.c.r/2; 
                if ( col.c.g > 0 ) col.c.g -= col.c.g/2; 
                if ( col.c.b > 0 ) col.c.b -= col.c.b/2; 
                
                StripLights_Pixel(i, 0, col.rgb );
            }        
      
//            while( StripLights_Ready() == 0);
//	    	StripLights_Trigger(1);
//            CyDelay( 15 );        
        }
        
}
void Icicle (uint8 redraw, uint8 length, int fade_amount )           
 {
    int x,j,i;
	led_color temp;

	// for entire length of strip, plus engough to move it off the display)
	for(x = StripLights_MIN_X; x <= StripLights_MAX_X + ( length * 2 ); x++)
	{
		
		if(fade_amount ) {
			// Fade  strip	
			FadeStrip( StripLights_MIN_X, StripLights_MAX_X , fade_amount );
		} else { 
			StripLights_MemClear(0);
		}
		
		
		// draw in same place 8 times
		for ( j = 0 ; j < redraw ;j++ ){
			
			// length of icicle
			for(i=0; i < length; i++)
			{
				// caculate a randow twink based on current position in length
				temp.c.r =
				temp.c.g =
				temp.c.b = calculate_sparkle( i  );

				// draw a pixel at x+i
			    StripLights_Pixel(x+i, 0, temp.rgb );
				
				CyDelay( 1 );  
		 	}    
			    
		}
		
		// check if firmware load requested
	    // if( Boot_P0_7_Read ( ) == 0 )   CySoftwareReset();
	}
}
void Sparkler ( uint16 runtime, int fade_amount , int num_sparkles ,char white ) 
{
    int x,j;
	led_color temp;

	// length of time to run
	for(x = 0; x <= runtime ; x++)
	{
		if(fade_amount ) {
			// Fade  strip	
			FadeStrip( StripLights_MIN_X, StripLights_MAX_X , fade_amount );
		} else { 
			StripLights_MemClear(0);
		}
		 
		
		// draw in same place 8 times
		for ( j = 0 ; j < num_sparkles ;j++ ){
						
			temp.c.r = calculate_sparkle( j );
			
			if (white ) { 
				temp.c.g = temp.c.b = temp.c.r;
			} else {
				temp.c.g = calculate_sparkle( j );
				temp.c.b = calculate_sparkle( j );
			}
				
			// draw a pixel 
			StripLights_Pixel(rand()%StripLights_MAX_X, 0, temp.rgb );
		}
	}
	
	if( fade_amount ) {
		// fade at end
		for(x = 0; x <= 200 ; x++)
		{
			// Fade  strip	
			FadeStrip( StripLights_MIN_X, StripLights_MAX_X , fade_amount );
		}
	}		
}
void ColorWheel( uint16_t count )
{
	static int i =0xAAA ,x;
	static uint32 color;
	static uint32 startColor ;   

    
	if (i >= count ) {
		i = 0;
	}
	
	if ( i == 0xaaa ) {
		i = 0;
		color = 0;
		startColor = 0;
	}
	
    for( ; i < count ; i++ )
    {   
        color = startColor;
        for(x = StripLights_MIN_X; x <= StripLights_MAX_X; x++)
        {
            StripLights_Pixel(x, 0, getColor( color ));

        	 color++;
            
			if(color >= StripLights_COLOR_WHEEL_SIZE) color = 0;
       	}
		
		startColor++;
    
		if(startColor >= StripLights_COLOR_WHEEL_SIZE) startColor = 0;

    }
}



/* ========================================
 *  Local Functions
 * ======================================== */

// Knight-Rider Animation 
void KITT(uint32 color)
{
    StripLights_MemClear( StripLights_BLACK );
    StripLights_Pixel(kittcounter, 0, color);
    
    if(kittcounter==StripLights_MIN_X) kittupdownselector = 0;
    if(kittupdownselector == 0) 
    { 
        StripLights_Pixel(kittcounter-1, 0, ReduceColor(color, 2));
        StripLights_Pixel(kittcounter-2, 0, ReduceColor(color, 4));
        StripLights_Pixel(kittcounter-3, 0, ReduceColor(color, 8));
        StripLights_Pixel(kittcounter-4, 0, ReduceColor(color, 16));
        kittcounter++;
    }
    else 
    {
        StripLights_Pixel(kittcounter+1, 0, ReduceColor(color, 2));
        StripLights_Pixel(kittcounter+2, 0, ReduceColor(color, 4));
        StripLights_Pixel(kittcounter+3, 0, ReduceColor(color, 8));
        StripLights_Pixel(kittcounter+4, 0, ReduceColor(color, 16));
        kittcounter--;
    }    
    if(kittcounter==StripLights_MAX_X) kittupdownselector = 1;
    
}

uint32 ReduceColor(uint32 color, uint8 reduce) 
{
    uint8 green  = ((uint8)(color & 0x000000FF)) / reduce;  // Write Green
    color = color >> 8;
    uint8 red = ( (uint8)(color & 0x000000FF) ) / reduce;  // Write Red
    color = color >> 8;
    uint8 blue = ( (uint8)(color & 0x000000FF) ) / reduce;  // Write Blue
    
    uint32 returncolor = ((uint32)blue<<16)+((uint32)red<<8)+green;
    
    return returncolor;
    
    
}

void FadeStrip(  uint16 start, int16 length ,int percentage )
{
	led_color trgb;
	int i;
	
    for(i = start; i <= start+length; i++) {
    
		// get pixel
		trgb.rgb = StripLights_GetPixel(i,0);
		
		trgb.rgb = TweenC1toC2( trgb,(led_color) StripLights_BLACK, percentage ) ;

		StripLights_Pixel( i, 0, trgb.rgb );
	}
}
//shortcut for generate a sparkle
inline uint8 calculate_sparkle( register uint8 i ) 
{
	register uint8 rnd;

	// every so often return very dark, to make it sparkle
	if ( rand() % 20 == 10 ) {
		return 3;
	}
	
	// pick value from hole range
	rnd = ( rand() % 255 );

	// scale down by level
	rnd /= ( i + 1 ) ;
	
	// scale down again if near end
	if ( i > 4 ) rnd /= 2;
	if ( i > 6 ) rnd /= 2;
	
	return rnd;
}

// quick helper function for testing hsv/rgb.
void StripLights_PixelHSV(int32 x,int32 y,hsv_color hsv )
{
	led_color rgb;
	
	rgb = hsv_to_rgb( hsv ) ;
	
	StripLights_Pixel( x,y,rgb.rgb);
}




/* [] END OF FILE */
