/* ========================================
 *
 * Copyright Andyk75, 2016
 * All Rights Reserved
 * UNPUBLISHED, LICENSED SOFTWARE.
 *
 * ========================================
*/
#ifndef __PERSISTENTSTORAGE_H__
#define __PERSISTENTSTORAGE_H__
    
/* ========================================
 *  Includes
 * ======================================== */
#include <project.h>
#include <stdbool.h>
    
    
    
/* ========================================
 * Global defines, Typedefs, Structures
 * ======================================== */
    
#define USER_SFLASH_ROW_SIZE            CY_SFLASH_SIZEOF_USERROW
#define SFLASH_STARTING_VALUE           (0x00) 
#define USER_SFLASH_ROWS                CY_SFLASH_NUMBER_USERROWS   /* Total number of user SFlash rows supported by the device */
#define USER_SFLASH_BASE_ADDRESS        CY_SFLASH_USERBASE          /* Starting address of user SFlash row for 128KB PSoC 4 BLE device */    
#define LOAD_FLASH				         0x80000004
#define WRITE_USER_SFLASH_ROW	         0x80000018
#define USER_SFLASH_WRITE_SUCCESSFUL     0xA0000000    
    
#define FLASH_NOT_WRITTEN                0xDEADBEEF    

typedef enum DataNames {
    e_SPEED = 10,  // 32bit
    e_WDTIMEOUT = 14,  // 32bit
    e_POVANIMATION = 18,    // 16bit
    Data3 = 20,
    LastData
} PersistenStorageDataNameEnum;
    
typedef struct PSTORB { uint8 Dataname; uint8 DataLength; uint32 DataValue; } S_PersistentStorageUpdate;

/* ========================================
 * Public Functions 
 * ======================================== */
uint32 PSTOR_WriteUserData(PersistenStorageDataNameEnum MyDataName, uint32 *dataPointer, bool WriteImmediatelytoFlash);   
void PSTOR_ReadUserFlashRow( void );
void PSTOR_ReadInitialParameters( PersistenStorageDataNameEnum MyDataName, uint32 *datapointer );
    

    
    
    
    
    
    
    
    
#endif // __PERSISTENTSTORAGE_H__
/* [] END OF FILE */
