/* ========================================
 *
 * Copyright Andyk75, 2017
 * All Rights Reserved
 * UNPUBLISHED, LICENSED SOFTWARE.
 *
 * ========================================
*/
#ifndef __BLE_PROCESS_H__
#define __BLE_PROCESS_H__
    
/* ========================================
 *  Includes
 * ======================================== */
#include <project.h>
    
/* ========================================
 * Global defines, Typedefs, Structures
 * ======================================== */
#define RGB_LED_SERVICE_INDEX           (CYBLE_RGB_LED_SERVICE_SERVICE_INDEX)

#define RGB_LED_CHAR_INDEX              (CYBLE_RGB_LED_SERVICE_RGB_LED_CHARACTERISTIC_CHAR_INDEX)
#define RGB_LED_CHAR_HANDLE				(CYBLE_RGB_LED_SERVICE_RGB_LED_CHARACTERISTIC_CHAR_HANDLE)
    
#define ANIMATION_SERVICE_INDEX         (CYBLE_ANIMATION_SERVICE_SERVICE_INDEX)
#define ANIMATION_CHAR_INDEX            (CYBLE_ANIMATION_SERVICE_ANIMATION_CHARACTERISTIC_CHAR_INDEX)
#define ANIMATION_CHAR_HANDLE           (CYBLE_ANIMATION_SERVICE_ANIMATION_CHARACTERISTIC_CHAR_HANDLE)    


    
#define PERSISTENT_STORAGE_SERVICE_INDEX  (CYBLE_PERSISTENTSTORAGESERVICE_SERVICE_INDEX)   // (0x03u) /* Index of PersistentStorageService service in the cyBle_customs array */
#define PSTOR_LONG_INDEX                  (CYBLE_PERSISTENTSTORAGESERVICE_LONGVARIABLES_CHAR_INDEX)  // (0x00u) /* Index of LongVariables characteristic */
#define SET_SPEED_INDEX                   (CYBLE_PERSISTENTSTORAGESERVICE_SET_SPEED_CHAR_INDEX)   //   (0x01u) /* Index of Set_Speed characteristic */
#define SET_WDTIMEOUT_INDEX               (CYBLE_PERSISTENTSTORAGESERVICE_SET_WDTIMEOUT_CHAR_INDEX)   //   (0x02u) /* Index of Set_WDTimeout characteristic */
#define SET_ANIMATION_PIC_INDEX           (CYBLE_PERSISTENTSTORAGESERVICE_SET_ANIMATION_CHAR_INDEX)   //   (0x03u) /* Index of Set_Animation characteristic */

#define PERSISTENT_STORAGE_SERVICE_HANDLE (CYBLE_PERSISTENTSTORAGESERVICE_SERVICE_HANDLE)   // (0x0019u) /* Handle of PersistentStorageService service */
#define PSTOR_LONG_HANDLE                 (CYBLE_PERSISTENTSTORAGESERVICE_LONGVARIABLES_CHAR_HANDLE)   // (0x001Bu) /* Handle of LongVariables characteristic */
#define SET_SPEED_HANDLE                  (CYBLE_PERSISTENTSTORAGESERVICE_SET_SPEED_CHAR_HANDLE)   //   (0x001Du) /* Handle of Set_Speed characteristic */
#define SET_WDTIMEOUT_HANDLE              (CYBLE_PERSISTENTSTORAGESERVICE_SET_WDTIMEOUT_CHAR_HANDLE)   //   (0x001Fu) /* Handle of Set_WDTimeout characteristic */
#define SET_ANIMATION_PIC_HANDLE          (CYBLE_PERSISTENTSTORAGESERVICE_SET_ANIMATION_CHAR_HANDLE)   //   (0x0021u) /* Handle of Set_Animation characteristic */

#define PSTOR_SERVICE_NAME_INDEX          (0)
#define PSTOR_SERVICE_VALUE_INDEX         (1)    
#define PSTOR_SET_VALUE_INDEX          (0)
    
#define TEXT_SERVICE_INDEX                (CYBLE_WRITE_TEXT_SERVICE_SERVICE_INDEX)   //    (0x04u) /* Index of Write_Text_Service service in the cyBle_customs array */
#define SET_CHARACTER_INDEX               (CYBLE_WRITE_TEXT_SERVICE_SET_CHARACTER_CHAR_INDEX)   //    (0x00u) /* Index of Set_Character characteristic */
#define CLEAR_TEXT_INDEX                  (CYBLE_WRITE_TEXT_SERVICE_CLEAR_STRING_CHAR_INDEX) //    (0x02u) /* Index of Clear_String characteristic */

#define TEXT_SERVICE_HANDLE               (CYBLE_WRITE_TEXT_SERVICE_SERVICE_HANDLE)   //    (0x0022u) /* Handle of Write_Text_Service service */
#define SET_CHARACTER_HANDLE              (CYBLE_WRITE_TEXT_SERVICE_SET_CHARACTER_CHAR_HANDLE)   //    (0x0024u) /* Handle of Set_Character characteristic */
#define CHARACTER_COUNT_HANDLE            (CYBLE_WRITE_TEXT_SERVICE_CHARACTERCOUNT_CHAR_HANDLE)   //    (0x0026u) /* Handle of CharacterCount characteristic */
#define CLEAR_TEXT_HANDLE                 (CYBLE_WRITE_TEXT_SERVICE_CLEAR_STRING_CHAR_HANDLE) //   (0x0029u) /* Handle of Clear_String characteristic */
#define TEXT_CHARACTER_POSITION           (0)    

#define CCC_DATA_INDEX					(0u)

#define BLE_STATE_ADVERTISING			(0x01)
#define BLE_STATE_CONNECTED				(0x02)
#define BLE_STATE_DISCONNECTED			(0x00)

#define PASSIVE_LED_STATUS				(0xFF)

#define LED_ADV_BLINK_PERIOD			(40000)
#define LED_CONN_ON_PERIOD				(145000)

#define MTU_XCHANGE_DATA_LEN			(0x0020)
    
#define RED_INDEX						(0)
#define GREEN_INDEX						(1)
#define BLUE_INDEX						(2)
#define INTENSITY_INDEX					(3)
#define ANIMATION_SELECTOR_INDEX        (0)
    
    
/* ========================================
 * Public Functions 
 * ======================================== */
void CustomEventHandler(uint32 event, void * eventParam);
void BLE_SetVersionData();
void BLE_WriteMovementReceivedNotification(volatile uint8 *FlagValue);


#endif // __BLE_PROCESS_H__
/* [] END OF FILE */
