/* ========================================
 *
 * Copyright Andyk75, 2016
 * All Rights Reserved
 * UNPUBLISHED, LICENSED SOFTWARE.
 *
 * ========================================
*/

/* ========================================
 *  Includes
 * ======================================== */
#include <BLE_Process.h>
#include <device.h>
#include <project.h>
#include <stdbool.h>
#include <persistentstorage.h>
#include <povanimation.h>

/* ========================================
 * Local Function Prototypes
 * ======================================== */
void StartFastAdvertising();
void UpdateRGBled( void );

/* ========================================
 *  global variables
 * ======================================== */
#define             REFRESH_INTERVAL                    (1000u)

extern volatile e_Animation Active_Animation;   // Variable für die aktive Animation. 

/* Connection handle used for transmitting information over BLE */
//CYBLE_CONN_HANDLE_T                 connHandle;
CYBLE_CONN_HANDLE_T                 cyBle_connHandle;

/* 'rgbHandle' stores RGB control data parameters */
CYBLE_GATT_HANDLE_VALUE_PAIR_T		rgbHandle;	
CYBLE_GATT_HANDLE_VALUE_PAIR_T		AnimationHandle;
CYBLE_GATT_HANDLE_VALUE_PAIR_T		KITTHandle;
CYBLE_GATT_HANDLE_VALUE_PAIR_T      VersionHandle;
CYBLE_GATT_HANDLE_VALUE_PAIR_T      PersistentStorageHandle;
CYBLE_GATT_HANDLE_VALUE_PAIR_T      TextWriteHandle;


/* Array to store the present RGB LED control data. The 4 bytes 
* of the array represents {R, G, B, Intensity} */
volatile uint8 RGBledData[4] = { 0 };
volatile uint8 Animationdata = 0;
volatile char MyCharacter = 0;

volatile S_PersistentStorageUpdate PersistentStorageLong;

/* Status flag for the Stack Busy state. This flag is used to notify the application 
* whether there is stack buffer free to push more data or not */
volatile uint8 busyStatus = 0;

/* This flag is used by application to know whether a Central 
* device has been connected. This is updated in BLE event callback 
* function*/
uint8 deviceConnected = false;
uint8 ucShowAnimation = true;
uint8 Use_Notifications = false;
static uint8 isConnectionUpdateRequested = true;
uint8 i;


/* ========================================
 * Public Functions 
 * ======================================== */

/*******************************************************************************
* Function Name: CustomEventHandler
********************************************************************************
* Summary:
* Call back event function to handle various events from BLE stack
*
* Parameters:
*  event:		event returned
*  eventParam:	link to value of the events returned
*
* Return:
*  void
*
*******************************************************************************/
void CustomEventHandler(uint32 event, void * eventParam)
{
    /* Local variable to strore the write request parameters */
	CYBLE_GATTS_WRITE_REQ_PARAM_T *wrReqParam;
    CYBLE_GATTC_READ_RSP_PARAM_T *rRegParam;
    CYBLE_GAP_AUTH_INFO_T *authInfo;
    CYBLE_GAP_SMP_KEY_DIST_T *KEY;
    CYBLE_GATT_ERR_CODE_T gattErr;

    switch(event)
    {
        case CYBLE_EVT_STACK_ON:
        	/* Start Advertisement and enter Discoverable mode*/
            // CyBle_GappStartAdvertisement(CYBLE_ADVERTISING_FAST);
            StartFastAdvertising();
			break;
			
        case CYBLE_EVT_TIMEOUT:
            // printf("Time OUT\r\n");
            // UseDeepSleep = true;
        break;
           
        /**********************************************************
        *                       GAP Events
        ***********************************************************/
        case CYBLE_EVT_GAP_DEVICE_DISCONNECTED:
            StartFastAdvertising();
        break;
            
		case CYBLE_EVT_GAPP_ADVERTISEMENT_START_STOP:
			/* Set the BLE state variable to control LED status */
            if(CYBLE_STATE_DISCONNECTED == CyBle_GetState())
            {
                 StartFastAdvertising();
            }
			break;
			
        case CYBLE_EVT_GAP_DEVICE_CONNECTED:
            // printf("Device Connected\r\n");
            /*Req Client to Start Authentication process*/
#ifdef UseBonding    
            CyBle_GapAuthReq(cyBle_connHandle.bdHandle, &cyBle_authInfo); // 2
#endif            
            //CyBle_GappStartAdvertisement(CYBLE_ADVERTISING_FAST);
            break;
            
        case CYBLE_EVT_GAP_AUTH_REQ:
                /*Authentication Request recieved from Master */
//                authInfo=((CYBLE_GAP_AUTH_INFO_T *)eventParam);
                // Timer_SetPrescaler(Timer_PRESCALE_DIVBY2);
            break;
        
        case CYBLE_EVT_GAP_PASSKEY_ENTRY_REQUEST:
                /*Passkey Entry Request*/
            break;

        case CYBLE_EVT_GAP_PASSKEY_DISPLAY_REQUEST:
                /*Passkey Display Request*/
                // Main_DisplayKey(*(uint32 *)eventParam);
                
            break;
        
        case CYBLE_EVT_GAP_KEYINFO_EXCHNGE_CMPLT:
                /*Key Information exchange completed */
                // KEY = (CYBLE_GAP_SMP_KEY_DIST_T *)eventParam;
            break;

        
        case CYBLE_EVT_GAP_ENCRYPT_CHANGE:
                /*Encyrption Change event*/
            break;
        
        case CYBLE_EVT_GAP_AUTH_COMPLETE:
                /*Authentication Completed*/
//                authInfo = (CYBLE_GAP_AUTH_INFO_T *)eventParam;
//                StoreBondingInformation();
            break;

        case CYBLE_EVT_GAP_AUTH_FAILED:
                /*Authentication Failed.Display the error code */
            break;
                
		/**********************************************************
        *                       GATT Events
        ***********************************************************/
        case CYBLE_EVT_GATT_CONNECT_IND:
			/* This flag is used in application to check connection status */
			deviceConnected = true;     // as long as someone is connected we are not allowed to prolong the BLE-Handling intervall for energy saving
            cyBle_connHandle = *(CYBLE_CONN_HANDLE_T *)eventParam;    // 1
			break;
        
        case CYBLE_EVT_GATT_DISCONNECT_IND:
			ucShowAnimation = true;
            /* Update deviceConnected flag*/
			deviceConnected = false;
            /*Device disconnected*/
            cyBle_connHandle.bdHandle=0;
            StartFastAdvertising();
            
            Use_Notifications = false;  // Prevent Notifications if Device is disconnected

			/* Reset the isConnectionUpdateRequested flag to allow sending
			* connection parameter update request in next connection */
			isConnectionUpdateRequested = true;  
            
			break;
        
        case CYBLE_EVT_GATTS_WRITE_CMD_REQ:
                /*Received Writewithout Response command from the Client*/
                wrReqParam =(CYBLE_GATTS_WRITE_REQ_PARAM_T*) eventParam; 
                
                gattErr = CyBle_GattsWriteAttributeValue(&wrReqParam->handleValPair, 0u, 
                        &wrReqParam->connHandle, CYBLE_GATT_DB_PEER_INITIATED);             
            break;    
                
        case CYBLE_EVT_GATTC_READ_MULTI_RSP:
                rRegParam = (CYBLE_GATTC_READ_RSP_PARAM_T *) eventParam;
            break;
    
            
        case CYBLE_EVT_GATTS_WRITE_REQ: 							
            /* This event is received when Central device sends a Write command 
             * on an Attribute. 
             * We first get the attribute handle from the event parameter and 
             * then try to match that handle with an attribute in the database.
             */
            wrReqParam = (CYBLE_GATTS_WRITE_REQ_PARAM_T *) eventParam;
             
            /* if (attributeHandle == RGB LED Characteristic Handle) */
            if(wrReqParam->handleValPair.attrHandle == cyBle_customs[RGB_LED_SERVICE_INDEX].\
								                        customServiceInfo[RGB_LED_CHAR_INDEX].\
                                                        customServiceCharHandle)
            {
                // ucShowAnimation = false;
                /* Extract the value of the attribute from the handle-value 
                 * pair database. */
                RGBledData[RED_INDEX] = wrReqParam->handleValPair.value.val[RED_INDEX];
                RGBledData[GREEN_INDEX] = wrReqParam->handleValPair.value.val[GREEN_INDEX];
                RGBledData[BLUE_INDEX] = wrReqParam->handleValPair.value.val[BLUE_INDEX];
                RGBledData[INTENSITY_INDEX] = wrReqParam->handleValPair.value.val[INTENSITY_INDEX];
                
                /* Update the PrISM components and the attribute for RGB LED read 
                 * characteristics */
                UpdateRGBled();
            }

            
            if(wrReqParam->handleValPair.attrHandle == cyBle_customs[ANIMATION_SERVICE_INDEX].\
								                        customServiceInfo[ANIMATION_CHAR_INDEX].\
                                                        customServiceCharHandle)
            {
                Main_ActivateAnimation(true); 
                Animationdata = wrReqParam->handleValPair.value.val[ANIMATION_SELECTOR_INDEX];
               
                Main_SelectAnimation(Animationdata);
                /* Update RGB control handle with new values */
   	            AnimationHandle.attrHandle = ANIMATION_CHAR_HANDLE;
	            AnimationHandle.value.val = wrReqParam->handleValPair.value.val;
	            AnimationHandle.value.len = sizeof(Animationdata);
	            AnimationHandle.value.actualLen = sizeof(Animationdata);
	            
                
            	/* Send updated Animation-Control handle as attribute for read by central device */
            	CyBle_GattsWriteAttributeValue(&AnimationHandle, false, &cyBle_connHandle, false);  
                            
            }
            
            if(wrReqParam->handleValPair.attrHandle == cyBle_customs[PERSISTENT_STORAGE_SERVICE_INDEX].\
								                        customServiceInfo[PSTOR_LONG_INDEX].\
                                                        customServiceCharHandle)
            {
                Main_ActivateAnimation(false); 
                PersistentStorageLong.Dataname = wrReqParam->handleValPair.value.val[PSTOR_SERVICE_NAME_INDEX];
                PersistentStorageLong.DataValue = (wrReqParam->handleValPair.value.val[PSTOR_SERVICE_VALUE_INDEX])<<24 ;
                PersistentStorageLong.DataValue = PersistentStorageLong.DataValue + ( (wrReqParam->handleValPair.value.val[PSTOR_SERVICE_VALUE_INDEX+1])<<16) ;
                PersistentStorageLong.DataValue = PersistentStorageLong.DataValue + ( (wrReqParam->handleValPair.value.val[PSTOR_SERVICE_VALUE_INDEX+2])<<8) ;
                PersistentStorageLong.DataValue = PersistentStorageLong.DataValue + ( (wrReqParam->handleValPair.value.val[PSTOR_SERVICE_VALUE_INDEX+3])) ;
                
                if( Main_UpdatePersistentStorageVariable(&PersistentStorageLong) == ERROR_VARIABLE_NOT_FOUND) {
                    PersistentStorageLong.Dataname = 0xFF;
                }
                
                PersistentStorageHandle.attrHandle = PSTOR_LONG_HANDLE;
	            PersistentStorageHandle.value.val = wrReqParam->handleValPair.value.val;
	            PersistentStorageHandle.value.len = sizeof(PersistentStorageLong);
	            PersistentStorageHandle.value.actualLen = sizeof(PersistentStorageLong);	            
                
            	/* Send updated Animation-Control handle as attribute for read by central device */
            	CyBle_GattsWriteAttributeValue(&PersistentStorageHandle, false, &cyBle_connHandle, false);  
                            
            }
            
            if(wrReqParam->handleValPair.attrHandle == cyBle_customs[PERSISTENT_STORAGE_SERVICE_INDEX].\
								                        customServiceInfo[SET_SPEED_INDEX].\
                                                        customServiceCharHandle)
            {
                Main_ActivateAnimation(false); 
                PersistentStorageLong.Dataname = e_SPEED;
                PersistentStorageLong.DataValue = (wrReqParam->handleValPair.value.val[PSTOR_SET_VALUE_INDEX])<<24 ;
                PersistentStorageLong.DataValue = PersistentStorageLong.DataValue + ( (wrReqParam->handleValPair.value.val[PSTOR_SET_VALUE_INDEX+1])<<16) ;
                PersistentStorageLong.DataValue = PersistentStorageLong.DataValue + ( (wrReqParam->handleValPair.value.val[PSTOR_SET_VALUE_INDEX+2])<<8) ;
                PersistentStorageLong.DataValue = PersistentStorageLong.DataValue + ( (wrReqParam->handleValPair.value.val[PSTOR_SET_VALUE_INDEX+3])) ;
                
                if( Main_UpdatePersistentStorageVariable(&PersistentStorageLong) == ERROR_VARIABLE_NOT_FOUND) {
                    PersistentStorageLong.Dataname = 0xFF;
                }
                
                PersistentStorageHandle.attrHandle = SET_SPEED_HANDLE;
	            PersistentStorageHandle.value.val = (uint8 *)PersistentStorageLong.DataValue;
	            PersistentStorageHandle.value.len = sizeof(uint32);
	            PersistentStorageHandle.value.actualLen = sizeof(uint32);	            
                
            	/* Send updated Animation-Control handle as attribute for read by central device */
            	CyBle_GattsWriteAttributeValue(&PersistentStorageHandle, false, &cyBle_connHandle, false);  
                            
            }
            
            if(wrReqParam->handleValPair.attrHandle == cyBle_customs[PERSISTENT_STORAGE_SERVICE_INDEX].\
								                        customServiceInfo[SET_WDTIMEOUT_INDEX].\
                                                        customServiceCharHandle)
            {
                Main_ActivateAnimation(false); 
                PersistentStorageLong.Dataname = e_WDTIMEOUT;
                PersistentStorageLong.DataValue = (wrReqParam->handleValPair.value.val[PSTOR_SET_VALUE_INDEX])<<24 ;
                PersistentStorageLong.DataValue = PersistentStorageLong.DataValue + ( (wrReqParam->handleValPair.value.val[PSTOR_SET_VALUE_INDEX+1])<<16) ;
                PersistentStorageLong.DataValue = PersistentStorageLong.DataValue + ( (wrReqParam->handleValPair.value.val[PSTOR_SET_VALUE_INDEX+2])<<8) ;
                PersistentStorageLong.DataValue = PersistentStorageLong.DataValue + ( (wrReqParam->handleValPair.value.val[PSTOR_SET_VALUE_INDEX+3])) ;
                
                if( Main_UpdatePersistentStorageVariable(&PersistentStorageLong) == ERROR_VARIABLE_NOT_FOUND) {
                    PersistentStorageLong.Dataname = 0xFF;
                }
                
                PersistentStorageHandle.attrHandle = SET_WDTIMEOUT_HANDLE;
	            PersistentStorageHandle.value.val = (uint8 *)PersistentStorageLong.DataValue;
	            PersistentStorageHandle.value.len = sizeof(uint32);
	            PersistentStorageHandle.value.actualLen = sizeof(uint32);	            
                
            	/* Send updated Animation-Control handle as attribute for read by central device */
            	CyBle_GattsWriteAttributeValue(&PersistentStorageHandle, false, &cyBle_connHandle, false);  
                            
            }
            
            if(wrReqParam->handleValPair.attrHandle == cyBle_customs[PERSISTENT_STORAGE_SERVICE_INDEX].\
								                        customServiceInfo[SET_ANIMATION_PIC_INDEX].\
                                                        customServiceCharHandle)
            {
                Main_ActivateAnimation(false); 
                PersistentStorageLong.Dataname = e_POVANIMATION;
                PersistentStorageLong.DataValue = (wrReqParam->handleValPair.value.val[PSTOR_SET_VALUE_INDEX]) ;
                
                if( Main_UpdatePersistentStorageVariable(&PersistentStorageLong) == ERROR_VARIABLE_NOT_FOUND) {
                    PersistentStorageLong.Dataname = 0xFF;
                }
                // Main_SelectAnimation(Animationdata);
                PersistentStorageHandle.attrHandle = SET_ANIMATION_PIC_HANDLE;
	            PersistentStorageHandle.value.val = (uint8 *)PersistentStorageLong.DataValue;
	            PersistentStorageHandle.value.len = sizeof(uint32);
	            PersistentStorageHandle.value.actualLen = sizeof(uint32);	            
                
            	/* Send updated Animation-Control handle as attribute for read by central device */
            	CyBle_GattsWriteAttributeValue(&PersistentStorageHandle, false, &cyBle_connHandle, false);  
                            
            }
            
            if(wrReqParam->handleValPair.attrHandle == cyBle_customs[TEXT_SERVICE_INDEX].\
								                        customServiceInfo[SET_CHARACTER_INDEX].\
                                                        customServiceCharHandle)
            {
                Main_ActivateAnimation(false); 
                MyCharacter = (wrReqParam->handleValPair.value.val[TEXT_CHARACTER_POSITION]);

                POVA_AddCharacterToText( MyCharacter );

                // Main_SelectAnimation(Animationdata);
                TextWriteHandle.attrHandle = SET_CHARACTER_HANDLE;
	            TextWriteHandle.value.val = (uint8 *)MyCharacter;
	            TextWriteHandle.value.len = sizeof(uint8);
	            TextWriteHandle.value.actualLen = sizeof(uint8);	            
                
                Main_ActivateNotification();
                
            	/* Send updated Animation-Control handle as attribute for read by central device */
            	CyBle_GattsWriteAttributeValue(&TextWriteHandle, false, &cyBle_connHandle, false);  
                            
            }        
            
             if(wrReqParam->handleValPair.attrHandle == cyBle_customs[TEXT_SERVICE_INDEX].\
								                        customServiceInfo[CLEAR_TEXT_INDEX].\
                                                        customServiceCharHandle)
            {
                Main_ActivateAnimation(false); // ucShowAnimation = false;
                // MyCharacter = (wrReqParam->handleValPair.value.val[TEXT_CHARACTER_POSITION]);

                POVA_ClearText();

                // Main_SelectAnimation(Animationdata);
                TextWriteHandle.attrHandle = CLEAR_TEXT_HANDLE;
	            TextWriteHandle.value.val = (uint8 *)MyCharacter;
	            TextWriteHandle.value.len = sizeof(uint8);
	            TextWriteHandle.value.actualLen = sizeof(uint8);	            
                
                Main_ActivateNotification();
                
            	/* Send updated Animation-Control handle as attribute for read by central device */
            	CyBle_GattsWriteAttributeValue(&TextWriteHandle, false, &cyBle_connHandle, false);  
                            
            }        
            
			/* Send the response to the write request received. */
			CyBle_GattsWriteRsp(cyBle_connHandle);
			
			break;

        case CYBLE_EVT_L2CAP_CONN_PARAM_UPDATE_RSP:
				/* If L2CAP connection parameter update response received, reset application flag */
            	isConnectionUpdateRequested = false;
            break;
			
		case CYBLE_EVT_STACK_BUSY_STATUS:
			/* This event is generated when the internal stack buffer is full and no more
			* data can be accepted or the stack has buffer available and can accept data.
			* This event is used by application to prevent pushing lot of data to stack. */
			
			/* Extract the present stack status */
            busyStatus = * (uint8*)eventParam;
            break;    
            
        default:

       	 	break;
    }
}

/*******************************************************************************
* Function Name: UpdateRGBled
********************************************************************************
* Summary:
* Receive the new RGB data and modify PrISM parameters. Also, update the
* read characteristic handle so that the next read from the BLE central device
* gives present RGB color and intensity data.
*
* Parameters:
*  void
*
* Return:
*  void
*
*******************************************************************************/
void UpdateRGBled()
{
	/* Local variables to calculate the color components from RGB received data*/
	uint8 debug_red;
	uint8 debug_green;
	uint8 debug_blue;
	
    uint8 intensity_divide_value = RGBledData[INTENSITY_INDEX];	
    
	debug_red = (uint8)(((uint16)RGBledData[RED_INDEX] * intensity_divide_value) / 255);
	debug_green = (uint8)(((uint16)RGBledData[GREEN_INDEX] * intensity_divide_value) / 255);
	debug_blue = (uint8)(((uint16)RGBledData[BLUE_INDEX] * intensity_divide_value) / 255);
	
    if( Active_Animation == RGB_Control) {
        Main_SelectAnimation(RGB_Control);
    	Display_new_Color(debug_red,debug_green,debug_blue);        
    } else {
        // Set the color for the next Text-display. Color hier ist: (Brightness, blau, rot, grün )
        POVA_SetTextColor( (debug_red<<8) + (debug_green) + (debug_blue<<16) );    
    }
    
    
	/* Update RGB control handle with new values */
	rgbHandle.attrHandle = RGB_LED_CHAR_HANDLE;
	rgbHandle.value.val = (uint8 *)RGBledData;
	rgbHandle.value.len = sizeof(RGBledData);
	rgbHandle.value.actualLen = sizeof(RGBledData);
	
	/* Send updated RGB control handle as attribute for read by central device */
	CyBle_GattsWriteAttributeValue(&rgbHandle, false, &cyBle_connHandle, false);  
}




void BLE_WriteMovementReceivedNotification(volatile uint8 *FlagValue)
{
    /* If stack is not busy, then send the notification */
    // busyStatus = CyBle_GattGetBusyStatus();
    // StackStatus = CyBle_GetState();
    
    if( (CYBLE_STACK_STATE_FREE == CyBle_GattGetBusyStatus() ) & (CYBLE_STATE_CONNECTED == CyBle_GetState() ) )
	{        
        TextWriteHandle.attrHandle = CHARACTER_COUNT_HANDLE;
        TextWriteHandle.value.val = (uint8 *)(FlagValue);
        TextWriteHandle.value.len  = sizeof(uint16);
        TextWriteHandle.value.actualLen = sizeof(uint16);
        
        // Write the value to the stack.
        CyBle_GattsWriteAttributeValue(&TextWriteHandle, false, &cyBle_connHandle, false);  
        
        // Trigger the notification to the client.
        CyBle_GattsNotification(cyBle_connHandle,(CYBLE_GATTS_HANDLE_VALUE_NTF_T*)&TextWriteHandle);        
    }
}


/* ========================================
 *  Local Functions
 * ======================================== */

// Restore the high Interrupt for Connection or advertising.
void StartFastAdvertising()
{
    CyBle_GappStartAdvertisement(CYBLE_ADVERTISING_FAST);
}




/* [] END OF FILE */
