//Pen holder for Reprappro Mendel

//Define pen clamp
pen_dia = 9.5;

//Mount
difference() {
	//Base
	translate([0,0,-5]) cube([32, 5, 10], center=true);

	//Screw holes with nut recesses
	translate([-12.5, -1.5, -5]) 
		union() {
			cylinder(r=3.4/2, h=15, center=true, $fn=20);
		}
	translate([12.5, -1.5, -5])
		union() {
			cylinder(r=3.4/2, h=15, center=true, $fn=20);
		}
}

//Base
translate([14,4,-5]) cube([4, 3, 10], center=true);
translate([-14,4,-5]) cube([4, 3, 10], center=true);

//Clamp
translate([0, -3 - (pen_dia / 2), 0])
	rotate([0,0,90])
		clamp(base=false, ring_thickness = 3, ring_inner_dia = pen_dia, screw_count = 2, nut_recess = false, jaws_thickness = 3.5, jaws_width=8);

module clamp(base = true, base_thickness = 2, base_width = 20, ring_thickness = 2, ring_inner_dia = 15, jaws_thickness = 5, jaws_width = 7, break_width = 5, screw_diameter = 3.4, screw_count = 1, nut_recess = true, nut_diameter = 6.5, nut_thickness = 3, height = 15) {

	//Check base thickness
	if(base && base_thickness < ring_thickness)
		echo("Base thickness must be at least ring thickness, ring will protrude through base");

	//Check jaws width
	if(jaws_width < ring_thickness)
		echo("Jaw width must be at least ring thickness, ring will protrude through jaws");

	//Calculate ring inner radius
	ring_inner_rad = ring_inner_dia / 2;

	//Calculate screw spacing
	screw_spacing = (height - (screw_diameter * screw_count)) / (screw_count + 1);

	//Base
	if(base)
		translate([ring_inner_rad + (base_thickness / 2), 0, 0])
			cube([base_thickness, base_width, height], center=true);

	//Clamp
	difference() {
		union() {
			//Outer cylinder
			cylinder(r=ring_inner_rad + ring_thickness, h=height  +5, center=true);

			//Jaws
			translate([0 - ring_inner_rad - (jaws_width / 2), 0, 0])
				cube([jaws_width, (jaws_thickness * 2) + break_width, height +5 ], center=true);
		}
	
		//Inner cylinder
		cylinder(r=ring_inner_rad, h=height +10, center=true);

		//Break
		translate([0 - ((jaws_width + ring_thickness + (ring_inner_dia / 2) + 10) / 2), 0, 0])
			cube([jaws_width + ring_thickness + (ring_inner_dia / 2) + 10, break_width, height + 10], center=true);

		//Screw hole(s)
		for(i = [1 : screw_count])
			translate([0 - (ring_inner_dia / 2) - (jaws_width / 2), 0, (height / 2) - (screw_diameter / 2) - (screw_spacing * i) - (screw_diameter * (i - 1))])
				rotate([90, 0, 0])
					union() {
						cylinder(r=screw_diameter / 2, h=jaws_thickness * 2 + break_width + 10, center=true, $fn=20);
						if(nut_recess) translate([0, 0, nut_thickness-((nut_thickness + 10)/2)-(break_width/2)-jaws_thickness]) cylinder(r=nut_diameter/2, h=nut_thickness + 10, center=true, $fn=6);
					}
	}
}