
class NicoArduinoNunchuk : public ArduinoNunchuk
{
  public:
    int joyx0, joyy0;
    int up, down, left, right;
    int was_cButton, was_zButton;
    int cPressed, zPressed;
    NicoArduinoNunchuk() : ArduinoNunchuk() 
      { 
      joyx0 = joyy0 = 128; 
      up = down = left = right = 0;
      was_cButton = was_zButton = 0;
      cPressed = zPressed = 0;
      }

    void nunchuckSetPowerpins()
      {
      const int vccPin = 17; // +v and gnd provided through these pins
      const int gndPin = 16;  
      pinMode(gndPin, OUTPUT); // set power pins to the correct state
      pinMode(vccPin, OUTPUT);
      digitalWrite(gndPin, LOW);
      digitalWrite(vccPin, HIGH);
      delay(100); // wait for power to stabilize
      }

     void init()
      {
      ArduinoNunchuk::init();
      int index;
      for(index=0; index < 4; index++)
            {
            ArduinoNunchuk::update();
            delay(500);
            }
      joyx0 = analogX;
      joyy0 = analogY;
      }

    void update()
      {
      ArduinoNunchuk::update();
      right = (analogX > (joyx0 + 0.3 * (255 - joyx0)));
      left  = (analogX < (joyx0 - 0.3 * (joyx0 - 000)));
      up    = (analogY > (joyy0 + 0.3 * (255 - joyy0)));
      down  = (analogY < (joyy0 - 0.3 * (joyy0 - 000)));
      cPressed = (cButton && !was_cButton);
      was_cButton = cButton;
      zPressed = (zButton && !was_zButton);
      was_zButton = zButton;
      }
    int still() { return (!up && !down && !left && !right); }
    int degree(int mesure, int ref)
      {
      if (mesure < ref)
        return(map(mesure,0,ref,0,10)*9);
      return(map(mesure,ref,255,10,20)*9);
      }
    int degreeX() { return degree(analogX, joyx0); }
    int degreeY() { return degree(analogY, joyy0); }
    
    void prt(HardwareSerial& serial)
      {
      serial.print("x:");
      serial.print(degreeX());
      serial.print(" y:");
      serial.print(degreeY());
      if (up) serial.print(" up");
      if (down) serial.print(" down");
      if (left) serial.print(" left");
      if (right) serial.print(" right");
      serial.println();
      }

};
