/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.ControllerView;
import controlP5.Label;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Slider2D
extends Controller<Slider2D> {
    protected int cursorWidth = 10;
    protected int cursorHeight = 10;
    protected float cursorX;
    protected float cursorY;
    protected float _myMinX;
    protected float _myMinY;
    protected float _myMaxX;
    protected float _myMaxY;
    public boolean isCrosshairs = true;
    private String _myValueLabelSeparator = ",";

    public Slider2D(ControlP5 theControlP5, String theName) {
        this(theControlP5, (ControllerGroup<?>)theControlP5.getDefaultTab(), theName, 0, 0, 99, 9);
        theControlP5.register(theControlP5.papplet, theName, this);
    }

    protected Slider2D(ControlP5 theControlP5, ControllerGroup<?> theParent, String theName, int theX, int theY, int theWidth, int theHeight) {
        super(theControlP5, theParent, theName, theX, theY, theWidth, theHeight);
        this._myArrayValue = new float[]{0.0f, 0.0f};
        this._myMinX = 0.0f;
        this._myMinY = 0.0f;
        this._myMaxX = theWidth;
        this._myMaxY = theHeight;
        this.getCaptionLabel().setPadding(0, Label.paddingY).align(37, 13);
        this.getValueLabel().setPadding(0, Label.paddingY).align(39, 13);
    }

    @Override
    @ControlP5.Invisible
    public Slider2D updateInternalEvents(PApplet theApplet) {
        if (this.isInside() && !this.cp5.keyHandler.isAltDown()) {
            float tX = PApplet.constrain((float)((float)this._myControlWindow.mouseX - (this._myParent.getAbsolutePosition().x + this.position.x)), (float)0.0f, (float)(this.width - this.cursorWidth));
            float tY = PApplet.constrain((float)((float)this._myControlWindow.mouseY - (this._myParent.getAbsolutePosition().y + this.position.y)), (float)0.0f, (float)(this.height - this.cursorHeight));
            if (this.isMousePressed) {
                this.cursorX = tX;
                this.cursorY = tY;
                this.updateValue();
            }
        }
        return this;
    }

    Slider2D updateValue() {
        return this.setValue(0.0f);
    }

    public Slider2D setMinX(float theMinX) {
        this._myMinX = theMinX;
        return this.updateValue();
    }

    public Slider2D setMinY(float theMinY) {
        this._myMinY = theMinY;
        return this.updateValue();
    }

    public Slider2D setMaxX(float theMaxX) {
        this._myMaxX = theMaxX;
        return this.updateValue();
    }

    public Slider2D setMaxY(float theMaxY) {
        this._myMaxY = theMaxY;
        return this.updateValue();
    }

    public float getMinX() {
        return this._myMinX;
    }

    public float getMinY() {
        return this._myMinY;
    }

    public float getMaxX() {
        return this._myMaxX;
    }

    public float getMaxY() {
        return this._myMaxY;
    }

    public float getCursorX() {
        return this.cursorX;
    }

    public float getCursorY() {
        return this.cursorY;
    }

    public float getCursorWidth() {
        return this.cursorWidth;
    }

    public float getCursorHeight() {
        return this.cursorHeight;
    }

    public Slider2D disableCrosshair() {
        this.isCrosshairs = false;
        return this;
    }

    public Slider2D enableCrosshair() {
        this.isCrosshairs = false;
        return this;
    }

    @Override
    public Slider2D setArrayValue(float[] theArray) {
        this._myArrayValue = theArray;
        float rX = (float)(this.width - this.cursorWidth) / (this._myMaxX - this._myMinX);
        float rY = (float)(this.height - this.cursorHeight) / (this._myMaxY - this._myMinY);
        this.cursorX = PApplet.constrain((float)(theArray[0] * rX), (float)0.0f, (float)(this.width - this.cursorWidth));
        this.cursorY = PApplet.constrain((float)(theArray[1] * rY), (float)0.0f, (float)(this.height - this.cursorHeight));
        return this.updateValue();
    }

    @Override
    public float[] getArrayValue() {
        return this._myArrayValue;
    }

    @Override
    public Slider2D setValue(float theValue) {
        this._myArrayValue[0] = this.cursorX / ((float)(this.width - this.cursorWidth) / (float)this.width);
        this._myArrayValue[1] = this.cursorY / ((float)(this.height - this.cursorHeight) / (float)this.height);
        this._myArrayValue[0] = PApplet.map((float)this._myArrayValue[0], (float)0.0f, (float)this.width, (float)this._myMinX, (float)this._myMaxX);
        this._myArrayValue[1] = PApplet.map((float)this._myArrayValue[1], (float)0.0f, (float)this.height, (float)this._myMinY, (float)this._myMaxY);
        this._myValueLabel.set(this.adjustValue(this._myArrayValue[0], 0) + this._myValueLabelSeparator + this.adjustValue(this._myArrayValue[1], 0));
        this.broadcast(2);
        return this;
    }

    public Slider2D shuffle() {
        float rX = (float)Math.random();
        float rY = (float)Math.random();
        this._myArrayValue[0] = rX * (float)this.width;
        this._myArrayValue[0] = rY * (float)this.height;
        return this.setValue(0.0f);
    }

    public void setValueLabelSeparator(String theSeparator) {
        this._myValueLabelSeparator = theSeparator;
    }

    @Override
    @ControlP5.Invisible
    public Slider2D updateDisplayMode(int theMode) {
        this._myDisplayMode = theMode;
        switch (theMode) {
            case 0: {
                this._myControllerView = new Slider2DView();
                break;
            }
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Slider2DView
    implements ControllerView<Slider2D> {
        Slider2DView() {
        }

        @Override
        public void display(PApplet theApplet, Slider2D theController) {
            if (theController.isInside()) {
                theApplet.fill(theController.getColor().getForeground());
            } else {
                theApplet.fill(theController.getColor().getBackground());
            }
            theApplet.noStroke();
            theApplet.rect(0.0f, 0.0f, (float)Slider2D.this.getWidth(), (float)Slider2D.this.getHeight());
            if (Slider2D.this.isCrosshairs) {
                if (theController.isInside()) {
                    theApplet.stroke(theController.getColor().getBackground());
                } else {
                    theApplet.stroke(theController.getColor().getForeground());
                }
                theApplet.line(0.0f, Slider2D.this.getCursorY() + Slider2D.this.getCursorHeight() / 2.0f, (float)Slider2D.this.getWidth(), Slider2D.this.getCursorY() + Slider2D.this.getCursorHeight() / 2.0f);
                theApplet.line(Slider2D.this.getCursorX() + Slider2D.this.getCursorWidth() / 2.0f, 0.0f, Slider2D.this.getCursorX() + Slider2D.this.getCursorWidth() / 2.0f, (float)Slider2D.this.getHeight());
                theApplet.noStroke();
            }
            theApplet.fill(theController.getColor().getActive());
            theApplet.rect(Slider2D.this.getCursorX(), Slider2D.this.getCursorY(), Slider2D.this.getCursorWidth(), Slider2D.this.getCursorHeight());
            Slider2D.this.getCaptionLabel().draw(theApplet, 0, 0, theController);
            Slider2D.this.getValueLabel().draw(theApplet, 0, 0, theController);
        }
    }
}

