/*
 * Decompiled with CFR 0.152.
 */
import controlP5.Button;
import controlP5.CheckBox;
import controlP5.ControlEvent;
import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ListBox;
import controlP5.Numberbox;
import controlP5.Slider;
import controlP5.Textlabel;
import controlP5.Toggle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import processing.core.PApplet;
import processing.core.PFont;
import processing.serial.Serial;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiWiiConf
extends PApplet {
    PrintWriter output;
    BufferedReader reader;
    String portnameFile = "SerialPort.txt";
    int GUI_BaudRate = 115200;
    int SerialPort;
    Serial g_serial;
    ControlP5 controlP5;
    Textlabel txtlblWhichcom;
    ListBox commListbox;
    static int CHECKBOXITEMS = 0;
    static int PIDITEMS = 10;
    int commListMax;
    cGraph g_graph;
    int windowsX = 1000;
    int windowsY = 540;
    int xGraph = 10;
    int yGraph = 325;
    int xObj = 520;
    int yObj = 293;
    int xCompass = 920;
    int yCompass = 341;
    int xLevelObj = 920;
    int yLevelObj = 80;
    int xParam = 120;
    int yParam = 5;
    int xRC = 690;
    int yRC = 10;
    int xMot = 690;
    int yMot = 155;
    int xButton = 845;
    int yButton = 231;
    int xBox = 415;
    int yBox = 10;
    int xGPS = 853;
    int yGPS = 438;
    boolean axGraph = true;
    boolean ayGraph = true;
    boolean azGraph = true;
    boolean gxGraph = true;
    boolean gyGraph = true;
    boolean gzGraph = true;
    boolean altGraph = true;
    boolean headGraph = true;
    boolean magxGraph = true;
    boolean magyGraph = true;
    boolean magzGraph = true;
    boolean debug1Graph = false;
    boolean debug2Graph = false;
    boolean debug3Graph = false;
    boolean debug4Graph = false;
    int multiType;
    int multiCapability = 0;
    int[] byteMP = new int[8];
    cDataArray accPITCH = new cDataArray(200);
    cDataArray accROLL = new cDataArray(200);
    cDataArray accYAW = new cDataArray(200);
    cDataArray gyroPITCH = new cDataArray(200);
    cDataArray gyroROLL = new cDataArray(200);
    cDataArray gyroYAW = new cDataArray(200);
    cDataArray magxData = new cDataArray(200);
    cDataArray magyData = new cDataArray(200);
    cDataArray magzData = new cDataArray(200);
    cDataArray altData = new cDataArray(200);
    cDataArray headData = new cDataArray(200);
    cDataArray debug1Data = new cDataArray(200);
    cDataArray debug2Data = new cDataArray(200);
    cDataArray debug3Data = new cDataArray(200);
    cDataArray debug4Data = new cDataArray(200);
    private static final int ROLL = 0;
    private static final int PITCH = 1;
    private static final int YAW = 2;
    private static final int ALT = 3;
    private static final int VEL = 4;
    private static final int LEVEL = 5;
    private static final int MAG = 6;
    Numberbox[] confP = new Numberbox[PIDITEMS];
    Numberbox[] confI = new Numberbox[PIDITEMS];
    Numberbox[] confD = new Numberbox[PIDITEMS];
    int[] byteP = new int[PIDITEMS];
    int[] byteI = new int[PIDITEMS];
    int[] byteD = new int[PIDITEMS];
    int byteRC_RATE;
    int byteRC_EXPO;
    int byteRollPitchRate;
    int byteYawRate;
    int byteDynThrPID;
    int byteThrottle_EXPO;
    int byteThrottle_MID;
    int byteSelectSetting;
    Numberbox confRC_RATE;
    Numberbox confRC_EXPO;
    Numberbox rollPitchRate;
    Numberbox yawRate;
    Numberbox dynamic_THR_PID;
    Numberbox throttle_EXPO;
    Numberbox throttle_MID;
    Numberbox confPowerTrigger;
    Numberbox confSetting;
    Numberbox confSelectSetting;
    Slider[] servoSliderH = new Slider[8];
    Slider[] servoSliderV = new Slider[8];
    Slider[] motSlider = new Slider[8];
    Slider rcStickThrottleSlider;
    Slider rcStickRollSlider;
    Slider rcStickPitchSlider;
    Slider rcStickYawSlider;
    Slider rcStickAUX1Slider;
    Slider rcStickAUX2Slider;
    Slider rcStickAUX3Slider;
    Slider rcStickAUX4Slider;
    Slider axSlider;
    Slider aySlider;
    Slider azSlider;
    Slider gxSlider;
    Slider gySlider;
    Slider gzSlider;
    Slider magxSlider;
    Slider magySlider;
    Slider magzSlider;
    Slider altSlider;
    Slider headSlider;
    Slider debug1Slider;
    Slider debug2Slider;
    Slider debug3Slider;
    Slider debug4Slider;
    Slider scaleSlider;
    Button buttonIMPORT;
    Button buttonSAVE;
    Button buttonREAD;
    Button buttonRESET;
    Button buttonWRITE;
    Button buttonCALIBRATE_ACC;
    Button buttonCALIBRATE_MAG;
    Button buttonSTART;
    Button buttonSTOP;
    Button buttonSETTING;
    Button buttonAcc;
    Button buttonBaro;
    Button buttonMag;
    Button buttonGPS;
    Button buttonSonar;
    Button buttonOptic;
    Button buttonRXbind;
    Button btnQConnect;
    Toggle tACC_ROLL;
    Toggle tACC_PITCH;
    Toggle tACC_Z;
    Toggle tGYRO_ROLL;
    Toggle tGYRO_PITCH;
    Toggle tGYRO_YAW;
    Toggle tBARO;
    Toggle tHEAD;
    Toggle tMAGX;
    Toggle tMAGY;
    Toggle tMAGZ;
    Toggle tDEBUG1;
    Toggle tDEBUG2;
    Toggle tDEBUG3;
    Toggle tDEBUG4;
    int yellow_ = this.color(200, 200, 20);
    int green_ = this.color(30, 120, 30);
    int red_ = this.color(120, 30, 30);
    int blue_ = this.color(50, 50, 100);
    int grey_ = this.color(30, 30, 30);
    boolean graphEnable = false;
    int version;
    int versionMisMatch;
    float gx;
    float gy;
    float gz;
    float ax;
    float ay;
    float az;
    float magx;
    float magy;
    float magz;
    float alt;
    float head;
    float angx;
    float angy;
    float debug1;
    float debug2;
    float debug3;
    float debug4;
    float angyLevelControl;
    float angCalc;
    int horizonInstrSize;
    int i;
    int j;
    int GPS_distanceToHome;
    int GPS_directionToHome;
    int GPS_numSat;
    int GPS_fix;
    int GPS_update;
    int GPS_altitude;
    int GPS_speed;
    int GPS_latitude;
    int GPS_longitude;
    int init_com;
    int graph_on;
    int pMeterSum;
    int intPowerTrigger;
    int bytevbat;
    float[] mot = new float[8];
    float[] servo = new float[8];
    float rcThrottle = 1500.0f;
    float rcRoll = 1500.0f;
    float rcPitch = 1500.0f;
    float rcYaw = 1500.0f;
    float rcAUX1 = 1500.0f;
    float rcAUX2 = 1500.0f;
    float rcAUX3 = 1500.0f;
    float rcAUX4 = 1500.0f;
    int cycleTime;
    int i2cError;
    CheckBox[] checkbox;
    int[] activation;
    Button[] buttonCheckbox;
    PFont font8;
    PFont font9;
    PFont font12;
    PFont font15;
    private static final String MSP_HEADER = "$M<";
    private static final int MSP_IDENT = 100;
    private static final int MSP_STATUS = 101;
    private static final int MSP_RAW_IMU = 102;
    private static final int MSP_SERVO = 103;
    private static final int MSP_MOTOR = 104;
    private static final int MSP_RC = 105;
    private static final int MSP_RAW_GPS = 106;
    private static final int MSP_COMP_GPS = 107;
    private static final int MSP_ATTITUDE = 108;
    private static final int MSP_ALTITUDE = 109;
    private static final int MSP_BAT = 110;
    private static final int MSP_RC_TUNING = 111;
    private static final int MSP_PID = 112;
    private static final int MSP_BOX = 113;
    private static final int MSP_MISC = 114;
    private static final int MSP_MOTOR_PINS = 115;
    private static final int MSP_BOXNAMES = 116;
    private static final int MSP_PIDNAMES = 117;
    private static final int MSP_SET_RAW_RC = 200;
    private static final int MSP_SET_RAW_GPS = 201;
    private static final int MSP_SET_PID = 202;
    private static final int MSP_SET_BOX = 203;
    private static final int MSP_SET_RC_TUNING = 204;
    private static final int MSP_ACC_CALIBRATION = 205;
    private static final int MSP_MAG_CALIBRATION = 206;
    private static final int MSP_SET_MISC = 207;
    private static final int MSP_RESET_CONF = 208;
    private static final int MSP_SELECT_SETTING = 210;
    private static final int MSP_BIND = 240;
    private static final int MSP_EEPROM_WRITE = 250;
    private static final int MSP_DEBUGMSG = 253;
    private static final int MSP_DEBUG = 254;
    public static final int IDLE = 0;
    public static final int HEADER_START = 1;
    public static final int HEADER_M = 2;
    public static final int HEADER_ARROW = 3;
    public static final int HEADER_SIZE = 4;
    public static final int HEADER_CMD = 5;
    public static final int HEADER_ERR = 6;
    int c_state = 0;
    boolean err_rcvd = false;
    byte checksum = 0;
    byte cmd;
    int offset = 0;
    int dataSize = 0;
    byte[] inBuf = new byte[256];
    int p;
    int mode;
    boolean toggleRead = false;
    boolean toggleReset = false;
    boolean toggleCalibAcc = false;
    boolean toggleCalibMag = false;
    boolean toggleWrite = false;
    boolean toggleRXbind = false;
    boolean toggleSetSetting = false;
    private int present = 0;
    int time;
    int time2;
    int time3;
    int time4;
    boolean portOK = false;

    public void create_checkboxes(String[] stringArray) {
        int n = 0;
        while (n < CHECKBOXITEMS) {
            this.buttonCheckbox[n].remove();
            this.checkbox[n].remove();
            ++n;
        }
        n = 0;
        this.checkbox = new CheckBox[stringArray.length];
        this.buttonCheckbox = new Button[stringArray.length];
        this.activation = new int[stringArray.length];
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray2[n3];
            this.buttonCheckbox[n] = (Button)((Button)this.controlP5.addButton("bcb" + n, 1.0f, this.xBox - 30, this.yBox + 20 + 13 * n, 68, 12).setColorBackground(this.red_)).setLabel(string);
            this.checkbox[n] = (CheckBox)((CheckBox)((CheckBox)this.controlP5.addCheckBox("cb" + n, this.xBox + 40, this.yBox + 20 + 13 * n).setColorActive(this.color(255))).setColorBackground(this.color(120))).setItemsPerRow(12).setSpacingColumn(10).setLabel("");
            int n4 = 1;
            while (n4 <= 12) {
                this.checkbox[n].addItem(String.valueOf(n) + "_cb_" + n4, (float)n4).hideLabels();
                ++n4;
            }
            ++n;
            ++n3;
        }
        CHECKBOXITEMS = stringArray.length;
    }

    public String shortifyPortName(String string, int n) {
        String string2 = string;
        if (string2.startsWith("/dev/")) {
            string2 = string2.substring(5);
        }
        if (string2.startsWith("tty.")) {
            string2 = string2.substring(4);
        }
        if (string.length() > n) {
            string2 = String.valueOf(string2.substring(0, (n - 1) / 2)) + "~" + string2.substring(string2.length() - (n - (n - 1) / 2));
        }
        if (string2.startsWith("cu.")) {
            string2 = "";
        }
        return string2;
    }

    public Controller hideLabel(Controller controller) {
        controller.setLabel("");
        controller.setLabelVisible(false);
        return controller;
    }

    public void setup() {
        this.size(this.windowsX, this.windowsY, "processing.opengl.PGraphicsOpenGL");
        this.frameRate(20.0f);
        this.font8 = this.createFont("Arial bold", 8.0f, false);
        this.font9 = this.createFont("Arial bold", 9.0f, false);
        this.font12 = this.createFont("Arial bold", 12.0f, false);
        this.font15 = this.createFont("Arial bold", 15.0f, false);
        this.controlP5 = new ControlP5((PApplet)this);
        this.controlP5.setControlFont(this.font12);
        this.g_graph = new cGraph(this.xGraph + 110, this.yGraph, 480.0f, 200.0f);
        this.commListbox = this.controlP5.addListBox("portComList", 5, 95, 110, 240);
        this.commListbox.captionLabel().set("PORT COM").setColorBackground(this.red_);
        int n = 0;
        while (n < Serial.list().length) {
            String string = this.shortifyPortName(Serial.list()[n], 13);
            if (string.length() > 0) {
                this.commListbox.addItem(string, n);
            }
            this.commListMax = n++;
        }
        this.commListbox.addItem("Close Comm", ++this.commListMax);
        this.txtlblWhichcom = this.controlP5.addTextlabel("txtlblWhichcom", "No Port Selected", 5, 65);
        this.buttonSAVE = (Button)((Button)this.controlP5.addButton("bSAVE", 1.0f, 5, 45, 40, 19).setLabel("SAVE")).setColorBackground(this.red_);
        this.buttonIMPORT = (Button)((Button)this.controlP5.addButton("bIMPORT", 1.0f, 50, 45, 40, 19).setLabel("LOAD")).setColorBackground(this.red_);
        this.btnQConnect = (Button)((Button)this.controlP5.addButton("bQCONN", 1.0f, this.xGraph + 0, this.yGraph - 75, 100, 19).setLabel("  ReConnect")).setColorBackground(this.red_);
        this.buttonSTART = (Button)((Button)this.controlP5.addButton("bSTART", 1.0f, this.xGraph + 110, this.yGraph - 25, 40, 19).setLabel("START")).setColorBackground(this.red_);
        this.buttonSTOP = (Button)((Button)this.controlP5.addButton("bSTOP", 1.0f, this.xGraph + 160, this.yGraph - 25, 40, 19).setLabel("STOP")).setColorBackground(this.red_);
        this.buttonAcc = (Button)((Button)this.controlP5.addButton("bACC", 1.0f, this.xButton, this.yButton, 45, 15).setColorBackground(this.red_)).setLabel("ACC");
        this.buttonBaro = (Button)((Button)this.controlP5.addButton("bBARO", 1.0f, this.xButton + 50, this.yButton, 45, 15).setColorBackground(this.red_)).setLabel("BARO");
        this.buttonMag = (Button)((Button)this.controlP5.addButton("bMAG", 1.0f, this.xButton + 100, this.yButton, 45, 15).setColorBackground(this.red_)).setLabel("MAG");
        this.buttonGPS = (Button)((Button)this.controlP5.addButton("bGPS", 1.0f, this.xButton, this.yButton + 17, 45, 15).setColorBackground(this.red_)).setLabel("GPS");
        this.buttonSonar = (Button)((Button)this.controlP5.addButton("bSonar", 1.0f, this.xButton + 50, this.yButton + 17, 45, 15).setColorBackground(this.red_)).setLabel("SONAR");
        this.buttonOptic = (Button)((Button)this.controlP5.addButton("bOptic", 1.0f, this.xButton + 100, this.yButton + 17, 45, 15).setColorBackground(this.grey_)).setLabel("OPTIC");
        n = this.color(0, 0, 0);
        int n2 = this.xGraph - 7;
        int n3 = this.xGraph + 40;
        int n4 = this.yGraph + 10;
        int n5 = this.yGraph + 55;
        int n6 = this.yGraph + 100;
        int n7 = this.yGraph + 150;
        int n8 = this.yGraph + 165;
        int n9 = this.yGraph + 205;
        this.tACC_ROLL = (Toggle)((Toggle)((Toggle)this.controlP5.addToggle("ACC_ROLL", true, (float)n3, (float)(n4 + 10), 20, 10).setColorActive(this.color(255, 0, 0))).setColorBackground(n)).setLabel("");
        this.tACC_PITCH = (Toggle)((Toggle)((Toggle)this.controlP5.addToggle("ACC_PITCH", true, (float)n3, (float)(n4 + 20), 20, 10).setColorActive(this.color(0, 255, 0))).setColorBackground(n)).setLabel("");
        this.tACC_Z = (Toggle)((Toggle)((Toggle)this.controlP5.addToggle("ACC_Z", true, (float)n3, (float)(n4 + 30), 20, 10).setColorActive(this.color(0, 0, 255))).setColorBackground(n)).setLabel("");
        this.tGYRO_ROLL = (Toggle)((Toggle)((Toggle)this.controlP5.addToggle("GYRO_ROLL", true, (float)n3, (float)(n5 + 10), 20, 10).setColorActive(this.color(200, 200, 0))).setColorBackground(n)).setLabel("");
        this.tGYRO_PITCH = (Toggle)((Toggle)((Toggle)this.controlP5.addToggle("GYRO_PITCH", true, (float)n3, (float)(n5 + 20), 20, 10).setColorActive(this.color(0, 255, 255))).setColorBackground(n)).setLabel("");
        this.tGYRO_YAW = (Toggle)((Toggle)((Toggle)this.controlP5.addToggle("GYRO_YAW", true, (float)n3, (float)(n5 + 30), 20, 10).setColorActive(this.color(255, 0, 255))).setColorBackground(n)).setLabel("");
        this.tBARO = (Toggle)((Toggle)((Toggle)this.controlP5.addToggle("BARO", true, (float)n3, (float)n7, 20, 10).setColorActive(this.color(125, 125, 125))).setColorBackground(n)).setLabel("");
        this.tHEAD = (Toggle)((Toggle)((Toggle)this.controlP5.addToggle("HEAD", true, (float)n3, (float)n8, 20, 10).setColorActive(this.color(225, 225, 125))).setColorBackground(n)).setLabel("");
        this.tMAGX = (Toggle)((Toggle)((Toggle)this.controlP5.addToggle("MAGX", true, (float)n3, (float)(n6 + 10), 20, 10).setColorActive(this.color(50, 100, 150))).setColorBackground(n)).setLabel("");
        this.tMAGY = (Toggle)((Toggle)((Toggle)this.controlP5.addToggle("MAGY", true, (float)n3, (float)(n6 + 20), 20, 10).setColorActive(this.color(100, 50, 150))).setColorBackground(n)).setLabel("");
        this.tMAGZ = (Toggle)((Toggle)((Toggle)this.controlP5.addToggle("MAGZ", true, (float)n3, (float)(n6 + 30), 20, 10).setColorActive(this.color(150, 100, 50))).setColorBackground(n)).setLabel("");
        this.tDEBUG1 = ((Toggle)((Toggle)((Toggle)this.controlP5.addToggle("DEBUG1", true, (float)(n3 + 70), (float)n9, 20, 10).setColorActive(this.color(200, 50, 0))).setColorBackground(n)).setLabel("")).setValue(0.0f);
        this.tDEBUG2 = ((Toggle)((Toggle)((Toggle)this.controlP5.addToggle("DEBUG2", true, (float)(n3 + 190), (float)n9, 20, 10).setColorActive(this.color(0, 200, 50))).setColorBackground(n)).setLabel("")).setValue(0.0f);
        this.tDEBUG3 = ((Toggle)((Toggle)((Toggle)this.controlP5.addToggle("DEBUG3", true, (float)(n3 + 310), (float)n9, 20, 10).setColorActive(this.color(50, 0, 200))).setColorBackground(n)).setLabel("")).setValue(0.0f);
        this.tDEBUG4 = ((Toggle)((Toggle)((Toggle)this.controlP5.addToggle("DEBUG4", true, (float)(n3 + 430), (float)n9, 20, 10).setColorActive(this.color(150, 100, 50))).setColorBackground(n)).setLabel("")).setValue(0.0f);
        this.controlP5.addTextlabel("acclabel", "ACC", n2, n4);
        this.controlP5.addTextlabel("accrolllabel", "   ROLL", n2, n4 + 10);
        this.controlP5.addTextlabel("accpitchlabel", "   PITCH", n2, n4 + 20);
        this.controlP5.addTextlabel("acczlabel", "   Z", n2, n4 + 30);
        this.controlP5.addTextlabel("gyrolabel", "GYRO", n2, n5);
        this.controlP5.addTextlabel("gyrorolllabel", "   ROLL", n2, n5 + 10);
        this.controlP5.addTextlabel("gyropitchlabel", "   PITCH", n2, n5 + 20);
        this.controlP5.addTextlabel("gyroyawlabel", "   YAW", n2, n5 + 30);
        this.controlP5.addTextlabel("maglabel", "MAG", n2, n6);
        this.controlP5.addTextlabel("magrolllabel", "   ROLL", n2, n6 + 10);
        this.controlP5.addTextlabel("magpitchlabel", "   PITCH", n2, n6 + 20);
        this.controlP5.addTextlabel("magyawlabel", "   YAW", n2, n6 + 30);
        this.controlP5.addTextlabel("altitudelabel", "ALT", n2, n7);
        this.controlP5.addTextlabel("headlabel", "HEAD", n2, n8);
        this.controlP5.addTextlabel("debug1", "debug1", n3 + 90, n9);
        this.controlP5.addTextlabel("debug2", "debug2", n3 + 210, n9);
        this.controlP5.addTextlabel("debug3", "debug3", n3 + 330, n9);
        this.controlP5.addTextlabel("debug4", "debug4", n3 + 450, n9);
        this.axSlider = (Slider)((Slider)this.controlP5.addSlider("axSlider", -1000.0f, 1000.0f, 0.0f, n3 + 20, n4 + 10, 50, 10).setDecimalPrecision(0)).setLabel("");
        this.aySlider = (Slider)((Slider)this.controlP5.addSlider("aySlider", -1000.0f, 1000.0f, 0.0f, n3 + 20, n4 + 20, 50, 10).setDecimalPrecision(0)).setLabel("");
        this.azSlider = (Slider)((Slider)this.controlP5.addSlider("azSlider", -1000.0f, 1000.0f, 0.0f, n3 + 20, n4 + 30, 50, 10).setDecimalPrecision(0)).setLabel("");
        this.gxSlider = (Slider)((Slider)this.controlP5.addSlider("gxSlider", -5000.0f, 5000.0f, 0.0f, n3 + 20, n5 + 10, 50, 10).setDecimalPrecision(0)).setLabel("");
        this.gySlider = (Slider)((Slider)this.controlP5.addSlider("gySlider", -5000.0f, 5000.0f, 0.0f, n3 + 20, n5 + 20, 50, 10).setDecimalPrecision(0)).setLabel("");
        this.gzSlider = (Slider)((Slider)this.controlP5.addSlider("gzSlider", -5000.0f, 5000.0f, 0.0f, n3 + 20, n5 + 30, 50, 10).setDecimalPrecision(0)).setLabel("");
        this.altSlider = (Slider)((Slider)this.controlP5.addSlider("altSlider", -30000.0f, 30000.0f, 0.0f, n3 + 20, n7, 50, 10).setDecimalPrecision(2)).setLabel("");
        this.headSlider = this.controlP5.addSlider("headSlider", -200.0f, 200.0f, 0.0f, n3 + 20, n8, 50, 10);
        this.headSlider.setDecimalPrecision(0);
        this.headSlider.setLabel("");
        this.magxSlider = (Slider)((Slider)this.controlP5.addSlider("magxSlider", -5000.0f, 5000.0f, 0.0f, n3 + 20, n6 + 10, 50, 10).setDecimalPrecision(0)).setLabel("");
        this.magySlider = (Slider)((Slider)this.controlP5.addSlider("magySlider", -5000.0f, 5000.0f, 0.0f, n3 + 20, n6 + 20, 50, 10).setDecimalPrecision(0)).setLabel("");
        this.magzSlider = (Slider)((Slider)this.controlP5.addSlider("magzSlider", -5000.0f, 5000.0f, 0.0f, n3 + 20, n6 + 30, 50, 10).setDecimalPrecision(0)).setLabel("");
        this.debug1Slider = (Slider)((Slider)this.controlP5.addSlider("debug1Slider", -32768.0f, 32767.0f, 0.0f, n3 + 130, n9, 50, 10).setDecimalPrecision(0)).setLabel("");
        this.debug2Slider = (Slider)((Slider)this.controlP5.addSlider("debug2Slider", -32768.0f, 32767.0f, 0.0f, n3 + 250, n9, 50, 10).setDecimalPrecision(0)).setLabel("");
        this.debug3Slider = (Slider)((Slider)this.controlP5.addSlider("debug3Slider", -32768.0f, 32767.0f, 0.0f, n3 + 370, n9, 50, 10).setDecimalPrecision(0)).setLabel("");
        this.debug4Slider = (Slider)((Slider)this.controlP5.addSlider("debug4Slider", -32768.0f, 32767.0f, 0.0f, n3 + 490, n9, 50, 10).setDecimalPrecision(0)).setLabel("");
        int n10 = 0;
        while (n10 < PIDITEMS) {
            this.confP[n10] = (Numberbox)this.hideLabel((Controller)this.controlP5.addNumberbox("confP" + n10, 0.0f, this.xParam + 40, this.yParam + 20 + n10 * 17, 30, 14));
            ((Numberbox)((Numberbox)((Numberbox)this.confP[n10].setColorBackground(this.red_)).setMin(0.0f)).setDirection(0).setDecimalPrecision(1)).setMultiplier(0.1f).setMax(20.0f);
            this.confI[n10] = (Numberbox)this.hideLabel((Controller)this.controlP5.addNumberbox("confI" + n10, 0.0f, this.xParam + 75, this.yParam + 20 + n10 * 17, 40, 14));
            ((Numberbox)((Numberbox)((Numberbox)this.confI[n10].setColorBackground(this.red_)).setMin(0.0f)).setDirection(0).setDecimalPrecision(3)).setMultiplier(0.001f).setMax(0.25f);
            this.confD[n10] = (Numberbox)this.hideLabel((Controller)this.controlP5.addNumberbox("confD" + n10, 0.0f, this.xParam + 120, this.yParam + 20 + n10 * 17, 30, 14));
            ((Numberbox)((Numberbox)((Numberbox)this.confD[n10].setColorBackground(this.red_)).setMin(0.0f)).setDirection(0).setDecimalPrecision(0)).setMultiplier(1.0f).setMax(100.0f);
            ++n10;
        }
        this.confI[8].hide();
        this.confD[8].hide();
        this.confD[4].hide();
        this.confP[9].hide();
        this.confI[9].hide();
        this.confD[9].hide();
        ((Numberbox)this.confP[4].setDecimalPrecision(2)).setMultiplier(0.01f).setMax(5.0f);
        ((Numberbox)this.confI[4].setDecimalPrecision(1)).setMultiplier(0.1f).setMax(2.5f);
        ((Numberbox)this.confP[5].setDecimalPrecision(1)).setMultiplier(0.1f).setMax(25.0f);
        ((Numberbox)this.confI[5].setDecimalPrecision(2)).setMultiplier(0.01f).setMax(2.5f);
        ((Numberbox)this.confD[5].setDecimalPrecision(3)).setMultiplier(0.001f).setMax(0.25f);
        ((Numberbox)this.confP[6].setDecimalPrecision(1)).setMultiplier(0.1f).setMax(25.0f);
        ((Numberbox)this.confI[6].setDecimalPrecision(2)).setMultiplier(0.01f).setMax(2.5f);
        ((Numberbox)this.confD[6].setDecimalPrecision(3)).setMultiplier(0.001f).setMax(0.25f);
        this.rollPitchRate = (Numberbox)this.hideLabel((Controller)this.controlP5.addNumberbox("rollPitchRate", 0.0f, this.xParam + 160, this.yParam + 30, 30, 14)).setDecimalPrecision(2);
        ((Numberbox)((Numberbox)((Numberbox)this.rollPitchRate.setDirection(0).setMin(0.0f)).setMax(1.0f)).setColorBackground(this.red_)).setMultiplier(0.01f);
        this.yawRate = (Numberbox)this.hideLabel((Controller)this.controlP5.addNumberbox("yawRate", 0.0f, this.xParam + 160, this.yParam + 54, 30, 14)).setDecimalPrecision(2);
        ((Numberbox)((Numberbox)((Numberbox)this.yawRate.setDirection(0).setMin(0.0f)).setMax(1.0f)).setColorBackground(this.red_)).setMultiplier(0.01f);
        this.dynamic_THR_PID = (Numberbox)this.hideLabel((Controller)this.controlP5.addNumberbox("dynamic_THR_PID", 0.0f, this.xParam + 215, this.yParam + 22, 30, 14)).setDecimalPrecision(2);
        ((Numberbox)((Numberbox)this.dynamic_THR_PID.setMultiplier(0.01f).setDirection(0).setMin(0.0f)).setMax(1.0f)).setColorBackground(this.red_);
        this.confRC_RATE = (Numberbox)((Numberbox)this.controlP5.addNumberbox("RC RATE", 1.0f, this.xParam + 40, this.yParam + 220, 30, 14).setDecimalPrecision(2)).setMultiplier(0.01f).setLabel("");
        ((Numberbox)((Numberbox)this.confRC_RATE.setDirection(0).setMin(0.0f)).setMax(2.5f)).setColorBackground(this.red_);
        this.confRC_EXPO = (Numberbox)((Numberbox)this.controlP5.addNumberbox("RC EXPO", 0.0f, this.xParam + 40, this.yParam + 237, 30, 14).setDecimalPrecision(2)).setMultiplier(0.01f).setLabel("");
        ((Numberbox)((Numberbox)this.confRC_EXPO.setDirection(0).setMin(0.0f)).setMax(1.0f)).setColorBackground(this.red_);
        this.confSetting = (Numberbox)((Numberbox)this.controlP5.addNumberbox("_SETTING", 0.0f, this.xParam + 2, this.yParam + 2, 30, 14).setDecimalPrecision(0)).setMultiplier(1.0f).setLabel("");
        ((Numberbox)((Numberbox)this.confSetting.setDirection(0).setMin(0.0f)).setMax(2.0f)).setColorBackground(this.red_);
        this.confSelectSetting = (Numberbox)((Numberbox)this.controlP5.addNumberbox("S_SETTING", 0.0f, this.xParam + 520, this.yParam + 260, 30, 14).setDecimalPrecision(0)).setMultiplier(1.0f).setLabel("");
        ((Numberbox)((Numberbox)this.confSelectSetting.setDirection(0).setMin(0.0f)).setMax(2.0f)).setColorBackground(this.red_);
        this.throttle_MID = (Numberbox)((Numberbox)((Numberbox)((Numberbox)((Numberbox)this.controlP5.addNumberbox("T MID", 0.5f, this.xParam + 40, this.yParam + 180, 30, 14).setDecimalPrecision(2)).setMultiplier(0.01f).setLabel("")).setDirection(0).setMin(0.0f)).setMax(1.0f)).setColorBackground(this.red_);
        this.throttle_EXPO = (Numberbox)((Numberbox)((Numberbox)((Numberbox)((Numberbox)this.controlP5.addNumberbox("T EXPO", 0.0f, this.xParam + 40, this.yParam + 197, 30, 14).setDecimalPrecision(2)).setMultiplier(0.01f).setLabel("")).setDirection(0).setMin(0.0f)).setMax(1.0f)).setColorBackground(this.red_);
        this.buttonREAD = (Button)this.controlP5.addButton("READ", 1.0f, this.xParam + 5, this.yParam + 260, 50, 16).setColorBackground(this.red_);
        this.buttonRESET = (Button)this.controlP5.addButton("RESET", 1.0f, this.xParam + 60, this.yParam + 260, 60, 16).setColorBackground(this.red_);
        this.buttonWRITE = (Button)this.controlP5.addButton("WRITE", 1.0f, this.xParam + 290, this.yParam + 260, 60, 16).setColorBackground(this.red_);
        this.buttonCALIBRATE_ACC = (Button)this.controlP5.addButton("CALIB_ACC", 1.0f, this.xParam + 210, this.yParam + 260, 70, 16).setColorBackground(this.red_);
        this.buttonCALIBRATE_MAG = (Button)this.controlP5.addButton("CALIB_MAG", 1.0f, this.xParam + 130, this.yParam + 260, 70, 16).setColorBackground(this.red_);
        this.buttonSETTING = (Button)((Button)this.controlP5.addButton("SETTING", 1.0f, this.xParam + 405, this.yParam + 260, 110, 16).setLabel("SELECT SETTING")).setColorBackground(this.red_);
        this.rcStickThrottleSlider = (Slider)this.controlP5.addSlider("Throt", 900.0f, 2100.0f, 1500.0f, this.xRC, this.yRC, 100, 10).setDecimalPrecision(0);
        this.rcStickPitchSlider = (Slider)this.controlP5.addSlider("Pitch", 900.0f, 2100.0f, 1500.0f, this.xRC, this.yRC + 15, 100, 10).setDecimalPrecision(0);
        this.rcStickRollSlider = (Slider)this.controlP5.addSlider("Roll", 900.0f, 2100.0f, 1500.0f, this.xRC, this.yRC + 30, 100, 10).setDecimalPrecision(0);
        this.rcStickYawSlider = (Slider)this.controlP5.addSlider("Yaw", 900.0f, 2100.0f, 1500.0f, this.xRC, this.yRC + 45, 100, 10).setDecimalPrecision(0);
        this.rcStickAUX1Slider = (Slider)this.controlP5.addSlider("AUX1", 900.0f, 2100.0f, 1500.0f, this.xRC, this.yRC + 60, 100, 10).setDecimalPrecision(0);
        this.rcStickAUX2Slider = (Slider)this.controlP5.addSlider("AUX2", 900.0f, 2100.0f, 1500.0f, this.xRC, this.yRC + 75, 100, 10).setDecimalPrecision(0);
        this.rcStickAUX3Slider = (Slider)this.controlP5.addSlider("AUX3", 900.0f, 2100.0f, 1500.0f, this.xRC, this.yRC + 90, 100, 10).setDecimalPrecision(0);
        this.rcStickAUX4Slider = (Slider)this.controlP5.addSlider("AUX4", 900.0f, 2100.0f, 1500.0f, this.xRC, this.yRC + 105, 100, 10).setDecimalPrecision(0);
        n10 = 0;
        while (n10 < 8) {
            this.motSlider[n10] = (Slider)this.controlP5.addSlider("motSlider" + n10, 1000.0f, 2000.0f, 1500.0f, 0, 0, 10, 100).setDecimalPrecision(0);
            this.servoSliderH[n10] = (Slider)this.controlP5.addSlider("ServoH" + n10, 1000.0f, 2000.0f, 1500.0f, 0, 0, 100, 10).setDecimalPrecision(0);
            this.servoSliderV[n10] = (Slider)this.controlP5.addSlider("ServoV" + n10, 1000.0f, 2000.0f, 1500.0f, 0, 0, 10, 100).setDecimalPrecision(0);
            ++n10;
        }
        this.scaleSlider = this.controlP5.addSlider("SCALE", 0.0f, 10.0f, 1.0f, this.xGraph + 515, this.yGraph, 75, 20);
        this.scaleSlider.setLabel("");
        this.confPowerTrigger = (Numberbox)((Numberbox)((Numberbox)((Numberbox)this.controlP5.addNumberbox("", 0.0f, this.xGraph + 50, this.yGraph - 29, 40, 14).setDecimalPrecision(0)).setMultiplier(10.0f).setDirection(0).setMin(0.0f)).setMax(65535.0f)).setColorBackground(this.red_);
        this.Tooltips();
    }

    public int read32() {
        return (this.inBuf[this.p++] & 0xFF) + ((this.inBuf[this.p++] & 0xFF) << 8) + ((this.inBuf[this.p++] & 0xFF) << 16) + ((this.inBuf[this.p++] & 0xFF) << 24);
    }

    public int read16() {
        return (this.inBuf[this.p++] & 0xFF) + (this.inBuf[this.p++] << 8);
    }

    public int read8() {
        return this.inBuf[this.p++] & 0xFF;
    }

    private List<Byte> requestMSP(int n) {
        return this.requestMSP(n, null);
    }

    private List<Byte> requestMSP(int[] nArray) {
        LinkedList<Byte> linkedList = new LinkedList<Byte>();
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            linkedList.addAll(this.requestMSP(n3, null));
            ++n2;
        }
        return linkedList;
    }

    private List<Byte> requestMSP(int n, Character[] characterArray) {
        byte by;
        if (n < 0) {
            return null;
        }
        LinkedList<Byte> linkedList = new LinkedList<Byte>();
        byte[] byArray = MSP_HEADER.getBytes();
        char c = byArray.length;
        char c2 = '\u0000';
        while (c2 < c) {
            by = byArray[c2];
            linkedList.add(by);
            ++c2;
        }
        by = 0;
        c2 = (char)((characterArray != null ? PApplet.parseInt((float)characterArray.length) : 0) & 0xFF);
        linkedList.add((byte)c2);
        by = (byte)(by ^ c2 & 0xFF);
        linkedList.add((byte)(n & 0xFF));
        by = (byte)(by ^ n & 0xFF);
        if (characterArray != null) {
            Character[] characterArray2 = characterArray;
            int n2 = characterArray.length;
            int n3 = 0;
            while (n3 < n2) {
                c = characterArray2[n3].charValue();
                linkedList.add((byte)(c & 0xFF));
                by = (byte)(by ^ c & 0xFF);
                ++n3;
            }
        }
        linkedList.add(by);
        return linkedList;
    }

    public void sendRequestMSP(List<Byte> list) {
        byte[] byArray = new byte[list.size()];
        int n = 0;
        for (byte by : list) {
            byArray[n++] = by;
        }
        this.g_serial.write(byArray);
    }

    public void evaluateCommand(byte by, int n) {
        int n2 = by & 0xFF;
        switch (n2) {
            case 100: {
                this.version = this.read8();
                this.multiType = this.read8();
                this.read8();
                this.multiCapability = this.read32();
                if ((this.multiCapability & 1) <= 0) break;
                this.buttonRXbind = this.controlP5.addButton("bRXbind", 1.0f, 10, this.yGraph + 205 - 10, 55, 10);
                this.buttonRXbind.setColorBackground(this.blue_);
                this.buttonRXbind.setLabel("RX Bind");
                break;
            }
            case 101: {
                this.cycleTime = this.read16();
                this.i2cError = this.read16();
                this.present = this.read16();
                this.mode = this.read32();
                if ((this.present & 1) > 0) {
                    this.buttonAcc.setColorBackground(this.green_);
                } else {
                    this.buttonAcc.setColorBackground(this.red_);
                    this.tACC_ROLL.setState(false);
                    this.tACC_PITCH.setState(false);
                    this.tACC_Z.setState(false);
                }
                if ((this.present & 2) > 0) {
                    this.buttonBaro.setColorBackground(this.green_);
                } else {
                    this.buttonBaro.setColorBackground(this.red_);
                    this.tBARO.setState(false);
                }
                if ((this.present & 4) > 0) {
                    this.buttonMag.setColorBackground(this.green_);
                } else {
                    this.buttonMag.setColorBackground(this.red_);
                    this.tMAGX.setState(false);
                    this.tMAGY.setState(false);
                    this.tMAGZ.setState(false);
                }
                if ((this.present & 8) > 0) {
                    this.buttonGPS.setColorBackground(this.green_);
                } else {
                    this.buttonGPS.setColorBackground(this.red_);
                    this.tHEAD.setState(false);
                }
                if ((this.present & 0x10) > 0) {
                    this.buttonSonar.setColorBackground(this.green_);
                } else {
                    this.buttonSonar.setColorBackground(this.red_);
                }
                int n3 = 0;
                while (n3 < CHECKBOXITEMS) {
                    if ((this.mode & 1 << n3) > 0) {
                        this.buttonCheckbox[n3].setColorBackground(this.green_);
                    } else {
                        this.buttonCheckbox[n3].setColorBackground(this.red_);
                    }
                    ++n3;
                }
                this.confSetting.setValue((float)this.read8());
                this.confSetting.setColorBackground(this.green_);
                break;
            }
            case 102: {
                this.ax = this.read16();
                this.ay = this.read16();
                this.az = this.read16();
                this.gx = this.read16() / 8;
                this.gy = this.read16() / 8;
                this.gz = this.read16() / 8;
                this.magx = this.read16() / 3;
                this.magy = this.read16() / 3;
                this.magz = this.read16() / 3;
                break;
            }
            case 103: {
                int n4 = 0;
                while (n4 < 8) {
                    this.servo[n4] = this.read16();
                    ++n4;
                }
                break;
            }
            case 104: {
                int n5 = 0;
                while (n5 < 8) {
                    this.mot[n5] = this.read16();
                    ++n5;
                }
                break;
            }
            case 105: {
                this.rcRoll = this.read16();
                this.rcPitch = this.read16();
                this.rcYaw = this.read16();
                this.rcThrottle = this.read16();
                this.rcAUX1 = this.read16();
                this.rcAUX2 = this.read16();
                this.rcAUX3 = this.read16();
                this.rcAUX4 = this.read16();
                break;
            }
            case 106: {
                this.GPS_fix = this.read8();
                this.GPS_numSat = this.read8();
                this.GPS_latitude = this.read32();
                this.GPS_longitude = this.read32();
                this.GPS_altitude = this.read16();
                this.GPS_speed = this.read16();
                break;
            }
            case 107: {
                this.GPS_distanceToHome = this.read16();
                this.GPS_directionToHome = this.read16();
                this.GPS_update = this.read8();
                break;
            }
            case 108: {
                this.angx = this.read16() / 10;
                this.angy = this.read16() / 10;
                this.head = this.read16();
                break;
            }
            case 109: {
                this.alt = this.read32();
                break;
            }
            case 110: {
                this.bytevbat = this.read8();
                this.pMeterSum = this.read16();
                break;
            }
            case 111: {
                this.byteRC_RATE = this.read8();
                this.byteRC_EXPO = this.read8();
                this.byteRollPitchRate = this.read8();
                this.byteYawRate = this.read8();
                this.byteDynThrPID = this.read8();
                this.byteThrottle_MID = this.read8();
                this.byteThrottle_EXPO = this.read8();
                this.confRC_RATE.setValue((float)this.byteRC_RATE / 100.0f);
                this.confRC_EXPO.setValue((float)this.byteRC_EXPO / 100.0f);
                this.rollPitchRate.setValue((float)this.byteRollPitchRate / 100.0f);
                this.yawRate.setValue((float)this.byteYawRate / 100.0f);
                this.dynamic_THR_PID.setValue((float)this.byteDynThrPID / 100.0f);
                this.throttle_MID.setValue((float)this.byteThrottle_MID / 100.0f);
                this.throttle_EXPO.setValue((float)this.byteThrottle_EXPO / 100.0f);
                this.confRC_RATE.setColorBackground(this.green_);
                this.confRC_EXPO.setColorBackground(this.green_);
                this.rollPitchRate.setColorBackground(this.green_);
                this.yawRate.setColorBackground(this.green_);
                this.dynamic_THR_PID.setColorBackground(this.green_);
                this.throttle_MID.setColorBackground(this.green_);
                this.throttle_EXPO.setColorBackground(this.green_);
                this.updateModelMSP_SET_RC_TUNING();
                break;
            }
            case 205: {
                break;
            }
            case 206: {
                break;
            }
            case 112: {
                int n6 = 0;
                while (n6 < PIDITEMS) {
                    this.byteP[n6] = this.read8();
                    this.byteI[n6] = this.read8();
                    this.byteD[n6] = this.read8();
                    switch (n6) {
                        case 0: {
                            this.confP[n6].setValue((float)this.byteP[n6] / 10.0f);
                            this.confI[n6].setValue((float)this.byteI[n6] / 1000.0f);
                            this.confD[n6].setValue((float)this.byteD[n6]);
                            break;
                        }
                        case 1: {
                            this.confP[n6].setValue((float)this.byteP[n6] / 10.0f);
                            this.confI[n6].setValue((float)this.byteI[n6] / 1000.0f);
                            this.confD[n6].setValue((float)this.byteD[n6]);
                            break;
                        }
                        case 2: {
                            this.confP[n6].setValue((float)this.byteP[n6] / 10.0f);
                            this.confI[n6].setValue((float)this.byteI[n6] / 1000.0f);
                            this.confD[n6].setValue((float)this.byteD[n6]);
                            break;
                        }
                        case 3: {
                            this.confP[n6].setValue((float)this.byteP[n6] / 10.0f);
                            this.confI[n6].setValue((float)this.byteI[n6] / 1000.0f);
                            this.confD[n6].setValue((float)this.byteD[n6]);
                            break;
                        }
                        case 7: {
                            this.confP[n6].setValue((float)this.byteP[n6] / 10.0f);
                            this.confI[n6].setValue((float)this.byteI[n6] / 1000.0f);
                            this.confD[n6].setValue((float)this.byteD[n6]);
                            break;
                        }
                        case 8: {
                            this.confP[n6].setValue((float)this.byteP[n6] / 10.0f);
                            this.confI[n6].setValue((float)this.byteI[n6] / 1000.0f);
                            this.confD[n6].setValue((float)this.byteD[n6]);
                            break;
                        }
                        case 9: {
                            this.confP[n6].setValue((float)this.byteP[n6] / 10.0f);
                            this.confI[n6].setValue((float)this.byteI[n6] / 1000.0f);
                            this.confD[n6].setValue((float)this.byteD[n6]);
                            break;
                        }
                        case 4: {
                            this.confP[n6].setValue((float)this.byteP[n6] / 100.0f);
                            this.confI[n6].setValue((float)this.byteI[n6] / 100.0f);
                            this.confD[n6].setValue((float)this.byteD[n6] / 1000.0f);
                            break;
                        }
                        case 5: {
                            this.confP[n6].setValue((float)this.byteP[n6] / 10.0f);
                            this.confI[n6].setValue((float)this.byteI[n6] / 100.0f);
                            this.confD[n6].setValue((float)this.byteD[n6] / 1000.0f);
                            break;
                        }
                        case 6: {
                            this.confP[n6].setValue((float)this.byteP[n6] / 10.0f);
                            this.confI[n6].setValue((float)this.byteI[n6] / 100.0f);
                            this.confD[n6].setValue((float)this.byteD[n6] / 1000.0f);
                        }
                    }
                    this.confP[n6].setColorBackground(this.green_);
                    this.confI[n6].setColorBackground(this.green_);
                    this.confD[n6].setColorBackground(this.green_);
                    ++n6;
                }
                this.updateModelMSP_SET_PID();
                break;
            }
            case 113: {
                int n7 = 0;
                while (n7 < CHECKBOXITEMS) {
                    this.activation[n7] = this.read16();
                    int n8 = 0;
                    while (n8 < 12) {
                        if ((this.activation[n7] & 1 << n8) > 0) {
                            this.checkbox[n7].activate(n8);
                        } else {
                            this.checkbox[n7].deactivate(n8);
                        }
                        ++n8;
                    }
                    ++n7;
                }
                break;
            }
            case 116: {
                this.create_checkboxes(new String(this.inBuf, 0, n).split(";"));
                break;
            }
            case 117: {
                break;
            }
            case 114: {
                this.intPowerTrigger = this.read16();
                this.confPowerTrigger.setValue((float)this.intPowerTrigger);
                this.updateModelMSP_SET_MISC();
                break;
            }
            case 115: {
                int n9 = 0;
                while (n9 < 8) {
                    this.byteMP[n9] = this.read8();
                    ++n9;
                }
                break;
            }
            case 253: {
                while (n-- > 0) {
                    char c = (char)this.read8();
                    if (c == '\u0000') continue;
                    System.out.print(c);
                }
                break;
            }
            case 254: {
                this.debug1 = this.read16();
                this.debug2 = this.read16();
                this.debug3 = this.read16();
                this.debug4 = this.read16();
            }
        }
    }

    public void draw() {
        int n;
        int n2;
        int n3;
        float f;
        int n4;
        int n5;
        int n6;
        int n7;
        float f2;
        float f3;
        int n8;
        if (this.init_com == 1 && this.graph_on == 1) {
            ArrayList<Character> arrayList;
            int[] nArray;
            this.time = this.millis();
            if (this.time - this.time4 > 40) {
                this.time4 = this.time;
                this.accROLL.addVal(this.ax);
                this.accPITCH.addVal(this.ay);
                this.accYAW.addVal(this.az);
                this.gyroROLL.addVal(this.gx);
                this.gyroPITCH.addVal(this.gy);
                this.gyroYAW.addVal(this.gz);
                this.magxData.addVal(this.magx);
                this.magyData.addVal(this.magy);
                this.magzData.addVal(this.magz);
                this.altData.addVal(this.alt);
                this.headData.addVal(this.head);
                this.debug1Data.addVal(this.debug1);
                this.debug2Data.addVal(this.debug2);
                this.debug3Data.addVal(this.debug3);
                this.debug4Data.addVal(this.debug4);
            }
            if (!(this.time - this.time2 <= 40 || this.toggleRead || this.toggleWrite || this.toggleSetSetting)) {
                this.time2 = this.time;
                nArray = new int[]{101, 102, 103, 104, 105, 106, 107, 109, 110, 253, 254};
                this.sendRequestMSP(this.requestMSP(nArray));
            }
            if (!(this.time - this.time3 <= 20 || this.toggleRead || this.toggleWrite || this.toggleSetSetting)) {
                this.sendRequestMSP(this.requestMSP(108));
                this.time3 = this.time;
            }
            if (this.toggleReset) {
                this.toggleReset = false;
                this.toggleRead = true;
                this.sendRequestMSP(this.requestMSP(208));
            }
            if (this.toggleRead) {
                this.toggleRead = false;
                nArray = new int[]{116, 111, 112, 113, 114, 100, 115};
                this.sendRequestMSP(this.requestMSP(nArray));
                this.buttonWRITE.setColorBackground(this.green_);
                this.buttonSETTING.setColorBackground(this.green_);
                this.confSelectSetting.setColorBackground(this.green_);
            }
            if (this.toggleSetSetting) {
                this.toggleSetSetting = false;
                this.toggleRead = true;
                arrayList = new ArrayList<Character>();
                arrayList.add(Character.valueOf(PApplet.parseChar((int)MultiWiiConf.round((float)this.confSelectSetting.value()))));
                this.sendRequestMSP(this.requestMSP(210, arrayList.toArray(new Character[arrayList.size()])));
            }
            if (this.toggleCalibAcc) {
                this.toggleCalibAcc = false;
                this.sendRequestMSP(this.requestMSP(205));
            }
            if (this.toggleCalibMag) {
                this.toggleCalibMag = false;
                this.sendRequestMSP(this.requestMSP(206));
            }
            if (this.toggleWrite) {
                this.toggleWrite = false;
                arrayList = new ArrayList();
                arrayList.add(Character.valueOf(PApplet.parseChar((int)MultiWiiConf.round((float)(this.confRC_RATE.value() * 100.0f)))));
                arrayList.add(Character.valueOf(PApplet.parseChar((int)MultiWiiConf.round((float)(this.confRC_EXPO.value() * 100.0f)))));
                arrayList.add(Character.valueOf(PApplet.parseChar((int)MultiWiiConf.round((float)(this.rollPitchRate.value() * 100.0f)))));
                arrayList.add(Character.valueOf(PApplet.parseChar((int)MultiWiiConf.round((float)(this.yawRate.value() * 100.0f)))));
                arrayList.add(Character.valueOf(PApplet.parseChar((int)MultiWiiConf.round((float)(this.dynamic_THR_PID.value() * 100.0f)))));
                arrayList.add(Character.valueOf(PApplet.parseChar((int)MultiWiiConf.round((float)(this.throttle_MID.value() * 100.0f)))));
                arrayList.add(Character.valueOf(PApplet.parseChar((int)MultiWiiConf.round((float)(this.throttle_EXPO.value() * 100.0f)))));
                this.sendRequestMSP(this.requestMSP(204, arrayList.toArray(new Character[arrayList.size()])));
                arrayList = new ArrayList();
                n8 = 0;
                while (n8 < PIDITEMS) {
                    this.byteP[n8] = MultiWiiConf.round((float)(this.confP[n8].value() * 10.0f));
                    this.byteI[n8] = MultiWiiConf.round((float)(this.confI[n8].value() * 1000.0f));
                    this.byteD[n8] = MultiWiiConf.round((float)this.confD[n8].value());
                    ++n8;
                }
                this.byteP[4] = MultiWiiConf.round((float)(this.confP[4].value() * 100.0f));
                this.byteI[4] = MultiWiiConf.round((float)(this.confI[4].value() * 100.0f));
                this.byteP[5] = MultiWiiConf.round((float)(this.confP[5].value() * 10.0f));
                this.byteI[5] = MultiWiiConf.round((float)(this.confI[5].value() * 100.0f));
                this.byteD[5] = MultiWiiConf.round((float)(this.confD[5].value() * 10000.0f)) / 10;
                this.byteP[6] = MultiWiiConf.round((float)(this.confP[6].value() * 10.0f));
                this.byteI[6] = MultiWiiConf.round((float)(this.confI[6].value() * 100.0f));
                this.byteD[6] = MultiWiiConf.round((float)(this.confD[6].value() * 10000.0f)) / 10;
                n8 = 0;
                while (n8 < PIDITEMS) {
                    arrayList.add(Character.valueOf(PApplet.parseChar((int)this.byteP[n8])));
                    arrayList.add(Character.valueOf(PApplet.parseChar((int)this.byteI[n8])));
                    arrayList.add(Character.valueOf(PApplet.parseChar((int)this.byteD[n8])));
                    ++n8;
                }
                this.sendRequestMSP(this.requestMSP(202, arrayList.toArray(new Character[arrayList.size()])));
                arrayList = new ArrayList();
                n8 = 0;
                while (n8 < CHECKBOXITEMS) {
                    this.activation[n8] = 0;
                    int n9 = 0;
                    while (n9 < 12) {
                        int n10 = n8;
                        this.activation[n10] = this.activation[n10] + (int)(this.checkbox[n8].arrayValue()[n9] * (float)(1 << n9));
                        ++n9;
                    }
                    arrayList.add(Character.valueOf(PApplet.parseChar((int)(this.activation[n8] % 256))));
                    arrayList.add(Character.valueOf(PApplet.parseChar((int)(this.activation[n8] / 256))));
                    ++n8;
                }
                this.sendRequestMSP(this.requestMSP(203, arrayList.toArray(new Character[arrayList.size()])));
                arrayList = new ArrayList();
                this.intPowerTrigger = MultiWiiConf.round((float)this.confPowerTrigger.value());
                arrayList.add(Character.valueOf(PApplet.parseChar((int)(this.intPowerTrigger % 256))));
                arrayList.add(Character.valueOf(PApplet.parseChar((int)(this.intPowerTrigger / 256))));
                this.sendRequestMSP(this.requestMSP(207, arrayList.toArray(new Character[arrayList.size()])));
                this.sendRequestMSP(this.requestMSP(250));
                this.updateModel();
            }
            if (this.toggleRXbind) {
                this.toggleRXbind = false;
                this.sendRequestMSP(this.requestMSP(240));
                this.bSTOP();
                this.InitSerial(9999.0f);
            }
            while (this.g_serial.available() > 0) {
                int n11 = this.g_serial.read();
                if (this.c_state == 0) {
                    this.c_state = n11 == 36 ? 1 : 0;
                    continue;
                }
                if (this.c_state == 1) {
                    this.c_state = n11 == 77 ? 2 : 0;
                    continue;
                }
                if (this.c_state == 2) {
                    if (n11 == 62) {
                        this.c_state = 3;
                        continue;
                    }
                    if (n11 == 33) {
                        this.c_state = 6;
                        continue;
                    }
                    this.c_state = 0;
                    continue;
                }
                if (this.c_state == 3 || this.c_state == 6) {
                    this.err_rcvd = this.c_state == 6;
                    this.dataSize = n11 & 0xFF;
                    this.p = 0;
                    this.offset = 0;
                    this.checksum = 0;
                    this.checksum = (byte)(this.checksum ^ n11 & 0xFF);
                    this.c_state = 4;
                    continue;
                }
                if (this.c_state == 4) {
                    this.cmd = (byte)(n11 & 0xFF);
                    this.checksum = (byte)(this.checksum ^ n11 & 0xFF);
                    this.c_state = 5;
                    continue;
                }
                if (this.c_state == 5 && this.offset < this.dataSize) {
                    this.checksum = (byte)(this.checksum ^ n11 & 0xFF);
                    this.inBuf[this.offset++] = (byte)(n11 & 0xFF);
                    continue;
                }
                if (this.c_state != 5 || this.offset < this.dataSize) continue;
                if ((this.checksum & 0xFF) == (n11 & 0xFF)) {
                    if (!this.err_rcvd) {
                        this.evaluateCommand(this.cmd, this.dataSize);
                    }
                } else {
                    System.out.println("invalid checksum for command " + (this.cmd & 0xFF) + ": " + (this.checksum & 0xFF) + " expected, got " + (n11 & 0xFF));
                    System.out.print("<" + (this.cmd & 0xFF) + " " + (this.dataSize & 0xFF) + "> {");
                    n8 = 0;
                    while (n8 < this.dataSize) {
                        if (n8 != 0) {
                            System.err.print(' ');
                        }
                        System.out.print(this.inBuf[n8] & 0xFF);
                        ++n8;
                    }
                    System.out.println("} [" + n11 + "]");
                    System.out.println(new String(this.inBuf, 0, this.dataSize));
                }
                this.c_state = 0;
            }
        }
        this.background(80);
        this.fill(40.0f, 40.0f, 40.0f);
        this.strokeWeight(3.0f);
        this.stroke(0);
        this.rectMode(1);
        this.rect(5.0f, 5.0f, 113.0f, 40.0f);
        this.textFont(this.font15);
        this.fill(255.0f, 255.0f, 255.0f);
        this.text("multiwii.com", 16.0f, 19.0f);
        this.text("V", 16.0f, 35.0f);
        this.text(this.version, 27.0f, 35.0f);
        this.text(this.i2cError, this.xGraph + 410, this.yGraph - 10);
        this.text(this.cycleTime, this.xGraph + 290, this.yGraph - 10);
        this.fill(0.0f, 0.0f, 0.0f);
        this.strokeWeight(3.0f);
        this.stroke(0);
        this.rectMode(1);
        this.rect(this.xGPS - 5, this.yGPS - 15, this.xGPS + 140, this.yGPS + 95);
        this.fill(255.0f, 255.0f, 255.0f);
        this.text("GPS", this.xGPS, this.yGPS);
        this.text(this.GPS_altitude, this.xGPS + 50, this.yGPS + 15);
        this.text(this.GPS_latitude, this.xGPS + 50, this.yGPS + 30);
        this.text(this.GPS_longitude, this.xGPS + 50, this.yGPS + 45);
        this.text(this.GPS_speed, this.xGPS + 50, this.yGPS + 60);
        this.text(this.GPS_numSat, this.xGPS + 50, this.yGPS + 75);
        this.text(this.GPS_distanceToHome, this.xGPS + 65, this.yGPS + 90);
        this.textFont(this.font12);
        this.text("alt   :", this.xGPS, this.yGPS + 15);
        this.text("lat   :", this.xGPS, this.yGPS + 30);
        this.text("lon   :", this.xGPS, this.yGPS + 45);
        this.text("speed :", this.xGPS, this.yGPS + 60);
        this.text("sat   :", this.xGPS, this.yGPS + 75);
        this.text("dist home : ", this.xGPS, this.yGPS + 90);
        this.text("I2C error:", this.xGraph + 350, this.yGraph - 10);
        this.text("Cycle Time:", this.xGraph + 220, this.yGraph - 10);
        this.text("Power:", this.xGraph - 5, this.yGraph - 30);
        this.text(this.pMeterSum, this.xGraph + 50, this.yGraph - 30);
        this.text("pAlarm:", this.xGraph - 5, this.yGraph - 15);
        this.text("Volt:", this.xGraph - 5, this.yGraph - 2);
        this.text((float)this.bytevbat / 10.0f, this.xGraph + 50, this.yGraph - 2);
        this.fill(255.0f, 255.0f, 255.0f);
        this.axSlider.setValue(this.ax);
        this.aySlider.setValue(this.ay);
        this.azSlider.setValue(this.az);
        this.gxSlider.setValue(this.gx);
        this.gySlider.setValue(this.gy);
        this.gzSlider.setValue(this.gz);
        this.altSlider.setValue(this.alt / 100.0f);
        this.headSlider.setValue(this.head);
        this.magxSlider.setValue(this.magx);
        this.magySlider.setValue(this.magy);
        this.magzSlider.setValue(this.magz);
        this.debug1Slider.setValue(this.debug1);
        this.debug2Slider.setValue(this.debug2);
        this.debug3Slider.setValue(this.debug3);
        this.debug4Slider.setValue(this.debug4);
        n8 = 0;
        while (n8 < 8) {
            this.motSlider[n8].setValue(this.mot[n8]).hide();
            this.servoSliderH[n8].setValue(this.servo[n8]).hide();
            this.servoSliderV[n8].setValue(this.servo[n8]).hide();
            ++n8;
        }
        this.rcStickThrottleSlider.setValue(this.rcThrottle);
        this.rcStickRollSlider.setValue(this.rcRoll);
        this.rcStickPitchSlider.setValue(this.rcPitch);
        this.rcStickYawSlider.setValue(this.rcYaw);
        this.rcStickAUX1Slider.setValue(this.rcAUX1);
        this.rcStickAUX2Slider.setValue(this.rcAUX2);
        this.rcStickAUX3Slider.setValue(this.rcAUX3);
        this.rcStickAUX4Slider.setValue(this.rcAUX4);
        this.stroke(255);
        float f4 = MultiWiiConf.radians((float)this.angx);
        float f5 = this.angy < -90.0f ? MultiWiiConf.radians((float)(-180.0f - this.angy)) : (this.angy > 90.0f ? MultiWiiConf.radians((float)(180.0f - this.angy)) : MultiWiiConf.radians((float)this.angy));
        float f6 = MultiWiiConf.radians((float)this.head);
        float f7 = 38.0f;
        this.fill(255.0f, 255.0f, 255.0f);
        this.pushMatrix();
        this.camera(this.xObj, this.yObj, 300.0f / MultiWiiConf.tan((float)0.5235988f), this.xObj / 2 + 30, this.yObj / 2 - 40, 0.0f, 0.0f, 1.0f, 0.0f);
        this.translate(this.xObj, this.yObj);
        this.directionalLight(200.0f, 200.0f, 200.0f, 0.0f, 0.0f, -1.0f);
        this.rotateZ(f6);
        this.rotateX(f5);
        this.rotateY(f4);
        this.stroke(150.0f, 255.0f, 150.0f);
        this.strokeWeight(0.0f);
        this.sphere(f7 / 3.0f);
        this.strokeWeight(3.0f);
        this.line(0.0f, 0.0f, 10.0f, 0.0f, -f7 - 5.0f, 10.0f);
        this.line(0.0f, -f7 - 5.0f, 10.0f, f7 / 4.0f, -f7 / 2.0f, 10.0f);
        this.line(0.0f, -f7 - 5.0f, 10.0f, -f7 / 4.0f, -f7 / 2.0f, 10.0f);
        this.stroke(255);
        this.textFont(this.font12);
        if (this.multiType == 1) {
            this.drawMotor(0.0f, f7, this.byteMP[0], 'L');
            this.drawMotor(f7, -f7, this.byteMP[1], 'L');
            this.drawMotor(-f7, -f7, this.byteMP[2], 'R');
            this.line(-f7, -f7, 0.0f, 0.0f);
            this.line(f7, -f7, 0.0f, 0.0f);
            this.line(0.0f, f7, 0.0f, 0.0f);
            this.noLights();
            this.text(" TRICOPTER", -40.0f, -50.0f);
            this.camera();
            this.popMatrix();
            ((Slider)((Slider)this.motSlider[0].setPosition((float)(this.xMot + 50), (float)(this.yMot + 15))).setHeight(100).setCaptionLabel("REAR")).show();
            ((Slider)((Slider)this.motSlider[1].setPosition((float)(this.xMot + 100), (float)(this.yMot - 15))).setHeight(100).setCaptionLabel("RIGHT")).show();
            ((Slider)((Slider)this.motSlider[2].setPosition((float)this.xMot, (float)(this.yMot - 15))).setHeight(100).setCaptionLabel("LEFT")).show();
            ((Slider)((Slider)this.servoSliderH[5].setPosition((float)this.xMot, (float)(this.yMot + 135))).setCaptionLabel("SERVO")).show();
        } else if (this.multiType == 2) {
            this.drawMotor(0.0f, f7, this.byteMP[0], 'R');
            this.drawMotor(f7, 0.0f, this.byteMP[1], 'L');
            this.drawMotor(-f7, 0.0f, this.byteMP[2], 'L');
            this.drawMotor(0.0f, -f7, this.byteMP[3], 'R');
            this.line(-f7, 0.0f, f7, 0.0f);
            this.line(0.0f, -f7, 0.0f, f7);
            this.noLights();
            this.text("QUADRICOPTER +", -40.0f, -50.0f);
            this.camera();
            this.popMatrix();
            ((Slider)((Slider)this.motSlider[0].setPosition((float)(this.xMot + 50), (float)(this.yMot + 75))).setHeight(60).setCaptionLabel("REAR")).show();
            ((Slider)((Slider)this.motSlider[1].setPosition((float)(this.xMot + 100), (float)(this.yMot + 35))).setHeight(60).setCaptionLabel("RIGHT")).show();
            ((Slider)((Slider)this.motSlider[2].setPosition((float)this.xMot, (float)(this.yMot + 35))).setHeight(60).setCaptionLabel("LEFT")).show();
            ((Slider)((Slider)this.motSlider[3].setPosition((float)(this.xMot + 50), (float)(this.yMot - 15))).setHeight(60).setCaptionLabel("FRONT")).show();
        } else if (this.multiType == 3) {
            this.drawMotor(f7, f7, this.byteMP[0], 'R');
            this.drawMotor(f7, -f7, this.byteMP[1], 'L');
            this.drawMotor(-f7, f7, this.byteMP[2], 'L');
            this.drawMotor(-f7, -f7, this.byteMP[3], 'R');
            this.line(-f7, -f7, 0.0f, 0.0f);
            this.line(f7, -f7, 0.0f, 0.0f);
            this.line(-f7, f7, 0.0f, 0.0f);
            this.line(f7, f7, 0.0f, 0.0f);
            this.noLights();
            this.text("QUADRICOPTER X", -40.0f, -50.0f);
            this.camera();
            this.popMatrix();
            ((Slider)((Slider)this.motSlider[0].setPosition((float)(this.xMot + 90), (float)(this.yMot + 75))).setHeight(60).setCaptionLabel("REAR_R")).show();
            ((Slider)((Slider)this.motSlider[1].setPosition((float)(this.xMot + 90), (float)(this.yMot - 15))).setHeight(60).setCaptionLabel("FRONT_R")).show();
            ((Slider)((Slider)this.motSlider[2].setPosition((float)(this.xMot + 10), (float)(this.yMot + 75))).setHeight(60).setCaptionLabel("REAR_L")).show();
            ((Slider)((Slider)this.motSlider[3].setPosition((float)(this.xMot + 10), (float)(this.yMot - 15))).setHeight(60).setCaptionLabel("FRONT_L")).show();
        } else if (this.multiType == 4) {
            this.drawMotor(-f7, 0.0f, this.byteMP[0], 'R');
            this.drawMotor(f7, 0.0f, this.byteMP[1], 'L');
            this.line(0.0f - f7, 0.0f, 0.0f, 0.0f);
            this.line(0.0f + f7, 0.0f, 0.0f, 0.0f);
            this.line(0.0f, f7 * 1.5f, 0.0f, 0.0f);
            this.noLights();
            this.text("BICOPTER", -30.0f, -20.0f);
            this.camera();
            this.popMatrix();
            ((Slider)((Slider)this.motSlider[0].setPosition((float)this.xMot, (float)(this.yMot + 30))).setHeight(55).setCaptionLabel("")).show();
            ((Slider)((Slider)this.motSlider[1].setPosition((float)(this.xMot + 100), (float)(this.yMot + 30))).setHeight(55).setCaptionLabel("")).show();
            ((Slider)((Slider)this.servoSliderH[4].setPosition((float)this.xMot, (float)(this.yMot + 100))).setWidth(60).setCaptionLabel("")).show();
            ((Slider)((Slider)this.servoSliderH[5].setPosition((float)(this.xMot + 80), (float)(this.yMot + 100))).setWidth(60).setCaptionLabel("")).show();
        } else if (this.multiType == 5) {
            this.noLights();
            this.text("GIMBAL", -20.0f, -10.0f);
            this.camera();
            this.popMatrix();
            this.text("GIMBAL", this.xMot, this.yMot + 25);
            ((Slider)((Slider)this.servoSliderH[1].setPosition((float)this.xMot, (float)(this.yMot + 75))).setCaptionLabel("ROLL")).show();
            ((Slider)((Slider)this.servoSliderH[0].setPosition((float)this.xMot, (float)(this.yMot + 35))).setCaptionLabel("PITCH")).show();
        } else if (this.multiType == 6) {
            this.drawMotor(7.0f, 7.0f + f7, this.byteMP[0], 'L');
            this.drawMotor(7.0f + f7, 7.0f - f7, this.byteMP[1], 'R');
            this.drawMotor(7.0f - f7, 7.0f - f7, this.byteMP[2], 'R');
            this.translate(0.0f, 0.0f, -7.0f);
            this.drawMotor(-7.0f, -7.0f + f7, this.byteMP[3], 'R');
            this.drawMotor(-7.0f + f7, -7.0f - f7, this.byteMP[4], 'L');
            this.drawMotor(-7.0f - f7, -7.0f - f7, this.byteMP[5], 'L');
            this.line(-f7, -f7, 0.0f, 0.0f);
            this.line(f7, -f7, 0.0f, 0.0f);
            this.line(0.0f, f7, 0.0f, 0.0f);
            this.noLights();
            this.text("TRICOPTER Y6", -40.0f, -55.0f);
            this.camera();
            this.popMatrix();
            ((Slider)((Slider)this.motSlider[0].setPosition((float)(this.xMot + 50), (float)(this.yMot + 23))).setHeight(50).setCaptionLabel("REAR")).show();
            ((Slider)((Slider)this.motSlider[1].setPosition((float)(this.xMot + 100), (float)(this.yMot - 18))).setHeight(50).setCaptionLabel("RIGHT")).show();
            ((Slider)((Slider)this.motSlider[2].setPosition((float)this.xMot, (float)(this.yMot - 18))).setHeight(50).setCaptionLabel("LEFT")).show();
            ((Slider)((Slider)this.motSlider[3].setPosition((float)(this.xMot + 50), (float)(this.yMot + 87))).setHeight(50).setCaptionLabel("U_REAR")).show();
            ((Slider)((Slider)this.motSlider[4].setPosition((float)(this.xMot + 100), (float)(this.yMot + 48))).setHeight(50).setCaptionLabel("U_RIGHT")).show();
            ((Slider)((Slider)this.motSlider[5].setPosition((float)this.xMot, (float)(this.yMot + 48))).setHeight(50).setCaptionLabel("U_LEFT")).show();
        } else if (this.multiType == 7) {
            this.drawMotor(f7, 0.55f * f7, this.byteMP[0], 'L');
            this.drawMotor(f7, -0.55f * f7, this.byteMP[1], 'R');
            this.drawMotor(-f7, 0.55f * f7, this.byteMP[2], 'L');
            this.drawMotor(-f7, -0.55f * f7, this.byteMP[3], 'R');
            this.drawMotor(0.0f, -f7, this.byteMP[4], 'L');
            this.drawMotor(0.0f, f7, this.byteMP[5], 'R');
            this.line(-f7, -0.55f * f7, 0.0f, 0.0f);
            this.line(f7, -0.55f * f7, 0.0f, 0.0f);
            this.line(-f7, 0.55f * f7, 0.0f, 0.0f);
            this.line(f7, 0.55f * f7, 0.0f, 0.0f);
            this.line(0.0f, f7, 0.0f, 0.0f);
            this.line(0.0f, -f7, 0.0f, 0.0f);
            this.noLights();
            this.text("HEXACOPTER", -40.0f, -50.0f);
            this.camera();
            this.popMatrix();
            ((Slider)((Slider)this.motSlider[0].setPosition((float)(this.xMot + 90), (float)(this.yMot + 65))).setHeight(50).setCaptionLabel("REAR_R")).show();
            ((Slider)((Slider)this.motSlider[1].setPosition((float)(this.xMot + 90), (float)(this.yMot - 5))).setHeight(50).setCaptionLabel("FRONT_R")).show();
            ((Slider)((Slider)this.motSlider[2].setPosition((float)(this.xMot + 5), (float)(this.yMot + 65))).setHeight(50).setCaptionLabel("REAR_L")).show();
            ((Slider)((Slider)this.motSlider[3].setPosition((float)(this.xMot + 5), (float)(this.yMot - 5))).setHeight(50).setCaptionLabel("FRONT_L")).show();
            ((Slider)((Slider)this.motSlider[4].setPosition((float)(this.xMot + 50), (float)(this.yMot - 20))).setHeight(50).setCaptionLabel("FRONT")).show();
            ((Slider)((Slider)this.motSlider[5].setPosition((float)(this.xMot + 50), (float)(this.yMot + 90))).setHeight(50).setCaptionLabel("REAR")).show();
        } else if (this.multiType == 8) {
            this.line(0.0f, 0.0f, 1.8f * f7, f7);
            this.line(1.8f * f7, f7, 1.8f * f7, f7 - 30.0f);
            this.line(1.8f * f7, f7 - 30.0f, 0.0f, -1.5f * f7);
            this.line(0.0f, 0.0f, -1.8f * f7, f7);
            this.line(-1.8f * f7, f7, -1.8f * f7, f7 - 30.0f);
            this.line(-1.8f * f7, f7 - 30.0f, 0.0f, -1.5f * f7);
            this.noLights();
            this.text("FLYING WING", -40.0f, -50.0f);
            this.camera();
            this.popMatrix();
            ((Slider)((Slider)this.servoSliderV[0].setPosition((float)(this.xMot + 5), (float)(this.yMot + 10))).setCaptionLabel("LEFT")).show();
            ((Slider)((Slider)this.servoSliderV[1].setPosition((float)(this.xMot + 100), (float)(this.yMot + 10))).setCaptionLabel("RIGHT")).show();
            ((Slider)((Slider)this.motSlider[0].setPosition((float)(this.xMot + 50), (float)(this.yMot + 30))).setHeight(90).setCaptionLabel("Mot")).show();
        } else if (this.multiType == 9) {
            this.drawMotor(15.0f, f7, this.byteMP[0], 'R');
            this.drawMotor(f7, -f7, this.byteMP[1], 'L');
            this.drawMotor(-f7, -f7, this.byteMP[3], 'R');
            this.line(-f7, -f7, 0.0f, 0.0f);
            this.line(f7, -f7, 0.0f, 0.0f);
            this.line(0.0f, f7, 0.0f, 0.0f);
            this.translate(0.0f, 0.0f, -7.0f);
            this.drawMotor(-15.0f, f7, this.byteMP[2], 'L');
            this.noLights();
            this.text("Y4", -5.0f, -50.0f);
            this.camera();
            this.popMatrix();
            ((Slider)((Slider)this.motSlider[0].setPosition((float)(this.xMot + 80), (float)(this.yMot + 75))).setHeight(60).setCaptionLabel("REAR_1")).show();
            ((Slider)((Slider)this.motSlider[1].setPosition((float)(this.xMot + 90), (float)(this.yMot - 15))).setHeight(60).setCaptionLabel("FRONT_R")).show();
            ((Slider)((Slider)this.motSlider[2].setPosition((float)(this.xMot + 30), (float)(this.yMot + 75))).setHeight(60).setCaptionLabel("REAR_2")).show();
            ((Slider)((Slider)this.motSlider[3].setPosition((float)(this.xMot + 10), (float)(this.yMot - 15))).setHeight(60).setCaptionLabel("FRONT_L")).show();
        } else if (this.multiType == 18) {
            this.drawMotor(f7, 1.2f * f7, this.byteMP[0], 'R');
            this.drawMotor(f7, -1.2f * f7, this.byteMP[1], 'L');
            this.drawMotor(-f7, 1.2f * f7, this.byteMP[2], 'L');
            this.drawMotor(-f7, -1.2f * f7, this.byteMP[3], 'R');
            this.drawMotor(-f7, 0.0f, this.byteMP[4], 'L');
            this.drawMotor(f7, 0.0f, this.byteMP[5], 'R');
            this.line(f7, 1.2f * f7, f7, -1.2f * f7);
            this.line(-f7, 1.2f * f7, -f7, -1.2f * f7);
            this.line(f7, 0.0f, 0.0f, 0.0f);
            this.line(-f7, 0.0f, 0.0f, 0.0f);
            this.noLights();
            this.text("HEXACOPTER H", -45.0f, -60.0f);
            this.camera();
            this.popMatrix();
            ((Slider)((Slider)this.motSlider[0].setPosition((float)(this.xMot + 80), (float)(this.yMot + 90))).setHeight(45).setCaptionLabel("REAR_R")).show();
            ((Slider)((Slider)this.motSlider[1].setPosition((float)(this.xMot + 80), (float)(this.yMot - 20))).setHeight(45).setCaptionLabel("FRONT_R")).show();
            ((Slider)((Slider)this.motSlider[2].setPosition((float)(this.xMot + 25), (float)(this.yMot + 90))).setHeight(45).setCaptionLabel("REAR_L")).show();
            ((Slider)((Slider)this.motSlider[3].setPosition((float)(this.xMot + 25), (float)(this.yMot - 20))).setHeight(45).setCaptionLabel("FRONT_L")).show();
            ((Slider)((Slider)this.motSlider[4].setPosition((float)(this.xMot + 90), (float)(this.yMot + 35))).setHeight(45).setCaptionLabel("RIGHT")).show();
            ((Slider)((Slider)this.motSlider[5].setPosition((float)(this.xMot + 5), (float)(this.yMot + 35))).setHeight(45).setCaptionLabel("LEFT")).show();
        } else if (this.multiType == 10) {
            this.drawMotor(0.55f * f7, f7, this.byteMP[0], 'L');
            this.drawMotor(0.55f * f7, -f7, this.byteMP[1], 'L');
            this.drawMotor(-0.55f * f7, f7, this.byteMP[2], 'R');
            this.drawMotor(-0.55f * f7, -f7, this.byteMP[3], 'R');
            this.drawMotor(f7, 0.0f, this.byteMP[4], 'R');
            this.drawMotor(-f7, 0.0f, this.byteMP[5], 'L');
            this.line(-0.55f * f7, -f7, 0.0f, 0.0f);
            this.line(-0.55f * f7, f7, 0.0f, 0.0f);
            this.line(0.55f * f7, -f7, 0.0f, 0.0f);
            this.line(0.55f * f7, f7, 0.0f, 0.0f);
            this.line(f7, 0.0f, 0.0f, 0.0f);
            this.line(-f7, 0.0f, 0.0f, 0.0f);
            this.noLights();
            this.text("HEXACOPTER X", -45.0f, -50.0f);
            this.camera();
            this.popMatrix();
            ((Slider)((Slider)this.motSlider[0].setPosition((float)(this.xMot + 80), (float)(this.yMot + 90))).setHeight(45).setCaptionLabel("REAR_R")).show();
            ((Slider)((Slider)this.motSlider[1].setPosition((float)(this.xMot + 80), (float)(this.yMot - 20))).setHeight(45).setCaptionLabel("FRONT_R")).show();
            ((Slider)((Slider)this.motSlider[2].setPosition((float)(this.xMot + 25), (float)(this.yMot + 90))).setHeight(45).setCaptionLabel("REAR_L")).show();
            ((Slider)((Slider)this.motSlider[3].setPosition((float)(this.xMot + 25), (float)(this.yMot - 20))).setHeight(45).setCaptionLabel("FRONT_L")).show();
            ((Slider)((Slider)this.motSlider[4].setPosition((float)(this.xMot + 90), (float)(this.yMot + 35))).setHeight(45).setCaptionLabel("RIGHT")).show();
            ((Slider)((Slider)this.motSlider[5].setPosition((float)(this.xMot + 5), (float)(this.yMot + 35))).setHeight(45).setCaptionLabel("LEFT")).show();
        } else if (this.multiType >= 11 && this.multiType <= 13) {
            this.noLights();
            this.text("OCTOCOPTER", -45.0f, -50.0f);
            this.camera();
            this.popMatrix();
        } else if (this.multiType == 14) {
            f3 = f7 * 1.3f;
            f2 = f3 * 0.25f;
            this.line(0.0f, 0.0f, f3, 0.0f);
            this.line(f3, 0.0f, f3, f2);
            this.line(f3, f2, 0.0f, f2);
            this.line(0.0f, 0.0f, -f3, 0.0f);
            this.line(-f3, 0.0f, -f3, f2);
            this.line(-f3, f2, 0.0f, f2);
            this.line(-(f7 * 0.4f), f7, f7 * 0.4f, f7);
            this.line(-(f7 * 0.4f), f7 + 5.0f, f7 * 0.4f, f7 + 5.0f);
            this.line(-(f7 * 0.4f), f7, -(f7 * 0.4f), f7 + 5.0f);
            this.line(f7 * 0.4f, f7, f7 * 0.4f, f7 + 5.0f);
            this.line(-2.0f, f7, -2.0f, -f7 + 5.0f);
            this.line(2.0f, f7, 2.0f, -f7 + 5.0f);
            this.line(-2.0f, -f7 + 5.0f, 2.0f, -f7 + 5.0f);
            this.line(0.0f, f7 - 3.0f, 0.0f, 0.0f, f7, 15.0f);
            this.line(0.0f, f7, 15.0f, 0.0f, f7 + 5.0f, 15.0f);
            this.line(0.0f, f7 + 5.0f, 15.0f, 0.0f, f7 + 5.0f, 0.0f);
            this.noLights();
            this.textFont(this.font12);
            this.text("AIRPLANE", -40.0f, -50.0f);
            this.camera();
            this.popMatrix();
            ((Slider)((Slider)this.servoSliderH[3].setPosition((float)this.xMot, (float)(this.yMot - 5))).setCaptionLabel("Wing 1")).show();
            ((Slider)((Slider)this.servoSliderH[4].setPosition((float)this.xMot, (float)(this.yMot + 25))).setCaptionLabel("Wing 2")).show();
            ((Slider)((Slider)this.servoSliderH[5].setPosition((float)this.xMot, (float)(this.yMot + 55))).setCaptionLabel("Rudd")).show();
            ((Slider)((Slider)this.servoSliderH[6].setPosition((float)this.xMot, (float)(this.yMot + 85))).setCaptionLabel("Elev")).show();
            ((Slider)((Slider)this.servoSliderH[7].setPosition((float)this.xMot, (float)(this.yMot + 115))).setCaptionLabel("Thro")).show();
        } else if (this.multiType == 15) {
            f3 = f7 * 0.8f;
            this.ellipse(0.0f, 0.0f, 2.0f * f3, 2.0f * f3);
            this.line(0.0f, 1.5f * f3, -2.0f, -0.5f * f3);
            this.line(0.0f, 1.5f * f3, 2.0f, -0.5f * f3);
            this.line(-2.0f, -0.5f * f3, 2.0f, -0.5f * f3);
            f2 = f3 * 1.3f;
            n7 = 5;
            n6 = 10;
            this.line(0.0f, f2 - 3.0f, 0.0f, 0.0f, f2 + 7.0f, -n6);
            this.line(0.0f, f2 + 7.0f, -n6, 0.0f, f2 + 10.0f, -n6);
            this.line(0.0f, f2 + 10.0f, -n6, 0.0f, f2 + 5.0f, 0.0f);
            this.line(0.0f, f2 - 3.0f, 0.0f, 0.0f, f2, n7);
            this.line(0.0f, f2, n7, 0.0f, f2 + 5.0f, n7);
            this.line(0.0f, f2 + 5.0f, n7, 0.0f, f2 + 5.0f, 0.0f);
            this.line(-(f3 * 0.3f), f3, f3 * 0.3f, f3);
            this.line(-(f3 * 0.3f), f3 + 3.0f, f3 * 0.3f, f3 + 3.0f);
            this.line(-(f3 * 0.3f), f3, -(f3 * 0.3f), f3 + 3.0f);
            this.line(f3 * 0.3f, f3, f3 * 0.3f, f3 + 3.0f);
            this.noLights();
            this.textFont(this.font12);
            this.text("Heli 120 CCPM", -42.0f, -50.0f);
            this.camera();
            this.popMatrix();
            ((Slider)((Slider)this.servoSliderV[7].setPosition((float)this.xMot, (float)this.yMot)).setCaptionLabel("Thro")).show();
            ((Slider)((Slider)this.servoSliderV[4].setPosition((float)(this.xMot + 40), (float)(this.yMot - 15))).setCaptionLabel("LEFT")).show();
            ((Slider)((Slider)this.servoSliderV[3].setPosition((float)(this.xMot + 70), (float)(this.yMot + 10))).setCaptionLabel("Nick")).show();
            ((Slider)((Slider)this.servoSliderH[5].setPosition((float)(this.xMot + 15), (float)(this.yMot + 130))).setCaptionLabel("Yaw")).show();
            ((Slider)((Slider)this.servoSliderV[6].setPosition((float)(this.xMot + 100), (float)(this.yMot - 15))).setCaptionLabel("RIGHT")).show();
        } else if (this.multiType == 16) {
            f3 = f7 * 0.8f;
            this.ellipse(0.0f, 0.0f, 2.0f * f3, 2.0f * f3);
            this.line(0.0f, 1.5f * f3, -2.0f, -0.5f * f3);
            this.line(0.0f, 1.5f * f3, 2.0f, -0.5f * f3);
            this.line(-2.0f, -0.5f * f3, 2.0f, -0.5f * f3);
            f2 = f3 * 1.3f;
            n7 = 5;
            n6 = 10;
            this.line(0.0f, f2 - 3.0f, 0.0f, 0.0f, f2 + 7.0f, -n6);
            this.line(0.0f, f2 + 7.0f, -n6, 0.0f, f2 + 10.0f, -n6);
            this.line(0.0f, f2 + 10.0f, -n6, 0.0f, f2 + 5.0f, 0.0f);
            this.line(0.0f, f2 - 3.0f, 0.0f, 0.0f, f2, n7);
            this.line(0.0f, f2, n7, 0.0f, f2 + 5.0f, n7);
            this.line(0.0f, f2 + 5.0f, n7, 0.0f, f2 + 5.0f, 0.0f);
            this.line(-(f3 * 0.3f), f3, f3 * 0.3f, f3);
            this.line(-(f3 * 0.3f), f3 + 3.0f, f3 * 0.3f, f3 + 3.0f);
            this.line(-(f3 * 0.3f), f3, -(f3 * 0.3f), f3 + 3.0f);
            this.line(f3 * 0.3f, f3, f3 * 0.3f, f3 + 3.0f);
            this.noLights();
            this.textFont(this.font12);
            this.text("Heli 90", -16.0f, -50.0f);
            this.camera();
            this.popMatrix();
            ((Slider)((Slider)this.servoSliderV[7].setPosition((float)this.xMot, (float)(this.yMot - 15))).setCaptionLabel("Thro")).show();
            ((Slider)((Slider)this.servoSliderV[4].setPosition((float)(this.xMot + 120), (float)(this.yMot - 15))).setCaptionLabel("ROLL")).show();
            ((Slider)((Slider)this.servoSliderV[3].setPosition((float)(this.xMot + 80), (float)(this.yMot + 10))).setCaptionLabel("Nick")).show();
            ((Slider)((Slider)this.servoSliderH[5].setPosition((float)(this.xMot + 15), (float)(this.yMot + 130))).setCaptionLabel("Yaw")).show();
            ((Slider)((Slider)this.servoSliderV[6].setPosition((float)(this.xMot + 40), (float)this.yMot)).setCaptionLabel("COLL")).show();
        } else if (this.multiType == 17) {
            this.drawMotor(0.55f * f7, f7, this.byteMP[0], 'R');
            this.drawMotor(f7, -f7, this.byteMP[1], 'L');
            this.drawMotor(-0.55f * f7, f7, this.byteMP[2], 'L');
            this.drawMotor(-f7, -f7, this.byteMP[3], 'R');
            this.line(-0.55f * f7, f7, 0.0f, 0.0f);
            this.line(0.55f * f7, f7, 0.0f, 0.0f);
            this.line(-f7, -f7, 0.0f, 0.0f);
            this.line(f7, -f7, 0.0f, 0.0f);
            this.noLights();
            this.textFont(this.font12);
            this.text("Vtail", -10.0f, -50.0f);
            this.camera();
            this.popMatrix();
            ((Slider)((Slider)this.motSlider[0].setPosition((float)(this.xMot + 80), (float)(this.yMot + 70))).setHeight(60).setCaptionLabel("REAR_R")).show();
            ((Slider)((Slider)this.motSlider[1].setPosition((float)(this.xMot + 100), (float)(this.yMot - 15))).setHeight(60).setCaptionLabel("RIGHT")).show();
            ((Slider)((Slider)this.motSlider[2].setPosition((float)(this.xMot + 25), (float)(this.yMot + 70))).setHeight(60).setCaptionLabel("REAR_L")).show();
            this.drawMotor(f7, 0.55f * f7, this.byteMP[0], 'L');
            ((Slider)((Slider)this.motSlider[3].setPosition((float)(this.xMot + 2), (float)(this.yMot - 15))).setHeight(60).setCaptionLabel("LEFT")).show();
        } else {
            this.noLights();
            this.camera();
            this.popMatrix();
        }
        this.fill(255.0f, 255.0f, 127.0f);
        this.textFont(this.font12);
        this.text(String.valueOf((int)this.angy) + "\u00b0", this.xLevelObj + 38, this.yLevelObj + 78);
        this.text(String.valueOf((int)this.angx) + "\u00b0", this.xLevelObj - 62, this.yLevelObj + 78);
        this.pushMatrix();
        this.translate(this.xLevelObj - 34, this.yLevelObj + 112);
        this.fill(50.0f, 50.0f, 50.0f);
        this.noStroke();
        this.ellipse(0.0f, 0.0f, 66.0f, 66.0f);
        this.rotate(f4);
        this.fill(255.0f, 255.0f, 127.0f);
        this.textFont(this.font12);
        this.text("ROLL", -13.0f, 15.0f);
        this.strokeWeight(1.5f);
        this.stroke(127.0f, 127.0f, 127.0f);
        this.line(-30.0f, 1.0f, 30.0f, 1.0f);
        this.stroke(255.0f, 255.0f, 255.0f);
        this.line(-30.0f, 0.0f, 30.0f, 0.0f);
        this.line(0.0f, 0.0f, 0.0f, -10.0f);
        this.popMatrix();
        this.pushMatrix();
        this.translate(this.xLevelObj + 34, this.yLevelObj + 112);
        this.fill(50.0f, 50.0f, 50.0f);
        this.noStroke();
        this.ellipse(0.0f, 0.0f, 66.0f, 66.0f);
        this.rotate(f5);
        this.fill(255.0f, 255.0f, 127.0f);
        this.textFont(this.font12);
        this.text("PITCH", -18.0f, 15.0f);
        this.strokeWeight(1.5f);
        this.stroke(127.0f, 127.0f, 127.0f);
        this.line(-30.0f, 1.0f, 30.0f, 1.0f);
        this.stroke(255.0f, 255.0f, 255.0f);
        this.line(-30.0f, 0.0f, 30.0f, 0.0f);
        this.line(30.0f, 0.0f, 30.0f - f7 / 6.0f, f7 / 6.0f);
        this.line(30.0f, 0.0f, 30.0f - f7 / 6.0f, -f7 / 6.0f);
        this.popMatrix();
        this.horizonInstrSize = 68;
        this.angyLevelControl = this.angy < (float)(-this.horizonInstrSize) ? (float)(-this.horizonInstrSize) : (this.angy > (float)this.horizonInstrSize ? (float)this.horizonInstrSize : this.angy);
        this.pushMatrix();
        this.translate(this.xLevelObj, this.yLevelObj);
        this.noStroke();
        this.fill(50.0f, 50.0f, 50.0f);
        this.ellipse(0.0f, 0.0f, 150.0f, 150.0f);
        this.rotate(-f4);
        this.rectMode(0);
        this.strokeWeight(1.0f);
        this.stroke(90.0f, 90.0f, 90.0f);
        this.arc(0.0f, 0.0f, 140.0f, 140.0f, 0.0f, (float)Math.PI * 2);
        this.stroke(190.0f, 190.0f, 190.0f);
        this.arc(0.0f, 0.0f, 138.0f, 138.0f, 0.0f, (float)Math.PI * 2);
        this.strokeWeight(1.0f);
        this.stroke(255.0f, 255.0f, 255.0f);
        this.fill(124.0f, 73.0f, 31.0f);
        f3 = MultiWiiConf.acos((float)(this.angyLevelControl / (float)this.horizonInstrSize));
        this.arc(0.0f, 0.0f, 136.0f, 136.0f, 0.0f, (float)Math.PI * 2);
        this.fill(38.0f, 139.0f, 224.0f);
        this.arc(0.0f, 0.0f, 136.0f, 136.0f, 1.5707964f - f3 + (float)Math.PI, 1.5707964f + f3 + (float)Math.PI);
        f2 = MultiWiiConf.sin((float)f3) * (float)this.horizonInstrSize;
        if (this.angy > 0.0f) {
            this.fill(124.0f, 73.0f, 31.0f);
        }
        this.noStroke();
        this.triangle(0.0f, 0.0f, f2, -this.angyLevelControl, -f2, -this.angyLevelControl);
        this.strokeWeight(1.0f);
        n8 = 0;
        while (n8 < 8) {
            this.j = n8 * 15;
            if (this.angy <= (float)(35 - this.j) && this.angy >= (float)(-65 - this.j)) {
                this.stroke(255.0f, 255.0f, 255.0f);
                this.line(-30.0f, (float)(-15 - this.j) - this.angy, 30.0f, (float)(-15 - this.j) - this.angy);
                this.fill(255.0f, 255.0f, 255.0f);
                this.textFont(this.font9);
                this.text("+" + (n8 + 1) + "0", 34.0f, (float)(-12 - this.j) - this.angy);
                this.text("+" + (n8 + 1) + "0", -48.0f, (float)(-12 - this.j) - this.angy);
            }
            if (this.angy <= (float)(42 - this.j) && this.angy >= (float)(-58 - this.j)) {
                this.stroke(167.0f, 167.0f, 167.0f);
                this.line(-20.0f, (float)(-7 - this.j) - this.angy, 20.0f, (float)(-7 - this.j) - this.angy);
            }
            if (this.angy <= (float)(65 + this.j) && this.angy >= (float)(-35 + this.j)) {
                this.stroke(255.0f, 255.0f, 255.0f);
                this.line(-30.0f, (float)(15 + this.j) - this.angy, 30.0f, (float)(15 + this.j) - this.angy);
                this.fill(255.0f, 255.0f, 255.0f);
                this.textFont(this.font9);
                this.text("-" + (n8 + 1) + "0", 34.0f, (float)(17 + this.j) - this.angy);
                this.text("-" + (n8 + 1) + "0", -48.0f, (float)(17 + this.j) - this.angy);
            }
            if (this.angy <= (float)(58 + this.j) && this.angy >= (float)(-42 + this.j)) {
                this.stroke(127.0f, 127.0f, 127.0f);
                this.line(-20.0f, (float)(7 + this.j) - this.angy, 20.0f, (float)(7 + this.j) - this.angy);
            }
            ++n8;
        }
        this.strokeWeight(2.0f);
        this.stroke(255.0f, 255.0f, 255.0f);
        if (this.angy <= 50.0f && this.angy >= -50.0f) {
            this.line(-40.0f, -this.angy, 40.0f, -this.angy);
            this.fill(255.0f, 255.0f, 255.0f);
            this.textFont(this.font9);
            this.text("0", 34.0f, 4.0f - this.angy);
            this.text("0", -39.0f, 4.0f - this.angy);
        }
        this.strokeWeight(1.0f);
        this.stroke(60.0f, 60.0f, 60.0f);
        this.fill(180.0f, 180.0f, 180.0f, 255.0f);
        this.triangle(-this.horizonInstrSize, -8.0f, -this.horizonInstrSize, 8.0f, -55.0f, 0.0f);
        this.triangle(this.horizonInstrSize, -8.0f, this.horizonInstrSize, 8.0f, 55.0f, 0.0f);
        this.strokeWeight(1.0f);
        this.stroke(255.0f, 0.0f, 0.0f);
        this.line(-20.0f, 0.0f, -5.0f, 0.0f);
        this.line(-5.0f, 0.0f, -5.0f, 5.0f);
        this.line(5.0f, 0.0f, 20.0f, 0.0f);
        this.line(5.0f, 0.0f, 5.0f, 5.0f);
        this.line(0.0f, -5.0f, 0.0f, 5.0f);
        this.popMatrix();
        this.pushMatrix();
        this.translate(this.xCompass, this.yCompass);
        this.fill(0.0f, 0.0f, 0.0f);
        this.strokeWeight(3.0f);
        this.stroke(0);
        this.rectMode(1);
        f7 = 29.0f;
        this.rect(-f7 * 2.5f, -f7 * 2.5f, f7 * 2.5f, f7 * 2.5f);
        this.strokeWeight(1.5f);
        if (this.GPS_update == 1) {
            this.fill(125);
            this.stroke(125);
        } else {
            this.fill(160);
            this.stroke(160);
        }
        this.ellipse(0.0f, 0.0f, 4.0f * f7 + 7.0f, 4.0f * f7 + 7.0f);
        this.rotate((float)this.GPS_directionToHome * (float)Math.PI / 180.0f);
        this.strokeWeight(4.0f);
        this.stroke(255.0f, 255.0f, 100.0f);
        this.line(0.0f, 0.0f, 0.0f, -2.4f * f7);
        this.line(0.0f, -2.4f * f7, -5.0f, -2.4f * f7 + 10.0f);
        this.line(0.0f, -2.4f * f7, 5.0f, -2.4f * f7 + 10.0f);
        this.rotate((float)(-this.GPS_directionToHome) * (float)Math.PI / 180.0f);
        this.strokeWeight(1.5f);
        this.fill(0);
        this.stroke(0);
        this.ellipse(0.0f, 0.0f, 2.6f * f7 + 7.0f, 2.6f * f7 + 7.0f);
        this.stroke(255);
        this.rotate(this.head * (float)Math.PI / 180.0f);
        this.line(0.0f, f7 * 0.2f, 0.0f, -f7 * 1.3f);
        this.line(0.0f, -f7 * 1.3f, -5.0f, -f7 * 1.3f + 10.0f);
        this.line(0.0f, -f7 * 1.3f, 5.0f, -f7 * 1.3f + 10.0f);
        this.popMatrix();
        n8 = 0;
        while (n8 <= 12) {
            this.angCalc = (float)n8 * (float)Math.PI / 6.0f;
            if (n8 % 3 != 0) {
                this.stroke(75);
                this.line((float)this.xCompass + MultiWiiConf.cos((float)this.angCalc) * f7 * 2.0f, (float)this.yCompass + MultiWiiConf.sin((float)this.angCalc) * f7 * 2.0f, (float)this.xCompass + MultiWiiConf.cos((float)this.angCalc) * f7 * 1.6f, (float)this.yCompass + MultiWiiConf.sin((float)this.angCalc) * f7 * 1.6f);
            } else {
                this.stroke(255);
                this.line((float)this.xCompass + MultiWiiConf.cos((float)this.angCalc) * f7 * 2.2f, (float)this.yCompass + MultiWiiConf.sin((float)this.angCalc) * f7 * 2.2f, (float)this.xCompass + MultiWiiConf.cos((float)this.angCalc) * f7 * 1.9f, (float)this.yCompass + MultiWiiConf.sin((float)this.angCalc) * f7 * 1.9f);
            }
            ++n8;
        }
        this.textFont(this.font15);
        this.text("N", this.xCompass - 5, (float)(this.yCompass - 22) - f7 * 0.9f);
        this.text("S", this.xCompass - 5, (float)(this.yCompass + 32) + f7 * 0.9f);
        this.text("W", (float)(this.xCompass - 33) - f7 * 0.9f, this.yCompass + 6);
        this.text("E", (float)(this.xCompass + 21) + f7 * 0.9f, this.yCompass + 6);
        this.textFont(this.font12);
        this.noStroke();
        this.fill(80.0f, 80.0f, 80.0f, 130.0f);
        this.rect(this.xCompass - 22, this.yCompass - 8, this.xCompass + 22, this.yCompass + 9);
        this.fill(255.0f, 255.0f, 127.0f);
        this.text(String.valueOf(this.head) + "\u00b0", this.xCompass - 11 - (this.head >= 10.0f ? (this.head >= 100.0f ? 6 : 3) : 0), this.yCompass + 6);
        this.fill(255.0f, 255.0f, 0.0f);
        this.text(String.valueOf(this.GPS_directionToHome) + "\u00b0", (float)(this.xCompass - 6) - f7 * 2.1f, (float)(this.yCompass + 7) + f7 * 2.0f);
        if (this.GPS_fix == 0) {
            this.fill(127.0f, 0.0f, 0.0f);
        } else {
            this.fill(0.0f, 255.0f, 0.0f);
        }
        this.rect((float)(this.xCompass - 28) + f7 * 2.1f, (float)(this.yCompass + 1) + f7 * 2.0f, (float)(this.xCompass + 9) + f7 * 2.1f, (float)(this.yCompass + 13) + f7 * 2.0f);
        this.textFont(this.font9);
        if (this.GPS_fix == 0) {
            this.fill(255.0f, 255.0f, 0.0f);
        } else {
            this.fill(0.0f, 50.0f, 0.0f);
        }
        this.text("GPS_fix", (float)(this.xCompass - 27) + f7 * 2.1f, (float)(this.yCompass + 10) + f7 * 2.0f);
        this.strokeWeight(1.0f);
        this.fill(255.0f, 255.0f, 255.0f);
        this.g_graph.drawGraphBox();
        this.strokeWeight(1.5f);
        this.stroke(255.0f, 0.0f, 0.0f);
        if (this.axGraph) {
            this.g_graph.drawLine(this.accROLL, -1000.0f, 1000.0f);
        }
        this.stroke(0.0f, 255.0f, 0.0f);
        if (this.ayGraph) {
            this.g_graph.drawLine(this.accPITCH, -1000.0f, 1000.0f);
        }
        this.stroke(0.0f, 0.0f, 255.0f);
        if (this.azGraph) {
            if (this.scaleSlider.value() < 2.0f) {
                this.g_graph.drawLine(this.accYAW, -1000.0f, 1000.0f);
            } else {
                this.g_graph.drawLine(this.accYAW, 200.0f * this.scaleSlider.value() - 1000.0f, 200.0f * this.scaleSlider.value() + 500.0f);
            }
        }
        float f8 = this.altData.getMinVal() + this.altData.getRange() / 2.0f - 100.0f;
        float f9 = this.altData.getMaxVal() + this.altData.getRange() / 2.0f + 100.0f;
        this.stroke(200.0f, 200.0f, 0.0f);
        if (this.gxGraph) {
            this.g_graph.drawLine(this.gyroROLL, -300.0f, 300.0f);
        }
        this.stroke(0.0f, 255.0f, 255.0f);
        if (this.gyGraph) {
            this.g_graph.drawLine(this.gyroPITCH, -300.0f, 300.0f);
        }
        this.stroke(255.0f, 0.0f, 255.0f);
        if (this.gzGraph) {
            this.g_graph.drawLine(this.gyroYAW, -300.0f, 300.0f);
        }
        this.stroke(125.0f, 125.0f, 125.0f);
        if (this.altGraph) {
            this.g_graph.drawLine(this.altData, f8, f9);
        }
        this.stroke(225.0f, 225.0f, 125.0f);
        if (this.headGraph) {
            this.g_graph.drawLine(this.headData, -370.0f, 370.0f);
        }
        this.stroke(50.0f, 100.0f, 150.0f);
        if (this.magxGraph) {
            this.g_graph.drawLine(this.magxData, -500.0f, 500.0f);
        }
        this.stroke(100.0f, 50.0f, 150.0f);
        if (this.magyGraph) {
            this.g_graph.drawLine(this.magyData, -500.0f, 500.0f);
        }
        this.stroke(150.0f, 100.0f, 50.0f);
        if (this.magzGraph) {
            this.g_graph.drawLine(this.magzData, -500.0f, 500.0f);
        }
        this.stroke(200.0f, 50.0f, 0.0f);
        if (this.debug1Graph) {
            this.g_graph.drawLine(this.debug1Data, -5000.0f, 5000.0f);
        }
        this.stroke(0.0f, 200.0f, 50.0f);
        if (this.debug2Graph) {
            this.g_graph.drawLine(this.debug2Data, -5000.0f, 5000.0f);
        }
        this.stroke(50.0f, 0.0f, 200.0f);
        if (this.debug3Graph) {
            this.g_graph.drawLine(this.debug3Data, -5000.0f, 5000.0f);
        }
        this.stroke(0.0f, 0.0f, 0.0f);
        if (this.debug4Graph) {
            this.g_graph.drawLine(this.debug4Data, -5000.0f, 5000.0f);
        }
        this.fill(0.0f, 0.0f, 0.0f);
        this.strokeWeight(3.0f);
        this.stroke(0);
        this.rectMode(1);
        this.rect(this.xMot - 5, this.yMot - 20, this.xMot + 145, this.yMot + 150);
        this.rect(this.xRC - 5, this.yRC - 5, this.xRC + 145, this.yRC + 120);
        this.rect(this.xParam, this.yParam, this.xParam + 555, this.yParam + 280);
        int n12 = this.xParam + 80;
        int n13 = this.yParam + 220;
        this.stroke(255);
        f4 = MultiWiiConf.min((float)this.confRC_RATE.value(), (float)1.0f);
        f5 = this.confRC_EXPO.value();
        this.strokeWeight(1.0f);
        this.line(n12, n13, n12, n13 + 35);
        this.line(n12, n13 + 35, n12 + 70, n13 + 35);
        this.strokeWeight(3.0f);
        this.stroke(30.0f, 120.0f, 30.0f);
        int[] nArray = new int[6];
        n8 = 0;
        while (n8 < 6) {
            nArray[n8] = PApplet.parseInt((float)((2500.0f + f5 * 100.0f * (float)(n8 * n8 - 25)) * (float)n8 * f4 * 100.0f / 2500.0f));
            ++n8;
        }
        n8 = 0;
        while (n8 < 70) {
            n5 = 7 * n8;
            n4 = n5 / 100;
            int n14 = 2 * nArray[n4] + 2 * (n5 - n4 * 100) * (nArray[n4 + 1] - nArray[n4]) / 100;
            f = n14 * 70 / 1000;
            this.point(n12 + n8, (float)n13 + (70.0f - f) * 3.5f / 7.0f);
            ++n8;
        }
        if (this.confRC_RATE.value() > 1.0f) {
            this.stroke(220.0f, 100.0f, 100.0f);
            this.ellipse(n12 + 70, n13, 7.0f, 7.0f);
        }
        f4 = this.throttle_MID.value();
        f5 = this.throttle_EXPO.value();
        n5 = this.xParam + 80;
        n4 = this.yParam + 180;
        this.strokeWeight(1.0f);
        this.stroke(255);
        this.line(n5, n4, n5, n4 + 35);
        this.line(n5, n4 + 35, n5 + 70, n4 + 35);
        this.strokeWeight(3.0f);
        this.stroke(30.0f, 100.0f, 250.0f);
        int[] nArray2 = new int[11];
        n8 = 0;
        while (n8 < 11) {
            n3 = PApplet.parseInt((float)(100.0f * f4));
            n2 = PApplet.parseInt((float)(100.0f * f5));
            n = 10 * n8 - n3;
            int n15 = 1;
            if (n > 0) {
                n15 = 100 - n3;
            }
            if (n < 0) {
                n15 = n3;
            }
            nArray2[n8] = PApplet.parseInt((float)(10 * n3 + n * (100 - n2 + n * n * n2 / (n15 * n15)) / 10));
            ++n8;
        }
        n8 = 0;
        while (n8 < 70) {
            n3 = 14 * n8;
            n2 = n3 / 100;
            n = nArray2[n2] + (n3 - n2 * 100) * (nArray2[n2 + 1] - nArray2[n2]) / 100;
            f = n * 70 / 1000;
            this.point(n5 + n8, (float)n4 + (70.0f - f) * 3.5f / 7.0f);
            ++n8;
        }
        this.line((float)n5 + (MultiWiiConf.max((float)1100.0f, (float)this.rcThrottle) - 1100.0f) * 70.0f / 900.0f, n4 + 25, (float)n5 + (MultiWiiConf.max((float)1100.0f, (float)this.rcThrottle) - 1100.0f) * 70.0f / 900.0f, n4 + 35);
        this.fill(255);
        this.textFont(this.font15);
        this.text("P", this.xParam + 45, this.yParam + 15);
        this.text("I", this.xParam + 90, this.yParam + 15);
        this.text("D", this.xParam + 130, this.yParam + 15);
        this.textFont(this.font8);
        this.text("PITCH", n12 + 2, n13 + 10);
        this.text("ROLL", n12 + 2, n13 + 20);
        this.text("THROT", n5 + 2, n4 + 10);
        this.textFont(this.font12);
        this.text("RATE", this.xParam + 3, this.yParam + 232);
        this.text("EXPO", this.xParam + 3, this.yParam + 249);
        this.text("MID", this.xParam + 3, this.yParam + 193);
        this.text("EXPO", this.xParam + 3, this.yParam + 210);
        this.text("RATE", this.xParam + 160, this.yParam + 15);
        this.text("ROLL", this.xParam + 3, this.yParam + 32);
        this.text("PITCH", this.xParam + 3, this.yParam + 32 + 17);
        this.text("YAW", this.xParam + 3, this.yParam + 32 + 34);
        this.text("ALT", this.xParam + 3, this.yParam + 32 + 51);
        this.text("Pos", this.xParam + 3, this.yParam + 32 + 68);
        this.text("PosR", this.xParam + 3, this.yParam + 32 + 85);
        this.text("NavR", this.xParam + 3, this.yParam + 32 + 102);
        this.text("LEVEL", this.xParam + 1, this.yParam + 32 + 119);
        this.text("MAG", this.xParam + 3, this.yParam + 32 + 136);
        this.text("T P A", this.xParam + 215, this.yParam + 15);
        this.text("AUX1", this.xBox + 55, this.yBox + 5);
        this.text("AUX2", this.xBox + 105, this.yBox + 5);
        this.text("AUX3", this.xBox + 165, this.yBox + 5);
        this.text("AUX4", this.xBox + 218, this.yBox + 5);
        this.textFont(this.font8);
        this.text("LOW", this.xBox + 37, this.yBox + 15);
        this.text("MID", this.xBox + 57, this.yBox + 15);
        this.text("HIGH", this.xBox + 74, this.yBox + 15);
        this.text("L", this.xBox + 100, this.yBox + 15);
        this.text("M", this.xBox + 118, this.yBox + 15);
        this.text("H", this.xBox + 136, this.yBox + 15);
        this.text("L", this.xBox + 154, this.yBox + 15);
        this.text("M", this.xBox + 174, this.yBox + 15);
        this.text("H", this.xBox + 194, this.yBox + 15);
        this.text("L", this.xBox + 212, this.yBox + 15);
        this.text("M", this.xBox + 232, this.yBox + 15);
        this.text("H", this.xBox + 252, this.yBox + 15);
        this.pushMatrix();
        this.translate(0.0f, 0.0f, 0.0f);
        this.popMatrix();
        if (this.versionMisMatch == 1) {
            this.textFont(this.font15);
            this.fill(-16777216);
            this.text("GUI vs. Arduino: Version or Buffer size mismatch", 180.0f, 420.0f);
            return;
        }
    }

    public void drawMotor(float f, float f2, int n, char c) {
        float f3 = 30.0f;
        this.pushStyle();
        float f4 = 0.0f;
        if (c == 'L') {
            f4 = 5.0f;
            this.fill(254.0f, 221.0f, 44.0f);
        }
        if (c == 'R') {
            f4 = -5.0f;
            this.fill(256.0f, 152.0f, 12.0f);
        }
        this.ellipse(f, f2, f3, f3);
        this.textFont(this.font15);
        this.textAlign(3);
        this.fill(0.0f, 0.0f, 0.0f);
        this.text(n, f, f2 + 5.0f, 3.0f);
        float f5 = f2 - f3 / 2.0f;
        this.stroke(255.0f, 0.0f, 0.0f);
        this.line(f, f5, 3.0f, f + f4, f5 - 5.0f, 3.0f);
        this.line(f, f5, 3.0f, f + f4, f5 + 5.0f, 3.0f);
        this.line(f, f5, 3.0f, f + f4 * 2.0f, f5, 3.0f);
        this.popStyle();
    }

    public void ACC_ROLL(boolean bl) {
        this.axGraph = bl;
    }

    public void ACC_PITCH(boolean bl) {
        this.ayGraph = bl;
    }

    public void ACC_Z(boolean bl) {
        this.azGraph = bl;
    }

    public void GYRO_ROLL(boolean bl) {
        this.gxGraph = bl;
    }

    public void GYRO_PITCH(boolean bl) {
        this.gyGraph = bl;
    }

    public void GYRO_YAW(boolean bl) {
        this.gzGraph = bl;
    }

    public void BARO(boolean bl) {
        this.altGraph = bl;
    }

    public void HEAD(boolean bl) {
        this.headGraph = bl;
    }

    public void MAGX(boolean bl) {
        this.magxGraph = bl;
    }

    public void MAGY(boolean bl) {
        this.magyGraph = bl;
    }

    public void MAGZ(boolean bl) {
        this.magzGraph = bl;
    }

    public void DEBUG1(boolean bl) {
        this.debug1Graph = bl;
    }

    public void DEBUG2(boolean bl) {
        this.debug2Graph = bl;
    }

    public void DEBUG3(boolean bl) {
        this.debug3Graph = bl;
    }

    public void DEBUG4(boolean bl) {
        this.debug4Graph = bl;
    }

    public void controlEvent(ControlEvent controlEvent) {
        if (controlEvent.isGroup() && controlEvent.name() == "portComList") {
            this.InitSerial(controlEvent.group().value());
        }
    }

    public void bSTART() {
        if (!this.graphEnable) {
            return;
        }
        this.graph_on = 1;
        this.toggleRead = true;
        this.g_serial.clear();
    }

    public void bSTOP() {
        this.graph_on = 0;
    }

    public void SETTING() {
        this.toggleSetSetting = true;
    }

    public void READ() {
        this.toggleRead = true;
    }

    public void RESET() {
        this.toggleReset = true;
    }

    public void WRITE() {
        this.toggleWrite = true;
    }

    public void CALIB_ACC() {
        this.toggleCalibAcc = true;
    }

    public void CALIB_MAG() {
        this.toggleCalibMag = true;
    }

    public void InitSerial(float f) {
        if (f < (float)this.commListMax) {
            String string = Serial.list()[PApplet.parseInt((float)f)];
            this.txtlblWhichcom.setValue("COM = " + this.shortifyPortName(string, 8));
            this.g_serial = new Serial((PApplet)this, string, this.GUI_BaudRate);
            this.SaveSerialPort(string);
            this.init_com = 1;
            this.buttonSTART.setColorBackground(this.green_);
            this.buttonSTOP.setColorBackground(this.green_);
            this.buttonREAD.setColorBackground(this.green_);
            this.buttonRESET.setColorBackground(this.green_);
            this.commListbox.setColorBackground(this.green_);
            this.buttonCALIBRATE_ACC.setColorBackground(this.green_);
            this.buttonCALIBRATE_MAG.setColorBackground(this.green_);
            this.graphEnable = true;
            this.g_serial.buffer(256);
            this.btnQConnect.hide();
        } else {
            this.txtlblWhichcom.setValue("Comm Closed");
            this.init_com = 0;
            this.buttonSTART.setColorBackground(this.red_);
            this.buttonSTOP.setColorBackground(this.red_);
            this.commListbox.setColorBackground(this.red_);
            this.buttonSETTING.setColorBackground(this.red_);
            this.graphEnable = false;
            this.init_com = 0;
            this.g_serial.stop();
            this.btnQConnect.show();
        }
    }

    public void SaveSerialPort(String string) {
        this.output = this.createWriter(this.portnameFile);
        this.output.print(String.valueOf(string) + ';' + this.GUI_BaudRate);
        this.output.flush();
        this.output.close();
    }

    public void bQCONN() {
        this.ReadSerialPort();
        if (this.portOK) {
            this.InitSerial(this.SerialPort);
            this.bSTART();
        }
    }

    public void ReadSerialPort() {
        String string;
        this.reader = this.createReader(this.portnameFile);
        try {
            string = this.reader.readLine();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            string = null;
        }
        if (string == null) {
            this.btnQConnect.hide();
            return;
        }
        String[] stringArray = MultiWiiConf.split((String)string, (char)';');
        PApplet.parseInt((String)stringArray[0]);
        this.GUI_BaudRate = PApplet.parseInt((String)stringArray[1]);
        String cfr_ignored_0 = stringArray[0];
        int n = 0;
        while (n < this.commListMax) {
            String[] stringArray2 = MultiWiiConf.match((String)this.shortifyPortName(Serial.list()[n], 13), (String)stringArray[0]);
            if (stringArray2 != null) {
                this.SerialPort = n;
                this.portOK = true;
            }
            ++n;
        }
    }

    public void bSAVE() {
        this.updateModel();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFileChooser jFileChooser = new JFileChooser(){
                    private static final long serialVersionUID = 7919427933588163126L;

                    public void approveSelection() {
                        File file = this.getSelectedFile();
                        if (file.exists() && this.getDialogType() == 1) {
                            int n = JOptionPane.showConfirmDialog(this, "The file exists, overwrite?", "Existing file", 1);
                            switch (n) {
                                case 0: {
                                    super.approveSelection();
                                    return;
                                }
                                case 2: {
                                    this.cancelSelection();
                                    return;
                                }
                            }
                            return;
                        }
                        super.approveSelection();
                    }
                };
                jFileChooser.setDialogType(1);
                jFileChooser.setFileFilter(new MwiFileFilter());
                int n = jFileChooser.showSaveDialog(null);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    FileOutputStream fileOutputStream = null;
                    String string = null;
                    try {
                        try {
                            fileOutputStream = new FileOutputStream(file);
                            MWI.conf.storeToXML(fileOutputStream, new Date().toString());
                            JOptionPane.showMessageDialog(null, new StringBuffer().append("configuration saved : ").append(file.toURI()));
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            string = fileNotFoundException.getCause().toString();
                            if (fileOutputStream != null) {
                                try {
                                    fileOutputStream.close();
                                }
                                catch (IOException iOException) {
                                    string = iOException.getCause().toString();
                                }
                            }
                            if (string != null) {
                                JOptionPane.showMessageDialog(null, new StringBuffer().append("error : ").append(string));
                            }
                        }
                        catch (IOException iOException) {
                            block22: {
                                iOException.printStackTrace();
                                string = iOException.getCause().toString();
                                if (fileOutputStream == null) break block22;
                                try {
                                    fileOutputStream.close();
                                }
                                catch (IOException iOException2) {
                                    string = iOException2.getCause().toString();
                                }
                            }
                            if (string != null) {
                                JOptionPane.showMessageDialog(null, new StringBuffer().append("error : ").append(string));
                            }
                        }
                    }
                    finally {
                        if (fileOutputStream != null) {
                            try {
                                fileOutputStream.close();
                            }
                            catch (IOException iOException) {
                                string = iOException.getCause().toString();
                            }
                        }
                        if (string != null) {
                            JOptionPane.showMessageDialog(null, new StringBuffer().append("error : ").append(string));
                        }
                    }
                }
            }
        });
    }

    public void bIMPORT() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                block25: {
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setDialogType(1);
                    jFileChooser.setFileFilter(new MwiFileFilter());
                    int n = jFileChooser.showOpenDialog(null);
                    if (n == 0) {
                        String string;
                        block27: {
                            File file = jFileChooser.getSelectedFile();
                            FileInputStream fileInputStream = null;
                            boolean bl = false;
                            string = null;
                            try {
                                fileInputStream = new FileInputStream(file);
                                MWI.conf.loadFromXML(fileInputStream);
                                JOptionPane.showMessageDialog(null, new StringBuffer().append("configuration loaded : ").append(file.toURI()));
                                bl = true;
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                string = fileNotFoundException.getCause().toString();
                                if (!bl) {
                                    MultiWiiConf.this.updateModel();
                                }
                                MultiWiiConf.this.updateView();
                                if (fileInputStream != null) {
                                    try {
                                        fileInputStream.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                if (string != null) {
                                    JOptionPane.showMessageDialog(null, new StringBuffer().append("error : ").append(string));
                                }
                                break block25;
                            }
                            catch (IOException iOException) {
                                block26: {
                                    try {
                                        iOException.printStackTrace();
                                        string = iOException.getCause().toString();
                                        if (!bl) {
                                            MultiWiiConf.this.updateModel();
                                        }
                                        MultiWiiConf.this.updateView();
                                        if (fileInputStream == null) break block26;
                                    }
                                    catch (Throwable throwable) {
                                        if (!bl) {
                                            MultiWiiConf.this.updateModel();
                                        }
                                        MultiWiiConf.this.updateView();
                                        if (fileInputStream != null) {
                                            try {
                                                fileInputStream.close();
                                            }
                                            catch (IOException iOException2) {}
                                        }
                                        if (string != null) {
                                            JOptionPane.showMessageDialog(null, new StringBuffer().append("error : ").append(string));
                                        }
                                        throw throwable;
                                    }
                                    try {
                                        fileInputStream.close();
                                    }
                                    catch (IOException iOException3) {}
                                }
                                if (string != null) {
                                    JOptionPane.showMessageDialog(null, new StringBuffer().append("error : ").append(string));
                                }
                                break block25;
                            }
                            if (!bl) {
                                MultiWiiConf.this.updateModel();
                            }
                            MultiWiiConf.this.updateView();
                            if (fileInputStream == null) break block27;
                            try {
                                fileInputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (string != null) {
                            JOptionPane.showMessageDialog(null, new StringBuffer().append("error : ").append(string));
                        }
                    }
                }
            }
        });
    }

    public void updateModel() {
        this.updateModelMSP_SET_RC_TUNING();
        this.updateModelMSP_SET_PID();
        this.updateModelMSP_SET_MISC();
    }

    public void updateModelMSP_SET_RC_TUNING() {
        MWI.setProperty("rc.rate", String.valueOf(this.confRC_RATE.value()));
        MWI.setProperty("rc.expo", String.valueOf(this.confRC_EXPO.value()));
        MWI.setProperty("rc.rollpitch.rate", String.valueOf(this.rollPitchRate.value()));
        MWI.setProperty("rc.yaw.rate", String.valueOf(this.yawRate.value()));
        MWI.setProperty("rc.throttle.rate", String.valueOf(this.dynamic_THR_PID.value()));
        MWI.setProperty("rc.throttle.mid", String.valueOf(this.throttle_MID.value()));
        MWI.setProperty("rc.throttle.expo", String.valueOf(this.throttle_EXPO.value()));
    }

    public void updateModelMSP_SET_PID() {
        int n = 0;
        while (n < PIDITEMS) {
            MWI.setProperty("pid." + n + ".p", String.valueOf(this.confP[n].value()));
            MWI.setProperty("pid." + n + ".i", String.valueOf(this.confI[n].value()));
            MWI.setProperty("pid." + n + ".d", String.valueOf(this.confD[n].value()));
            ++n;
        }
    }

    public void updateModelMSP_SET_MISC() {
        MWI.setProperty("power.trigger", String.valueOf(MultiWiiConf.round((float)this.confPowerTrigger.value())));
    }

    public void updateView() {
        this.confRC_RATE.setValue(Float.valueOf(MWI.conf.getProperty("rc.rate")).floatValue());
        this.confRC_EXPO.setValue(Float.valueOf(MWI.conf.getProperty("rc.expo")).floatValue());
        this.rollPitchRate.setValue(Float.valueOf(MWI.conf.getProperty("rc.rollpitch.rate")).floatValue());
        this.yawRate.setValue(Float.valueOf(MWI.conf.getProperty("rc.yaw.rate")).floatValue());
        this.dynamic_THR_PID.setValue(Float.valueOf(MWI.conf.getProperty("rc.throttle.rate")).floatValue());
        this.throttle_MID.setValue(Float.valueOf(MWI.conf.getProperty("rc.throttle.mid")).floatValue());
        this.throttle_EXPO.setValue(Float.valueOf(MWI.conf.getProperty("rc.throttle.expo")).floatValue());
        int n = 0;
        while (n < PIDITEMS) {
            this.confP[n].setValue(Float.valueOf(MWI.conf.getProperty("pid." + n + ".p")).floatValue());
            this.confI[n].setValue(Float.valueOf(MWI.conf.getProperty("pid." + n + ".i")).floatValue());
            this.confD[n].setValue(Float.valueOf(MWI.conf.getProperty("pid." + n + ".d")).floatValue());
            ++n;
        }
        this.confPowerTrigger.setValue(Float.valueOf(MWI.conf.getProperty("power.trigger")).floatValue());
    }

    public void bRXbind() {
        this.toggleRXbind = true;
    }

    public void Tooltips() {
        this.controlP5.getTooltip().setDelay(300L);
        this.controlP5.getTooltip().register("bQCONN", "ComPort must be Selected First Time.");
        this.controlP5.getTooltip().register("SETTING", "Save Multiple settings.");
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#ECE9D8", "MultiWiiConf"});
    }

    static class MWI {
        private static Properties conf = new Properties();

        MWI() {
        }

        public static void setProperty(String string, String string2) {
            conf.setProperty(string, string2);
        }

        public static String getProperty(String string) {
            return conf.getProperty(string, "0");
        }

        public static void clear() {
            conf = null;
            conf = new Properties();
        }
    }

    public class MwiFileFilter
    extends FileFilter {
        public boolean accept(File file) {
            if (file != null) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = this.getExtension(file);
                if ("mwi".equals(string)) {
                    return true;
                }
            }
            return false;
        }

        public String getExtension(File file) {
            String string;
            int n;
            if (file != null && (n = (string = file.getName()).lastIndexOf(46)) > 0 && n < string.length() - 1) {
                return string.substring(n + 1).toLowerCase();
            }
            return null;
        }

        public String getDescription() {
            return "*.mwi Multiwii configuration file";
        }
    }

    class cDataArray {
        float[] m_data;
        int m_maxSize;
        int m_startIndex = 0;
        int m_endIndex = 0;
        int m_curSize;

        cDataArray(int n) {
            this.m_maxSize = n;
            this.m_data = new float[n];
        }

        public void addVal(float f) {
            this.m_data[this.m_endIndex] = f;
            this.m_endIndex = (this.m_endIndex + 1) % this.m_maxSize;
            if (this.m_curSize == this.m_maxSize) {
                this.m_startIndex = (this.m_startIndex + 1) % this.m_maxSize;
            } else {
                ++this.m_curSize;
            }
        }

        public float getVal(int n) {
            return this.m_data[(this.m_startIndex + n) % this.m_maxSize];
        }

        public int getCurSize() {
            return this.m_curSize;
        }

        public int getMaxSize() {
            return this.m_maxSize;
        }

        public float getMaxVal() {
            float f = 0.0f;
            int n = 0;
            while (n < this.m_curSize - 1) {
                if (this.m_data[n] > f || n == 0) {
                    f = this.m_data[n];
                }
                ++n;
            }
            return f;
        }

        public float getMinVal() {
            float f = 0.0f;
            int n = 0;
            while (n < this.m_curSize - 1) {
                if (this.m_data[n] < f || n == 0) {
                    f = this.m_data[n];
                }
                ++n;
            }
            return f;
        }

        public float getRange() {
            return this.getMaxVal() - this.getMinVal();
        }
    }

    class cGraph {
        float m_gWidth;
        float m_gHeight;
        float m_gLeft;
        float m_gBottom;
        float m_gRight;
        float m_gTop;

        cGraph(float f, float f2, float f3, float f4) {
            this.m_gWidth = f3;
            this.m_gHeight = f4;
            this.m_gLeft = f;
            this.m_gBottom = f2;
            this.m_gRight = f + f3;
            this.m_gTop = f2 + f4;
        }

        public void drawGraphBox() {
            MultiWiiConf.this.stroke(0.0f, 0.0f, 0.0f);
            MultiWiiConf.this.rectMode(1);
            MultiWiiConf.this.rect(this.m_gLeft, this.m_gBottom, this.m_gRight, this.m_gTop);
        }

        public void drawLine(cDataArray cDataArray2, float f, float f2) {
            float f3 = this.m_gWidth / (float)cDataArray2.getMaxSize();
            float f4 = this.m_gHeight / (f2 - f);
            int n = 0;
            while (n < cDataArray2.getCurSize() - 1) {
                float f5 = (float)n * f3 + this.m_gLeft;
                float f6 = this.m_gTop - ((cDataArray2.getVal(n) - (f2 + f) / 2.0f) * MultiWiiConf.this.scaleSlider.value() + (f2 - f) / 2.0f) * f4;
                float f7 = (float)(n + 1) * f3 + this.m_gLeft;
                float f8 = this.m_gTop - ((cDataArray2.getVal(n + 1) - (f2 + f) / 2.0f) * MultiWiiConf.this.scaleSlider.value() + (f2 - f) / 2.0f) * f4;
                MultiWiiConf.this.line(f5, f6, f7, f8);
                ++n;
            }
        }
    }
}

