/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.BitFontRenderer;
import controlP5.CDrawable;
import controlP5.ControlFont;
import controlP5.ControlP5;
import controlP5.ControllerInterface;
import controlP5.ControllerStyle;
import processing.core.PApplet;
import processing.core.PFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Label
implements CDrawable {
    protected int _myLetterSpacing = 0;
    protected boolean isMultiline;
    protected boolean isFixedSize;
    protected ControllerStyle _myControllerStyle = new ControllerStyle();
    protected boolean isVisible = true;
    protected int _myColor = -1;
    protected boolean isColorBackground;
    protected boolean isToUpperCase = true;
    protected boolean changed;
    protected int _myColorBackground = -1;
    protected int _myHeight = -1;
    protected int _myWidth = -1;
    protected String _myText = "";
    protected ControlFont _myFontLabel;
    protected int _myLineHeight = 0;
    protected int alignX = 37;
    protected int alignY = 37;
    public static int paddingX = 4;
    public static int paddingY = 4;
    public int _myPaddingX = paddingX;
    public int _myPaddingY = paddingY;
    protected Labeltype _myLabeltype;
    protected int _myTextHeight = 1;
    protected float offsetYratio = 0.0f;

    private Label(Label theLabel) {
        this._myText = theLabel.getText();
        this.isToUpperCase = theLabel.isToUpperCase();
        this._myLetterSpacing = theLabel.getLetterSpacing();
        this._myLineHeight = theLabel.getLineHeight();
        this._myFontLabel = theLabel.getFont();
        this._myLabeltype = theLabel.getLabeltype();
    }

    public Label(ControlP5 theControlP5, String theValue) {
        this.init(theControlP5, theValue, 0, 0, this._myColor);
    }

    public Label(ControlP5 theControlP5, String theValue, int theWidth, int theHeight, int theColor) {
        this.init(theControlP5, theValue, theWidth, theHeight, theColor);
    }

    private void init(ControlP5 theControlP5, String theValue, int theWidth, int theHeight, int theColor) {
        this._myWidth = theWidth;
        this._myHeight = theHeight;
        this._myText = theValue;
        this._myColor = theColor;
        this.setLabeltype(new SinglelineLabel());
        if (theControlP5.isControlFont && theControlP5.getFont() != null) {
            this.setFont(theControlP5.getFont());
        } else {
            this.setFont(ControlP5.bitFont);
            this.setLineHeight(BitFontRenderer.getHeight(ControlP5.bitFont));
            int[] dim = BitFontRenderer.getDimension(this, (ControlFont.BitFontLabel)this._myFontLabel.get(), this.getTextFormatted());
            this.setWidth(theWidth != 0 ? theWidth : dim[0]);
            this.setHeight(theHeight != 0 ? theHeight : dim[1]);
        }
        this.setLabeltype(new SinglelineLabel());
        this.set(this._myText);
        this._myControllerStyle = new ControllerStyle();
    }

    Label setLabeltype(Labeltype theType) {
        this._myLabeltype = theType;
        return this;
    }

    Labeltype getLabeltype() {
        return this._myLabeltype;
    }

    public Label align(int[] a) {
        this.alignX = a[0];
        this.alignY = a[1];
        return this;
    }

    public Label align(int theX, int theY) {
        this.alignX = theX;
        this.alignY = theY;
        return this;
    }

    public Label alignX(int theX) {
        this.alignX = theX;
        return this;
    }

    public Label alignY(int theY) {
        this.alignY = theY;
        return this;
    }

    public int[] getAlign() {
        return new int[]{this.alignX, this.alignY};
    }

    public Label setPadding(int thePaddingX, int thePaddingY) {
        this._myPaddingX = thePaddingX;
        this._myPaddingY = thePaddingY;
        return this;
    }

    public Label setPaddingX(int thePaddingX) {
        this._myPaddingX = thePaddingX;
        return this;
    }

    public Label setPaddingY(int thePaddingY) {
        this._myPaddingY = thePaddingY;
        return this;
    }

    public void draw(PApplet theApplet, int theX, int theY, ControllerInterface<?> theController) {
        if (this.isVisible) {
            this.getLabeltype().draw(this, theApplet, theX, theY, theController);
        }
    }

    @Override
    public void draw(PApplet theApplet) {
        if (this.isVisible) {
            this._myFontLabel.adjust(theApplet, this);
            this.draw(theApplet, 0, 0);
        }
    }

    public void draw(PApplet theApplet, int theX, int theY) {
        if (this.isVisible) {
            theApplet.pushMatrix();
            theApplet.translate((float)this._myControllerStyle.marginLeft, (float)this._myControllerStyle.marginTop);
            theApplet.translate((float)theX, (float)theY);
            if (this.isColorBackground) {
                float ww = this.getStyle().paddingRight + this.getStyle().paddingLeft;
                ww = this.getStyle().backgroundWidth > -1 ? (ww += (float)this._myControllerStyle.backgroundWidth) : (ww += (float)this._myFontLabel.getWidth());
                float hh = this.getStyle().paddingBottom + this.getStyle().paddingTop;
                hh = this.getStyle().backgroundHeight > -1 ? (hh += (float)this.getStyle().backgroundHeight) : (hh += (float)this._myFontLabel.getHeight());
                theApplet.fill(this._myColorBackground);
                theApplet.rect(0.0f, 0.0f, ww, hh);
            }
            theApplet.translate((float)this._myControllerStyle.paddingLeft, (float)this._myControllerStyle.paddingTop);
            this._myFontLabel.draw(theApplet, this);
            theApplet.popMatrix();
        }
    }

    public Label hide() {
        return this.setVisible(false);
    }

    public Label show() {
        return this.setVisible(true);
    }

    public Label setVisible(boolean theValue) {
        this.isVisible = theValue;
        return this;
    }

    public Label updateFont(ControlFont theFont) {
        return this.setFont(theFont);
    }

    public Label set(String theValue) {
        return this.setText(theValue);
    }

    public Label setText(String theValue) {
        this._myText = theValue;
        this.setChanged(true);
        return this;
    }

    public Label setFixedSize(boolean theValue) {
        this.isFixedSize = theValue;
        return this;
    }

    public boolean isFixedSize() {
        return this.isMultiline ? false : this.isFixedSize;
    }

    public String getText() {
        return this._myText;
    }

    public String getTextFormatted() {
        return this.getLabeltype().getTextFormatted();
    }

    public ControllerStyle getStyle() {
        return this._myControllerStyle;
    }

    public Label setWidth(int theWidth) {
        this._myWidth = theWidth;
        this.setChanged(true);
        return this;
    }

    public Label setHeight(int theHeight) {
        this._myHeight = theHeight;
        this.setChanged(true);
        return this;
    }

    public int getWidth() {
        return this._myLabeltype.getWidth();
    }

    public int getHeight() {
        return this._myLabeltype.getHeight();
    }

    public int getOverflow() {
        return this.getLabeltype().getOverflow();
    }

    public Label setMultiline(boolean theValue) {
        this.isMultiline = theValue;
        this._myLabeltype = this.isMultiline ? new MultilineLabel() : new SinglelineLabel();
        return this;
    }

    public Label toUpperCase(boolean theValue) {
        this.isToUpperCase = theValue;
        this.setChanged(true);
        return this;
    }

    public ControlFont getFont() {
        return this._myFontLabel;
    }

    public Label setFont(int theBitFontIndex) {
        this.setFont(new ControlFont(theBitFontIndex));
        return this;
    }

    public Label setFont(PFont thePFont) {
        return this.setFont(new ControlFont(thePFont));
    }

    public Label setFont(ControlFont theFont) {
        if (theFont.get() instanceof ControlFont.BitFontLabel) {
            this.setLineHeight(BitFontRenderer.getHeight((ControlFont.BitFontLabel)theFont.get()));
            this._myFontLabel = new ControlFont(((ControlFont.BitFontLabel)theFont.get()).getFontIndex());
        } else {
            this.setLineHeight(((ControlFont.PFontLabel)theFont.get()).getSize());
            ControlFont.PFontLabel cpf = (ControlFont.PFontLabel)theFont.get();
            this._myFontLabel = new ControlFont(cpf.getFont(), cpf.getSize());
        }
        this._myFontLabel.init(this);
        this.setChanged(true);
        return this;
    }

    public Label setSize(int theSize) {
        if (this._myFontLabel.get() instanceof ControlFont.PFontLabel) {
            ((ControlFont.PFontLabel)this._myFontLabel.get()).setSize(theSize);
        }
        return this;
    }

    protected boolean isChanged() {
        return this.changed;
    }

    protected Label setChanged(boolean theValue) {
        this.changed = theValue;
        return this;
    }

    Label setTextHeight(int theHeight) {
        this._myTextHeight = theHeight;
        return this;
    }

    public int getTextHeight() {
        return this._myFontLabel.get().getTextHeight();
    }

    public int getLineHeight() {
        return this._myLineHeight;
    }

    public Label setOffsetY(int theValue) {
        return this;
    }

    public Label setOffsetYratio(float theValue) {
        this.offsetYratio = theValue;
        this.setChanged(true);
        return this;
    }

    public float getOffsetYratio() {
        return this.offsetYratio;
    }

    public Label setLineHeight(int theValue) {
        this._myLineHeight = theValue;
        this.setChanged(true);
        return this;
    }

    public Label setColor(int theValue, boolean theFlag) {
        this.setColor(theValue);
        this.setFixedSize(theFlag);
        return this;
    }

    public Label setColor(int theColor) {
        this._myColor = theColor;
        this.setChanged(true);
        return this;
    }

    public int getColor() {
        return this._myColor;
    }

    public Label setColorBackground(int theColor) {
        this.enableColorBackground();
        this._myColorBackground = theColor;
        return this;
    }

    public Label disableColorBackground() {
        this.isColorBackground = false;
        return this;
    }

    public Label enableColorBackground() {
        this.isColorBackground = true;
        return this;
    }

    public int getLetterSpacing() {
        return this._myLetterSpacing;
    }

    public Label setLetterSpacing(int theValue) {
        this._myLetterSpacing = theValue;
        this.setChanged(true);
        return this;
    }

    public boolean isMultiline() {
        return this.isMultiline;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public boolean isToUpperCase() {
        return this.isToUpperCase;
    }

    protected Label copy() {
        return new Label(this);
    }

    @Deprecated
    public ControllerStyle style() {
        return this.getStyle();
    }

    @Deprecated
    public Label setControlFont(ControlFont theFont) {
        return this.setFont(theFont);
    }

    @Deprecated
    public Label setControlFontSize(int theSize) {
        System.out.println("Label.getControlFontSize has been deprecated");
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MultilineLabel
    implements Labeltype {
        MultilineLabel() {
        }

        @Override
        public void draw(Label theLabel, PApplet theApplet, int theX, int theY, ControllerInterface<?> theController) {
            Label.this._myFontLabel.adjust(theApplet, theLabel);
            theLabel.draw(theApplet, theX, theY);
        }

        @Override
        public int getWidth() {
            return Label.this._myWidth;
        }

        @Override
        public int getHeight() {
            return Label.this._myHeight;
        }

        @Override
        public int getOverflow() {
            return Label.this._myFontLabel.get().getOverflow();
        }

        @Override
        public String getTextFormatted() {
            return Label.this.isToUpperCase ? Label.this._myText.toUpperCase() : Label.this._myText;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SinglelineLabel
    implements Labeltype {
        SinglelineLabel() {
        }

        private void align(PApplet theApplet, ControllerInterface<?> theController, int theAlignX, int theAlignY) {
            int x = 0;
            int y = 0;
            switch (theAlignX) {
                case 3: {
                    x = (theController.getWidth() - Label.this._myFontLabel.getWidth()) / 2;
                    break;
                }
                case 37: {
                    x = Label.this._myPaddingX;
                    break;
                }
                case 39: {
                    x = theController.getWidth() - Label.this._myFontLabel.getWidth() - Label.this._myPaddingX;
                    break;
                }
                case 10: {
                    x = -Label.this._myFontLabel.getWidth() - Label.this._myPaddingX;
                    break;
                }
                case 11: {
                    x = theController.getWidth() + Label.this._myPaddingX;
                }
            }
            switch (theAlignY) {
                case 3: {
                    y = theController.getHeight() / 2 + Label.this._myFontLabel.get().getTop() - Label.this._myFontLabel.get().getCenter();
                    break;
                }
                case 101: {
                    y = 0;
                    break;
                }
                case 102: {
                    y = theController.getHeight() - Label.this._myFontLabel.get().getHeight() - 1;
                    break;
                }
                case 0: {
                    y = theController.getHeight() + Label.this._myFontLabel.get().getTop() - 1;
                    break;
                }
                case 13: {
                    y = theController.getHeight() + Label.this._myPaddingY;
                    break;
                }
                case 12: {
                    y = -Label.this._myFontLabel.getHeight() - Label.this._myPaddingY;
                }
            }
            theApplet.translate((float)x, (float)y);
        }

        @Override
        public void draw(Label theLabel, PApplet theApplet, int theX, int theY, ControllerInterface<?> theController) {
            Label.this._myFontLabel.adjust(theApplet, theLabel);
            theApplet.pushMatrix();
            this.align(theApplet, theController, Label.this.alignX, Label.this.alignY);
            theLabel.draw(theApplet, theX, theY);
            theApplet.popMatrix();
        }

        @Override
        public int getWidth() {
            return Label.this.isFixedSize ? Label.this._myWidth : Label.this._myFontLabel.getWidth();
        }

        @Override
        public int getHeight() {
            return Label.this._myFontLabel.getHeight();
        }

        @Override
        public int getOverflow() {
            return -1;
        }

        @Override
        public String getTextFormatted() {
            return Label.this.isToUpperCase ? Label.this._myText.toUpperCase() : Label.this._myText;
        }
    }

    class SinglelineTextfield
    extends SinglelineLabel {
        SinglelineTextfield() {
        }

        public String getTextFormatted() {
            return Label.this._myText;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Labeltype {
        public void draw(Label var1, PApplet var2, int var3, int var4, ControllerInterface<?> var5);

        public int getWidth();

        public int getHeight();

        public int getOverflow();

        public String getTextFormatted();
    }
}

