/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CallbackEvent;
import controlP5.CallbackListener;
import controlP5.ControlEvent;
import controlP5.ControlListener;
import controlP5.ControlP5;
import controlP5.ControlP5Constants;
import controlP5.Controller;
import controlP5.ControllerPlug;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlBroadcaster {
    private int _myControlEventType = -1;
    private ControllerPlug _myControlEventPlug = null;
    private ControllerPlug _myControllerCallbackEventPlug = null;
    private ControlP5 cp5;
    private String _myEventMethod = "controlEvent";
    private String _myControllerCallbackEventMethod = "controlEvent";
    private ArrayList<ControlListener> _myControlListeners;
    private Map<CallbackListener, Controller<?>> _myControllerCallbackListeners;
    private static boolean setPrintStackTrace = true;
    private static boolean ignoreErrorMessage = false;

    protected ControlBroadcaster(ControlP5 theControlP5) {
        this.cp5 = theControlP5;
        this._myControlListeners = new ArrayList();
        this._myControllerCallbackListeners = new ConcurrentHashMap();
        this._myControlEventPlug = ControlBroadcaster.checkObject(this.cp5.papplet, this.getEventMethod(), new Class[]{ControlEvent.class});
        this._myControllerCallbackEventPlug = ControlBroadcaster.checkObject(this.cp5.papplet, this._myControllerCallbackEventMethod, new Class[]{CallbackEvent.class});
        if (this._myControlEventPlug != null) {
            this._myControlEventType = 0;
        }
    }

    public ControlBroadcaster addListener(ControlListener ... theListeners) {
        for (ControlListener l : theListeners) {
            this._myControlListeners.add(l);
        }
        return this;
    }

    public ControlBroadcaster removeListener(ControlListener ... theListeners) {
        for (ControlListener l : theListeners) {
            this._myControlListeners.remove(l);
        }
        return this;
    }

    public ControlListener getListener(int theIndex) {
        if (theIndex < 0 || theIndex >= this._myControlListeners.size()) {
            return null;
        }
        return this._myControlListeners.get(theIndex);
    }

    public int listenerSize() {
        return this._myControlListeners.size();
    }

    public ControlBroadcaster addCallback(CallbackListener ... theListeners) {
        for (CallbackListener l : theListeners) {
            this._myControllerCallbackListeners.put(l, new EmptyController());
        }
        return this;
    }

    public ControlBroadcaster addCallback(CallbackListener theListener) {
        this._myControllerCallbackListeners.put(theListener, new EmptyController());
        return this;
    }

    public void addCallback(CallbackListener theListener, Controller<?> ... theController) {
        for (Controller<?> c : theController) {
            this._myControllerCallbackListeners.put(theListener, c);
        }
    }

    public ControlBroadcaster removeCallback(CallbackListener ... theListeners) {
        for (CallbackListener c : theListeners) {
            this._myControllerCallbackListeners.remove(c);
        }
        return this;
    }

    public ControlBroadcaster removeCallback(CallbackListener theListener) {
        this._myControllerCallbackListeners.remove(theListener);
        return this;
    }

    public ControlBroadcaster removeCallback(Controller<?> ... theControllers) {
        for (Controller<?> c : theControllers) {
            for (Map.Entry<CallbackListener, Controller<?>> entry : this._myControllerCallbackListeners.entrySet()) {
                if (c == null || !entry.getValue().equals(c)) continue;
                this._myControllerCallbackListeners.remove(entry.getKey());
            }
        }
        return this;
    }

    public ControlBroadcaster plug(Object theObject, String theControllerName, String theTargetMethod) {
        this.plug(theObject, this.cp5.getController(theControllerName), theTargetMethod);
        return this;
    }

    public ControlBroadcaster plug(Object theObject, Controller<?> theController, String theTargetMethod) {
        if (theController != null) {
            ControllerPlug myControllerPlug = ControlBroadcaster.checkObject(theObject, theTargetMethod, ControlP5Constants.acceptClassList);
            if (myControllerPlug == null) {
                return this;
            }
            if (!theController.checkControllerPlug(myControllerPlug)) {
                theController.addControllerPlug(myControllerPlug);
            }
            return this;
        }
        return this;
    }

    protected static ControllerPlug checkObject(Object theObject, String theTargetName, Class<?>[] theAcceptClassList) {
        Class<?> myClass = theObject.getClass();
        Method[] myMethods = myClass.getDeclaredMethods();
        for (int i = 0; i < myMethods.length; ++i) {
            if (!myMethods[i].getName().equals(theTargetName)) continue;
            if (myMethods[i].getParameterTypes().length == 1) {
                if (theAcceptClassList.length == 1 && theAcceptClassList[0] == CallbackEvent.class) {
                    ControllerPlug cp = new ControllerPlug(CallbackEvent.class, theObject, theTargetName, 2, -1);
                    if (cp.getMethod() == null) {
                        return null;
                    }
                    return cp;
                }
                if (myMethods[i].getParameterTypes()[0] == ControlP5Constants.controlEventClass) {
                    return new ControllerPlug(ControlEvent.class, theObject, theTargetName, 2, -1);
                }
                for (int j = 0; j < theAcceptClassList.length; ++j) {
                    if (myMethods[i].getParameterTypes()[0] != theAcceptClassList[j]) continue;
                    return new ControllerPlug(theObject, theTargetName, 0, j, theAcceptClassList);
                }
                break;
            }
            if (myMethods[i].getParameterTypes().length != 0) break;
            return new ControllerPlug(theObject, theTargetName, 0, -1, theAcceptClassList);
        }
        Field[] myFields = myClass.getDeclaredFields();
        for (int i = 0; i < myFields.length; ++i) {
            if (!myFields[i].getName().equals(theTargetName)) continue;
            for (int j = 0; j < theAcceptClassList.length; ++j) {
                if (myFields[i].getType() != theAcceptClassList[j]) continue;
                return new ControllerPlug(theObject, theTargetName, 1, j, theAcceptClassList);
            }
            break;
        }
        return null;
    }

    public ControlBroadcaster broadcast(ControlEvent theControlEvent, int theType) {
        for (ControlListener cl : this._myControlListeners) {
            cl.controlEvent(theControlEvent);
        }
        if (!theControlEvent.isTab() && !theControlEvent.isGroup() && theControlEvent.getController().getControllerPlugList().size() > 0) {
            if (theType == 4) {
                for (ControllerPlug cp : theControlEvent.getController().getControllerPlugList()) {
                    this.callTarget(cp, theControlEvent.getStringValue());
                }
            } else if (theType != 5) {
                for (ControllerPlug cp : theControlEvent.getController().getControllerPlugList()) {
                    if (cp.checkType(2)) {
                        this.invokeMethod(cp.getObject(), cp.getMethod(), new Object[]{theControlEvent});
                        continue;
                    }
                    this.callTarget(cp, theControlEvent.getValue());
                }
            }
        }
        if (this._myControlEventType == 0) {
            this.invokeMethod(this._myControlEventPlug.getObject(), this._myControlEventPlug.getMethod(), new Object[]{theControlEvent});
        }
        return this;
    }

    protected void callTarget(ControllerPlug thePlug, float theValue) {
        if (thePlug.checkType(0)) {
            this.invokeMethod(thePlug.getObject(), thePlug.getMethod(), thePlug.getMethodParameter(theValue));
        } else if (thePlug.checkType(1)) {
            this.invokeField(thePlug.getObject(), thePlug.getField(), thePlug.getFieldParameter(theValue));
        }
    }

    protected void callTarget(ControllerPlug thePlug, String theValue) {
        if (thePlug.checkType(0)) {
            this.invokeMethod(thePlug.getObject(), thePlug.getMethod(), new Object[]{theValue});
        } else if (thePlug.checkType(1)) {
            this.invokeField(thePlug.getObject(), thePlug.getField(), theValue);
        }
    }

    private void invokeField(Object theObject, Field theField, Object theParam) {
        try {
            theField.set(theObject, theParam);
        }
        catch (IllegalAccessException e) {
            ControlP5.logger().warning(e.toString());
        }
    }

    private void invokeMethod(Object theObject, Method theMethod, Object[] theParam) {
        try {
            if (theParam[0] == null) {
                theMethod.invoke(theObject, new Object[0]);
            } else {
                theMethod.invoke(theObject, theParam);
            }
        }
        catch (IllegalArgumentException e) {
            ControlP5.logger().warning(e.toString());
        }
        catch (IllegalAccessException e) {
            this.printMethodError(theMethod, e);
        }
        catch (InvocationTargetException e) {
            this.printMethodError(theMethod, e);
        }
        catch (NullPointerException e) {
            this.printMethodError(theMethod, e);
        }
    }

    protected String getEventMethod() {
        return this._myEventMethod;
    }

    protected void invokeAction(CallbackEvent theEvent) {
        for (Map.Entry<CallbackListener, Controller<?>> entry : this._myControllerCallbackListeners.entrySet()) {
            boolean invoke = entry.getValue().getClass().equals(EmptyController.class) ? true : entry.getValue().equals(theEvent.getController());
            if (!invoke) continue;
            entry.getKey().controlEvent(theEvent);
        }
        if (this._myControllerCallbackEventPlug != null) {
            this.invokeMethod(this.cp5.papplet, this._myControllerCallbackEventPlug.getMethod(), new Object[]{theEvent});
        }
    }

    private void printMethodError(Method theMethod, Exception theException) {
        if (!ignoreErrorMessage) {
            ControlP5.logger().severe("An error occured while forwarding a Controller event, please check your code at " + theMethod.getName() + (!setPrintStackTrace ? " exception:  " + theException : ""));
            if (setPrintStackTrace) {
                theException.printStackTrace();
            }
        }
    }

    public static void ignoreErrorMessage(boolean theFlag) {
        ignoreErrorMessage = theFlag;
    }

    public static void setPrintStackTrace(boolean theFlag) {
        setPrintStackTrace = theFlag;
    }

    @Deprecated
    public void plug(String theControllerName, String theTargetMethod) {
        this.plug((Object)this.cp5.papplet, theControllerName, theTargetMethod);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EmptyController
    extends Controller<EmptyController> {
        protected EmptyController() {
            this(0, 0);
        }

        protected EmptyController(int theX, int theY) {
            super("empty" + (int)(Math.random() * 1000000.0), theX, theY);
        }

        @Override
        public EmptyController setValue(float theValue) {
            return this;
        }
    }
}

