/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.ControllerView;
import controlP5.Label;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ControlP5.Layout
public class Bang
extends Controller<Bang> {
    protected int cnt;
    protected int triggerId = 2;

    public Bang(ControlP5 theControlP5, String theName) {
        this(theControlP5, theControlP5.getDefaultTab(), theName, 0.0f, 0.0f, 20, 20);
        theControlP5.register(theControlP5.papplet, theName, this);
    }

    protected Bang(ControlP5 theControlP5, ControllerGroup<?> theParent, String theName, float theX, float theY, int theWidth, int theHeight) {
        super(theControlP5, theParent, theName, theX, theY, theWidth, theHeight);
        this._myCaptionLabel.setPadding(0, Label.paddingY).align(37, 13);
        this._myValue = 1.0f;
    }

    @Override
    protected void onEnter() {
        this.cnt = 0;
        this.isActive = true;
    }

    @Override
    protected void onLeave() {
        this.isActive = false;
    }

    @Override
    protected void mousePressed() {
        if (this.triggerId == 2) {
            this.cnt = -3;
            this.isActive = true;
            this.update();
        }
    }

    @Override
    protected void mouseReleased() {
        if (this.triggerId == 1) {
            this.cnt = -3;
            this.isActive = true;
            this.update();
        }
    }

    @Override
    protected void mouseReleasedOutside() {
        this.onLeave();
    }

    @ControlP5.Layout
    public Bang setTriggerEvent(int theEventID) {
        this.triggerId = theEventID;
        return this;
    }

    @ControlP5.Layout
    public int getTriggerEvent() {
        return this.triggerId;
    }

    @Override
    public Bang setValue(float theValue) {
        this._myValue = theValue;
        this.broadcast(2);
        return this;
    }

    @Override
    public Bang update() {
        return this.setValue(this._myValue);
    }

    @Override
    @ControlP5.Invisible
    public Bang updateDisplayMode(int theMode) {
        this.updateViewMode(theMode);
        return this;
    }

    @ControlP5.Invisible
    public Bang updateViewMode(int theMode) {
        this._myDisplayMode = theMode;
        switch (theMode) {
            case 0: {
                this._myControllerView = new BangView();
                break;
            }
            case 2: {
                this._myControllerView = new BangSpriteView();
                break;
            }
            case 1: {
                this._myControllerView = new BangImageView();
                break;
            }
        }
        return this;
    }

    @Override
    public String getInfo() {
        return "type:\tBang\n" + super.getInfo();
    }

    @Override
    public String toString() {
        return super.toString() + " [ " + this.getValue() + " ] " + "Bang" + " (" + this.getClass().getSuperclass() + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    private class BangSpriteView
    implements ControllerView<Bang> {
        private BangSpriteView() {
        }

        @Override
        public void display(PApplet theApplet, Bang theController) {
            if (Bang.this.isActive) {
                Bang.this.sprite.setState(1);
            } else {
                Bang.this.sprite.setState(0);
            }
            if (Bang.this.cnt < 0) {
                Bang.this.sprite.setState(0);
                ++Bang.this.cnt;
            }
            theApplet.fill(0);
            Bang.this.sprite.draw(theApplet);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BangImageView
    implements ControllerView<Bang> {
        private BangImageView() {
        }

        @Override
        public void display(PApplet theApplet, Bang theController) {
            if (Bang.this.isActive) {
                theApplet.image(Bang.this.availableImages[2] ? Bang.this.images[2] : Bang.this.images[0], 0.0f, 0.0f);
            } else {
                theApplet.image(Bang.this.availableImages[1] ? Bang.this.images[1] : Bang.this.images[0], 0.0f, 0.0f);
            }
            if (Bang.this.cnt < 0) {
                theApplet.image(Bang.this.availableImages[1] ? Bang.this.images[1] : Bang.this.images[0], 0.0f, 0.0f);
                ++Bang.this.cnt;
            }
            if (!Bang.this.isActive && Bang.this.cnt >= 0) {
                theApplet.image(Bang.this.images[0], 0.0f, 0.0f);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BangView
    implements ControllerView<Bang> {
        private BangView() {
        }

        @Override
        public void display(PApplet theApplet, Bang theController) {
            if (Bang.this.isActive) {
                theApplet.fill(Bang.this.color.getActive());
            } else {
                theApplet.fill(Bang.this.color.getForeground());
            }
            if (Bang.this.cnt < 0) {
                theApplet.fill(Bang.this.color.getForeground());
                ++Bang.this.cnt;
            }
            theApplet.rect(0.0f, 0.0f, (float)Bang.this.width, (float)Bang.this.height);
            if (Bang.this.isLabelVisible) {
                Bang.this._myCaptionLabel.draw(theApplet, 0, 0, theController);
            }
        }
    }
}

