/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlEvent;
import controlP5.ControlGroup;
import controlP5.ControlP5;
import controlP5.ControllerGroup;
import controlP5.ControllerPlug;
import controlP5.Label;
import controlP5.Toggle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import processing.core.PImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadioButton
extends ControlGroup<RadioButton> {
    protected List<Toggle> _myRadioToggles;
    protected int spacingRow = 1;
    protected int spacingColumn = 1;
    protected int itemsPerRow = -1;
    protected boolean isMultipleChoice;
    protected int itemHeight = 9;
    protected int itemWidth = 9;
    protected boolean[] availableImages = new boolean[3];
    protected PImage[] images = new PImage[3];
    protected boolean noneSelectedAllowed = true;
    private Object _myPlug;
    private String _myPlugName;

    public RadioButton(ControlP5 theControlP5, String theName) {
        this(theControlP5, (ControllerGroup<?>)theControlP5.getDefaultTab(), theName, 0, 0);
        theControlP5.register(theControlP5.papplet, theName, this);
    }

    public RadioButton(ControlP5 theControlP5, ControllerGroup<?> theParent, String theName, int theX, int theY) {
        super(theControlP5, theParent, theName, theX, theY, 99, 9);
        this.isBarVisible = false;
        this.isCollapse = false;
        this._myRadioToggles = new ArrayList<Toggle>();
        this.setItemsPerRow(1);
        this._myPlug = this.cp5.papplet;
        this._myPlugName = this.getName();
        if (!ControllerPlug.checkPlug(this._myPlug, this._myPlugName, new Class[]{Integer.TYPE})) {
            this._myPlug = null;
        }
    }

    public RadioButton addItem(String theName, float theValue) {
        Toggle t = this.cp5.addToggle(theName, 0.0f, 0.0f, this.itemWidth, this.itemHeight);
        t.getCaptionLabel().align(11, 3).setPadding(Label.paddingX, 0);
        t.setMode(0);
        t.setImages(this.images[0], this.images[1], this.images[2]);
        t.setSize(this.images[0]);
        this.addItem(t, theValue);
        return this;
    }

    public RadioButton addItem(Toggle theToggle, float theValue) {
        theToggle.setGroup(this);
        theToggle.isMoveable = false;
        theToggle.setInternalValue(theValue);
        theToggle.isBroadcast = false;
        this._myRadioToggles.add(theToggle);
        this.updateLayout();
        this.getColor().copyTo(theToggle);
        theToggle.addListener(this);
        this.updateValues(false);
        this.cp5.removeProperty(theToggle);
        return this;
    }

    public RadioButton removeItem(String theName) {
        int n = this._myRadioToggles.size();
        for (int i = 0; i < n; ++i) {
            if (!this._myRadioToggles.get(i).getName().equals(theName)) continue;
            this._myRadioToggles.get(i).removeListener(this);
            this._myRadioToggles.remove(i);
        }
        this.updateValues(false);
        return this;
    }

    public RadioButton setImages(PImage theDefaultImage, PImage theOverImage, PImage theActiveImage) {
        this.setImage(theDefaultImage, 0);
        this.setImage(theOverImage, 1);
        this.setImage(theActiveImage, 2);
        return this;
    }

    public RadioButton setImage(PImage theImage) {
        return this.setImage(theImage, 0);
    }

    public RadioButton setImage(PImage theImage, int theState) {
        if (theImage != null) {
            this.images[theState] = theImage;
            this.availableImages[theState] = true;
            for (int i = 0; i < this._myRadioToggles.size(); ++i) {
                this._myRadioToggles.get(i).setImage(theImage, theState);
            }
        }
        return this;
    }

    public RadioButton setSize(PImage theImage) {
        return this.setSize(theImage.width, theImage.height);
    }

    public RadioButton setSize(int theWidth, int theHeight) {
        this.setItemWidth(theWidth);
        this.setItemHeight(theHeight);
        return this;
    }

    public RadioButton setItemHeight(int theItemHeight) {
        this.itemHeight = theItemHeight;
        for (Toggle t : this._myRadioToggles) {
            t.setHeight(theItemHeight);
        }
        this.updateLayout();
        return this;
    }

    public RadioButton setItemWidth(int theItemWidth) {
        this.itemWidth = theItemWidth;
        for (Toggle t : this._myRadioToggles) {
            t.setWidth(theItemWidth);
        }
        this.updateLayout();
        return this;
    }

    public Toggle getItem(int theIndex) {
        return this._myRadioToggles.get(theIndex);
    }

    public Toggle getItem(String theName) {
        for (Toggle t : this._myRadioToggles) {
            if (!theName.equals(t.getName())) continue;
            return t;
        }
        return null;
    }

    public List<Toggle> getItems() {
        return this._myRadioToggles;
    }

    public boolean getState(int theIndex) {
        if (theIndex < this._myRadioToggles.size() && theIndex >= 0) {
            return this._myRadioToggles.get(theIndex).getState();
        }
        return false;
    }

    public boolean getState(String theName) {
        int n = this._myRadioToggles.size();
        for (int i = 0; i < n; ++i) {
            Toggle t = this._myRadioToggles.get(i);
            if (!theName.equals(t.getName())) continue;
            return t.getState();
        }
        return false;
    }

    public void updateLayout() {
        int nn = 0;
        int xx = 0;
        int yy = 0;
        int n = this._myRadioToggles.size();
        for (int i = 0; i < n; ++i) {
            Toggle t = this._myRadioToggles.get(i);
            t.position.y = yy;
            t.position.x = xx;
            xx += t.width + this.spacingColumn;
            if (++nn == this.itemsPerRow) {
                nn = 0;
                this._myWidth = xx;
                yy += t.height + this.spacingRow;
                xx = 0;
                continue;
            }
            this._myWidth = xx;
        }
    }

    public RadioButton setItemsPerRow(int theValue) {
        this.itemsPerRow = theValue;
        this.updateLayout();
        return this;
    }

    public RadioButton setSpacingColumn(int theSpacing) {
        this.spacingColumn = theSpacing;
        this.updateLayout();
        return this;
    }

    public RadioButton setSpacingRow(int theSpacing) {
        this.spacingRow = theSpacing;
        this.updateLayout();
        return this;
    }

    public RadioButton deactivateAll() {
        if (!this.isMultipleChoice && !this.noneSelectedAllowed) {
            return this;
        }
        int n = this._myRadioToggles.size();
        for (int i = 0; i < n; ++i) {
            this._myRadioToggles.get(i).deactivate();
        }
        this._myValue = -1.0f;
        this.updateValues(true);
        return this;
    }

    public RadioButton activate(int theIndex) {
        int n = this._myRadioToggles.size();
        if (theIndex < n) {
            for (int i = 0; i < n; ++i) {
                this._myRadioToggles.get(i).deactivate();
            }
            this._myRadioToggles.get(theIndex).activate();
            this._myValue = this._myRadioToggles.get(theIndex).internalValue();
            this.updateValues(true);
        }
        return this;
    }

    public RadioButton deactivate(int theIndex) {
        if (!this.isMultipleChoice && !this.noneSelectedAllowed) {
            return this;
        }
        if (theIndex < this._myRadioToggles.size()) {
            Toggle t = this._myRadioToggles.get(theIndex);
            if (t.isActive) {
                t.deactivate();
                this._myValue = -1.0f;
                this.updateValues(true);
            }
        }
        return this;
    }

    public RadioButton activate(String theName) {
        int n = this._myRadioToggles.size();
        for (int i = 0; i < n; ++i) {
            Toggle t = this._myRadioToggles.get(i);
            if (!theName.equals(t.getName())) continue;
            this.activate(i);
            return this;
        }
        return this;
    }

    public RadioButton deactivate(String theName) {
        int n = this._myRadioToggles.size();
        for (int i = 0; i < n; ++i) {
            Toggle t = this._myRadioToggles.get(i);
            if (!theName.equals(t.getName())) continue;
            t.deactivate();
            this._myValue = -1.0f;
            this.updateValues(true);
            return this;
        }
        return this;
    }

    public RadioButton toggle(int theIndex) {
        ControlP5.logger().info("toggle() not yet implemented, working on it.");
        return this;
    }

    @Override
    @ControlP5.Invisible
    public void controlEvent(ControlEvent theEvent) {
        if (!this.isMultipleChoice) {
            if (!this.noneSelectedAllowed && theEvent.getController().getValue() < 1.0f && theEvent.getController() instanceof Toggle) {
                Toggle t = (Toggle)theEvent.getController();
                boolean b = t.isBroadcast();
                t.setBroadcast(false);
                t.setState(true);
                t.setBroadcast(b);
                return;
            }
            this._myValue = -1.0f;
            int n = this._myRadioToggles.size();
            for (int i = 0; i < n; ++i) {
                Toggle t = this._myRadioToggles.get(i);
                if (!t.equals(theEvent.getController())) {
                    t.deactivate();
                    continue;
                }
                if (!t.isOn) continue;
                this._myValue = t.internalValue();
            }
        }
        if (this._myPlug != null) {
            try {
                Method method = this._myPlug.getClass().getMethod(this._myPlugName, Integer.TYPE);
                method.invoke(this._myPlug, (int)this._myValue);
            }
            catch (SecurityException ex) {
                ex.printStackTrace();
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
        }
        this.updateValues(true);
    }

    public RadioButton plugTo(Object theObject) {
        this._myPlug = theObject;
        if (!ControllerPlug.checkPlug(this._myPlug, this._myPlugName, new Class[]{Integer.TYPE})) {
            this._myPlug = null;
        }
        return this;
    }

    public RadioButton plugTo(Object theObject, String thePlugName) {
        this._myPlug = theObject;
        this._myPlugName = thePlugName;
        if (!ControllerPlug.checkPlug(this._myPlug, this._myPlugName, new Class[]{Integer.TYPE})) {
            this._myPlug = null;
        }
        return this;
    }

    protected void updateValues(boolean theBroadcastFlag) {
        int n = this._myRadioToggles.size();
        this._myArrayValue = new float[n];
        for (int i = 0; i < n; ++i) {
            Toggle t = this._myRadioToggles.get(i);
            this._myArrayValue[i] = t.getValue();
        }
        if (theBroadcastFlag) {
            ControlEvent myEvent = new ControlEvent(this);
            this.cp5.getControlBroadcaster().broadcast(myEvent, 2);
        }
    }

    public RadioButton setNoneSelectedAllowed(boolean theValue) {
        this.noneSelectedAllowed = theValue;
        return this;
    }

    @Override
    public RadioButton setArrayValue(float[] theArray) {
        for (int i = 0; i < theArray.length; ++i) {
            if (this._myArrayValue[i] == theArray[i]) continue;
            if (theArray[i] == 0.0f) {
                this.deactivate(i);
                continue;
            }
            this.activate(i);
        }
        super.setArrayValue(theArray);
        return this;
    }

    public RadioButton setColorLabels(int theColor) {
        for (Toggle t : this._myRadioToggles) {
            t.getCaptionLabel().setColor(theColor);
        }
        return this;
    }

    public RadioButton hideLabels() {
        for (Toggle t : this._myRadioToggles) {
            t.getCaptionLabel().setVisible(false);
        }
        return this;
    }

    public RadioButton showLabels() {
        for (Toggle t : this._myRadioToggles) {
            t.getCaptionLabel().setVisible(true);
        }
        return this;
    }

    public RadioButton toUpperCase(boolean theValue) {
        for (Toggle t : this._myRadioToggles) {
            t.getCaptionLabel().toUpperCase(theValue);
        }
        return this;
    }

    @Override
    public String getInfo() {
        return "type:\tRadioButton\n" + super.getInfo();
    }

    @Deprecated
    public RadioButton add(String theName, float theValue) {
        return this.addItem(theName, theValue);
    }
}

