/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CallbackEvent;
import controlP5.ControlEvent;
import controlP5.ControlP5;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessControlException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerPlug {
    private Object _myObject;
    private String _myName;
    private Method _myMethod;
    private Field _myField;
    private int _myType = -1;
    private Class<?> _myParameterClass;
    private int _myParameterType = -1;
    private Object _myValue = null;
    private Class<?>[] _myAcceptClassList;
    private Class<?> _myEventMethodParameter = ControlEvent.class;

    public ControllerPlug(Object theObject, String theName, int theType, int theParameterType, Class<?>[] theAcceptClassList) {
        this.set(theObject, theName, theType, theParameterType, theAcceptClassList);
    }

    ControllerPlug(Class<?> param, Object theObject, String theName, int theType, int theParameterType) {
        this.setEventMethodParameter(param);
        this.set(theObject, theName, theType, theParameterType, null);
    }

    void setEventMethodParameter(Class<?> theClass) {
        this._myEventMethodParameter = theClass;
    }

    protected void set(Object theObject) {
        this.set(theObject, this.getName(), this.getType(), this.getParameterType(), this.getAcceptClassList());
    }

    public void set(Object theObject, String theName, int theType, int theParameterType, Class<?>[] theAcceptClassList) {
        block24: {
            this._myObject = theObject;
            this._myName = theName;
            this._myType = theType;
            this._myParameterType = theParameterType;
            this._myAcceptClassList = theAcceptClassList;
            Class<?> myClass = theObject.getClass();
            if (this._myType == 0) {
                try {
                    Class[] classArray;
                    Method[] myMethods = myClass.getDeclaredMethods();
                    block12: for (int i = 0; i < myMethods.length; ++i) {
                        if (!myMethods[i].getName().equals(theName)) continue;
                        if (myMethods[i].getParameterTypes().length == 1) {
                            for (int j = 0; j < this._myAcceptClassList.length; ++j) {
                                if (myMethods[i].getParameterTypes()[0] != this._myAcceptClassList[j]) continue;
                                this._myParameterClass = myMethods[i].getParameterTypes()[0];
                                break block12;
                            }
                            break;
                        }
                        if (myMethods[i].getParameterTypes().length != 0) break;
                        this._myParameterClass = null;
                        break;
                    }
                    if (this._myParameterClass == null) {
                        classArray = new Class[]{};
                    } else {
                        Class[] classArray2 = new Class[1];
                        classArray = classArray2;
                        classArray2[0] = this._myParameterClass;
                    }
                    Class[] myArgs = classArray;
                    this._myMethod = myClass.getDeclaredMethod(this._myName, myArgs);
                    this._myMethod.setAccessible(true);
                }
                catch (SecurityException e) {
                    this.printSecurityWarning(e);
                }
                catch (NoSuchMethodException e) {
                    if (this._myParameterClass != CallbackEvent.class) {
                        ControlP5.logger().warning(" plug() failed. If function " + theName + " does exist, make it public. " + e);
                    }
                    break block24;
                }
            }
            if (this._myType == 2) {
                try {
                    this._myMethod = this._myObject.getClass().getMethod(this._myName, this._myEventMethodParameter);
                    this._myMethod.setAccessible(true);
                    this._myParameterClass = this._myEventMethodParameter;
                }
                catch (SecurityException e) {
                    this.printSecurityWarning(e);
                }
                catch (NoSuchMethodException e) {
                    if (this._myEventMethodParameter != CallbackEvent.class) {
                        ControlP5.logger().warning(" plug() failed " + this._myParameterClass + ". If function " + theName + " does exist, make it public. " + e);
                    }
                    break block24;
                }
            }
            if (this._myType == 1) {
                for (int i = 0; i < myClass.getDeclaredFields().length; ++i) {
                    if (!myClass.getDeclaredFields()[i].getName().equals(this._myName)) continue;
                    this._myParameterClass = myClass.getDeclaredFields()[i].getType();
                }
                if (this._myParameterClass != null) {
                    try {
                        this._myField = myClass.getDeclaredField(this._myName);
                        try {
                            this._myField.setAccessible(true);
                        }
                        catch (AccessControlException e) {
                            this.printSecurityWarning(e);
                        }
                        try {
                            this._myValue = this._myField.get(theObject);
                        }
                        catch (Exception ex) {
                            this.printSecurityWarning(ex);
                        }
                    }
                    catch (NoSuchFieldException e) {
                        ControlP5.logger().warning(e.toString());
                    }
                }
            }
        }
    }

    private void printSecurityWarning(Exception e) {
        if (!ControlP5.isApplet) {
            ControlP5.isApplet = true;
            ControlP5.logger().warning("You are probably running in applet mode.\nmake sure fields and methods in your code are public.\n" + e);
        }
    }

    protected Object getValue() {
        return this._myValue;
    }

    protected Object getObject() {
        return this._myObject;
    }

    protected String getName() {
        return this._myName;
    }

    protected int getType() {
        return this._myType;
    }

    protected int getParameterType() {
        return this._myParameterType;
    }

    protected Class<?>[] getAcceptClassList() {
        return this._myAcceptClassList;
    }

    protected Class<?> getClassType() {
        return this._myParameterClass;
    }

    protected boolean checkType(int theType) {
        return this._myType == theType;
    }

    protected boolean checkName(String theName) {
        return this._myName.equals(theName);
    }

    private Object get(float theValue) {
        if (this._myParameterClass == Float.TYPE) {
            return new Float(theValue);
        }
        if (this._myParameterClass == Integer.TYPE) {
            return new Integer((int)theValue);
        }
        if (this._myParameterClass == Boolean.TYPE) {
            return (double)theValue > 0.5 ? new Boolean(true) : new Boolean(false);
        }
        return null;
    }

    protected Object getFieldParameter(float theValue) {
        return this.get(theValue);
    }

    protected Object[] getMethodParameter(float theValue) {
        return new Object[]{this.get(theValue)};
    }

    protected Method getMethod() {
        return this._myMethod;
    }

    protected Field getField() {
        return this._myField;
    }

    public static boolean checkPlug(Object theObject, String thePlugName, Class<?>[] theArgs) {
        try {
            theObject.getClass().getDeclaredMethod(thePlugName, theArgs);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Deprecated
    protected Class<?> classType() {
        return this._myParameterClass;
    }

    @Deprecated
    protected Object value() {
        return this._myValue;
    }

    @Deprecated
    protected Object object() {
        return this._myObject;
    }

    @Deprecated
    protected String name() {
        return this._myName;
    }

    @Deprecated
    protected int type() {
        return this._myType;
    }

    @Deprecated
    protected int parameterType() {
        return this._myParameterType;
    }

    @Deprecated
    protected Class<?>[] acceptClassList() {
        return this._myAcceptClassList;
    }
}

