/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.ControllerView;
import controlP5.Label;
import controlP5.TickMark;
import java.util.ArrayList;
import java.util.logging.Level;
import processing.core.PApplet;
import processing.core.PVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Range
extends Controller<Range> {
    protected static final int HORIZONTAL = 0;
    protected static final int VERTICAL = 1;
    protected int _myDirection;
    protected float _myValuePosition;
    protected boolean isDragging;
    protected boolean isDraggable = true;
    protected boolean isFirstClick;
    protected Label _myHighValueLabel;
    protected float _myValueRange;
    protected boolean isMinHandle;
    protected boolean isMaxHandle;
    protected boolean isMoveHandle;
    protected float distanceHandle;
    protected int handleSize = 10;
    protected int minHandle = 0;
    protected int maxHandle = 0;
    protected int mr = 0;
    protected final ArrayList<TickMark> _myTickMarks = new ArrayList();
    protected boolean isShowTickMarks;
    protected boolean isSnapToTickMarks;
    public static int autoWidth = 99;
    public static int autoHeight = 9;
    public static PVector autoSpacing = new PVector(0.0f, 5.0f, 0.0f);
    public int alignValueLabel = 3;
    protected int _myColorTickMark = -1;
    private int mode = -1;

    public Range(ControlP5 theControlP5, String theName) {
        this(theControlP5, theControlP5.getDefaultTab(), theName, 0.0f, 100.0f, 0.0f, 100.0f, 0, 0, 99, 9);
        theControlP5.register(theControlP5.papplet, theName, this);
    }

    @ControlP5.Invisible
    public Range(ControlP5 theControlP5, ControllerGroup<?> theParent, String theName, float theMin, float theMax, float theDefaultMinValue, float theDefaultMaxValue, int theX, int theY, int theWidth, int theHeight) {
        super(theControlP5, theParent, theName, theX, theY, theWidth, theHeight);
        this._myArrayValue = new float[]{theDefaultMinValue, theDefaultMaxValue};
        this._myMin = theMin;
        this._myMax = theMax;
        this._myValueRange = this._myMax - this._myMin;
        this.minHandle = (int)PApplet.map((float)theDefaultMinValue, (float)this._myMin, (float)this._myMax, (float)this.handleSize, (float)(this.getWidth() - this.handleSize));
        this.maxHandle = (int)PApplet.map((float)theDefaultMaxValue, (float)this._myMin, (float)this._myMax, (float)this.handleSize, (float)(this.getWidth() - this.handleSize));
        this.mr = this.maxHandle - this.minHandle;
        this._myCaptionLabel = new Label(this.cp5, theName).setColor(this.color.getCaptionLabel()).align(11, 3);
        this._myValueLabel = new Label(this.cp5, "" + this.adjustValue(this._myMin)).setColor(this.color.getValueLabel()).set("" + this.adjustValue(theDefaultMinValue)).align(37, 3);
        this._myHighValueLabel = new Label(this.cp5, this.adjustValue(this._myMax)).setColor(this.color.getValueLabel()).set("" + this.adjustValue(theDefaultMaxValue)).align(39, 3);
        this._myValue = theDefaultMinValue;
        this._myDirection = 0;
        this.update();
    }

    @Override
    public Range setColorValueLabel(int theColor) {
        this._myValueLabel.setColor(theColor);
        this._myHighValueLabel.setColor(theColor);
        return this;
    }

    @Override
    public Range setColorCaptionLabel(int theColor) {
        this._myCaptionLabel.setColor(theColor);
        return this;
    }

    public Range setHighValueLabel(String theLabel) {
        this._myHighValueLabel.set(theLabel);
        return this;
    }

    public Range setLowValueLabel(String theLabel) {
        this._myValueLabel.set(theLabel);
        return this;
    }

    @ControlP5.Invisible
    public Range setSliderMode(int theMode) {
        return this;
    }

    public Range setHandleSize(int theSize) {
        this.handleSize = theSize;
        this.setLowValue(this._myArrayValue[0], false);
        this.setHighValue(this._myArrayValue[1], false);
        this.mr = this.maxHandle - this.minHandle;
        return this;
    }

    @Override
    @ControlP5.Invisible
    public Range updateInternalEvents(PApplet theApplet) {
        if (this.isVisible) {
            int c = this._myControlWindow.mouseX - this._myControlWindow.pmouseX;
            if (c == 0) {
                return this;
            }
            if (this.isMousePressed && !this.cp5.keyHandler.isAltDown()) {
                switch (this.mode) {
                    case 37: {
                        this.minHandle = PApplet.max((int)this.handleSize, (int)PApplet.min((int)this.maxHandle, (int)(this.minHandle + c)));
                        break;
                    }
                    case 39: {
                        this.maxHandle = PApplet.max((int)this.minHandle, (int)PApplet.min((int)(this.getWidth() - this.handleSize), (int)(this.maxHandle + c)));
                        break;
                    }
                    case 3: {
                        this.minHandle = PApplet.max((int)this.handleSize, (int)PApplet.min((int)(this.getWidth() - this.mr - this.handleSize), (int)(this.minHandle + c)));
                        this.maxHandle = PApplet.max((int)this.minHandle, (int)PApplet.min((int)(this.getWidth() - this.handleSize), (int)(this.minHandle + this.mr)));
                    }
                }
                this.update();
            }
        }
        return this;
    }

    @Override
    @ControlP5.Invisible
    public void mousePressed() {
        float posX = this._myParent.getAbsolutePosition().x + this.position.x;
        float posY = this._myParent.getAbsolutePosition().y + this.position.y;
        if ((float)this._myControlWindow.mouseY < posY || (float)this._myControlWindow.mouseY > posY + (float)this.getHeight()) {
            this.mode = -1;
            this.isMaxHandle = false;
            this.isMinHandle = false;
            return;
        }
        int x0 = (int)(posX + (float)this.minHandle);
        int x1 = (int)(posX + (float)this.maxHandle);
        if (this._myControlWindow.mouseX >= x0 - this.handleSize && this._myControlWindow.mouseX < x0) {
            this.mode = 37;
            this.isMinHandle = true;
        } else if (this._myControlWindow.mouseX >= x1 && this._myControlWindow.mouseX < x1 + this.handleSize) {
            this.mode = 39;
            this.isMaxHandle = true;
        } else if (this._myControlWindow.mouseX > x0 && this._myControlWindow.mouseX < x1 && this.isDraggable) {
            this.mode = 3;
        }
    }

    @Override
    @ControlP5.Invisible
    public Range setValue(float theValue) {
        this._myValue = theValue;
        this.broadcast(5);
        return this;
    }

    @Override
    @ControlP5.Invisible
    public Range update() {
        this._myArrayValue[0] = PApplet.map((float)this.minHandle, (float)this.handleSize, (float)(this.getWidth() - this.handleSize), (float)this._myMin, (float)this._myMax);
        this._myArrayValue[1] = PApplet.map((float)this.maxHandle, (float)this.handleSize, (float)(this.getWidth() - this.handleSize), (float)this._myMin, (float)this._myMax);
        this.mr = this.maxHandle - this.minHandle;
        this._myHighValueLabel.set(this.adjustValue(this._myArrayValue[1]));
        this._myValueLabel.set(this.adjustValue(this._myArrayValue[0]));
        return this.setValue(this._myValue);
    }

    @ControlP5.Invisible
    public Range setDraggable(boolean theFlag) {
        this.isDraggable = theFlag;
        this.isDragging = !theFlag ? false : this.isDragging;
        return this;
    }

    @Override
    public float[] getArrayValue() {
        return this._myArrayValue;
    }

    @Override
    public Range setArrayValue(float[] theArray) {
        this.setLowValue(theArray[0], false);
        this.setHighValue(theArray[1], false);
        return this.update();
    }

    @Override
    public Range setMin(float theValue) {
        this._myMin = theValue;
        this._myValueRange = this._myMax - this._myMin;
        return this.setLowValue(this._myArrayValue[0]);
    }

    @Override
    public Range setMax(float theValue) {
        this._myMax = theValue;
        this._myValueRange = this._myMax - this._myMin;
        return this.setHighValue(this._myArrayValue[1]);
    }

    public float getLowValue() {
        return this._myArrayValue[0];
    }

    public float getHighValue() {
        return this._myArrayValue[1];
    }

    @Override
    public Range setWidth(int theValue) {
        this.width = theValue;
        return this;
    }

    @Override
    public Range setHeight(int theValue) {
        this.height = theValue;
        return this;
    }

    @Override
    @ControlP5.Invisible
    public void mouseReleased() {
        this.isMoveHandle = false;
        this.isMaxHandle = false;
        this.isMinHandle = false;
        this.isDragging = false;
        this.mode = -1;
    }

    @Override
    @ControlP5.Invisible
    public void mouseReleasedOutside() {
        this.mouseReleased();
    }

    @Override
    @ControlP5.Invisible
    public void onLeave() {
        this.isMinHandle = false;
        this.isMaxHandle = false;
    }

    protected void setTickMarks() {
        System.out.println("Range Tickmarks not yet supported");
    }

    public Range setColorTickMark(int theColor) {
        this._myColorTickMark = theColor;
        return this;
    }

    public Range showTickMarks(boolean theFlag) {
        this.isShowTickMarks = theFlag;
        return this;
    }

    public Range snapToTickMarks(boolean theFlag) {
        this.isSnapToTickMarks = theFlag;
        System.out.println("Range Tickmarks not yet supported");
        return this;
    }

    @ControlP5.Invisible
    public TickMark getTickMark() {
        System.out.println("Range Tickmarks not yet supported");
        return null;
    }

    public ArrayList<TickMark> getTickMarks() {
        return this._myTickMarks;
    }

    public Range setNumberOfTickMarks(int theNumber) {
        System.out.println("Range Tickmarks not yet supported");
        this._myTickMarks.clear();
        if (theNumber > 0) {
            for (int i = 0; i < theNumber; ++i) {
                this._myTickMarks.add(new TickMark(this));
            }
            this.showTickMarks(true);
            this.snapToTickMarks(true);
        } else {
            this.showTickMarks(false);
            this.snapToTickMarks(false);
        }
        this._myUnit = (this._myMax - this._myMin) / (float)(this.width > this.height ? this.width - 1 : this.height - 1);
        this.setLowValue(this._myArrayValue[0], false);
        this.setHighValue(this._myArrayValue[1], false);
        return this.update();
    }

    public Range setRange(float theMinValue, float theMaxValue) {
        this.setMin(theMinValue);
        this.setMax(theMaxValue);
        return this;
    }

    public Range setRangeValues(float theLowValue, float theHighValue) {
        return this.setArrayValue(new float[]{theLowValue, theHighValue});
    }

    private Range setLowValue(float theValue, boolean isUpdate) {
        this._myArrayValue[0] = PApplet.max((float)this._myMin, (float)this.snapValue(theValue));
        this.minHandle = (int)PApplet.map((float)this._myArrayValue[0], (float)this._myMin, (float)this._myMax, (float)this.handleSize, (float)(this.getWidth() - this.handleSize));
        return isUpdate ? this.update() : this;
    }

    public Range setLowValue(float theValue) {
        return this.setLowValue(theValue, true);
    }

    private Range setHighValue(float theValue, boolean isUpdate) {
        this._myArrayValue[1] = PApplet.min((float)this._myMax, (float)this.snapValue(theValue));
        this.maxHandle = (int)PApplet.map((float)this._myArrayValue[1], (float)this._myMin, (float)this._myMax, (float)this.handleSize, (float)(this.getWidth() - this.handleSize));
        return isUpdate ? this.update() : this;
    }

    public Range setHighValue(float theValue) {
        return this.setHighValue(theValue, true);
    }

    protected float snapValue(float theValue) {
        if (this.isMousePressed) {
            return theValue;
        }
        if (this.isSnapToTickMarks) {
            this._myValuePosition = (theValue - this._myMin) / this._myUnit;
            float n = PApplet.round((float)PApplet.map((float)this._myValuePosition, (float)0.0f, (float)(this._myDirection == 0 ? (float)this.getWidth() : (float)this.getHeight()), (float)0.0f, (float)(this._myTickMarks.size() - 1)));
            theValue = PApplet.map((float)n, (float)0.0f, (float)(this._myTickMarks.size() - 1), (float)this._myMin, (float)this._myMax);
        }
        return theValue;
    }

    @Override
    @ControlP5.Invisible
    public Range updateDisplayMode(int theMode) {
        this._myDisplayMode = theMode;
        switch (theMode) {
            case 0: {
                this._myControllerView = new RangeView();
                break;
            }
            case 2: {
                this._myControllerView = new RangeSpriteView();
                break;
            }
            case 1: {
                this._myControllerView = new RangeImageView();
                break;
            }
        }
        return this;
    }

    @Override
    @ControlP5.Invisible
    public String toString() {
        return "type:\tRange\n" + super.toString();
    }

    @Deprecated
    public float lowValue() {
        return this.getLowValue();
    }

    @Deprecated
    public float highValue() {
        return this.getHighValue();
    }

    @Override
    @Deprecated
    public float[] arrayValue() {
        return this._myArrayValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RangeImageView
    implements ControllerView<Range> {
        RangeImageView() {
        }

        @Override
        public void display(PApplet theApplet, Range theController) {
            ControlP5.logger().log(Level.INFO, "RangeImageDisplay not implemented.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RangeView
    implements ControllerView<Range> {
        RangeView() {
        }

        @Override
        public void display(PApplet theApplet, Range theController) {
            int high = Range.this.mode;
            float posX = Range.this._myParent.getAbsolutePosition().x + Range.this.position.x;
            int x0 = (int)(posX + (float)Range.this.minHandle);
            int x1 = (int)(posX + (float)Range.this.maxHandle);
            if (Range.this.isInside() && high < 0) {
                if (Range.this._myControlWindow.mouseX >= x0 - Range.this.handleSize && Range.this._myControlWindow.mouseX < x0) {
                    high = 37;
                } else if (Range.this._myControlWindow.mouseX >= x1 && Range.this._myControlWindow.mouseX < x1 + Range.this.handleSize) {
                    high = 39;
                } else if (Range.this._myControlWindow.mouseX > x0 && Range.this._myControlWindow.mouseX < x1 && Range.this.isDraggable) {
                    high = 3;
                }
            }
            theApplet.pushMatrix();
            theApplet.fill(Range.this.color.getBackground());
            theApplet.noStroke();
            theApplet.rect(0.0f, 0.0f, (float)Range.this.width, (float)Range.this.height);
            theApplet.fill(high == 3 ? Range.this.color.getActive() : Range.this.color.getForeground());
            if (Range.this.isShowTickMarks) {
                int n = Range.this.handleSize / 2;
                theApplet.rect((float)(Range.this.minHandle - n), 0.0f, (float)(Range.this.mr + Range.this.handleSize), (float)Range.this.height);
                theApplet.fill(Range.this.isMinHandle || high == 37 ? Range.this.color.getActive() : Range.this.color.getForeground());
                theApplet.triangle((float)(Range.this.minHandle - Range.this.handleSize), 0.0f, (float)Range.this.minHandle, 0.0f, (float)(Range.this.minHandle - n), (float)Range.this.height);
                theApplet.fill(Range.this.isMaxHandle || high == 39 ? Range.this.color.getActive() : Range.this.color.getForeground());
                theApplet.triangle((float)Range.this.maxHandle, 0.0f, (float)(Range.this.maxHandle + Range.this.handleSize), 0.0f, (float)(Range.this.maxHandle + n), (float)Range.this.height);
            } else {
                theApplet.rect((float)Range.this.minHandle, 0.0f, (float)Range.this.mr, (float)Range.this.height);
                theApplet.fill(Range.this.isMinHandle || high == 37 ? Range.this.color.getActive() : Range.this.color.getForeground());
                theApplet.rect((float)(Range.this.minHandle - Range.this.handleSize), 0.0f, (float)Range.this.handleSize, (float)Range.this.height);
                theApplet.fill(Range.this.isMaxHandle || high == 39 ? Range.this.color.getActive() : Range.this.color.getForeground());
                theApplet.rect((float)Range.this.maxHandle, 0.0f, (float)Range.this.handleSize, (float)Range.this.height);
            }
            if (Range.this.isLabelVisible) {
                Range.this._myCaptionLabel.draw(theApplet, 0, 0, theController);
                Range.this._myValueLabel.draw(theApplet, 0, 0, theController);
                Range.this._myHighValueLabel.draw(theApplet, 0, 0, theController);
            }
            theApplet.popMatrix();
            if (Range.this.isShowTickMarks) {
                theApplet.pushMatrix();
                float x = (Range.this.getWidth() - Range.this.handleSize) / (Range.this.getTickMarks().size() - 1);
                theApplet.translate((float)(Range.this.handleSize / 2), (float)Range.this.getHeight());
                theApplet.fill(Range.this._myColorTickMark);
                for (TickMark tm : Range.this.getTickMarks()) {
                    tm.draw(theApplet);
                    theApplet.translate(x, 0.0f);
                }
                theApplet.popMatrix();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RangeSpriteView
    implements ControllerView<Range> {
        RangeSpriteView() {
        }

        @Override
        public void display(PApplet theApplet, Range theController) {
            ControlP5.logger().log(Level.INFO, "RangeSpriteDisplay not available.");
        }
    }
}

