/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ControllerView;
import controlP5.Label;
import controlP5.Tab;
import processing.core.PApplet;
import processing.core.PVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Numberbox
extends Controller<Numberbox> {
    protected int cnt;
    protected boolean isActive;
    public static int LEFT = 0;
    public static int UP = 1;
    public static int RIGHT = 2;
    public static int DOWN = 3;
    protected int _myNumberCount = 1;
    protected float _myMultiplier = 1.0f;
    public static int autoWidth = 69;
    public static int autoHeight = 19;
    protected PVector autoSpacing = new PVector(10.0f, 20.0f, 0.0f);
    protected float scrollSensitivity = 0.1f;

    public Numberbox(ControlP5 theControlP5, String theName) {
        this(theControlP5, theControlP5.getDefaultTab(), theName, 0.0f, 0, 0, autoWidth, autoHeight);
        theControlP5.register(theControlP5.papplet, theName, this);
    }

    public Numberbox(ControlP5 theControlP5, Tab theParent, String theName, float theDefaultValue, int theX, int theY, int theWidth, int theHeight) {
        super(theControlP5, theParent, theName, theX, theY, theWidth, theHeight);
        this._myMin = -3.4028235E38f;
        this._myMax = Float.MAX_VALUE;
        this._myValue = theDefaultValue;
        this._myValueLabel = new Label(this.cp5, "" + this._myValue, theWidth, 12, this.color.getValueLabel());
        if (Float.isNaN(this._myValue)) {
            this._myValue = 0.0f;
        }
    }

    @Override
    @ControlP5.Invisible
    public Numberbox updateInternalEvents(PApplet theApplet) {
        if (this.isActive && !this.cp5.keyHandler.isAltDown()) {
            if (this._myNumberCount == 1) {
                this.setValue(this._myValue + (float)(this._myControlWindow.mouseY - this._myControlWindow.pmouseY) * this._myMultiplier);
            } else {
                this.setValue(this._myValue + (float)(this._myControlWindow.mouseX - this._myControlWindow.pmouseX) * this._myMultiplier);
            }
        }
        return this;
    }

    @Override
    @ControlP5.Invisible
    public void mousePressed() {
        this.isActive = true;
    }

    @Override
    @ControlP5.Invisible
    public void mouseReleased() {
        this.isActive = false;
    }

    @Override
    @ControlP5.Invisible
    public void mouseReleasedOutside() {
        this.mouseReleased();
    }

    public Numberbox setMultiplier(float theMultiplier) {
        this._myMultiplier = theMultiplier;
        return this;
    }

    public float getMultiplier() {
        return this._myMultiplier;
    }

    @Override
    public Numberbox setValue(float theValue) {
        this._myValue = theValue;
        this._myValue = Math.max(this._myMin, Math.min(this._myMax, this._myValue));
        this.broadcast(2);
        this._myValueLabel.set(this.adjustValue(this._myValue));
        return this;
    }

    public Numberbox shuffle() {
        float r = (float)Math.random();
        if (this.getMax() != Float.MAX_VALUE && this.getMin() != -3.4028235E38f) {
            this.setValue(PApplet.map((float)r, (float)0.0f, (float)1.0f, (float)this.getMin(), (float)this.getMax()));
        }
        return this;
    }

    public Numberbox setRange(float theMin, float theMax) {
        this.setMin(theMin);
        this.setMax(theMax);
        this.setValue(this.getValue());
        return this;
    }

    public Numberbox setScrollSensitivity(float theValue) {
        this.scrollSensitivity = theValue;
        return this;
    }

    @ControlP5.Invisible
    public Numberbox scrolled(int theRotationValue) {
        float f = this.getValue();
        this.setValue(f += this._myMultiplier == 1.0f ? (float)theRotationValue * this.scrollSensitivity : (float)theRotationValue * this._myMultiplier);
        return this;
    }

    public Numberbox setDirection(int theValue) {
        this._myNumberCount = theValue == 0 || theValue == 1 ? theValue : 1;
        return this;
    }

    @Override
    public Numberbox update() {
        return this.setValue(this._myValue);
    }

    @Override
    public Numberbox linebreak() {
        this.cp5.linebreak(this, true, autoWidth, autoHeight, this.autoSpacing);
        return this;
    }

    @Override
    @ControlP5.Invisible
    public Numberbox updateDisplayMode(int theMode) {
        this._myDisplayMode = theMode;
        switch (theMode) {
            case 0: {
                this._myControllerView = new NumberboxView();
            }
        }
        return this;
    }

    @Deprecated
    public Numberbox setSensitivity(float theValue) {
        return this.setScrollSensitivity(theValue);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NumberboxView
    implements ControllerView<Numberbox> {
        NumberboxView() {
        }

        @Override
        public void display(PApplet theApplet, Numberbox theController) {
            theApplet.fill(Numberbox.this.color.getBackground());
            theApplet.rect(0.0f, 0.0f, (float)Numberbox.this.width, (float)Numberbox.this.height);
            theApplet.fill(Numberbox.this.isActive ? Numberbox.this.color.getActive() : Numberbox.this.color.getForeground());
            Numberbox.this._myValueLabel.draw(theApplet, 0, (Numberbox.this.height - Numberbox.this._myValueLabel.getHeight() + 4) / 2, theController);
            Numberbox.this._myCaptionLabel.draw(theApplet, 0, Numberbox.this.height + 4, theController);
        }
    }
}

