/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.ControllerView;
import processing.core.PApplet;
import processing.core.PVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Knob
extends Controller<Knob> {
    protected float _myDiameter;
    protected float _myRadius;
    protected float myAngle;
    protected float startAngle;
    protected float angleRange;
    protected float resolution = 200.0f;
    protected int _myTickMarksNum = 8;
    protected boolean isShowTickMarks;
    protected boolean isSnapToTickMarks;
    protected int myTickMarkLength = 2;
    protected float myTickMarkWeight = 1.0f;
    protected boolean isShowAngleRange = true;
    protected float currentValue;
    protected float previousValue;
    protected float modifiedValue;
    protected boolean isConstrained;
    protected int _myDragDirection = 0;
    protected int viewStyle = 1;
    public static int autoWidth = 39;
    public static int autoHeight = 39;
    protected PVector autoSpacing = new PVector(10.0f, 20.0f, 0.0f);
    private float scrollSensitivity = 1.0f / this.resolution;

    public Knob(ControlP5 theControlP5, String theName) {
        this(theControlP5, theControlP5.getDefaultTab(), theName, 0.0f, 100.0f, 0.0f, 0, 0, autoWidth);
        theControlP5.register(theControlP5.papplet, theName, this);
    }

    public Knob(ControlP5 theControlP5, ControllerGroup<?> theParent, String theName, float theMin, float theMax, float theDefaultValue, int theX, int theY, int theWidth) {
        super(theControlP5, theParent, theName, theX, theY, theWidth, theWidth);
        this._myValue = theDefaultValue;
        this.setMin(theMin);
        this.setMax(theMax);
        this._myDiameter = theWidth;
        this._myRadius = this._myDiameter / 2.0f;
        this._myUnit = (this._myMax - this._myMin) / ((float)Math.PI * 2);
        this.startAngle = 2.3561945f;
        this.angleRange = 4.712389f;
        this.myAngle = this.startAngle;
        this.isConstrained = true;
        this.getCaptionLabel().align(3, 13);
    }

    public Knob setSize(float theWidth, float theHeight) {
        return this.setRadius(theWidth / 2.0f);
    }

    public Knob setRadius(float theValue) {
        this._myRadius = theValue;
        this._myDiameter = this._myRadius * 2.0f;
        this.width = (int)this._myDiameter;
        this.height = (int)this._myDiameter;
        return this;
    }

    public float getRadius() {
        return this._myRadius;
    }

    public Knob setStartAngle(float theAngle) {
        this.startAngle = theAngle;
        this.setInternalValue(this.modifiedValue);
        return this;
    }

    public float getStartAngle() {
        return this.startAngle;
    }

    public Knob setAngleRange(float theRange) {
        this.angleRange = theRange;
        this.setInternalValue(this.modifiedValue);
        return this;
    }

    public float getAngleRange() {
        return this.angleRange;
    }

    public float getAngle() {
        return this.myAngle;
    }

    public boolean isShowAngleRange() {
        return this.isShowAngleRange;
    }

    public Knob setShowAngleRange(boolean theValue) {
        this.isShowAngleRange = theValue;
        return this;
    }

    public Knob setDragDirection(int theValue) {
        this._myDragDirection = theValue == 0 ? 0 : 1;
        return this;
    }

    public int getDragDirection() {
        return this._myDragDirection;
    }

    public Knob setResolution(float theValue) {
        this.resolution = theValue;
        return this;
    }

    public float getResolution() {
        return this.resolution;
    }

    public Knob setNumberOfTickMarks(int theNumber) {
        this._myTickMarksNum = theNumber;
        this.showTickMarks();
        return this;
    }

    public int getNumberOfTickMarks() {
        return this._myTickMarksNum;
    }

    public Knob showTickMarks() {
        this.isShowTickMarks = true;
        return this;
    }

    public Knob hideTickMarks() {
        this.isShowTickMarks = false;
        return this;
    }

    public boolean isShowTickMarks() {
        return this.isShowTickMarks;
    }

    public Knob snapToTickMarks(boolean theFlag) {
        this.isSnapToTickMarks = theFlag;
        this.update();
        return this;
    }

    public Knob setTickMarkLength(int theLength) {
        this.myTickMarkLength = theLength;
        return this;
    }

    public int getTickMarkLength() {
        return this.myTickMarkLength;
    }

    public Knob setTickMarkWeight(float theWeight) {
        this.myTickMarkWeight = theWeight;
        return this;
    }

    public float getTickMarkWeight() {
        return this.myTickMarkWeight;
    }

    public Knob setConstrained(boolean theValue) {
        this.isConstrained = theValue;
        if (!this.isConstrained) {
            this.setShowAngleRange(false);
        } else {
            this.setShowAngleRange(true);
        }
        return this;
    }

    public boolean isConstrained() {
        return this.isConstrained;
    }

    @Override
    @ControlP5.Invisible
    public Knob updateInternalEvents(PApplet theApplet) {
        if (this.isMousePressed && !this.cp5.keyHandler.isAltDown() && this.isActive) {
            float c = this._myDragDirection == 0 ? (float)(this._myControlWindow.mouseX - this._myControlWindow.pmouseX) : (float)(this._myControlWindow.mouseY - this._myControlWindow.pmouseY);
            this.currentValue += c / this.resolution;
            if (this.isConstrained) {
                this.currentValue = PApplet.constrain((float)this.currentValue, (float)0.0f, (float)1.0f);
            }
            this.setInternalValue(this.currentValue);
        }
        return this;
    }

    @Override
    protected void onEnter() {
        this.isActive = true;
    }

    @Override
    protected void onLeave() {
        this.isActive = false;
    }

    @Override
    @ControlP5.Invisible
    public void mousePressed() {
        float x = this._myParent.getAbsolutePosition().x + this.position.x + this._myRadius;
        float y = this._myParent.getAbsolutePosition().y + this.position.y + this._myRadius;
        if (PApplet.dist((float)x, (float)y, (float)this._myControlWindow.mouseX, (float)this._myControlWindow.mouseY) < this._myRadius) {
            this.isActive = true;
            if ((double)PApplet.dist((float)x, (float)y, (float)this._myControlWindow.mouseX, (float)this._myControlWindow.mouseY) > (double)this._myRadius * 0.6) {
                this.myAngle = PApplet.atan2((float)((float)this._myControlWindow.mouseY - y), (float)((float)this._myControlWindow.mouseX - x)) - this.startAngle;
                if (this.myAngle < 0.0f) {
                    this.myAngle = (float)Math.PI * 2 + this.myAngle;
                }
                if (this.isConstrained) {
                    this.myAngle %= (float)Math.PI * 2;
                }
                this.currentValue = PApplet.map((float)this.myAngle, (float)0.0f, (float)this.angleRange, (float)0.0f, (float)1.0f);
                this.setInternalValue(this.currentValue);
            }
        }
    }

    @Override
    @ControlP5.Invisible
    public void mouseReleasedOutside() {
        this.isActive = false;
    }

    @Override
    public Knob setMin(float theValue) {
        this._myMin = theValue;
        return this;
    }

    @Override
    public Knob setMax(float theValue) {
        this._myMax = theValue;
        return this;
    }

    public Knob setRange(float theMin, float theMax) {
        this.setMin(theMin);
        this.setMax(theMax);
        this.update();
        return this;
    }

    protected void setInternalValue(float theValue) {
        this.modifiedValue = this.isSnapToTickMarks ? (float)PApplet.round((float)(theValue * (float)this._myTickMarksNum)) / (float)this._myTickMarksNum : theValue;
        this.currentValue = theValue;
        this.myAngle = PApplet.map((float)(this.isSnapToTickMarks ? this.modifiedValue : this.currentValue), (float)0.0f, (float)1.0f, (float)this.startAngle, (float)(this.startAngle + this.angleRange));
        if (this.isSnapToTickMarks && this.previousValue != this.modifiedValue && this.isSnapToTickMarks) {
            this.broadcast(2);
            this.previousValue = this.modifiedValue;
            return;
        }
        if (this.previousValue != this.currentValue) {
            this.broadcast(2);
            this.previousValue = this.modifiedValue;
        }
    }

    @Override
    public Knob setValue(float theValue) {
        theValue = PApplet.map((float)theValue, (float)this._myMin, (float)this._myMax, (float)0.0f, (float)1.0f);
        if (this.isConstrained) {
            theValue = PApplet.constrain((float)theValue, (float)0.0f, (float)1.0f);
        }
        this.setInternalValue(theValue);
        return this;
    }

    @Override
    public float getValue() {
        this._myValue = PApplet.map((float)(this._myTickMarksNum > 0 ? this.modifiedValue : this.currentValue), (float)0.0f, (float)1.0f, (float)this._myMin, (float)this._myMax);
        return this._myValue;
    }

    public Knob shuffle() {
        float r = (float)Math.random();
        this.setValue(PApplet.map((float)r, (float)0.0f, (float)1.0f, (float)this.getMin(), (float)this.getMax()));
        return this;
    }

    public Knob setScrollSensitivity(float theValue) {
        this.scrollSensitivity = theValue;
        return this;
    }

    @ControlP5.Invisible
    public Knob scrolled(int theRotationValue) {
        float f = this.getValue();
        float steps = this.isSnapToTickMarks ? 1.0f / (float)this.getNumberOfTickMarks() : this.scrollSensitivity;
        this.setValue(f += (this.getMax() - this.getMin()) * ((float)(-theRotationValue) * steps));
        return this;
    }

    @Override
    @ControlP5.Invisible
    public Knob update() {
        this.setValue(this._myValue);
        return this;
    }

    public Knob setViewStyle(int theStyle) {
        this.viewStyle = theStyle;
        return this;
    }

    public int getViewStyle() {
        return this.viewStyle;
    }

    @Override
    @ControlP5.Invisible
    public Knob updateDisplayMode(int theMode) {
        this._myDisplayMode = theMode;
        switch (theMode) {
            case 0: {
                this._myControllerView = new KnobView();
                break;
            }
            case 1: 
            case 2: {
                this._myControllerView = new KnobView();
                break;
            }
        }
        return this;
    }

    @Deprecated
    public Knob setOffsetAngle(float theValue) {
        return this.setStartAngle(theValue);
    }

    @Override
    @Deprecated
    public float value() {
        return this.getValue();
    }

    @Deprecated
    public Knob setDisplayStyle(int theStyle) {
        this.viewStyle = theStyle;
        return this;
    }

    @Deprecated
    public int getDisplayStyle() {
        return this.viewStyle;
    }

    @Deprecated
    @ControlP5.Invisible
    public Knob setSensitivity(float theValue) {
        this.scrollSensitivity = theValue;
        return this;
    }

    @Deprecated
    public Knob showTickMarks(boolean theFlag) {
        this.isShowTickMarks = theFlag;
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class KnobView
    implements ControllerView<Knob> {
        KnobView() {
        }

        @Override
        public void display(PApplet theApplet, Knob theController) {
            theApplet.translate(Knob.this.getRadius(), Knob.this.getRadius());
            theApplet.pushMatrix();
            theApplet.ellipseMode(3);
            theApplet.noStroke();
            theApplet.fill(Knob.this.getColor().getBackground());
            theApplet.ellipse(0.0f, 0.0f, Knob.this.getRadius() * 2.0f, Knob.this.getRadius() * 2.0f);
            theApplet.popMatrix();
            int c = Knob.this.isActive() ? Knob.this.getColor().getActive() : Knob.this.getColor().getForeground();
            theApplet.pushMatrix();
            if (Knob.this.getViewStyle() == 1) {
                theApplet.rotate(Knob.this.getAngle());
                theApplet.stroke(c);
                theApplet.strokeWeight(Knob.this.getTickMarkWeight());
                theApplet.line(0.0f, 0.0f, Knob.this.getRadius(), 0.0f);
            } else if (Knob.this.getViewStyle() == 2) {
                theApplet.rotate(Knob.this.getAngle());
                theApplet.fill(c);
                theApplet.ellipse(Knob.this.getRadius() * 0.75f, 0.0f, Knob.this.getRadius() * 0.2f, Knob.this.getRadius() * 0.2f);
            } else if (Knob.this.getViewStyle() == 3) {
                theApplet.fill(c);
                theApplet.arc(0.0f, 0.0f, Knob.this.getRadius() * 1.8f, Knob.this.getRadius() * 1.8f, Knob.this.getStartAngle(), Knob.this.getAngle() + (Knob.this.getStartAngle() == Knob.this.getAngle() ? 0.06f : 0.0f));
                theApplet.fill(Knob.this.getColor().getBackground());
                theApplet.ellipse(0.0f, 0.0f, Knob.this.getRadius() * 1.2f, Knob.this.getRadius() * 1.2f);
            }
            theApplet.popMatrix();
            theApplet.pushMatrix();
            theApplet.rotate(Knob.this.getStartAngle());
            if (Knob.this.isShowTickMarks()) {
                float step = Knob.this.getAngleRange() / (float)Knob.this.getNumberOfTickMarks();
                theApplet.stroke(Knob.this.getColor().getForeground());
                theApplet.strokeWeight(Knob.this.getTickMarkWeight());
                for (int i = 0; i <= Knob.this.getNumberOfTickMarks(); ++i) {
                    theApplet.line(Knob.this.getRadius() + 2.0f, 0.0f, Knob.this.getRadius() + (float)Knob.this.getTickMarkLength() + 2.0f, 0.0f);
                    theApplet.rotate(step);
                }
            } else if (Knob.this.isShowAngleRange()) {
                theApplet.stroke(Knob.this.getColor().getForeground());
                theApplet.strokeWeight(Knob.this.getTickMarkWeight());
                theApplet.line(Knob.this.getRadius() + 2.0f, 0.0f, Knob.this.getRadius() + (float)Knob.this.getTickMarkLength() + 2.0f, 0.0f);
                theApplet.rotate(Knob.this.getAngleRange());
                theApplet.line(Knob.this.getRadius() + 2.0f, 0.0f, Knob.this.getRadius() + (float)Knob.this.getTickMarkLength() + 2.0f, 0.0f);
            }
            theApplet.noStroke();
            theApplet.popMatrix();
            if (Knob.this.isLabelVisible) {
                Knob.this._myCaptionLabel.draw(theApplet, -Knob.this.getWidth() / 2, -Knob.this.getHeight() / 2, theController);
            }
        }
    }
}

