/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CColor;
import controlP5.CDrawable;
import controlP5.ControlFont;
import controlP5.ControlP5;
import controlP5.ControlP5Constants;
import controlP5.ControlP5IOHandler;
import controlP5.ControlWindow;
import controlP5.ControlWindowCanvas;
import controlP5.Controller;
import controlP5.ControllerInterface;
import controlP5.ControllerList;
import controlP5.ControllerProperty;
import controlP5.Label;
import controlP5.Tab;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import processing.core.PApplet;
import processing.core.PVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ControllerGroup<T>
implements ControllerInterface<T>,
ControlP5Constants {
    protected PVector position;
    protected PVector positionBuffer;
    protected PVector absolutePosition;
    protected ControllerList controllers;
    protected ControlWindow _myControlWindow;
    protected ControlP5 cp5;
    protected ControllerGroup<?> _myParent;
    protected String _myName;
    protected int _myId = -1;
    protected CColor color = new CColor();
    protected boolean isMousePressed = false;
    protected boolean isInside = false;
    protected boolean isInsideGroup = false;
    protected boolean isVisible = true;
    protected boolean isOpen = true;
    protected boolean isMoveable = true;
    protected Label _myLabel;
    protected Label _myValueLabel;
    protected int _myWidth = 99;
    protected int _myHeight = 9;
    protected boolean isUpdate;
    protected List<ControlWindowCanvas> _myControlCanvas;
    protected float _myValue;
    protected String _myStringValue;
    protected float[] _myArrayValue;
    protected boolean isCollapse = true;
    protected int _myPickingColor = 0x6600FFFF;
    protected PVector autoPosition = new PVector(10.0f, 30.0f, 0.0f);
    protected float tempAutoPositionHeight = 0.0f;
    protected float autoPositionOffsetX = 10.0f;
    private String _myAddress = "";
    private boolean mouseover;
    protected final T me;

    public ControllerGroup(ControlP5 theControlP5, String theName) {
        this(theControlP5, theControlP5.getDefaultTab(), theName, 0.0f, 0.0f);
        theControlP5.register(theControlP5.papplet, theName, this);
    }

    public ControllerGroup(ControlP5 theControlP5, ControllerGroup<?> theParent, String theName, float theX, float theY) {
        this.position = new PVector(theX, theY, 0.0f);
        this.cp5 = theControlP5;
        this.me = this;
        this.color.set(theParent == null ? ControlP5.color : theParent.color);
        this._myName = theName;
        this.controllers = new ControllerList();
        this._myControlCanvas = new ArrayList<ControlWindowCanvas>();
        this._myLabel = new Label(this.cp5, this._myName);
        this._myLabel.setColor(this.color.getCaptionLabel());
        this.setParent(theParent == null ? this : theParent);
    }

    protected ControllerGroup(int theX, int theY) {
        this.position = new PVector((float)theX, (float)theY, 0.0f);
        this.me = this;
        this.controllers = new ControllerList();
        this._myControlCanvas = new ArrayList<ControlWindowCanvas>();
    }

    @Override
    @ControlP5.Invisible
    public void init() {
    }

    @Override
    @ControlP5.Invisible
    public ControllerInterface<?> getParent() {
        return this._myParent;
    }

    void setParent(ControllerGroup<?> theParent) {
        if (this._myParent != null && this._myParent != this) {
            this._myParent.remove(this);
        }
        this._myParent = theParent;
        if (this._myParent != this) {
            this._myParent.add(this);
        }
        this.absolutePosition = new PVector(this.position.x, this.position.y);
        this.absolutePosition.add(this._myParent.absolutePosition);
        this.positionBuffer = new PVector(this.position.x, this.position.y);
        this._myControlWindow = this._myParent.getWindow();
        for (int i = 0; i < this.controllers.size(); ++i) {
            if (this.controllers.get(i) instanceof Controller) {
                ((Controller)this.controllers.get((int)i))._myControlWindow = this._myControlWindow;
                continue;
            }
            ((ControllerGroup)this.controllers.get((int)i))._myControlWindow = this._myControlWindow;
        }
        if (this._myControlWindow != null) {
            this.setMouseOver(false);
        }
    }

    public final T setGroup(ControllerGroup<?> theGroup) {
        this.setParent(theGroup);
        return this.me;
    }

    public final T setGroup(String theName) {
        this.setParent(this.cp5.getGroup(theName));
        return this.me;
    }

    @Override
    public final T moveTo(ControllerGroup<?> theGroup, Tab theTab, ControlWindow theControlWindow) {
        if (theGroup != null) {
            this.setGroup(theGroup);
            return this.me;
        }
        if (theControlWindow == null) {
            theControlWindow = this.cp5.controlWindow;
        }
        this.setTab(theControlWindow, theTab.getName());
        return this.me;
    }

    @Override
    public final T moveTo(ControllerGroup<?> theGroup) {
        this.moveTo(theGroup, null, null);
        return this.me;
    }

    public final T moveTo(Tab theTab) {
        this.moveTo(null, theTab, theTab.getWindow());
        return this.me;
    }

    public T moveTo(PApplet thePApplet) {
        this.moveTo(this.cp5.controlWindow);
        return this.me;
    }

    public T moveTo(ControlWindow theControlWindow) {
        this.moveTo(null, theControlWindow.getTab("default"), theControlWindow);
        return this.me;
    }

    public final T moveTo(String theTabName) {
        this.moveTo(null, this.cp5.controlWindow.getTab(theTabName), this.cp5.controlWindow);
        return this.me;
    }

    public final T moveTo(String theTabName, ControlWindow theControlWindow) {
        this.moveTo(null, theControlWindow.getTab(theTabName), theControlWindow);
        return this.me;
    }

    public final T moveTo(ControlWindow theControlWindow, String theTabName) {
        this.moveTo(null, theControlWindow.getTab(theTabName), theControlWindow);
        return this.me;
    }

    public final T moveTo(Tab theTab, ControlWindow theControlWindow) {
        this.moveTo(null, theTab, theControlWindow);
        return this.me;
    }

    public final T setTab(String theName) {
        this.setParent(this.cp5.getTab(theName));
        return this.me;
    }

    public final T setTab(ControlWindow theWindow, String theName) {
        this.setParent(this.cp5.getTab(theWindow, theName));
        return this.me;
    }

    public final T setTab(Tab theTab) {
        this.setParent(theTab);
        return this.me;
    }

    @Override
    public Tab getTab() {
        if (this instanceof Tab) {
            return (Tab)this;
        }
        if (this._myParent instanceof Tab) {
            return (Tab)this._myParent;
        }
        return this._myParent.getTab();
    }

    protected void updateFont(ControlFont theControlFont) {
        this._myLabel.updateFont(theControlFont);
        if (this._myValueLabel != null) {
            this._myValueLabel.updateFont(theControlFont);
        }
        for (int i = 0; i < this.controllers.size(); ++i) {
            if (this.controllers.get(i) instanceof Controller) {
                ((Controller)this.controllers.get(i)).updateFont(theControlFont);
                continue;
            }
            ((ControllerGroup)this.controllers.get(i)).updateFont(theControlFont);
        }
    }

    @Override
    @ControlP5.Invisible
    public PVector getAbsolutePosition() {
        return new PVector(this.absolutePosition.x, this.absolutePosition.y);
    }

    @Override
    @ControlP5.Invisible
    public T setAbsolutePosition(PVector thePVector) {
        this.absolutePosition.set(thePVector.x, thePVector.y, thePVector.z);
        return this.me;
    }

    @Override
    public PVector getPosition() {
        return new PVector(this.position.x, this.position.y);
    }

    @Override
    public T setPosition(float theX, float theY) {
        this.position.set((float)((int)theX), (float)((int)theY), 0.0f);
        this.positionBuffer.set(this.position);
        this.updateAbsolutePosition();
        return this.me;
    }

    @Override
    public T setPosition(PVector thePVector) {
        this.setPosition(thePVector.x, thePVector.y);
        return this.me;
    }

    @Override
    public T updateAbsolutePosition() {
        this.absolutePosition.set(this.position);
        this.absolutePosition.add(this._myParent.getAbsolutePosition());
        for (int i = 0; i < this.controllers.size(); ++i) {
            this.controllers.get(i).updateAbsolutePosition();
        }
        return this.me;
    }

    @Override
    @ControlP5.Invisible
    public void continuousUpdateEvents() {
        if (this.controllers.size() <= 0) {
            return;
        }
        for (int i = this.controllers.size() - 1; i >= 0; --i) {
            this.controllers.get(i).continuousUpdateEvents();
        }
    }

    @Override
    public T update() {
        if (this.controllers.size() <= 0) {
            return this.me;
        }
        for (int i = this.controllers.size() - 1; i >= 0; --i) {
            if (!this.controllers.get(i).isUpdate()) continue;
            this.controllers.get(i).update();
        }
        return this.me;
    }

    @Override
    public T setUpdate(boolean theFlag) {
        this.isUpdate = theFlag;
        for (int i = 0; i < this.controllers.size(); ++i) {
            this.controllers.get(i).setUpdate(theFlag);
        }
        return this.me;
    }

    @Override
    public boolean isUpdate() {
        return this.isUpdate;
    }

    @Override
    @ControlP5.Invisible
    public T updateEvents() {
        if (this.isOpen) {
            for (int i = this.controllers.size() - 1; i >= 0; --i) {
                this.controllers.get(i).updateEvents();
            }
        }
        if (this.isVisible && this.isMousePressed == this._myControlWindow.mouselock) {
            if (this.isMousePressed && this.cp5.keyHandler.isAltDown() && this.isMoveable) {
                if (!this.cp5.isMoveable) {
                    this.positionBuffer.x += (float)(this._myControlWindow.mouseX - this._myControlWindow.pmouseX);
                    this.positionBuffer.y += (float)(this._myControlWindow.mouseY - this._myControlWindow.pmouseY);
                    if (this.cp5.keyHandler.isShiftDown) {
                        this.position.x = (int)this.positionBuffer.x / 10 * 10;
                        this.position.y = (int)this.positionBuffer.y / 10 * 10;
                    } else {
                        this.position.set(this.positionBuffer);
                    }
                    this.updateAbsolutePosition();
                }
            } else {
                if (this.isInside) {
                    this.setMouseOver(true);
                }
                if (this.inside()) {
                    if (!this.isInside) {
                        this.isInside = true;
                        this.onEnter();
                        this.setMouseOver(true);
                    }
                } else if (this.isInside && !this.isMousePressed) {
                    this.onLeave();
                    this.isInside = false;
                    this.setMouseOver(false);
                }
            }
        }
        return this.me;
    }

    @Override
    @ControlP5.Invisible
    public T updateInternalEvents(PApplet theApplet) {
        return this.me;
    }

    @Override
    public boolean isMouseOver() {
        this.mouseover = this.isInside || this.isInsideGroup;
        return this.mouseover;
    }

    @Override
    public T setMouseOver(boolean theFlag) {
        this.mouseover = theFlag;
        if (!this.mouseover) {
            this.isInside = false;
            this.isInsideGroup = false;
            this._myControlWindow.removeMouseOverFor(this);
            for (int i = this.controllers.size() - 1; i >= 0; --i) {
                this.controllers.get(i).setMouseOver(false);
            }
        } else {
            this._myControlWindow.setMouseOverController(this);
        }
        return this.me;
    }

    @Override
    @ControlP5.Invisible
    public final void draw(PApplet theApplet) {
        if (this.isVisible) {
            theApplet.pushMatrix();
            theApplet.translate(this.position.x, this.position.y);
            this.preDraw(theApplet);
            this.drawControllers(theApplet);
            this.postDraw(theApplet);
            if (this._myValueLabel != null) {
                this._myValueLabel.draw(theApplet, 2, 2, this);
            }
            theApplet.popMatrix();
        }
    }

    protected void drawControllers(PApplet theApplet) {
        if (this.isOpen) {
            for (ControlWindowCanvas controlWindowCanvas : this._myControlCanvas) {
                if (controlWindowCanvas.mode() != 0) continue;
                controlWindowCanvas.draw(theApplet);
            }
            for (ControllerInterface controllerInterface : this.controllers.get()) {
                if (!controllerInterface.isVisible()) continue;
                controllerInterface.updateInternalEvents(theApplet);
                controllerInterface.draw(theApplet);
            }
            for (CDrawable cDrawable : this.controllers.getDrawables()) {
                cDrawable.draw(theApplet);
            }
            for (ControlWindowCanvas controlWindowCanvas : this._myControlCanvas) {
                if (controlWindowCanvas.mode() != 1) continue;
                controlWindowCanvas.draw(theApplet);
            }
        }
    }

    protected void preDraw(PApplet theApplet) {
    }

    protected void postDraw(PApplet theApplet) {
    }

    public ControlWindowCanvas addCanvas(ControlWindowCanvas theCanvas) {
        this._myControlCanvas.add(theCanvas);
        theCanvas.setup(this.cp5.papplet);
        return theCanvas;
    }

    public T removeCanvas(ControlWindowCanvas theCanvas) {
        this._myControlCanvas.remove(theCanvas);
        return this.me;
    }

    @Override
    public T add(ControllerInterface<?> theElement) {
        this.controllers.add(theElement);
        return this.me;
    }

    @Override
    public T bringToFront() {
        return this.bringToFront(this);
    }

    @Override
    public T bringToFront(ControllerInterface<?> theController) {
        if (this._myParent instanceof Tab) {
            this.moveTo((Tab)this._myParent);
        } else {
            this._myParent.bringToFront(theController);
        }
        if (theController != this && this.controllers.get().contains(theController)) {
            this.controllers.remove(theController);
            this.controllers.add(theController);
        }
        return this.me;
    }

    @Override
    public T remove(ControllerInterface<?> theElement) {
        if (theElement != null) {
            theElement.setMouseOver(false);
        }
        this.controllers.remove(theElement);
        return this.me;
    }

    @ControlP5.Invisible
    public T addDrawable(CDrawable theElement) {
        this.controllers.addDrawable(theElement);
        return this.me;
    }

    public T remove(CDrawable theElement) {
        this.controllers.removeDrawable(theElement);
        return this.me;
    }

    @Override
    public void remove() {
        this._myControlWindow.removeMouseOverFor(this);
        if (this._myParent != null) {
            this._myParent.remove(this);
        }
        if (this.cp5 != null) {
            this.cp5.remove(this);
        }
        for (int i = this.controllers.size() - 1; i >= 0; --i) {
            this.controllers.get(i).remove();
        }
        this.controllers.clear();
        this.controllers.clearDrawable();
        this.controllers = new ControllerList();
        if (this instanceof Tab) {
            this._myControlWindow.removeTab((Tab)this);
        }
    }

    @Override
    public String getName() {
        return this._myName;
    }

    @Override
    public String getAddress() {
        return this._myAddress;
    }

    @Override
    public T setAddress(String theAddress) {
        if (this._myAddress.length() == 0) {
            this._myAddress = theAddress;
        }
        return this.me;
    }

    @Override
    public ControlWindow getWindow() {
        return this._myControlWindow;
    }

    @Override
    @ControlP5.Invisible
    public void keyEvent(KeyEvent theEvent) {
        for (int i = 0; i < this.controllers.size(); ++i) {
            this.controllers.get(i).keyEvent(theEvent);
        }
    }

    @Override
    public boolean setMousePressed(boolean theStatus) {
        if (!this.isVisible) {
            return false;
        }
        for (int i = this.controllers.size() - 1; i >= 0; --i) {
            if (!this.controllers.get(i).setMousePressed(theStatus)) continue;
            return true;
        }
        if (theStatus) {
            if (this.isInside) {
                this.isMousePressed = true;
                this.mousePressed();
                return true;
            }
        } else if (this.isMousePressed) {
            this.isMousePressed = false;
            this.mouseReleased();
        }
        return false;
    }

    protected void mousePressed() {
    }

    protected void mouseReleased() {
    }

    protected void onEnter() {
    }

    protected void onLeave() {
    }

    protected void onScroll(int theAmount) {
    }

    @Override
    public T setId(int theId) {
        this._myId = theId;
        return this.me;
    }

    @Override
    public int getId() {
        return this._myId;
    }

    @Override
    public T setColor(CColor theColor) {
        for (ControllerInterface<?> ci : this.controllers.get()) {
            ci.setColor(theColor);
        }
        return this.me;
    }

    @Override
    public T setColorActive(int theColor) {
        this.color.setActive(theColor);
        for (ControllerInterface<?> ci : this.controllers.get()) {
            ci.setColorActive(theColor);
        }
        return this.me;
    }

    @Override
    public T setColorForeground(int theColor) {
        this.color.setForeground(theColor);
        for (ControllerInterface<?> ci : this.controllers.get()) {
            ci.setColorForeground(theColor);
        }
        return this.me;
    }

    @Override
    public T setColorBackground(int theColor) {
        this.color.setBackground(theColor);
        for (ControllerInterface<?> ci : this.controllers.get()) {
            ci.setColorBackground(theColor);
        }
        return this.me;
    }

    @Override
    public T setColorLabel(int theColor) {
        this.color.setCaptionLabel(theColor);
        if (this._myLabel != null) {
            this._myLabel.setColor(this.color.getCaptionLabel());
        }
        for (ControllerInterface<?> ci : this.controllers.get()) {
            ci.setColorLabel(theColor);
        }
        return this.me;
    }

    @Override
    public T setColorValue(int theColor) {
        this.color.setValueLabel(theColor);
        if (this._myValueLabel != null) {
            this._myValueLabel.setColor(this.color.getValueLabel());
        }
        for (ControllerInterface<?> ci : this.controllers.get()) {
            ci.setColorValue(theColor);
        }
        return this.me;
    }

    @Override
    public T setLabel(String theLabel) {
        this._myLabel.set(theLabel);
        return this.me;
    }

    @Override
    public boolean isVisible() {
        if (this._myParent != null && this._myParent != this && !this.getParent().isVisible()) {
            return false;
        }
        return this.isVisible;
    }

    public T setVisible(boolean theFlag) {
        this.isVisible = theFlag;
        return this.me;
    }

    @Override
    public T hide() {
        this.isVisible = false;
        return this.me;
    }

    @Override
    public T show() {
        this.isVisible = true;
        return this.me;
    }

    public T setMoveable(boolean theFlag) {
        this.isMoveable = theFlag;
        return this.me;
    }

    public boolean isMoveable() {
        return this.isMoveable;
    }

    public T setOpen(boolean theFlag) {
        this.isOpen = theFlag;
        return this.me;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public T open() {
        this.setOpen(true);
        return this.me;
    }

    public T close() {
        this.setOpen(false);
        return this.me;
    }

    @Override
    @ControlP5.Invisible
    public int getPickingColor() {
        return this._myPickingColor;
    }

    @Override
    public CColor getColor() {
        return this.color;
    }

    @Override
    public T setValue(float theValue) {
        this._myValue = theValue;
        return this.me;
    }

    @Override
    public float getValue() {
        return this._myValue;
    }

    @Override
    public String getStringValue() {
        return this._myStringValue;
    }

    @Override
    public T setStringValue(String theValue) {
        this._myStringValue = theValue;
        return this.me;
    }

    @Override
    public float[] getArrayValue() {
        return this._myArrayValue;
    }

    public T setArrayValue(float[] theArray) {
        this._myArrayValue = theArray;
        return this.me;
    }

    public Controller<?> getController(String theController) {
        return this.cp5.getController(theController);
    }

    public Label getCaptionLabel() {
        return this._myLabel;
    }

    public Label getValueLabel() {
        return this._myValueLabel;
    }

    public T enableCollapse() {
        this.isCollapse = true;
        return this.me;
    }

    public T disableCollapse() {
        this.isCollapse = false;
        return this.me;
    }

    public boolean isCollapse() {
        return this.isCollapse;
    }

    @Override
    public int getWidth() {
        return this._myWidth;
    }

    @Override
    public int getHeight() {
        return this._myHeight;
    }

    public T setWidth(int theWidth) {
        this._myWidth = theWidth;
        return this.me;
    }

    public T setHeight(int theHeight) {
        this._myHeight = theHeight;
        return this.me;
    }

    protected boolean inside() {
        return (float)this._myControlWindow.mouseX > this.position.x + this._myParent.absolutePosition.x && (float)this._myControlWindow.mouseX < this.position.x + this._myParent.absolutePosition.x + (float)this._myWidth && (float)this._myControlWindow.mouseY > this.position.y + this._myParent.absolutePosition.y - (float)this._myHeight && (float)this._myControlWindow.mouseY < this.position.y + this._myParent.absolutePosition.y;
    }

    @Override
    public ControllerProperty getProperty(String thePropertyName) {
        return this.cp5.getProperties().getProperty(this, thePropertyName);
    }

    @Override
    public ControllerProperty getProperty(String theSetter, String theGetter) {
        return this.cp5.getProperties().getProperty(this, theSetter, theGetter);
    }

    @Override
    public T registerProperty(String thePropertyName) {
        this.cp5.getProperties().register(this, thePropertyName);
        return this.me;
    }

    @Override
    public T registerProperty(String theSetter, String theGetter) {
        this.cp5.getProperties().register(this, theSetter, theGetter);
        return this.me;
    }

    @Override
    public T removeProperty(String thePropertyName) {
        this.cp5.getProperties().remove((ControllerInterface<?>)this, thePropertyName);
        return this.me;
    }

    @Override
    public T removeProperty(String theSetter, String theGetter) {
        this.cp5.getProperties().remove((ControllerInterface<?>)this, theSetter, theGetter);
        return this.me;
    }

    public String toString() {
        return this.getName() + " [" + this.getClass().getSimpleName() + "]";
    }

    public String getInfo() {
        return "type:\tControllerGroup\nname:\t" + this._myName + "\n" + "label:\t" + this._myLabel.getText() + "\n" + "id:\t" + this._myId + "\n" + "value:\t" + this._myValue + "\n" + "arrayvalue:\t" + ControlP5IOHandler.arrayToString(this._myArrayValue) + "\n" + "position:\t" + this.position + "\n" + "absolute:\t" + this.absolutePosition + "\n" + "width:\t" + this.getWidth() + "\n" + "height:\t" + this.getHeight() + "\n" + "color:\t" + this.getColor() + "\n" + "visible:\t" + this.isVisible + "\n" + "moveable:\t" + this.isMoveable + "\n";
    }

    @Deprecated
    public PVector absolutePosition() {
        return this.getAbsolutePosition();
    }

    @Deprecated
    public PVector position() {
        return this.getPosition();
    }

    @Deprecated
    public CColor color() {
        return this.color;
    }

    @Deprecated
    public float value() {
        return this._myValue;
    }

    @Override
    @Deprecated
    public String stringValue() {
        return this.getStringValue();
    }

    @Deprecated
    public float[] arrayValue() {
        return this.getArrayValue();
    }

    @Override
    @Deprecated
    public String name() {
        return this._myName;
    }

    @Override
    @Deprecated
    public int id() {
        return this._myId;
    }

    @Deprecated
    public Controller<?> controller(String theController) {
        return this.cp5.getController(theController);
    }

    @Override
    @ControlP5.Invisible
    @Deprecated
    public ControllerInterface<?> parent() {
        return this._myParent;
    }

    @Deprecated
    public Label captionLabel() {
        return this._myLabel;
    }

    @Deprecated
    public Label valueLabel() {
        return this._myValueLabel;
    }
}

