/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import processing.core.PVector;

class CRect {
    private float x;
    private float y;
    private float width;
    private float height;
    private float x0;
    private float y0;
    private float x1;
    private float y1;

    public CRect() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.width = 0.0f;
        this.height = 0.0f;
        this.x0 = 0.0f;
        this.x1 = 0.0f;
        this.y0 = 0.0f;
        this.y1 = 0.0f;
    }

    public CRect(float theX, float theY, float theWidth, float theHeight) {
        this.x = theX;
        this.y = theY;
        this.width = theWidth;
        this.height = theHeight;
        this.x0 = theX;
        this.y0 = theY;
        this.x1 = this.x0 + this.width;
        this.y1 = this.y0 + this.height;
    }

    public CRect(CRect theRect) {
        this.x = theRect.x;
        this.y = theRect.y;
        this.x0 = theRect.x0;
        this.y0 = theRect.y0;
        this.x1 = theRect.x1;
        this.y1 = theRect.y1;
        this.width = theRect.width;
        this.height = theRect.height;
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public float x0() {
        return this.x0;
    }

    public float y0() {
        return this.y0;
    }

    public float x1() {
        return this.x1;
    }

    public float y1() {
        return this.y1;
    }

    public void x(float theX) {
        this.x0 = this.x = theX;
        this.x1 = this.x + this.width;
    }

    public void y(float theY) {
        this.y0 = this.y = theY;
        this.y1 = this.y + this.height;
    }

    public void x0(float theX0) {
        this.x(theX0);
    }

    public void y0(float theY0) {
        this.y(theY0);
    }

    public void x1(float theX1) {
        this.x1 = theX1;
        this.width = this.x1 - this.x0;
    }

    public void y1(float theY1) {
        this.y1 = theY1;
        this.height = this.y1 - this.y0;
    }

    public float width() {
        return this.width;
    }

    public float height() {
        return this.height;
    }

    public void width(float theWidth) {
        this.width = theWidth;
        this.x1 = this.x + this.width;
    }

    public void height(float theHeight) {
        this.height = theHeight;
        this.y1 = this.y + this.height;
    }

    public String toString() {
        return this.x0 + " " + this.y0 + " " + this.x1 + " " + this.y1;
    }

    public static boolean inside(CRect theRect, PVector theVector) {
        return theVector.x > theRect.x0 && theVector.x < theRect.x1 && theVector.y > theRect.y0 && theVector.y < theRect.y1;
    }

    public static boolean inside(CRect theRect, float theX, float theY) {
        return theX > theRect.x0 && theX < theRect.x1 && theY > theRect.y0 && theY < theRect.y1;
    }
}

