/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.ControllerView;
import controlP5.Tab;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Button
extends Controller<Button> {
    protected boolean isPressed;
    protected boolean isOn = false;
    public static int autoWidth = 69;
    public static int autoHeight = 19;
    protected int activateBy = 1;
    protected boolean isSwitch = false;

    public Button(ControlP5 theControlP5, String theName) {
        this(theControlP5, theControlP5.getDefaultTab(), theName, 0.0f, 0, 0, autoWidth, autoHeight);
        theControlP5.register(theControlP5.papplet, theName, this);
    }

    protected Button(ControlP5 theControlP5, ControllerGroup<?> theParent, String theName, float theDefaultValue, int theX, int theY, int theWidth, int theHeight) {
        super(theControlP5, theParent, theName, theX, theY, theWidth, theHeight);
        this._myValue = theDefaultValue;
        this._myCaptionLabel.align(37, 3);
    }

    public Button() {
        super(null, null, null, 0.0f, 0.0f, 1, 1);
    }

    @Override
    protected void onEnter() {
        this.isActive = true;
    }

    @Override
    protected void onLeave() {
        this.isActive = false;
    }

    @Override
    @ControlP5.Invisible
    public void mousePressed() {
        this.isActive = this.getIsInside();
        this.isPressed = true;
        if (this.activateBy == 2) {
            this.activate();
        }
    }

    @Override
    @ControlP5.Invisible
    public void mouseReleased() {
        this.isPressed = false;
        if (this.activateBy == 1) {
            this.activate();
        }
        this.isActive = false;
    }

    public Button activateBy(int theValue) {
        this.activateBy = theValue == 2 ? 2 : 1;
        return this;
    }

    protected void activate() {
        if (this.isActive) {
            this.isActive = false;
            if (this.getParent() instanceof Tab) {
                this.setIsInside(false);
            }
            this.isOn = !this.isOn;
            this.setValue(this._myValue);
        }
    }

    @Override
    @ControlP5.Invisible
    public void mouseReleasedOutside() {
        this.mouseReleased();
    }

    @Override
    public Button setValue(float theValue) {
        this._myValue = theValue;
        this.broadcast(2);
        return this;
    }

    @Override
    public Button update() {
        return this.setValue(this._myValue);
    }

    public Button setSwitch(boolean theFlag) {
        this.isSwitch = theFlag;
        return this;
    }

    public Button setOn() {
        if (this.isSwitch) {
            this.isOn = false;
            this.isActive = true;
            this.activate();
        }
        return this;
    }

    public Button setOff() {
        if (this.isSwitch) {
            this.isOn = true;
            this.isActive = true;
            this.activate();
        }
        return this;
    }

    public boolean isOn() {
        return this.isOn;
    }

    public boolean isPressed() {
        return this.isPressed;
    }

    public boolean getBooleanValue() {
        return this.isOn;
    }

    @Override
    @ControlP5.Invisible
    public Button updateDisplayMode(int theMode) {
        return this.updateViewMode(theMode);
    }

    @ControlP5.Invisible
    public Button updateViewMode(int theMode) {
        this._myDisplayMode = theMode;
        switch (theMode) {
            case 0: {
                this._myControllerView = new ButtonView();
                break;
            }
            case 1: {
                this._myControllerView = new ButtonImageView();
                break;
            }
            case 2: {
                this._myControllerView = new ButtonSpriteView();
                break;
            }
        }
        return this;
    }

    @Override
    public String getInfo() {
        return "type:\tButton\n" + super.getInfo();
    }

    @Override
    public String toString() {
        return super.toString() + " [ " + this.getValue() + " ] " + "Button" + " (" + this.getClass().getSuperclass() + ")";
    }

    @Deprecated
    public boolean booleanValue() {
        return this.isOn;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    private class ButtonSpriteView
    implements ControllerView<Button> {
        private ButtonSpriteView() {
        }

        @Override
        public void display(PApplet theApplet, Button theController) {
            if (Button.this.isOn && Button.this.isSwitch) {
                Button.this.sprite.setState(2);
            } else if (Button.this.isActive) {
                if (Button.this.isPressed) {
                    Button.this.sprite.setState(2);
                } else {
                    Button.this.sprite.setState(1);
                }
            } else {
                Button.this.sprite.setState(0);
            }
            theApplet.fill(0);
            Button.this.sprite.draw(theApplet);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ButtonImageView
    implements ControllerView<Button> {
        private ButtonImageView() {
        }

        @Override
        public void display(PApplet theApplet, Button theController) {
            if (Button.this.isOn && Button.this.isSwitch) {
                theApplet.image(Button.this.availableImages[3] ? Button.this.images[3] : Button.this.images[0], 0.0f, 0.0f);
                return;
            }
            if (Button.this.getIsInside()) {
                if (Button.this.isPressed) {
                    theApplet.image(Button.this.availableImages[2] ? Button.this.images[2] : Button.this.images[0], 0.0f, 0.0f);
                } else {
                    theApplet.image(Button.this.availableImages[1] ? Button.this.images[1] : Button.this.images[0], 0.0f, 0.0f);
                }
            } else {
                theApplet.image(Button.this.images[0], 0.0f, 0.0f);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ButtonView
    implements ControllerView<Button> {
        private ButtonView() {
        }

        @Override
        public void display(PApplet theApplet, Button theController) {
            if (Button.this.isOn && Button.this.isSwitch) {
                theApplet.fill(Button.this.color.getActive());
            } else if (Button.this.getIsInside()) {
                if (Button.this.isPressed) {
                    theApplet.fill(Button.this.color.getActive());
                } else {
                    theApplet.fill(Button.this.color.getForeground());
                }
            } else {
                theApplet.fill(Button.this.color.getBackground());
            }
            theApplet.rect(0.0f, 0.0f, (float)Button.this.width, (float)Button.this.height);
            if (Button.this.isLabelVisible) {
                Button.this._myCaptionLabel.draw(theApplet, 0, 0, theController);
            }
        }
    }
}

