package br.com.minhavia.minhavia.view;

import android.Manifest;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;

import br.com.minhavia.minhavia.R;
import br.com.minhavia.minhavia.receive.AlarmFirebaseReceive;
import br.com.minhavia.minhavia.receive.AlarmGeoReceive;
import br.com.minhavia.minhavia.receive.AlarmReceive;
import br.com.minhavia.minhavia.util.Constantes;


public class MainActivity extends AppCompatActivity {

    AlarmManager alarmManager;
    PendingIntent pendingIntent;

    AlarmManager alarmManagerFirebase;
    PendingIntent pendingIntentFirebase;

    AlarmManager alarmManagerGeo;
    PendingIntent pendingIntentGeo;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        if (ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED && ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
            ActivityCompat.requestPermissions(this, new String[]{Manifest.permission.ACCESS_FINE_LOCATION}, 200);
        }
        if (alarmManager == null) {
            alarmManager = (AlarmManager) getSystemService(Context.ALARM_SERVICE);
            Intent intent = new Intent(this, AlarmReceive.class);
            pendingIntent = PendingIntent.getBroadcast(this, 0, intent, 0);
            alarmManager.setRepeating(AlarmManager.RTC_WAKEUP, System.currentTimeMillis(), Constantes.TIMER_REPEAT_LOCATION,
                    pendingIntent);
        }

        if (alarmManagerFirebase == null) {
            alarmManagerFirebase = (AlarmManager) getSystemService(Context.ALARM_SERVICE);
            Intent intent = new Intent(this, AlarmFirebaseReceive.class);
            pendingIntentFirebase = PendingIntent.getBroadcast(this, 0, intent, 0);
            alarmManagerFirebase.setRepeating(AlarmManager.RTC_WAKEUP, System.currentTimeMillis(), Constantes.TIMER_REPEAT_FIREBASE,
                    pendingIntentFirebase);
        }


        if (alarmManagerGeo == null) {
            alarmManagerGeo = (AlarmManager) getSystemService(Context.ALARM_SERVICE);
            Intent intent = new Intent(this, AlarmGeoReceive.class);
            pendingIntentGeo = PendingIntent.getBroadcast(this, 0, intent, 0);
            alarmManagerGeo.setRepeating(AlarmManager.RTC_WAKEUP, System.currentTimeMillis(), Constantes.TIMER_REPEAT_GEO,
                    pendingIntentGeo);
        }
    }
}
