package br.com.minhavia.minhavia.util;

public class CalcularDistancia {
    private final static double DISTANCIA_MINIMA_MESMO_PONTO = 1.50;

    private static Double distanciaEntrePontos(String latitudeOrigem, String longitudeOrigem, String latitudeDestino, String longitudeDestino) {

        Double chLat = Double.parseDouble(latitudeOrigem) - Double.parseDouble(latitudeDestino);
        Double chLon = Double.parseDouble(longitudeOrigem) - Double.parseDouble(longitudeDestino);

        Double diametroLatitude = chLat * (Math.PI / 180);
        Double diametroLongitude = chLon * (Math.PI / 180);

        Double raioLatitudeUnidade = chLat * (Math.PI / 180);
        Double raioLongitudePonto = chLon * (Math.PI / 180);

        Double a = Math.sin(diametroLatitude / 2) * Math.sin(diametroLatitude / 2) + Math.sin(diametroLongitude / 2) * Math.sin(diametroLongitude / 2) * Math.cos(raioLatitudeUnidade) * Math.cos(raioLongitudePonto);
        Double c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
        Double d = 6371 * c;
        return d;
    }

    public static boolean ehMesmoPonto(String latitudeOrigem, String longitudeOrigem, String latitudeDestino, String longitudeDestino){
        return distanciaEntrePontos(latitudeOrigem,longitudeOrigem,latitudeDestino,longitudeDestino) <= DISTANCIA_MINIMA_MESMO_PONTO;
    }

}
