package br.com.minhavia.minhavia.model;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.PrimaryKey;
import android.support.annotation.NonNull;
import android.util.Base64;

import java.io.Serializable;

@Entity(tableName = "pavimentoIrregular")
public class PavimentoIrregular implements Serializable, Cloneable{


    @PrimaryKey(autoGenerate = true)
    private int id;

    @NonNull
    @ColumnInfo(name = "latitude")
    private String latitude;

    @NonNull
    @ColumnInfo(name = "longitude")
    private String longitude;

    @ColumnInfo(name = "irregular")
    private boolean irregular = false;

    @NonNull
    @ColumnInfo(name = "velocidade")
    private double velocidade;

    @NonNull
    @ColumnInfo(name = "timestamp")
    private long timestamp;

    @ColumnInfo(name = "pais")
    private String pais;

    @ColumnInfo(name = "uf")
    private String uf;

    @ColumnInfo(name = "cidade")
    private String cidade;

    @ColumnInfo(name = "bairro")
    private String bairro;

    @ColumnInfo(name = "logradouro")
    private String logradouro;

    private int quantidadeOcorrencias = 0;

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return id;
    }

    @NonNull
    public String getLatitude() {
        return latitude;
    }

    public void setLatitude(@NonNull String latitude) {
        this.latitude = latitude;
    }

    @NonNull
    public String getLongitude() {
        return longitude;
    }

    public void setLongitude(@NonNull String longitude) {
        this.longitude = longitude;
    }

    public boolean isIrregular() {
        return irregular;
    }

    public void setIrregular(boolean irregular) {
        this.irregular = irregular;
    }

    @NonNull
    public double getVelocidade() {
        return velocidade;
    }

    public void setVelocidade(@NonNull double velocidade) {
        this.velocidade = velocidade;
    }

    @NonNull
    public long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(@NonNull long timestamp) {
        this.timestamp = timestamp;
    }

    public String getPais() {
        return pais;
    }

    public void setPais(String pais) {
        this.pais = pais;
    }

    public String getUf() {
        return uf;
    }

    public void setUf(String uf) {
        this.uf = uf;
    }

    public String getCidade() {
        return cidade;
    }

    public void setCidade(String cidade) {
        this.cidade = cidade;
    }

    public String getBairro() {
        return bairro;
    }

    public void setBairro(String bairro) {
        this.bairro = bairro;
    }

    public String getLogradouro() {
        return logradouro;
    }

    public void setLogradouro(String logradouro) {
        this.logradouro = logradouro;
    }

    public int getQuantidadeOcorrencias() {
        return quantidadeOcorrencias;
    }

    public void setQuantidadeOcorrencias(int quantidadeOcorrencias) {
        this.quantidadeOcorrencias = quantidadeOcorrencias;
    }

    public String getIdFirebase(){
        if(pais != null && uf != null && cidade != null && logradouro != null) {
            return cidade;
        }else{
            return null;
        }
    }

    public PavimentoIrregular getClone () {
        try {
            return (PavimentoIrregular)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
            return null;
        }
    }


}
