package br.com.minhavia.minhavia.dao;

import android.arch.persistence.room.Database;
import android.arch.persistence.room.Room;
import android.arch.persistence.room.RoomDatabase;
import android.content.Context;

import br.com.minhavia.minhavia.model.PavimentoIrregular;

@Database(entities = {PavimentoIrregular.class}, version = 1)
public abstract class PavimentoIrregularDatabase extends RoomDatabase{

    public abstract PavimentoIrregularDAO pavimentoIrregularDAO();

    private static PavimentoIrregularDatabase INSTANCE;

    public static PavimentoIrregularDatabase getDATABASE(final Context context){
        if(INSTANCE == null){
            synchronized (PavimentoIrregularDatabase.class){
                if(INSTANCE == null){
                    INSTANCE = Room.databaseBuilder(
                            context.getApplicationContext(),
                            PavimentoIrregularDatabase.class, "pavimentoIrregular.db")
                            .allowMainThreadQueries()
                            .build();
                }
            }
        }

        return INSTANCE;
    }
}
