package br.com.minhavia.minhavia.dao;

import android.arch.persistence.room.Dao;
import android.arch.persistence.room.Delete;
import android.arch.persistence.room.Insert;
import android.arch.persistence.room.Query;
import android.arch.persistence.room.Update;

import java.util.List;

import br.com.minhavia.minhavia.model.PavimentoIrregular;

@Dao
public interface PavimentoIrregularDAO {

    @Insert
    void insert(PavimentoIrregular pavimentoIrregular);

    @Update
    void update(PavimentoIrregular pavimentoIrregular);

    @Delete
    void delete(PavimentoIrregular pavimentoIrregular);

    @Query("DELETE FROM pavimentoIrregular WHERE irregular = :irregular")
    void deletePavimentos(boolean irregular);

    @Query("SELECT * FROM pavimentoIrregular")
    List<PavimentoIrregular> getAll();

    @Query("SELECT * FROM pavimentoIrregular WHERE cidade IS NULL LIMIT 50")
    List<PavimentoIrregular> getAllWithoutAddress();

    @Query("SELECT COUNT(*) FROM pavimentoIrregular")
    int count();

    @Query("SELECT * FROM pavimentoIrregular WHERE irregular = :irregular AND cidade IS NOT NULL LIMIT 50 ")
    List<PavimentoIrregular> getPavimentos(boolean irregular);
}
