package br.com.minhavia.minhavia.dao;

import android.arch.persistence.db.SupportSQLiteDatabase;
import android.arch.persistence.db.SupportSQLiteOpenHelper;
import android.arch.persistence.db.SupportSQLiteOpenHelper.Callback;
import android.arch.persistence.db.SupportSQLiteOpenHelper.Configuration;
import android.arch.persistence.room.DatabaseConfiguration;
import android.arch.persistence.room.InvalidationTracker;
import android.arch.persistence.room.RoomOpenHelper;
import android.arch.persistence.room.RoomOpenHelper.Delegate;
import android.arch.persistence.room.util.TableInfo;
import android.arch.persistence.room.util.TableInfo.Column;
import android.arch.persistence.room.util.TableInfo.ForeignKey;
import android.arch.persistence.room.util.TableInfo.Index;
import java.lang.IllegalStateException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.HashSet;

@SuppressWarnings("unchecked")
public class PavimentoIrregularDatabase_Impl extends PavimentoIrregularDatabase {
  private volatile PavimentoIrregularDAO _pavimentoIrregularDAO;

  @Override
  protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
    final SupportSQLiteOpenHelper.Callback _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(1) {
      @Override
      public void createAllTables(SupportSQLiteDatabase _db) {
        _db.execSQL("CREATE TABLE IF NOT EXISTS `pavimentoIrregular` (`id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `latitude` TEXT NOT NULL, `longitude` TEXT NOT NULL, `irregular` INTEGER NOT NULL, `velocidade` REAL NOT NULL, `timestamp` INTEGER NOT NULL, `pais` TEXT, `uf` TEXT, `cidade` TEXT, `bairro` TEXT, `logradouro` TEXT, `quantidadeOcorrencias` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
        _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, \"f9e7441b9bd0e327abe9a630c0e9e4bd\")");
      }

      @Override
      public void dropAllTables(SupportSQLiteDatabase _db) {
        _db.execSQL("DROP TABLE IF EXISTS `pavimentoIrregular`");
      }

      @Override
      protected void onCreate(SupportSQLiteDatabase _db) {
        if (mCallbacks != null) {
          for (int _i = 0, _size = mCallbacks.size(); _i < _size; _i++) {
            mCallbacks.get(_i).onCreate(_db);
          }
        }
      }

      @Override
      public void onOpen(SupportSQLiteDatabase _db) {
        mDatabase = _db;
        internalInitInvalidationTracker(_db);
        if (mCallbacks != null) {
          for (int _i = 0, _size = mCallbacks.size(); _i < _size; _i++) {
            mCallbacks.get(_i).onOpen(_db);
          }
        }
      }

      @Override
      protected void validateMigration(SupportSQLiteDatabase _db) {
        final HashMap<String, TableInfo.Column> _columnsPavimentoIrregular = new HashMap<String, TableInfo.Column>(12);
        _columnsPavimentoIrregular.put("id", new TableInfo.Column("id", "INTEGER", true, 1));
        _columnsPavimentoIrregular.put("latitude", new TableInfo.Column("latitude", "TEXT", true, 0));
        _columnsPavimentoIrregular.put("longitude", new TableInfo.Column("longitude", "TEXT", true, 0));
        _columnsPavimentoIrregular.put("irregular", new TableInfo.Column("irregular", "INTEGER", true, 0));
        _columnsPavimentoIrregular.put("velocidade", new TableInfo.Column("velocidade", "REAL", true, 0));
        _columnsPavimentoIrregular.put("timestamp", new TableInfo.Column("timestamp", "INTEGER", true, 0));
        _columnsPavimentoIrregular.put("pais", new TableInfo.Column("pais", "TEXT", false, 0));
        _columnsPavimentoIrregular.put("uf", new TableInfo.Column("uf", "TEXT", false, 0));
        _columnsPavimentoIrregular.put("cidade", new TableInfo.Column("cidade", "TEXT", false, 0));
        _columnsPavimentoIrregular.put("bairro", new TableInfo.Column("bairro", "TEXT", false, 0));
        _columnsPavimentoIrregular.put("logradouro", new TableInfo.Column("logradouro", "TEXT", false, 0));
        _columnsPavimentoIrregular.put("quantidadeOcorrencias", new TableInfo.Column("quantidadeOcorrencias", "INTEGER", true, 0));
        final HashSet<TableInfo.ForeignKey> _foreignKeysPavimentoIrregular = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesPavimentoIrregular = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoPavimentoIrregular = new TableInfo("pavimentoIrregular", _columnsPavimentoIrregular, _foreignKeysPavimentoIrregular, _indicesPavimentoIrregular);
        final TableInfo _existingPavimentoIrregular = TableInfo.read(_db, "pavimentoIrregular");
        if (! _infoPavimentoIrregular.equals(_existingPavimentoIrregular)) {
          throw new IllegalStateException("Migration didn't properly handle pavimentoIrregular(br.com.minhavia.minhavia.model.PavimentoIrregular).\n"
                  + " Expected:\n" + _infoPavimentoIrregular + "\n"
                  + " Found:\n" + _existingPavimentoIrregular);
        }
      }
    }, "f9e7441b9bd0e327abe9a630c0e9e4bd", "f4f872e835f8bc360a4cfb898828ed4a");
    final SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder(configuration.context)
        .name(configuration.name)
        .callback(_openCallback)
        .build();
    final SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
    return _helper;
  }

  @Override
  protected InvalidationTracker createInvalidationTracker() {
    return new InvalidationTracker(this, "pavimentoIrregular");
  }

  @Override
  public void clearAllTables() {
    super.assertNotMainThread();
    final SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
    try {
      super.beginTransaction();
      _db.execSQL("DELETE FROM `pavimentoIrregular`");
      super.setTransactionSuccessful();
    } finally {
      super.endTransaction();
      _db.query("PRAGMA wal_checkpoint(FULL)").close();
      if (!_db.inTransaction()) {
        _db.execSQL("VACUUM");
      }
    }
  }

  @Override
  public PavimentoIrregularDAO pavimentoIrregularDAO() {
    if (_pavimentoIrregularDAO != null) {
      return _pavimentoIrregularDAO;
    } else {
      synchronized(this) {
        if(_pavimentoIrregularDAO == null) {
          _pavimentoIrregularDAO = new PavimentoIrregularDAO_Impl(this);
        }
        return _pavimentoIrregularDAO;
      }
    }
  }
}
