package br.com.minhavia.minhavia.dao;

import android.arch.persistence.db.SupportSQLiteStatement;
import android.arch.persistence.room.EntityDeletionOrUpdateAdapter;
import android.arch.persistence.room.EntityInsertionAdapter;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomSQLiteQuery;
import android.arch.persistence.room.SharedSQLiteStatement;
import android.database.Cursor;
import br.com.minhavia.minhavia.model.PavimentoIrregular;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.List;

@SuppressWarnings("unchecked")
public class PavimentoIrregularDAO_Impl implements PavimentoIrregularDAO {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter __insertionAdapterOfPavimentoIrregular;

  private final EntityDeletionOrUpdateAdapter __deletionAdapterOfPavimentoIrregular;

  private final EntityDeletionOrUpdateAdapter __updateAdapterOfPavimentoIrregular;

  private final SharedSQLiteStatement __preparedStmtOfDeletePavimentos;

  public PavimentoIrregularDAO_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfPavimentoIrregular = new EntityInsertionAdapter<PavimentoIrregular>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `pavimentoIrregular`(`id`,`latitude`,`longitude`,`irregular`,`velocidade`,`timestamp`,`pais`,`uf`,`cidade`,`bairro`,`logradouro`,`quantidadeOcorrencias`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, PavimentoIrregular value) {
        stmt.bindLong(1, value.getId());
        if (value.getLatitude() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getLatitude());
        }
        if (value.getLongitude() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getLongitude());
        }
        final int _tmp;
        _tmp = value.isIrregular() ? 1 : 0;
        stmt.bindLong(4, _tmp);
        stmt.bindDouble(5, value.getVelocidade());
        stmt.bindLong(6, value.getTimestamp());
        if (value.getPais() == null) {
          stmt.bindNull(7);
        } else {
          stmt.bindString(7, value.getPais());
        }
        if (value.getUf() == null) {
          stmt.bindNull(8);
        } else {
          stmt.bindString(8, value.getUf());
        }
        if (value.getCidade() == null) {
          stmt.bindNull(9);
        } else {
          stmt.bindString(9, value.getCidade());
        }
        if (value.getBairro() == null) {
          stmt.bindNull(10);
        } else {
          stmt.bindString(10, value.getBairro());
        }
        if (value.getLogradouro() == null) {
          stmt.bindNull(11);
        } else {
          stmt.bindString(11, value.getLogradouro());
        }
        stmt.bindLong(12, value.getQuantidadeOcorrencias());
      }
    };
    this.__deletionAdapterOfPavimentoIrregular = new EntityDeletionOrUpdateAdapter<PavimentoIrregular>(__db) {
      @Override
      public String createQuery() {
        return "DELETE FROM `pavimentoIrregular` WHERE `id` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, PavimentoIrregular value) {
        stmt.bindLong(1, value.getId());
      }
    };
    this.__updateAdapterOfPavimentoIrregular = new EntityDeletionOrUpdateAdapter<PavimentoIrregular>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `pavimentoIrregular` SET `id` = ?,`latitude` = ?,`longitude` = ?,`irregular` = ?,`velocidade` = ?,`timestamp` = ?,`pais` = ?,`uf` = ?,`cidade` = ?,`bairro` = ?,`logradouro` = ?,`quantidadeOcorrencias` = ? WHERE `id` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, PavimentoIrregular value) {
        stmt.bindLong(1, value.getId());
        if (value.getLatitude() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getLatitude());
        }
        if (value.getLongitude() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getLongitude());
        }
        final int _tmp;
        _tmp = value.isIrregular() ? 1 : 0;
        stmt.bindLong(4, _tmp);
        stmt.bindDouble(5, value.getVelocidade());
        stmt.bindLong(6, value.getTimestamp());
        if (value.getPais() == null) {
          stmt.bindNull(7);
        } else {
          stmt.bindString(7, value.getPais());
        }
        if (value.getUf() == null) {
          stmt.bindNull(8);
        } else {
          stmt.bindString(8, value.getUf());
        }
        if (value.getCidade() == null) {
          stmt.bindNull(9);
        } else {
          stmt.bindString(9, value.getCidade());
        }
        if (value.getBairro() == null) {
          stmt.bindNull(10);
        } else {
          stmt.bindString(10, value.getBairro());
        }
        if (value.getLogradouro() == null) {
          stmt.bindNull(11);
        } else {
          stmt.bindString(11, value.getLogradouro());
        }
        stmt.bindLong(12, value.getQuantidadeOcorrencias());
        stmt.bindLong(13, value.getId());
      }
    };
    this.__preparedStmtOfDeletePavimentos = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM pavimentoIrregular WHERE irregular = ?";
        return _query;
      }
    };
  }

  @Override
  public void insert(PavimentoIrregular pavimentoIrregular) {
    __db.beginTransaction();
    try {
      __insertionAdapterOfPavimentoIrregular.insert(pavimentoIrregular);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void delete(PavimentoIrregular pavimentoIrregular) {
    __db.beginTransaction();
    try {
      __deletionAdapterOfPavimentoIrregular.handle(pavimentoIrregular);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(PavimentoIrregular pavimentoIrregular) {
    __db.beginTransaction();
    try {
      __updateAdapterOfPavimentoIrregular.handle(pavimentoIrregular);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void deletePavimentos(boolean irregular) {
    final SupportSQLiteStatement _stmt = __preparedStmtOfDeletePavimentos.acquire();
    __db.beginTransaction();
    try {
      int _argIndex = 1;
      final int _tmp;
      _tmp = irregular ? 1 : 0;
      _stmt.bindLong(_argIndex, _tmp);
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
      __preparedStmtOfDeletePavimentos.release(_stmt);
    }
  }

  @Override
  public List<PavimentoIrregular> getAll() {
    final String _sql = "SELECT * FROM pavimentoIrregular";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    final Cursor _cursor = __db.query(_statement);
    try {
      final int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
      final int _cursorIndexOfLatitude = _cursor.getColumnIndexOrThrow("latitude");
      final int _cursorIndexOfLongitude = _cursor.getColumnIndexOrThrow("longitude");
      final int _cursorIndexOfIrregular = _cursor.getColumnIndexOrThrow("irregular");
      final int _cursorIndexOfVelocidade = _cursor.getColumnIndexOrThrow("velocidade");
      final int _cursorIndexOfTimestamp = _cursor.getColumnIndexOrThrow("timestamp");
      final int _cursorIndexOfPais = _cursor.getColumnIndexOrThrow("pais");
      final int _cursorIndexOfUf = _cursor.getColumnIndexOrThrow("uf");
      final int _cursorIndexOfCidade = _cursor.getColumnIndexOrThrow("cidade");
      final int _cursorIndexOfBairro = _cursor.getColumnIndexOrThrow("bairro");
      final int _cursorIndexOfLogradouro = _cursor.getColumnIndexOrThrow("logradouro");
      final int _cursorIndexOfQuantidadeOcorrencias = _cursor.getColumnIndexOrThrow("quantidadeOcorrencias");
      final List<PavimentoIrregular> _result = new ArrayList<PavimentoIrregular>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final PavimentoIrregular _item;
        _item = new PavimentoIrregular();
        final int _tmpId;
        _tmpId = _cursor.getInt(_cursorIndexOfId);
        _item.setId(_tmpId);
        final String _tmpLatitude;
        _tmpLatitude = _cursor.getString(_cursorIndexOfLatitude);
        _item.setLatitude(_tmpLatitude);
        final String _tmpLongitude;
        _tmpLongitude = _cursor.getString(_cursorIndexOfLongitude);
        _item.setLongitude(_tmpLongitude);
        final boolean _tmpIrregular;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfIrregular);
        _tmpIrregular = _tmp != 0;
        _item.setIrregular(_tmpIrregular);
        final double _tmpVelocidade;
        _tmpVelocidade = _cursor.getDouble(_cursorIndexOfVelocidade);
        _item.setVelocidade(_tmpVelocidade);
        final long _tmpTimestamp;
        _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
        _item.setTimestamp(_tmpTimestamp);
        final String _tmpPais;
        _tmpPais = _cursor.getString(_cursorIndexOfPais);
        _item.setPais(_tmpPais);
        final String _tmpUf;
        _tmpUf = _cursor.getString(_cursorIndexOfUf);
        _item.setUf(_tmpUf);
        final String _tmpCidade;
        _tmpCidade = _cursor.getString(_cursorIndexOfCidade);
        _item.setCidade(_tmpCidade);
        final String _tmpBairro;
        _tmpBairro = _cursor.getString(_cursorIndexOfBairro);
        _item.setBairro(_tmpBairro);
        final String _tmpLogradouro;
        _tmpLogradouro = _cursor.getString(_cursorIndexOfLogradouro);
        _item.setLogradouro(_tmpLogradouro);
        final int _tmpQuantidadeOcorrencias;
        _tmpQuantidadeOcorrencias = _cursor.getInt(_cursorIndexOfQuantidadeOcorrencias);
        _item.setQuantidadeOcorrencias(_tmpQuantidadeOcorrencias);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<PavimentoIrregular> getAllWithoutAddress() {
    final String _sql = "SELECT * FROM pavimentoIrregular WHERE cidade IS NULL LIMIT 50";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    final Cursor _cursor = __db.query(_statement);
    try {
      final int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
      final int _cursorIndexOfLatitude = _cursor.getColumnIndexOrThrow("latitude");
      final int _cursorIndexOfLongitude = _cursor.getColumnIndexOrThrow("longitude");
      final int _cursorIndexOfIrregular = _cursor.getColumnIndexOrThrow("irregular");
      final int _cursorIndexOfVelocidade = _cursor.getColumnIndexOrThrow("velocidade");
      final int _cursorIndexOfTimestamp = _cursor.getColumnIndexOrThrow("timestamp");
      final int _cursorIndexOfPais = _cursor.getColumnIndexOrThrow("pais");
      final int _cursorIndexOfUf = _cursor.getColumnIndexOrThrow("uf");
      final int _cursorIndexOfCidade = _cursor.getColumnIndexOrThrow("cidade");
      final int _cursorIndexOfBairro = _cursor.getColumnIndexOrThrow("bairro");
      final int _cursorIndexOfLogradouro = _cursor.getColumnIndexOrThrow("logradouro");
      final int _cursorIndexOfQuantidadeOcorrencias = _cursor.getColumnIndexOrThrow("quantidadeOcorrencias");
      final List<PavimentoIrregular> _result = new ArrayList<PavimentoIrregular>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final PavimentoIrregular _item;
        _item = new PavimentoIrregular();
        final int _tmpId;
        _tmpId = _cursor.getInt(_cursorIndexOfId);
        _item.setId(_tmpId);
        final String _tmpLatitude;
        _tmpLatitude = _cursor.getString(_cursorIndexOfLatitude);
        _item.setLatitude(_tmpLatitude);
        final String _tmpLongitude;
        _tmpLongitude = _cursor.getString(_cursorIndexOfLongitude);
        _item.setLongitude(_tmpLongitude);
        final boolean _tmpIrregular;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfIrregular);
        _tmpIrregular = _tmp != 0;
        _item.setIrregular(_tmpIrregular);
        final double _tmpVelocidade;
        _tmpVelocidade = _cursor.getDouble(_cursorIndexOfVelocidade);
        _item.setVelocidade(_tmpVelocidade);
        final long _tmpTimestamp;
        _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
        _item.setTimestamp(_tmpTimestamp);
        final String _tmpPais;
        _tmpPais = _cursor.getString(_cursorIndexOfPais);
        _item.setPais(_tmpPais);
        final String _tmpUf;
        _tmpUf = _cursor.getString(_cursorIndexOfUf);
        _item.setUf(_tmpUf);
        final String _tmpCidade;
        _tmpCidade = _cursor.getString(_cursorIndexOfCidade);
        _item.setCidade(_tmpCidade);
        final String _tmpBairro;
        _tmpBairro = _cursor.getString(_cursorIndexOfBairro);
        _item.setBairro(_tmpBairro);
        final String _tmpLogradouro;
        _tmpLogradouro = _cursor.getString(_cursorIndexOfLogradouro);
        _item.setLogradouro(_tmpLogradouro);
        final int _tmpQuantidadeOcorrencias;
        _tmpQuantidadeOcorrencias = _cursor.getInt(_cursorIndexOfQuantidadeOcorrencias);
        _item.setQuantidadeOcorrencias(_tmpQuantidadeOcorrencias);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public int count() {
    final String _sql = "SELECT COUNT(*) FROM pavimentoIrregular";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    final Cursor _cursor = __db.query(_statement);
    try {
      final int _result;
      if(_cursor.moveToFirst()) {
        _result = _cursor.getInt(0);
      } else {
        _result = 0;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<PavimentoIrregular> getPavimentos(boolean irregular) {
    final String _sql = "SELECT * FROM pavimentoIrregular WHERE irregular = ? AND cidade IS NOT NULL LIMIT 50 ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final int _tmp;
    _tmp = irregular ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp);
    final Cursor _cursor = __db.query(_statement);
    try {
      final int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
      final int _cursorIndexOfLatitude = _cursor.getColumnIndexOrThrow("latitude");
      final int _cursorIndexOfLongitude = _cursor.getColumnIndexOrThrow("longitude");
      final int _cursorIndexOfIrregular = _cursor.getColumnIndexOrThrow("irregular");
      final int _cursorIndexOfVelocidade = _cursor.getColumnIndexOrThrow("velocidade");
      final int _cursorIndexOfTimestamp = _cursor.getColumnIndexOrThrow("timestamp");
      final int _cursorIndexOfPais = _cursor.getColumnIndexOrThrow("pais");
      final int _cursorIndexOfUf = _cursor.getColumnIndexOrThrow("uf");
      final int _cursorIndexOfCidade = _cursor.getColumnIndexOrThrow("cidade");
      final int _cursorIndexOfBairro = _cursor.getColumnIndexOrThrow("bairro");
      final int _cursorIndexOfLogradouro = _cursor.getColumnIndexOrThrow("logradouro");
      final int _cursorIndexOfQuantidadeOcorrencias = _cursor.getColumnIndexOrThrow("quantidadeOcorrencias");
      final List<PavimentoIrregular> _result = new ArrayList<PavimentoIrregular>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final PavimentoIrregular _item;
        _item = new PavimentoIrregular();
        final int _tmpId;
        _tmpId = _cursor.getInt(_cursorIndexOfId);
        _item.setId(_tmpId);
        final String _tmpLatitude;
        _tmpLatitude = _cursor.getString(_cursorIndexOfLatitude);
        _item.setLatitude(_tmpLatitude);
        final String _tmpLongitude;
        _tmpLongitude = _cursor.getString(_cursorIndexOfLongitude);
        _item.setLongitude(_tmpLongitude);
        final boolean _tmpIrregular;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfIrregular);
        _tmpIrregular = _tmp_1 != 0;
        _item.setIrregular(_tmpIrregular);
        final double _tmpVelocidade;
        _tmpVelocidade = _cursor.getDouble(_cursorIndexOfVelocidade);
        _item.setVelocidade(_tmpVelocidade);
        final long _tmpTimestamp;
        _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
        _item.setTimestamp(_tmpTimestamp);
        final String _tmpPais;
        _tmpPais = _cursor.getString(_cursorIndexOfPais);
        _item.setPais(_tmpPais);
        final String _tmpUf;
        _tmpUf = _cursor.getString(_cursorIndexOfUf);
        _item.setUf(_tmpUf);
        final String _tmpCidade;
        _tmpCidade = _cursor.getString(_cursorIndexOfCidade);
        _item.setCidade(_tmpCidade);
        final String _tmpBairro;
        _tmpBairro = _cursor.getString(_cursorIndexOfBairro);
        _item.setBairro(_tmpBairro);
        final String _tmpLogradouro;
        _tmpLogradouro = _cursor.getString(_cursorIndexOfLogradouro);
        _item.setLogradouro(_tmpLogradouro);
        final int _tmpQuantidadeOcorrencias;
        _tmpQuantidadeOcorrencias = _cursor.getInt(_cursorIndexOfQuantidadeOcorrencias);
        _item.setQuantidadeOcorrencias(_tmpQuantidadeOcorrencias);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }
}
