/*
VCC goes to 5V on the Arduino UNO (for power)
GND goes to Ground on Arduino UNO
D0 (MISO) goes to pin 12 on Arduino UNO
D1 (MOSI) goes to pin 11 on Arduino UNO
CLK goes to pin 13 on Arduino UNO
D3 (CS) goes to pin 10 on Arduino UNO
 */

#include <SD.h>                      // need to include the SD library
#include <SPI.h>
//#define SD_ChipSelectPin 53  //example uses hardware SS pin 53 on Mega2560
#define SD_ChipSelectPin 10  //using digital pin 4 on arduino nano 328
#include <TMRpcm.h>           //  also need to include this library...

TMRpcm tmrpcm;   // create an object for use in this sketch
#define SHAMASH 8
void setup()
{
  int i;
  tmrpcm.speakerPin = 9; //11 on Mega, 9 on Uno, Nano, etc

  //Serial.begin(9600);
  if (!SD.begin(SD_ChipSelectPin))
  { // see if the card is present and can be initialized:
    //Serial.println("INIT FAIL");
    return;   // don't do anything more if not
  }

  tmrpcm.setVolume(3);

  //Serial.println("INIT DONE");

  for (i = 0; i < 9; i++)
  {
    pinMode(i, OUTPUT);
  }

}

void loop()
{
  int i;
  static int PREV_STATE = 0;
  static int SW_STATE;
  static int light = 0;
  SW_STATE = analogRead(A0);
  Serial.println(SW_STATE);
  if (tmrpcm.isPlaying() == 0)
  {
    tmrpcm.play("1.wav");
  }
  if ((SW_STATE < 5) && (PREV_STATE == 0))
  {
    Serial.println("HI");
    PREV_STATE = 1;
    light = (light == 8 ? 0 : light + 1);
  }
  else if((SW_STATE >= 800) && (PREV_STATE == 1))
  {
    //light = (light == 8 ? 0 : light + 1);
    PREV_STATE = 0;
  }

  for (i = 0; i < light; i++)
  {
    digitalWrite(i, HIGH);
  }
  for (i = light; i < 9; i++)
  {
    digitalWrite(i, LOW);
  }
}
