/*
  MechLabWatch.cpp - Library for controlling the mechLab Watch.
  Created by Jonathan Hodgins, August 2, 2017.
*/

#include "MechLabsWatch.h"
#include "Arduino.h"

Watch::Watch(void)
{

}

void Watch::initilize(void)
{
  //set all dispaly column output values low
  PORTD=PORTD & B00001111;//set PD4-PD7 Low
  PORTB=PORTB & B11111011;//set PB2 Low
  //set display columns to input
  DDRD = DDRD & B00001111;//set PD4-PD7 as input
  DDRB = DDRB & B11111011;//set PB2 as input


  //set row values to low
  PORTB=PORTB & B11111100;//set PB0-PB2 Low
  PORTC=PORTC & B11110000;//set PC0-PC3 Low
  //set rows to output
  DDRB = DDRB | B00000011;//set PB0-PB1 as output
  DDRC = DDRC | B00001111;//set PC0-PC3 as output


}

void Watch::setTime(int hh,int mm)
{
  hours = hh;
  minutes = mm;
}

void Watch::showTime(void)
{
  bool ledsRaw[28]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

  switch(hours%12)
  {
    case 12:
      ledsRaw[0]=1;
      break;
    case 0:
      ledsRaw[0]=1;
      break;
    case 1:
      ledsRaw[1]=1;
      break;
    case 2:
      ledsRaw[2]=1;
      break;
    case 3:
      ledsRaw[3]=1;
      break;
    case 4:
      ledsRaw[4]=1;
      break;
    case 5:
      ledsRaw[5]=1;
      break;
    case 6:
      ledsRaw[17]=1;
      break;
    case 7:
      ledsRaw[16]=1;
      break;
    case 8:
      ledsRaw[15]=1;
      break;
    case 9:
      ledsRaw[14]=1;
      break;
    case 10:
      ledsRaw[13]=1;
      break;
    case 11:
      ledsRaw[12]=1;
      break;
  }
  switch(int(floor(minutes/5)))
  {
    case 12:
      ledsRaw[6]=1;
      break;
    case 0:
      ledsRaw[6]=1;
      break;
    case 1:
      ledsRaw[7]=1;
      break;
    case 2:
      ledsRaw[8]=1;
      break;
    case 3:
      ledsRaw[9]=1;
      break;
    case 4:
      ledsRaw[10]=1;
      break;
    case 5:
      ledsRaw[11]=1;
      break;
    case 6:
      ledsRaw[23]=1;
      break;
    case 7:
      ledsRaw[22]=1;
      break;
    case 8:
      ledsRaw[21]=1;
      break;
    case 9:
      ledsRaw[20]=1;
      break;
    case 10:
      ledsRaw[19]=1;
      break;
    case 11:
      ledsRaw[18]=1;
      break;
  }
  switch(minutes%5)
  {
    case 0:
      //do nothing
      break;
    case 1:
      ledsRaw[24]=1;
      break;
    case 2:
      ledsRaw[24]=1;
      ledsRaw[25]=1;
      break;
    case 3:
      ledsRaw[24]=1;
      ledsRaw[25]=1;
      ledsRaw[26]=1;
      break;
    case 4:
      ledsRaw[24]=1;
      ledsRaw[25]=1;
      ledsRaw[26]=1;
      ledsRaw[27]=1;
      break;
  }

  showRaw(ledsRaw);
}
  
void Watch::showRaw(bool leds[28])
{
  //pin arrangement:
  //          0    1    2    3    4 
  //         PD4  PD5  PD7  PD6  PB2  High to turn on
  // 0  PB1  H12  M12  H11  M11  sM1
  // 1  PB0  H1   M1   H10  M10  sM2
  // 2  PC0  H2   M2   H9   M9   sM3
  // 3  PC3  H3   M3   H8   M8   sM4
  // 4  PC2  H4   M4   H7   M7
  // 5  PC1  H5   M5   H6   M6
  // low to turn on

  //the leds input indexes the array as follows
  // H12 H1 H2 H3 H4 H5 M12 M1 M2 M3 M4 M5 H11 H10 H9 ...
  // H8 H7 H6 M11 M10 M9 M8 M7 M6 sM1 sM2 sM3 sM4
  // or [iCol*numRow+iRow]

  for(int iCol=0;iCol<numCol;iCol++)
  {
    //set row outputs to proper state for next column to display
    for(int iRow=0;iRow<numRow;iRow++)
    {
      setRow(iRow,leds[iCol*numRow+iRow]);
    }
    setColumn(iCol,columnOn);
    delayMicroseconds(ledOnTime);
    setColumn(iCol,columnOff);
  }
  
}
    
void Watch::setRow(int8_t row,boolean ledState)
{
  switch(row)
  {
    case 0://PB1
      if(ledState==HIGH)
        PORTB=PORTB | B00000010;//set PB1 High
      else
        PORTB=PORTB & B11111101;//set PB1 Low
      break;
    case 1://PB0
      if(ledState==HIGH)
        PORTB=PORTB | B00000001;//set PB0 High
      else
        PORTB=PORTB & B11111110;//set PB0 Low
      break;
    case 2://PC0
      if(ledState==HIGH)
        PORTC=PORTC | B00000001;//set PC0 High
      else
        PORTC=PORTC & B11111110;//set PC0 Low
      break;
    case 3://PC3
      if(ledState==HIGH)
        PORTC=PORTC | B00001000;//set PC3 High
      else
        PORTC=PORTC & B11110111;//set PC3 Low
      break;
    case 4://PC2
      if(ledState==HIGH)
        PORTC=PORTC | B00000100;//set PC2 High
      else
        PORTC=PORTC & B11111011;//set PC2 Low
      break;
    case 5://PC1
      if(ledState==HIGH)
        PORTC=PORTC | B00000010;//set PC1 High
      else
        PORTC=PORTC & B11111101;//set PC1 Low
      break;
  }
}

void Watch::setColumn(int8_t col,boolean turnOn)
{
  switch(col)
  {
   case 0://PD4
     if(turnOn)
       DDRD = DDRD | B00010000;//set PD4 as output
     else
       DDRD = DDRD & B11101111;//set PD4 as input
      break;
    case 1://PD5
     if(turnOn)
       DDRD = DDRD | B00100000;//set PD5 as output
     else
       DDRD = DDRD & B11011111;//set PD5 as input
      break;
    case 2://PD7
     if(turnOn)
       DDRD = DDRD | B10000000;//set PD7 as output
     else
       DDRD = DDRD & B01111111;//set PD7 as input
      break;
    case 3://PD6
     if(turnOn)
       DDRD = DDRD | B01000000;//set PD6 as output
     else
       DDRD = DDRD & B10111111;//set PD6 as input
      break;
    case 4://PB2
     if(turnOn)
       DDRB = DDRB | B00000100;//set PB2 as output
     else
       DDRB = DDRB & B11111011;//set PB2 as input
      break;
  }
}


