	title "LEDCard"
	LIST	P=16F57
	#include <p16f5x.inc>

	__CONFIG  _RC_OSC & _CP_OFF & _WDT_OFF 

temp equ 0x08;
mpos equ 0x09;
mlen equ 0x0a;
char  equ 0x0b;
clear equ 0x0c;
msgno equ 0x0d;
bttn  equ 0x0e;

col1 equ 0x11;
col2 equ 0x12;
col3 equ 0x13;
col4 equ 0x14;
col5 equ 0x15;
col6 equ 0x16;
col7 equ 0x17;
col8 equ 0x18;
col9 equ 0x19;
col10 equ 0x1a;
col11 equ 0x1b;
col12 equ 0x1c;
col13 equ 0x1d;
col14 equ 0x1e;
col15 equ 0x1f;

	ORG 0x7ff
	Goto Main

    ORG 0

Delay
    MOVLW 0x20
    MOVWF temp
L2  DECFSZ temp,1
    GOTO L2
    RETLW 00

Redraw
    MOVLW B'01111111'	; Prime Col Outputs for first column
    MOVWF PORTC
    MOVLW B'11111110'
    MOVWF PORTB

    MOVLW col1
    MOVWF FSR

L1  CLRF char			; Clear Row Outputs
    BTFSC INDF,0		; Load New Row Outputs;
    BSF  char,4
    BTFSC INDF,1
    BSF  char,3
    BTFSC INDF,2
    BSF  char,2
    BTFSC INDF,3
    BSF  char,1
    BTFSC INDF,4
    BSF  char,0

    MOVFW char
    MOVWF PORTA
    BCF  PORTB,0
    BTFSC char,4
    BSF  PORTB,0
    CALL Delay			; Pause so that it is seen
    CLRF PORTA
    BCF  PORTB,0

    BTFSS PORTB,1
    RETLW 00			; If finished all columns, then return	
    BSF STATUS,C
    RRF PORTC,f			; Go To Next Column
    BCF  PORTB,1		; This pre-clears bit 1, so that on rotate right, bit 0 (the top row driver) isn't active even for a fraction of a second
    RRF PORTB,f
    INCF FSR,f
	GOTO L1

BufLeft
    MOVFW col2
    MOVWF col1
    MOVFW col3
    MOVWF col2
    MOVFW col4
    MOVWF col3
    MOVFW col5
    MOVWF col4
    MOVFW col6
    MOVWF col5
    MOVFW col7
    MOVWF col6
    MOVFW col8
    MOVWF col7
    MOVFW col9
    MOVWF col8
    MOVFW col10
    MOVWF col9
    MOVFW col11
    MOVWF col10
    MOVFW col12
    MOVWF col11
    MOVFW col13
    MOVWF col12
    MOVFW col14
    MOVWF col13
    MOVFW col15
    MOVWF col14
    RETLW 00

MSG1LEN equ D'34';
Msg1
	addwf	PCL, 1
    retlw	B'00001' ;T
    retlw	B'11111'
    retlw	B'00001'
    retlw	B'01100' ;o
    retlw	B'10010'
    retlw	B'10010'
    retlw	B'01100'
    retlw	B'00000'
    retlw	B'11110' ;m
    retlw	B'00010'
    retlw	B'11100'
    retlw	B'00010'
    retlw	B'11100'
    retlw	B'00000'
    retlw	B'00000'
    retlw	B'01111' ;W
    retlw	B'10000'
    retlw	B'01110'
    retlw	B'10000'
    retlw	B'01111'
    retlw	B'00000'
    retlw	B'01100' ;a
    retlw	B'10010'
    retlw	B'10010'
    retlw	B'11100'
    retlw	B'00000'
    retlw	B'11110' ;r
    retlw	B'00100'
    retlw	B'00010'
    retlw	B'00000'
    retlw	B'01100' ;d
    retlw	B'10010'
    retlw	B'10010'
    retlw	B'11111'

    org 0x200
MSG2LEN equ D'130';
Msg2
	addwf   PCL,1
	retlw   B'01110' ;C
	retlw   B'10001'
	retlw   B'10001'
	retlw   B'00000'
	retlw   B'01110' ;u
	retlw   B'10000'
	retlw   B'10000'
	retlw   B'11110'
	retlw   B'00000'
	retlw   B'10100' ;s
	retlw   B'10110'
	retlw   B'11010'
	retlw   B'01010'
	retlw   B'00000'
	retlw   B'00010' ;t
	retlw   B'11111'
	retlw   B'00010'
    retlw   B'00000'
    retlw	B'01100' ;o
    retlw	B'10010'
    retlw	B'10010'
    retlw	B'01100'
    retlw	B'00000'
    retlw	B'11110' ;m
    retlw	B'00010'
    retlw	B'11100'
    retlw	B'00010'
    retlw	B'11100'
	retlw   B'00000'
	retlw   B'00000'
    retlw   B'11111' ;E
    retlw   B'10101'
    retlw   B'10101'
    retlw   B'00000'
    retlw   B'11111' ;l
    retlw   B'00000'
	retlw   B'01100' ;e
	retlw   B'10010'
	retlw   B'11010'
	retlw   B'10110'
    retlw	B'00000'
    retlw   B'01100' ;c
    retlw   B'10010'
    retlw   B'10010'
    retlw   B'00000'
	retlw   B'00010' ;t
	retlw   B'11111'
	retlw   B'00010'
    retlw   B'00000'
    retlw	B'11110' ;r
    retlw	B'00100'
    retlw	B'00010'
    retlw	B'00000'
    retlw	B'01100' ;o
    retlw	B'10010'
    retlw	B'10010'
    retlw	B'01100'
    retlw	B'00000'
	retlw   B'11110' ;n
	retlw   B'00010'
	retlw   B'00010'
	retlw   B'11100'
	retlw   B'00000'
	retlw   B'11101' ;i
	retlw   B'00000'
    retlw   B'01100' ;c
    retlw   B'10010'
    retlw   B'10010'
    retlw   B'00000'
	retlw   B'00000'
	retlw   B'11111' ;B
	retlw   B'10101'
	retlw   B'10101'
	retlw   B'01010'
	retlw   B'00000'
	retlw   B'01110' ;u
	retlw   B'10000'
	retlw   B'10000'
	retlw   B'11110'
	retlw   B'00000'
	retlw   B'10100' ;s
	retlw   B'10110'
	retlw   B'11010'
	retlw   B'01010'
	retlw   B'00000'
	retlw   B'11101' ;i
	retlw   B'00000'
	retlw   B'11110' ;n
	retlw   B'00010'
	retlw   B'00010'
	retlw   B'11100'
	retlw   B'00000'
	retlw   B'01100' ;e
	retlw   B'10010'
	retlw   B'11010'
	retlw   B'10110'
    retlw	B'00000'
	retlw   B'10100' ;s
	retlw   B'10110'
	retlw   B'11010'
	retlw   B'01010'
	retlw   B'00000'
	retlw   B'10100' ;s
	retlw   B'10110'
	retlw   B'11010'
	retlw   B'01010'
	retlw   B'00000'
	retlw   B'00000'
	retlw   B'01110' ;C
	retlw   B'10001'
	retlw   B'10001'
	retlw   B'00000'
    retlw	B'01100' ;a
    retlw	B'10010'
    retlw	B'10010'
    retlw	B'11100'
    retlw	B'00000'
    retlw	B'11110' ;r
    retlw	B'00100'
    retlw	B'00010'
    retlw	B'00000'
    retlw	B'01100' ;d
    retlw	B'10010'
    retlw	B'10010'
    retlw	B'11111'
    retlw	B'00000'
	retlw   B'10100' ;s
	retlw   B'10110'
	retlw   B'11010'
	retlw   B'01010'

    org 0x400
MSG3LEN equ D'118';
Msg3
	addwf   PCL,1
    retlw	B'01111' ;W
    retlw	B'10000'
    retlw	B'01110'
    retlw	B'10000'
    retlw	B'01111'
    retlw	B'00000'
    retlw	B'01111' ;W
    retlw	B'10000'
    retlw	B'01110'
    retlw	B'10000'
    retlw	B'01111'
    retlw	B'00000'
    retlw	B'01111' ;W
    retlw	B'10000'
    retlw	B'01110'
    retlw	B'10000'
    retlw	B'01111'
    retlw	B'00000'
	retlw   B'10000' ;.
	retlw   B'00000'
	retlw   B'11111' ;L
	retlw   B'10000'
	retlw   B'10000'
	retlw   B'00000'
	retlw   B'10001' ;I
	retlw   B'11111'
	retlw   B'10001'
	retlw   B'00000'
	retlw   B'01110' ;G
	retlw   B'10001'
	retlw   B'10101'
	retlw   B'11101'
	retlw   B'00000'
	retlw   B'11111' ;H
	retlw   B'00100'
	retlw   B'00100'
	retlw   B'11111'
	retlw   B'00000'
	retlw   B'00001' ;T
	retlw   B'11111'
	retlw   B'00001'
	retlw   B'00000'
	retlw   B'11111' ;B
	retlw   B'10101'
	retlw   B'10101'
	retlw   B'01010'
	retlw   B'00000'
	retlw   B'01110' ;O
	retlw   B'10001'
	retlw   B'10001'
	retlw   B'01110'
	retlw   B'00000'
	retlw   B'11011' ;X
	retlw   B'00100'
	retlw   B'00100'
	retlw   B'11011'
	retlw   B'00000'
	retlw   B'00001' ;T
	retlw   B'11111'
	retlw   B'00001'
    retlw   B'00000'
    retlw   B'11111' ;E
    retlw   B'10101'
    retlw   B'10101'
	retlw   B'00000'
	retlw   B'01110' ;C
	retlw   B'10001'
	retlw   B'10001'
	retlw   B'00000'
	retlw   B'11111' ;H
	retlw   B'00100'
	retlw   B'00100'
	retlw   B'11111'
	retlw   B'00000'
	retlw   B'11111' ;N
	retlw   B'00010'
	retlw   B'00100'
	retlw   B'11111'
	retlw   B'00000'
	retlw   B'01110' ;O
	retlw   B'10001'
	retlw   B'10001'
	retlw   B'01110'
	retlw   B'00000'
	retlw   B'11111' ;L
	retlw   B'10000'
	retlw   B'10000'
	retlw   B'00000'
	retlw   B'01110' ;O
	retlw   B'10001'
	retlw   B'10001'
	retlw   B'01110'
	retlw   B'00000'
	retlw   B'01110' ;G
	retlw   B'10001'
	retlw   B'10101'
	retlw   B'11101'
	retlw   B'00000'
    retlw   B'00011' ;Y
    retlw   B'11100'
    retlw   B'00011'
    retlw   B'00000'
	retlw   B'10000' ;.
	retlw   B'00000'
	retlw   B'01110' ;C
	retlw   B'10001'
	retlw   B'10001'
	retlw   B'00000'
	retlw   B'01110' ;O
	retlw   B'10001'
	retlw   B'10001'
	retlw   B'01110'
	retlw   B'00000'
	retlw   B'11111' ;M
	retlw   B'00010'
	retlw   B'00100'
	retlw   B'00010'
	retlw   B'11111'

    org 0x600
MSG4LEN equ D'123';
Msg4
	addwf   PCL,1
	retlw   B'10001' ;I
	retlw   B'11111'
	retlw   B'10001'
	retlw   B'00000'
	retlw   B'00000'
	retlw   B'11111' ;N
	retlw   B'00010'
	retlw   B'00100'
	retlw   B'11111'
	retlw   B'00000'
    retlw   B'11111' ;F
    retlw   B'00101'
    retlw   B'00101'
    retlw   B'00000'
	retlw   B'01110' ;O
	retlw   B'10001'
	retlw   B'10001'
	retlw   B'01110'
	retlw   B'00000'
    retlw   B'01110' ;@
    retlw   B'00001'
    retlw   B'01101'
    retlw   B'11011'
    retlw   B'01110'
    retlw   B'00000'
	retlw   B'11111' ;L
	retlw   B'10000'
	retlw   B'10000'
	retlw   B'00000'
	retlw   B'10001' ;I
	retlw   B'11111'
	retlw   B'10001'
	retlw   B'00000'
	retlw   B'01110' ;G
	retlw   B'10001'
	retlw   B'10101'
	retlw   B'11101'
	retlw   B'00000'
	retlw   B'11111' ;H
	retlw   B'00100'
	retlw   B'00100'
	retlw   B'11111'
	retlw   B'00000'
	retlw   B'00001' ;T
	retlw   B'11111'
	retlw   B'00001'
	retlw   B'00000'
	retlw   B'11111' ;B
	retlw   B'10101'
	retlw   B'10101'
	retlw   B'01010'
	retlw   B'00000'
	retlw   B'01110' ;O
	retlw   B'10001'
	retlw   B'10001'
	retlw   B'01110'
	retlw   B'00000'
	retlw   B'11011' ;X
	retlw   B'00100'
	retlw   B'00100'
	retlw   B'11011'
	retlw   B'00000'
	retlw   B'00001' ;T
	retlw   B'11111'
	retlw   B'00001'
    retlw   B'00000'
    retlw   B'11111' ;E
    retlw   B'10101'
    retlw   B'10101'
	retlw   B'00000'
	retlw   B'01110' ;C
	retlw   B'10001'
	retlw   B'10001'
	retlw   B'00000'
	retlw   B'11111' ;H
	retlw   B'00100'
	retlw   B'00100'
	retlw   B'11111'
	retlw   B'00000'
	retlw   B'11111' ;N
	retlw   B'00010'
	retlw   B'00100'
	retlw   B'11111'
	retlw   B'00000'
	retlw   B'01110' ;O
	retlw   B'10001'
	retlw   B'10001'
	retlw   B'01110'
	retlw   B'00000'
	retlw   B'11111' ;L
	retlw   B'10000'
	retlw   B'10000'
	retlw   B'00000'
	retlw   B'01110' ;O
	retlw   B'10001'
	retlw   B'10001'
	retlw   B'01110'
	retlw   B'00000'
	retlw   B'01110' ;G
	retlw   B'10001'
	retlw   B'10101'
	retlw   B'11101'
	retlw   B'00000'
    retlw   B'00011' ;Y
    retlw   B'11100'
    retlw   B'00011'
    retlw   B'00000'
	retlw   B'10000' ;.
	retlw   B'00000'
	retlw   B'01110' ;C
	retlw   B'10001'
	retlw   B'10001'
	retlw   B'00000'
	retlw   B'01110' ;O
	retlw   B'10001'
	retlw   B'10001'
	retlw   B'01110'
	retlw   B'00000'
	retlw   B'11111' ;M
	retlw   B'00010'
	retlw   B'00100'
	retlw   B'00010'
	retlw   B'11111'

    org 0x100

Main
	CLRF  PORTA
	MOVLW 0xfe          ; 0b11111110 (Bit 0 is a row driver, all the rest are columns)
    MOVWF PORTB
    MOVLW 0xff
    MOVWF PORTC
	MOVLW 0x00         	; Set all ports for output
	TRIS PORTA
	TRIS PORTB
	TRIS PORTC
L6
    MOVLW 0             ; Turn port A/B back to outputs
    TRIS PORTA
    TRIS PORTB
    BSF PORTB,1
    CALL Delay

    MOVLW 0xff			; Turn port A to inputs temporarily
    TRIS PORTA
    MOVFW PORTA
    ANDLW B'00001110'
    MOVWF bttn

    MOVLW 0x01
    TRIS PORTB
    BTFSC PORTB,0
    BSF bttn,4
    MOVFW bttn
    BTFSC STATUS,Z
    GOTO L6

    MOVLW 0             ; Turn port A/B back to outputs
    TRIS PORTA
    TRIS PORTB

ScrollMsg
    MOVLW col1;			; Clear display buffer
    MOVWF FSR;
L5  CLRF INDF 
    INCF FSR,F
    BTFSC FSR,4
    GOTO L5
    MOVLW col1
    MOVWF FSR			; Why is this needed?
    MOVLW 0xff
    MOVWF mpos
    BTFSC bttn,4
    MOVLW MSG1LEN
    BTFSC bttn,3
    MOVLW MSG2LEN
    BTFSC bttn,2
    MOVLW MSG3LEN
    BTFSC bttn,1
    MOVLW MSG4LEN
    MOVWF mlen
    DECF mlen,f
ScrollMsgLoop
    CALL BufLeft        ; Shift Buffer 1 place left
    INCF mpos,f    		; Get Next Char for buffer
    MOVFW mpos

    BTFSC bttn,4
    CALL Msg1
    BTFSS bttn,3
    GOTO X1
    BCF STATUS,6
    BSF STATUS,5
    CALL Msg2
    BCF STATUS,5
X1  BTFSS bttn,2
    GOTO X2
    BSF STATUS,6
    BCF STATUS,5
    CALL Msg3
    BCF STATUS,6
X2  BTFSS bttn,1
    GOTO X3
    BSF STATUS,6
    BSF STATUS,5
    CALL Msg4
    BCF STATUS,6
    BCF STATUS,5

X3  MOVWF col15
    CALL Redraw
    CALL Redraw
    CALL Redraw
    CALL Redraw
    CALL Redraw
    CALL Redraw
    CALL Redraw
    MOVFW mpos
    SUBWF mlen,w
    BTFSS STATUS,Z
    GOTO ScrollMsgLoop
    MOVLW D'15'			; Scroll out the message to blank again
    MOVWF clear
L3  CALL BufLeft
    CLRF col15
    CALL Redraw
    CALL Redraw
    CALL Redraw
    CALL Redraw
    CALL Redraw
    CALL Redraw
    CALL Redraw
    DECFSZ clear,f
	GOTO L3
L4  GOTO L6

    end
