/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.view.accessibility.CaptioningManager;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.internal.zzlh;
import com.google.android.gms.internal.zzlk;
import org.json.JSONException;
import org.json.JSONObject;

public final class TextTrackStyle {
    public static final float DEFAULT_FONT_SCALE = 1.0f;
    public static final int COLOR_UNSPECIFIED = 0;
    public static final int EDGE_TYPE_UNSPECIFIED = -1;
    public static final int EDGE_TYPE_NONE = 0;
    public static final int EDGE_TYPE_OUTLINE = 1;
    public static final int EDGE_TYPE_DROP_SHADOW = 2;
    public static final int EDGE_TYPE_RAISED = 3;
    public static final int EDGE_TYPE_DEPRESSED = 4;
    public static final int WINDOW_TYPE_UNSPECIFIED = -1;
    public static final int WINDOW_TYPE_NONE = 0;
    public static final int WINDOW_TYPE_NORMAL = 1;
    public static final int WINDOW_TYPE_ROUNDED = 2;
    public static final int FONT_FAMILY_UNSPECIFIED = -1;
    public static final int FONT_FAMILY_SANS_SERIF = 0;
    public static final int FONT_FAMILY_MONOSPACED_SANS_SERIF = 1;
    public static final int FONT_FAMILY_SERIF = 2;
    public static final int FONT_FAMILY_MONOSPACED_SERIF = 3;
    public static final int FONT_FAMILY_CASUAL = 4;
    public static final int FONT_FAMILY_CURSIVE = 5;
    public static final int FONT_FAMILY_SMALL_CAPITALS = 6;
    public static final int FONT_STYLE_UNSPECIFIED = -1;
    public static final int FONT_STYLE_NORMAL = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    public static final int FONT_STYLE_BOLD_ITALIC = 3;
    private float zzTc;
    private int zzTd;
    private int zzvc;
    private int zzTe;
    private int zzTf;
    private int zzTg;
    private int zzTh;
    private int zzTi;
    private String zzTj;
    private int zzTk;
    private int zzTl;
    private JSONObject zzRJ;

    public TextTrackStyle() {
        this.clear();
    }

    public void setFontScale(float fontScale) {
        this.zzTc = fontScale;
    }

    public float getFontScale() {
        return this.zzTc;
    }

    public void setForegroundColor(int foregroundColor) {
        this.zzTd = foregroundColor;
    }

    public int getForegroundColor() {
        return this.zzTd;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.zzvc = backgroundColor;
    }

    public int getBackgroundColor() {
        return this.zzvc;
    }

    public void setEdgeType(int edgeType) {
        if (edgeType < 0 || edgeType > 4) {
            throw new IllegalArgumentException("invalid edgeType");
        }
        this.zzTe = edgeType;
    }

    public int getEdgeType() {
        return this.zzTe;
    }

    public void setEdgeColor(int edgeColor) {
        this.zzTf = edgeColor;
    }

    public int getEdgeColor() {
        return this.zzTf;
    }

    public void setWindowType(int windowType) {
        if (windowType < 0 || windowType > 2) {
            throw new IllegalArgumentException("invalid windowType");
        }
        this.zzTg = windowType;
    }

    public int getWindowType() {
        return this.zzTg;
    }

    public void setWindowColor(int windowColor) {
        this.zzTh = windowColor;
    }

    public int getWindowColor() {
        return this.zzTh;
    }

    public void setWindowCornerRadius(int windowCornerRadius) {
        if (windowCornerRadius < 0) {
            throw new IllegalArgumentException("invalid windowCornerRadius");
        }
        this.zzTi = windowCornerRadius;
    }

    public int getWindowCornerRadius() {
        return this.zzTi;
    }

    public void setFontFamily(String fontFamily) {
        this.zzTj = fontFamily;
    }

    public String getFontFamily() {
        return this.zzTj;
    }

    public void setFontGenericFamily(int fontGenericFamily) {
        if (fontGenericFamily < 0 || fontGenericFamily > 6) {
            throw new IllegalArgumentException("invalid fontGenericFamily");
        }
        this.zzTk = fontGenericFamily;
    }

    public int getFontGenericFamily() {
        return this.zzTk;
    }

    public void setFontStyle(int fontStyle) {
        if (fontStyle < 0 || fontStyle > 3) {
            throw new IllegalArgumentException("invalid fontStyle");
        }
        this.zzTl = fontStyle;
    }

    public int getFontStyle() {
        return this.zzTl;
    }

    public void setCustomData(JSONObject customData) {
        this.zzRJ = customData;
    }

    public JSONObject getCustomData() {
        return this.zzRJ;
    }

    private void clear() {
        this.zzTc = 1.0f;
        this.zzTd = 0;
        this.zzvc = 0;
        this.zzTe = -1;
        this.zzTf = 0;
        this.zzTg = -1;
        this.zzTh = 0;
        this.zzTi = 0;
        this.zzTj = null;
        this.zzTk = -1;
        this.zzTl = -1;
        this.zzRJ = null;
    }

    public static TextTrackStyle fromSystemSettings(Context context) {
        TextTrackStyle textTrackStyle = new TextTrackStyle();
        if (!zzlk.zzoX()) {
            return textTrackStyle;
        }
        CaptioningManager captioningManager = (CaptioningManager)context.getSystemService("captioning");
        textTrackStyle.setFontScale(captioningManager.getFontScale());
        CaptioningManager.CaptionStyle captionStyle = captioningManager.getUserStyle();
        textTrackStyle.setBackgroundColor(captionStyle.backgroundColor);
        textTrackStyle.setForegroundColor(captionStyle.foregroundColor);
        switch (captionStyle.edgeType) {
            case 1: {
                textTrackStyle.setEdgeType(1);
                break;
            }
            case 2: {
                textTrackStyle.setEdgeType(2);
                break;
            }
            default: {
                textTrackStyle.setEdgeType(0);
            }
        }
        textTrackStyle.setEdgeColor(captionStyle.edgeColor);
        Typeface typeface = captionStyle.getTypeface();
        if (typeface != null) {
            if (Typeface.MONOSPACE.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(1);
            } else if (Typeface.SANS_SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(0);
            } else if (Typeface.SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(2);
            } else {
                textTrackStyle.setFontGenericFamily(0);
            }
            boolean bl = typeface.isBold();
            boolean bl2 = typeface.isItalic();
            if (bl && bl2) {
                textTrackStyle.setFontStyle(3);
            } else if (bl) {
                textTrackStyle.setFontStyle(1);
            } else if (bl2) {
                textTrackStyle.setFontStyle(2);
            } else {
                textTrackStyle.setFontStyle(0);
            }
        }
        return textTrackStyle;
    }

    public void zzf(JSONObject jSONObject) throws JSONException {
        String string2;
        this.clear();
        this.zzTc = (float)jSONObject.optDouble("fontScale", 1.0);
        this.zzTd = this.zzbz(jSONObject.optString("foregroundColor"));
        this.zzvc = this.zzbz(jSONObject.optString("backgroundColor"));
        if (jSONObject.has("edgeType")) {
            string2 = jSONObject.getString("edgeType");
            if ("NONE".equals(string2)) {
                this.zzTe = 0;
            } else if ("OUTLINE".equals(string2)) {
                this.zzTe = 1;
            } else if ("DROP_SHADOW".equals(string2)) {
                this.zzTe = 2;
            } else if ("RAISED".equals(string2)) {
                this.zzTe = 3;
            } else if ("DEPRESSED".equals(string2)) {
                this.zzTe = 4;
            }
        }
        this.zzTf = this.zzbz(jSONObject.optString("edgeColor"));
        if (jSONObject.has("windowType")) {
            string2 = jSONObject.getString("windowType");
            if ("NONE".equals(string2)) {
                this.zzTg = 0;
            } else if ("NORMAL".equals(string2)) {
                this.zzTg = 1;
            } else if ("ROUNDED_CORNERS".equals(string2)) {
                this.zzTg = 2;
            }
        }
        this.zzTh = this.zzbz(jSONObject.optString("windowColor"));
        if (this.zzTg == 2) {
            this.zzTi = jSONObject.optInt("windowRoundedCornerRadius", 0);
        }
        this.zzTj = jSONObject.optString("fontFamily", null);
        if (jSONObject.has("fontGenericFamily")) {
            string2 = jSONObject.getString("fontGenericFamily");
            if ("SANS_SERIF".equals(string2)) {
                this.zzTk = 0;
            } else if ("MONOSPACED_SANS_SERIF".equals(string2)) {
                this.zzTk = 1;
            } else if ("SERIF".equals(string2)) {
                this.zzTk = 2;
            } else if ("MONOSPACED_SERIF".equals(string2)) {
                this.zzTk = 3;
            } else if ("CASUAL".equals(string2)) {
                this.zzTk = 4;
            } else if ("CURSIVE".equals(string2)) {
                this.zzTk = 5;
            } else if ("SMALL_CAPITALS".equals(string2)) {
                this.zzTk = 6;
            }
        }
        if (jSONObject.has("fontStyle")) {
            string2 = jSONObject.getString("fontStyle");
            if ("NORMAL".equals(string2)) {
                this.zzTl = 0;
            } else if ("BOLD".equals(string2)) {
                this.zzTl = 1;
            } else if ("ITALIC".equals(string2)) {
                this.zzTl = 2;
            } else if ("BOLD_ITALIC".equals(string2)) {
                this.zzTl = 3;
            }
        }
        this.zzRJ = jSONObject.optJSONObject("customData");
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("fontScale", (double)this.zzTc);
            if (this.zzTd != 0) {
                jSONObject.put("foregroundColor", (Object)this.zzG(this.zzTd));
            }
            if (this.zzvc != 0) {
                jSONObject.put("backgroundColor", (Object)this.zzG(this.zzvc));
            }
            switch (this.zzTe) {
                case 0: {
                    jSONObject.put("edgeType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("edgeType", (Object)"OUTLINE");
                    break;
                }
                case 2: {
                    jSONObject.put("edgeType", (Object)"DROP_SHADOW");
                    break;
                }
                case 3: {
                    jSONObject.put("edgeType", (Object)"RAISED");
                    break;
                }
                case 4: {
                    jSONObject.put("edgeType", (Object)"DEPRESSED");
                    break;
                }
            }
            if (this.zzTf != 0) {
                jSONObject.put("edgeColor", (Object)this.zzG(this.zzTf));
            }
            switch (this.zzTg) {
                case 0: {
                    jSONObject.put("windowType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("windowType", (Object)"NORMAL");
                    break;
                }
                case 2: {
                    jSONObject.put("windowType", (Object)"ROUNDED_CORNERS");
                    break;
                }
            }
            if (this.zzTh != 0) {
                jSONObject.put("windowColor", (Object)this.zzG(this.zzTh));
            }
            if (this.zzTg == 2) {
                jSONObject.put("windowRoundedCornerRadius", this.zzTi);
            }
            if (this.zzTj != null) {
                jSONObject.put("fontFamily", (Object)this.zzTj);
            }
            switch (this.zzTk) {
                case 0: {
                    jSONObject.put("fontGenericFamily", (Object)"SANS_SERIF");
                    break;
                }
                case 1: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SANS_SERIF");
                    break;
                }
                case 2: {
                    jSONObject.put("fontGenericFamily", (Object)"SERIF");
                    break;
                }
                case 3: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SERIF");
                    break;
                }
                case 4: {
                    jSONObject.put("fontGenericFamily", (Object)"CASUAL");
                    break;
                }
                case 5: {
                    jSONObject.put("fontGenericFamily", (Object)"CURSIVE");
                    break;
                }
                case 6: {
                    jSONObject.put("fontGenericFamily", (Object)"SMALL_CAPITALS");
                    break;
                }
            }
            switch (this.zzTl) {
                case 0: {
                    jSONObject.put("fontStyle", (Object)"NORMAL");
                    break;
                }
                case 1: {
                    jSONObject.put("fontStyle", (Object)"BOLD");
                    break;
                }
                case 2: {
                    jSONObject.put("fontStyle", (Object)"ITALIC");
                    break;
                }
                case 3: {
                    jSONObject.put("fontStyle", (Object)"BOLD_ITALIC");
                    break;
                }
            }
            if (this.zzRJ != null) {
                jSONObject.put("customData", (Object)this.zzRJ);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    private String zzG(int n) {
        return String.format("#%02X%02X%02X%02X", Color.red((int)n), Color.green((int)n), Color.blue((int)n), Color.alpha((int)n));
    }

    private int zzbz(String string2) {
        if (string2 != null && string2.length() == 9 && string2.charAt(0) == '#') {
            try {
                int n = Integer.parseInt(string2.substring(1, 3), 16);
                int n2 = Integer.parseInt(string2.substring(3, 5), 16);
                int n3 = Integer.parseInt(string2.substring(5, 7), 16);
                int n4 = Integer.parseInt(string2.substring(7, 9), 16);
                return Color.argb((int)n4, (int)n, (int)n2, (int)n3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextTrackStyle)) {
            return false;
        }
        TextTrackStyle textTrackStyle = (TextTrackStyle)other;
        if (this.zzRJ == null != (textTrackStyle.zzRJ == null)) {
            return false;
        }
        if (this.zzRJ != null && textTrackStyle.zzRJ != null && !zzlh.zzd((Object)this.zzRJ, (Object)textTrackStyle.zzRJ)) {
            return false;
        }
        return this.zzTc == textTrackStyle.zzTc && this.zzTd == textTrackStyle.zzTd && this.zzvc == textTrackStyle.zzvc && this.zzTe == textTrackStyle.zzTe && this.zzTf == textTrackStyle.zzTf && this.zzTg == textTrackStyle.zzTg && this.zzTi == textTrackStyle.zzTi && zzf.zza(this.zzTj, textTrackStyle.zzTj) && this.zzTk == textTrackStyle.zzTk && this.zzTl == textTrackStyle.zzTl;
    }

    public int hashCode() {
        return zzt.hashCode((Object[])new Object[]{Float.valueOf(this.zzTc), this.zzTd, this.zzvc, this.zzTe, this.zzTf, this.zzTg, this.zzTh, this.zzTi, this.zzTj, this.zzTk, this.zzTl, this.zzRJ});
    }
}

