/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.app.Notification;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.support.v4.app.NotificationCompat;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.text.TextUtils;
import android.view.Display;
import com.google.android.gms.R;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.CastMediaControlIntent;
import com.google.android.gms.cast.CastRemoteDisplay;
import com.google.android.gms.cast.internal.zzl;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzu;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class CastRemoteDisplayLocalService
extends Service {
    private static final zzl zzQW = new zzl("CastRemoteDisplayLocalService");
    private static final int zzQX = R.id.cast_notification_id;
    private static final Object zzQY = new Object();
    private static AtomicBoolean zzQZ = new AtomicBoolean(false);
    private GoogleApiClient zzRa;
    private CastRemoteDisplay.CastRemoteDisplaySessionCallbacks zzRb;
    private String zzQv;
    private Callbacks zzRc;
    private zzb zzRd;
    private NotificationSettings zzRe;
    private Notification mNotification;
    private Boolean zzRf;
    private PendingIntent zzRg;
    private CastDevice zzRh;
    private Display zzRi;
    private Context zzRj;
    private ServiceConnection zzRk;
    private Handler mHandler;
    private MediaRouter zzRl;
    private final MediaRouter.Callback zzRm = new MediaRouter.Callback(){

        public void onRouteUnselected(MediaRouter router, MediaRouter.RouteInfo info) {
            zzQW.zzb("onRouteUnselected", new Object[0]);
            if (CastRemoteDisplayLocalService.this.zzRh == null) {
                zzQW.zzb("onRouteUnselected, no device was selected", new Object[0]);
                return;
            }
            CastDevice castDevice = CastDevice.getFromBundle(info.getExtras());
            if (!castDevice.getDeviceId().equals(CastRemoteDisplayLocalService.this.zzRh.getDeviceId())) {
                zzQW.zzb("onRouteUnselected, device does not match", new Object[0]);
                return;
            }
            CastRemoteDisplayLocalService.stopService();
        }
    };
    private static CastRemoteDisplayLocalService zzRn;
    private final IBinder zzRo = new zza();

    public IBinder onBind(Intent intent) {
        return this.zzRo;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        zzQW.zzb("onStartCommand", new Object[0]);
        return 2;
    }

    protected static void setDebugEnabled() {
        zzQW.zzS(true);
    }

    protected Display getDisplay() {
        return this.zzRi;
    }

    public abstract void onCreatePresentation(Display var1);

    public abstract void onDismissPresentation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CastRemoteDisplayLocalService getInstance() {
        Object object = zzQY;
        synchronized (object) {
            return zzRn;
        }
    }

    public static void startService(final Context activityContext, Class<? extends CastRemoteDisplayLocalService> serviceClass, final String applicationId, final CastDevice device, final NotificationSettings notificationSettings, final Callbacks callbacks) {
        zzQW.zzb("Starting Service", new Object[0]);
        CastRemoteDisplayLocalService.zzb(activityContext, serviceClass);
        zzu.zzb((Object)activityContext, (Object)"activityContext is required.");
        zzu.zzb(serviceClass, (Object)"serviceClass is required.");
        zzu.zzb((Object)applicationId, (Object)"applicationId is required.");
        zzu.zzb((Object)device, (Object)"device is required.");
        zzu.zzb((Object)notificationSettings, (Object)"notificationSettings is required.");
        zzu.zzb((Object)callbacks, (Object)"callbacks is required.");
        if (notificationSettings.mNotification == null && notificationSettings.zzRv == null) {
            throw new IllegalArgumentException("notificationSettings: Either the notification or the notificationPendingIntent must be provided");
        }
        if (zzQZ.getAndSet(true)) {
            zzQW.zzc("Service is already being started, startService has been called twice", new Object[0]);
            return;
        }
        Intent intent = new Intent(activityContext, serviceClass);
        activityContext.startService(intent);
        activityContext.bindService(intent, new ServiceConnection(){

            public void onServiceConnected(ComponentName className, IBinder binder) {
                CastRemoteDisplayLocalService castRemoteDisplayLocalService = ((zza)binder).zzlp();
                if (castRemoteDisplayLocalService != null) {
                    castRemoteDisplayLocalService.zza(applicationId, device, notificationSettings, activityContext, this, callbacks);
                } else {
                    zzQW.zzc("Connected but unable to get the service instance", new Object[0]);
                    callbacks.onRemoteDisplaySessionError(new Status(2200));
                    zzQZ.set(false);
                    activityContext.unbindService((ServiceConnection)this);
                }
            }

            public void onServiceDisconnected(ComponentName arg0) {
                zzQW.zzb("onServiceDisconnected", new Object[0]);
                callbacks.onRemoteDisplaySessionError(new Status(2201, "Service Disconnected"));
                zzQZ.set(false);
                activityContext.unbindService((ServiceConnection)this);
            }
        }, 64);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zzM(boolean bl) {
        CastRemoteDisplayLocalService castRemoteDisplayLocalService;
        zzQW.zzb("Stopping Service", new Object[0]);
        zzQZ.set(false);
        Object object = zzQY;
        synchronized (object) {
            if (zzRn == null) {
                zzQW.zzc("Service is already being stopped", new Object[0]);
                return;
            }
            castRemoteDisplayLocalService = zzRn;
            zzRn = null;
        }
        if (!bl && castRemoteDisplayLocalService.zzRl != null) {
            zzQW.zzb("Setting default route", new Object[0]);
            castRemoteDisplayLocalService.zzRl.selectRoute(castRemoteDisplayLocalService.zzRl.getDefaultRoute());
        }
        if (castRemoteDisplayLocalService.zzRd != null) {
            zzQW.zzb("Unregistering notification receiver", new Object[0]);
            castRemoteDisplayLocalService.unregisterReceiver(castRemoteDisplayLocalService.zzRd);
        }
        castRemoteDisplayLocalService.zzlk();
        castRemoteDisplayLocalService.zzll();
        castRemoteDisplayLocalService.zzlg();
        if (castRemoteDisplayLocalService.zzRj != null && castRemoteDisplayLocalService.zzRk != null) {
            castRemoteDisplayLocalService.zzRj.unbindService(castRemoteDisplayLocalService.zzRk);
            castRemoteDisplayLocalService.zzRk = null;
            castRemoteDisplayLocalService.zzRj = null;
        }
        castRemoteDisplayLocalService.zzRc = null;
        castRemoteDisplayLocalService.zzQv = null;
        castRemoteDisplayLocalService.zzRa = null;
        castRemoteDisplayLocalService.zzRh = null;
        castRemoteDisplayLocalService.zzRe = null;
        castRemoteDisplayLocalService.mNotification = null;
        castRemoteDisplayLocalService.zzRi = null;
    }

    public static void stopService() {
        CastRemoteDisplayLocalService.zzM(false);
    }

    public void updateNotificationSettings(NotificationSettings notificationSettings) {
        zzu.zzb((Object)notificationSettings, (Object)"notificationSettings is required.");
        if (this.zzRf.booleanValue()) {
            if (notificationSettings.mNotification != null) {
                throw new IllegalStateException("Current mode is default notification, notification attribute must not be provided");
            }
            if (notificationSettings.zzRv != null) {
                this.zzRe.zzRv = notificationSettings.zzRv;
            }
            if (!TextUtils.isEmpty((CharSequence)notificationSettings.zzRw)) {
                this.zzRe.zzRw = notificationSettings.zzRw;
            }
            if (!TextUtils.isEmpty((CharSequence)notificationSettings.zzRx)) {
                this.zzRe.zzRx = notificationSettings.zzRx;
            }
            this.mNotification = this.zzN(true);
        } else {
            zzu.zzb((Object)notificationSettings.mNotification, (Object)"notification is required.");
            this.mNotification = notificationSettings.mNotification;
            this.zzRe.mNotification = this.mNotification;
        }
        this.startForeground(zzQX, this.mNotification);
    }

    public void onCreate() {
        super.onCreate();
        this.zzRb = new CastRemoteDisplay.CastRemoteDisplaySessionCallbacks(){

            @Override
            public void onRemoteDisplayEnded(Status status) {
                zzQW.zzb(String.format("Cast screen has ended: %d", status.getStatusCode()), new Object[0]);
                if (CastRemoteDisplayLocalService.this.mHandler != null) {
                    CastRemoteDisplayLocalService.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            CastRemoteDisplayLocalService.zzM(false);
                        }
                    });
                }
            }
        };
    }

    private static void zzb(Context context, Class clazz) {
        try {
            ComponentName componentName = new ComponentName(context, clazz);
            ServiceInfo serviceInfo = context.getPackageManager().getServiceInfo(componentName, 128);
            if (serviceInfo != null && serviceInfo.exported) {
                throw new IllegalStateException("The service must not be exported, verify the manifest configuration");
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new IllegalStateException("Service not found, did you forget to configure it in the manifest?");
        }
    }

    private void zza(Display display) {
        this.zzRi = display;
        if (this.zzRf.booleanValue()) {
            this.mNotification = this.zzN(true);
        }
        if (this.zzRc != null) {
            this.zzRc.onRemoteDisplaySessionStarted(this);
            this.zzRc = null;
        }
        this.onCreatePresentation(this.zzRi);
    }

    private void zzlg() {
        if (this.zzRl != null) {
            zzu.zzbY((String)"CastRemoteDisplayLocalService calls must be done on the main thread");
            this.zzRl.removeCallback(this.zzRm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(String string2, CastDevice castDevice, NotificationSettings notificationSettings, Context context, ServiceConnection serviceConnection, Callbacks callbacks) {
        zzQW.zzb("startRemoteDisplaySession", new Object[0]);
        zzu.zzbY((String)"Starting the Cast Remote Display must be done on the main thread");
        Object object = zzQY;
        synchronized (object) {
            if (zzRn != null) {
                CastRemoteDisplayLocalService.zzM(true);
                zzQW.zzf("An existing service had not been stopped before starting one", new Object[0]);
            }
            zzRn = this;
        }
        this.zzRc = callbacks;
        this.zzQv = string2;
        this.zzRh = castDevice;
        this.zzRj = context;
        this.zzRk = serviceConnection;
        this.zzRl = MediaRouter.getInstance((Context)this.getApplicationContext());
        object = new MediaRouteSelector.Builder().addControlCategory(CastMediaControlIntent.categoryForCast(this.zzQv)).build();
        this.zzRl.addCallback((MediaRouteSelector)object, this.zzRm, 4);
        this.mHandler = new Handler(this.getMainLooper());
        this.mNotification = notificationSettings.mNotification;
        this.zzRd = new zzb();
        this.registerReceiver(this.zzRd, new IntentFilter("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT"));
        this.zzRe = new NotificationSettings(notificationSettings);
        if (this.zzRe.mNotification == null) {
            this.zzRf = true;
            this.mNotification = this.zzN(false);
        } else {
            this.zzRf = false;
            this.mNotification = this.zzRe.mNotification;
        }
        this.zzRa = this.zza(castDevice);
        this.zzRa.connect();
    }

    private void zzlh() {
        zzQW.zzb("startRemoteDisplay", new Object[0]);
        if (this.zzRa == null || !this.zzRa.isConnected()) {
            zzQW.zzc("Unable to start the remote display as the API client is not ready", new Object[0]);
            return;
        }
        CastRemoteDisplay.CastRemoteDisplayApi.startRemoteDisplay(this.zzRa, this.zzQv).setResultCallback((ResultCallback)new ResultCallback<CastRemoteDisplay.CastRemoteDisplaySessionResult>(){

            public void zza(CastRemoteDisplay.CastRemoteDisplaySessionResult castRemoteDisplaySessionResult) {
                if (!castRemoteDisplaySessionResult.getStatus().isSuccess()) {
                    zzQW.zzc("Connection was not successful", new Object[0]);
                    CastRemoteDisplayLocalService.this.zzlj();
                    return;
                }
                Display display = castRemoteDisplaySessionResult.getPresentationDisplay();
                if (display != null) {
                    CastRemoteDisplayLocalService.this.zza(display);
                } else {
                    zzQW.zzc("Cast Remote Display session created without display", new Object[0]);
                }
                zzQZ.set(false);
                if (CastRemoteDisplayLocalService.this.zzRj != null && CastRemoteDisplayLocalService.this.zzRk != null) {
                    CastRemoteDisplayLocalService.this.zzRj.unbindService(CastRemoteDisplayLocalService.this.zzRk);
                    CastRemoteDisplayLocalService.this.zzRk = null;
                    CastRemoteDisplayLocalService.this.zzRj = null;
                }
            }

            public /* synthetic */ void onResult(Result x0) {
                this.zza((CastRemoteDisplay.CastRemoteDisplaySessionResult)x0);
            }
        });
    }

    private void zzli() {
        zzQW.zzb("stopRemoteDisplay", new Object[0]);
        if (this.zzRa == null || !this.zzRa.isConnected()) {
            zzQW.zzc("Unable to stop the remote display as the API client is not ready", new Object[0]);
            return;
        }
        CastRemoteDisplay.CastRemoteDisplayApi.stopRemoteDisplay(this.zzRa).setResultCallback((ResultCallback)new ResultCallback<CastRemoteDisplay.CastRemoteDisplaySessionResult>(){

            public void zza(CastRemoteDisplay.CastRemoteDisplaySessionResult castRemoteDisplaySessionResult) {
                if (!castRemoteDisplaySessionResult.getStatus().isSuccess()) {
                    zzQW.zzb("Unable to stop the remote display, result unsuccessful", new Object[0]);
                } else {
                    zzQW.zzb("remote display stopped", new Object[0]);
                }
                CastRemoteDisplayLocalService.this.zzRi = null;
            }

            public /* synthetic */ void onResult(Result x0) {
                this.zza((CastRemoteDisplay.CastRemoteDisplaySessionResult)x0);
            }
        });
    }

    private void zzlj() {
        if (this.zzRc != null) {
            this.zzRc.onRemoteDisplaySessionError(new Status(2200));
            this.zzRc = null;
        }
        CastRemoteDisplayLocalService.stopService();
    }

    private void zzlk() {
        zzQW.zzb("stopRemoteDisplaySession", new Object[0]);
        this.zzli();
        this.onDismissPresentation();
    }

    private void zzll() {
        zzQW.zzb("Stopping the remote display Service", new Object[0]);
        this.stopForeground(true);
        this.stopSelf();
    }

    private GoogleApiClient zza(CastDevice castDevice) {
        CastRemoteDisplay.CastRemoteDisplayOptions.Builder builder = new CastRemoteDisplay.CastRemoteDisplayOptions.Builder(castDevice, this.zzRb);
        GoogleApiClient.ConnectionCallbacks connectionCallbacks = new GoogleApiClient.ConnectionCallbacks(){

            public void onConnected(Bundle bundle) {
                zzQW.zzb("onConnected", new Object[0]);
                CastRemoteDisplayLocalService.this.zzlh();
            }

            public void onConnectionSuspended(int cause) {
                zzQW.zzf(String.format("ConnectionSuspended %d", cause), new Object[0]);
            }
        };
        GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = new GoogleApiClient.OnConnectionFailedListener(){

            public void onConnectionFailed(ConnectionResult connectionResult) {
                zzQW.zzc("Connection failed: " + connectionResult, new Object[0]);
                CastRemoteDisplayLocalService.this.zzlj();
            }
        };
        return new GoogleApiClient.Builder((Context)this, connectionCallbacks, onConnectionFailedListener).addApi(CastRemoteDisplay.API, (Api.ApiOptions.HasOptions)builder.build()).build();
    }

    private PendingIntent zzlm() {
        if (this.zzRg == null) {
            Intent intent = new Intent("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT");
            this.zzRg = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)intent, (int)0x10000000);
        }
        return this.zzRg;
    }

    private Notification zzN(boolean bl) {
        int n;
        int n2;
        int n3 = this.getApplicationInfo().labelRes;
        String string2 = this.zzRe.zzRw;
        String string3 = this.zzRe.zzRx;
        if (bl) {
            n2 = R.string.cast_notification_connected_message;
            n = R.drawable.cast_ic_notification_on;
        } else {
            n2 = R.string.cast_notification_connecting_message;
            n = R.drawable.cast_ic_notification_connecting;
        }
        String string4 = TextUtils.isEmpty((CharSequence)string2) ? this.getString(n3) : string2;
        String string5 = TextUtils.isEmpty((CharSequence)string3) ? this.getString(n2, new Object[]{this.zzRh.getFriendlyName()}) : string3;
        Notification notification = new NotificationCompat.Builder((Context)this).setContentTitle((CharSequence)string4).setContentText((CharSequence)string5).setContentIntent(this.zzRe.zzRv).setSmallIcon(n).setOngoing(true).addAction(17301560, (CharSequence)this.getString(R.string.cast_notification_disconnect), this.zzlm()).build();
        this.startForeground(zzQX, notification);
        return notification;
    }

    private class zza
    extends Binder {
        private zza() {
        }

        CastRemoteDisplayLocalService zzlp() {
            return CastRemoteDisplayLocalService.this;
        }
    }

    private static final class zzb
    extends BroadcastReceiver {
        private zzb() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT")) {
                zzQW.zzb("disconnecting", new Object[0]);
                CastRemoteDisplayLocalService.stopService();
            }
        }
    }

    public static final class NotificationSettings {
        private Notification mNotification;
        private PendingIntent zzRv;
        private String zzRw;
        private String zzRx;

        private NotificationSettings() {
        }

        private NotificationSettings(NotificationSettings newSettings) {
            this.mNotification = newSettings.mNotification;
            this.zzRv = newSettings.zzRv;
            this.zzRw = newSettings.zzRw;
            this.zzRx = newSettings.zzRx;
        }

        public static final class Builder {
            private NotificationSettings zzRy = new NotificationSettings();

            public Builder setNotification(Notification notification) {
                this.zzRy.mNotification = notification;
                return this;
            }

            public Builder setNotificationPendingIntent(PendingIntent notificationPendingIntent) {
                this.zzRy.zzRv = notificationPendingIntent;
                return this;
            }

            public Builder setNotificationTitle(String notificationTitle) {
                this.zzRy.zzRw = notificationTitle;
                return this;
            }

            public Builder setNotificationText(String notificationText) {
                this.zzRy.zzRx = notificationText;
                return this;
            }

            public NotificationSettings build() {
                if (this.zzRy.mNotification != null) {
                    if (!TextUtils.isEmpty((CharSequence)this.zzRy.zzRw)) {
                        throw new IllegalArgumentException("notificationTitle requires using the default notification");
                    }
                    if (!TextUtils.isEmpty((CharSequence)this.zzRy.zzRx)) {
                        throw new IllegalArgumentException("notificationText requires using the default notification");
                    }
                    if (this.zzRy.zzRv != null) {
                        throw new IllegalArgumentException("notificationPendingIntent requires using the default notification");
                    }
                } else if (TextUtils.isEmpty((CharSequence)this.zzRy.zzRw) && TextUtils.isEmpty((CharSequence)this.zzRy.zzRx) && this.zzRy.zzRv == null) {
                    throw new IllegalArgumentException("At least an argument must be provided");
                }
                return this.zzRy;
            }
        }
    }

    public static interface Callbacks {
        public void onRemoteDisplaySessionStarted(CastRemoteDisplayLocalService var1);

        public void onRemoteDisplaySessionError(Status var1);
    }
}

